/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.webrtc.sdp;

import com.wowza.util.BufferUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.webrtc.model.WebRTCMessageHandler$1;
import com.wowza.wms.webrtc.sdp.WebRTCSDPHeader;
import com.wowza.wms.webrtc.sdp.WebRTCSDPInfo$IOException;
import com.wowza.wms.webrtc.sdp.WebRTCSDPParser$1;
import com.wowza.wms.webrtc.sdp.WebRTCSDPTrack;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class WebRTCSDPInfo {
    private static final Class<WebRTCSDPInfo> a;
    private static final String b = "WebRTCSDPInfo";
    public Map<Integer, WebRTCSDPTrack> tracks = new HashMap<Integer, WebRTCSDPTrack>();
    public List<WebRTCSDPTrack> trackOrder = new ArrayList<WebRTCSDPTrack>();
    public WebRTCSDPHeader sdpHeader = new WebRTCSDPHeader();
    protected Map<Long, WebRTCSDPTrack> ssrcToTrack = new HashMap<Long, WebRTCSDPTrack>();
    protected Object lock = new Object();
    protected UUID msidGUIDStreamId = UUID.randomUUID();
    protected UUID msidGUIDVideoTrackId = UUID.randomUUID();
    protected UUID msidGUIDAudioTrackId = UUID.randomUUID();
    protected UUID cnameGUIDStream = UUID.randomUUID();

    public WebRTCSDPInfo() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = null;
        byArray = new byte[16];
        ((Random)secureRandom).nextBytes(byArray);
        this.sdpHeader.iceInfoLocal.icePWD = BufferUtils.encodeHexString((byte[])byArray);
        byArray = new byte[4];
        ((Random)secureRandom).nextBytes(byArray);
        this.sdpHeader.iceInfoLocal.iceUFRAG = BufferUtils.encodeHexString((byte[])byArray);
        this.sdpHeader.sessionIdLocal = Math.abs(secureRandom.nextInt());
    }

    public String toSDPString(IApplicationInstance iApplicationInstance, String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.toSDPString(iApplicationInstance, stringBuffer, string);
            return stringBuffer.toString();
        }
        catch (WebRTCSDPInfo$IOException webRTCSDPInfo$IOException) {
            return null;
        }
    }

    public void toSDPString(IApplicationInstance iApplicationInstance, StringBuffer stringBuffer, String string) {
        try {
            this.sdpHeader.toSDPString(stringBuffer, string);
            Iterator<WebRTCSDPTrack> iterator = this.trackOrder.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                WebRTCSDPTrack webRTCSDPTrack = iterator.next();
                webRTCSDPTrack.toSDPString(iApplicationInstance, stringBuffer, string);
            }
        }
        catch (WebRTCSDPInfo$IOException webRTCSDPInfo$IOException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebRTCSDPTrack getTrackByType(int n) {
        try {
            WebRTCSDPTrack webRTCSDPTrack;
            WebRTCSDPTrack webRTCSDPTrack2 = null;
            Iterator<WebRTCSDPTrack> iterator = this.trackOrder.iterator();
            do {
                if (!iterator.hasNext()) return webRTCSDPTrack2;
                webRTCSDPTrack = iterator.next();
            } while (webRTCSDPTrack.trackType != n);
            return webRTCSDPTrack;
        }
        catch (WebRTCSDPInfo$IOException webRTCSDPInfo$IOException) {
            return null;
        }
    }

    public WebRTCSDPTrack getVideoTrack() {
        try {
            return this.getTrackByType(1);
        }
        catch (WebRTCSDPInfo$IOException webRTCSDPInfo$IOException) {
            return null;
        }
    }

    public WebRTCSDPTrack getAudioTrack() {
        try {
            return this.getTrackByType(2);
        }
        catch (WebRTCSDPInfo$IOException webRTCSDPInfo$IOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSSRCToTrack(long l, WebRTCSDPTrack webRTCSDPTrack) {
        Object object = this.lock;
        synchronized (object) {
            this.ssrcToTrack.put(l, webRTCSDPTrack);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebRTCSDPTrack getTrack(long l) {
        WebRTCSDPTrack webRTCSDPTrack = null;
        Object object = this.lock;
        synchronized (object) {
            return this.ssrcToTrack.get(l);
        }
    }

    public UUID getMSIDGUIDStreamId() {
        return this.msidGUIDStreamId;
    }

    public UUID getMSIDGUIDVideoTrackId() {
        return this.msidGUIDVideoTrackId;
    }

    public UUID getMSIDGUIDAudioTrackId() {
        return this.msidGUIDAudioTrackId;
    }

    public String getCNAMEStream() {
        try {
            return this.cnameGUIDStream.toString();
        }
        catch (WebRTCSDPInfo$IOException webRTCSDPInfo$IOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int hashCode() {
        try {
            int n = 1;
            n = 31 * n + (this.cnameGUIDStream == null ? 0 : this.cnameGUIDStream.hashCode());
            n = 31 * n + (this.sdpHeader == null ? 0 : this.sdpHeader.hashCode());
            n = 31 * n + (this.ssrcToTrack == null ? 0 : this.ssrcToTrack.hashCode());
            n = 31 * n + (this.trackOrder == null ? 0 : this.trackOrder.hashCode());
            return 31 * n + (this.tracks == null ? 0 : this.tracks.hashCode());
        }
        catch (WebRTCSDPInfo$IOException webRTCSDPInfo$IOException) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WebRTCSDPInfo webRTCSDPInfo = (WebRTCSDPInfo)object;
            if (this.cnameGUIDStream == null ? webRTCSDPInfo.cnameGUIDStream != null : !this.cnameGUIDStream.equals(webRTCSDPInfo.cnameGUIDStream)) return false;
            if (this.sdpHeader == null ? webRTCSDPInfo.sdpHeader != null : !this.sdpHeader.equals(webRTCSDPInfo.sdpHeader)) {
                return false;
            }
            if (this.ssrcToTrack == null ? webRTCSDPInfo.ssrcToTrack != null : !this.ssrcToTrack.equals(webRTCSDPInfo.ssrcToTrack)) return false;
            if (this.trackOrder == null ? webRTCSDPInfo.trackOrder != null : !this.trackOrder.equals(webRTCSDPInfo.trackOrder)) {
                return false;
            }
            if (this.tracks == null) {
                if (webRTCSDPInfo.tracks == null) return true;
                return false;
            }
            if (this.tracks.equals(webRTCSDPInfo.tracks)) return true;
            return false;
        }
        catch (WebRTCSDPInfo$IOException webRTCSDPInfo$IOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string;
        int n = WebRTCSDPParser$1.toString();
        String string2 = WebRTCSDPParser$1.toString(n * 5 % n != 0 ? WebRTCMessageHandler$1.equals(120, ">=9mf9;n8;6736<1jl=1;n7j*s+\"p/wq(} \u007fxx*") : "Xus@GWFRGQw|t<F\u0014kr`ahw8\f", 32 - 17);
        int n2 = WebRTCSDPParser$1.toString();
        String string3 = WebRTCSDPParser$1.toString(n2 * 3 % n2 != 0 ? WebRTCSDPParser$1.toString("?>nhg?i738f47`=<m:j6hllt+p+  ,s!z,!*{-,", 121) : ")&szhi`C\u007fjjb,", 1406 / 242);
        int n3 = WebRTCSDPParser$1.toString();
        String string4 = WebRTCSDPParser$1.toString(n3 * 5 % n3 == 0 ? "/$vbw@lkoi\u007f3" : WebRTCMessageHandler$1.equals(5, "4449;9"), 508 / 134);
        int n4 = WebRTCSDPParser$1.toString();
        String string5 = WebRTCSDPParser$1.toString(n4 * 4 % n4 == 0 ? "/$vuuk]e_~lmd-" : WebRTCMessageHandler$1.equals(103, "\n1}2\u0005\b\b\u007f\u0000\u0004\u0018`\u001d\u0000\u0018d"), 257 / 73);
        int n5 = WebRTCSDPParser$1.toString();
        String string6 = WebRTCSDPParser$1.toString(n5 * 3 % n5 == 0 ? "*'ezcoKXGKCe`vux_s%" : WebRTCSDPParser$1.toString("+\".3/)8/:3*<5", 26), 336 / 50);
        int n6 = WebRTCSDPParser$1.toString();
        String string7 = WebRTCSDPParser$1.toString(n6 * 5 % n6 == 0 ? "yv:+0>\u001c\t\u0014\u001a\t)%',\u00107'$#\u0000.v" : WebRTCSDPParser$1.toString("\u0000f9f\u0004j\u001fj", 83), 51 + 34);
        int n7 = WebRTCSDPParser$1.toString();
        String string8 = WebRTCSDPParser$1.toString(n7 * 2 % n7 != 0 ? WebRTCMessageHandler$1.equals(94, "8;t'xr\"!v}pq){vt(.5kjjg7lghk?a>n8m:1gea") : "yv:+0>\u001c\t\u0014\u001a\u001e5%+,\u00107'$#\u0000.v", 12 + 73);
        int n8 = WebRTCSDPParser$1.toString();
        if (n8 * 2 % n8 != 0) {
            string = WebRTCSDPParser$1.toString("\b=?(=", 78);
            return string2 + this.tracks + string3 + this.trackOrder + string4 + this.sdpHeader + string5 + this.ssrcToTrack + string6 + this.msidGUIDStreamId + string7 + this.msidGUIDVideoTrackId + string8 + this.msidGUIDAudioTrackId + WebRTCSDPParser$1.toString(string, 19 + 102) + this.cnameGUIDStream + "]";
        }
        string = "uz82<3:GTKGWqtbid7";
        return string2 + this.tracks + string3 + this.trackOrder + string4 + this.sdpHeader + string5 + this.ssrcToTrack + string6 + this.msidGUIDStreamId + string7 + this.msidGUIDVideoTrackId + string8 + this.msidGUIDAudioTrackId + WebRTCSDPParser$1.toString(string, 19 + 102) + this.cnameGUIDStream + "]";
    }

    static {
        try {
            a = WebRTCSDPInfo.class;
        }
        catch (WebRTCSDPInfo$IOException webRTCSDPInfo$IOException) {}
    }
}

