/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.webrtc.dtls;

import com.wowza.wms.certificate.CertificateHolderX509;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.webrtc.dtls.DTLSUtils;
import com.wowza.wms.webrtc.dtls.WebRTCDTLSServer$ParseException;
import com.wowza.wms.webrtc.model.WebRTCMessageHandler$1;
import com.wowza.wms.webrtc.model.WebRTCSession;
import com.wowza.wms.webrtc.sdp.WebRTCSDPParser$1;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.tls.AlertDescription;
import org.bouncycastle.crypto.tls.AlertLevel;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsServer;
import org.bouncycastle.crypto.tls.MaxFragmentLength;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsECCUtils;
import org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsSRTPUtils;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.tls.UseSRTPData;

public class WebRTCDTLSServer
extends DefaultTlsServer {
    private static final Class<WebRTCDTLSServer> a;
    private static final String b = "WebRTCDTLSServer";
    protected CertificateHolderX509 certificateHolder = null;
    protected Object lock = new Object();
    protected int protectionProfile = -1;
    protected byte[] mki = null;
    protected byte[] mSecret = null;
    protected WebRTCSession webrtcSession = null;
    protected boolean handshakeDone = false;

    public WebRTCDTLSServer(WebRTCSession webRTCSession) {
        this.webrtcSession = webRTCSession;
        this.certificateHolder = webRTCSession.getCertificateHolderX509();
    }

    public boolean shouldUseGMTUnixTime() {
        return true;
    }

    public boolean getHandshakeDone() {
        return this.handshakeDone;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifySecureRenegotiation(boolean bl) throws IOException {
        if (!this.webrtcSession.getRTPSession().getAppInstance().getWebRTCApplicationContext().isDebugLog()) return;
        int n = WebRTCSDPParser$1.toString();
        WMSLoggerFactory.getLogger(a).warn(WebRTCSDPParser$1.toString(n * 2 % n == 0 ? "N\u007fyNI][\u0014\r\u0011\u0010!70\":g$$8$(6\u000341&&0\u000426<=4(4?+).,yd" : WebRTCMessageHandler$1.equals(59, "JKStF\u0017\u000b14p\u0015\u00056\u001b\u000b!\u0011\u001f\u000f9\u0016\b\u001b>0g\u001b:\u001e\u001f\u000fj\u0012\u001b\u000f2\u0016\u0007r\u0006$|\u000e6%\u000f\u000f?\u0012~t=.\u0007\u0004!"), 43 * 43) + bl);
    }

    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifyAlertReceived(short s, short s2) {
        if (!this.webrtcSession.getRTPSession().getAppInstance().getWebRTCApplicationContext().isDebugLog()) return;
        int n = WebRTCSDPParser$1.toString();
        int n2 = WebRTCSDPParser$1.toString();
        WMSLoggerFactory.getLogger(a).warn(WebRTCSDPParser$1.toString(n * 5 % n != 0 ? WebRTCSDPParser$1.toString("dgga<6>1?1<ikn*!vvq/pu . }}%*%qp!%~s\"s,", 34) : "S`dU\\JN_@^]jbgwa:{ycq\u007fcZpxlkRdafmscc2)fnzhb5", 840 / 172) + AlertLevel.getText((short)s) + WebRTCSDPParser$1.toString(n2 * 3 % n2 != 0 ? WebRTCMessageHandler$1.equals(126, "\f1JwgT<8") : "m**#2h", 86 + 119) + AlertDescription.getText((short)s2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifyHandshakeComplete() throws IOException {
        if (this.webrtcSession.getRTPSession().getAppInstance().getWebRTCApplicationContext().isDebugLog()) {
            int n = WebRTCSDPParser$1.toString();
            WMSLoggerFactory.getLogger(a).warn(WebRTCSDPParser$1.toString(n * 2 % n != 0 ? WebRTCMessageHandler$1.equals(126, "8;5`8:<3`=kj9:6oh7$+v\"%q,\"+{\u007f!}y*):b755") : "VgaVQEC\\EYXi\u007fxjb?||`|pnPxt\u007fou\u007fteBmnticsm)ld~-}jcb{|z/", -19 - -20) + this.webrtcSession);
        }
        this.mSecret = new byte[this.context.getSecurityParameters().getMasterSecret().length];
        System.arraycopy(this.context.getSecurityParameters().getMasterSecret(), 0, this.mSecret, 0, this.context.getSecurityParameters().getMasterSecret().length);
        this.handshakeDone = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CertificateRequest getCertificateRequest() throws IOException {
        short[] sArray = new short[]{1, 2, 64};
        Vector vector = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)this.serverVersion)) {
            vector = TlsUtils.getDefaultSupportedSignatureAlgorithms();
        }
        Vector<X500Name> vector2 = new Vector<X500Name>();
        vector2.add(DTLSUtils.loadCertificateResource(this.certificateHolder).getSubject());
        return new CertificateRequest(sArray, vector, vector2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifyClientCertificate(org.bouncycastle.crypto.tls.Certificate certificate) throws IOException {
        Certificate[] certificateArray = certificate.getCertificateList();
        int n = 0;
        while (n != certificateArray.length) {
            Certificate certificate2 = certificateArray[n];
            ++n;
        }
        return;
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.DTLSv12;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.DTLSv12;
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        try {
            return DTLSUtils.loadEncryptionCredentials((TlsContext)this.context, this.certificateHolder);
        }
        catch (WebRTCDTLSServer$ParseException webRTCDTLSServer$ParseException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        try {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
            Vector vector = this.supportedSignatureAlgorithms;
            if (vector == null) return DTLSUtils.loadSignerCredentials((TlsContext)this.context, this.certificateHolder, signatureAndHashAlgorithm);
            int n = 0;
            while (n < vector.size()) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm2 = (SignatureAndHashAlgorithm)vector.elementAt(n);
                if (signatureAndHashAlgorithm2.getSignature() == 1) {
                    signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
                    break;
                }
                ++n;
            }
            if (signatureAndHashAlgorithm != null) return DTLSUtils.loadSignerCredentials((TlsContext)this.context, this.certificateHolder, signatureAndHashAlgorithm);
            return null;
        }
        catch (WebRTCDTLSServer$ParseException webRTCDTLSServer$ParseException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Hashtable getServerExtensions() throws IOException {
        block10: {
            var1_1 = this.a();
            if (TlsSRTPUtils.getUseSRTPExtension((Hashtable)var1_1) != null) return var1_1;
            if (var1_1 == null) {
                var1_1 = new Hashtable<K, V>();
            }
            var2_5 = TlsSRTPUtils.getUseSRTPExtension((Hashtable)this.clientExtensions);
            var3_6 = 1;
            var4_7 = var2_5.getMki();
            if (var3_6 < 0) {
                v0 = WebRTCMessageHandler$1.equals();
            }
            TlsSRTPUtils.addUseSRTPExtension(var1_1, (UseSRTPData)new UseSRTPData(new int[]{var3_6}, var2_5.getMki()));
            // MONITORENTER : this.lock
            this.protectionProfile = var3_6;
            {
                if (var4_7 != null && var4_7.length > 0) {
                    v1 = this;
                    break block10;
                }
                v2 = this;
            }
lbl-1000:
            // 3 sources

            {
                catch (Throwable var7_8) {}
                {
                    // MONITOREXIT : var5_3
                    throw var7_8;
                }
            }
            {
                ** try [egrp 3[TRYBLOCK] [4 : 246->272)] { 
lbl22:
                // 1 sources

                v2.mki = null;
                return var1_1;
            }
        }
        v1.mki = new byte[var4_7.length];
        System.arraycopy(var4_7, 0, this.mki, 0, this.mki.length);
        return var1_1;
        var5_2 = WebRTCMessageHandler$1.equals(65 + 29, v0 * 3 % v0 == 0 ? "\u00100`\"*,7 (g\u001b\u001b\u001e\u001bl=< $41'=:8w(+5=51;~" : WebRTCMessageHandler$1.equals(90, "li:9ojr#otswrj|~|}auz|`|`dg7aaln9jhe"));
        var6_4 = new TlsFatalAlert(80);
        v3 = WebRTCMessageHandler$1.equals();
        WMSLoggerFactory.getLogger(WebRTCDTLSServer.a).warn(WebRTCMessageHandler$1.equals(9 * 5, v3 * 2 % v3 != 0 ? WebRTCMessageHandler$1.equals(49, "CU*aqNF%") : "ZkmBEQW@YED}kl~n3yz4\u0012'12 4\u00020=/%?$!!#kr") + var5_2);
        throw var6_4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Hashtable a() throws IOException {
        if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite((int)this.selectedCipherSuite)) {
            TlsExtensionsUtils.addEncryptThenMACExtension((Hashtable)this.checkServerExtensions());
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid((short)this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension((Hashtable)this.checkServerExtensions(), (short)this.maxFragmentLengthOffered);
        }
        if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
            TlsExtensionsUtils.addTruncatedHMacExtension((Hashtable)this.checkServerExtensions());
        }
        if (!TlsECCUtils.isECCCipherSuite((int)this.selectedCipherSuite)) return this.serverExtensions;
        this.serverECPointFormats = new short[]{0, 1, 2};
        TlsECCUtils.addSupportedPointFormatsExtension((Hashtable)this.checkServerExtensions(), (short[])this.serverECPointFormats);
        return this.serverExtensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getKeyingMaterial(int n) {
        String string;
        int n2 = 764 / 148;
        int n3 = WebRTCMessageHandler$1.equals();
        if (n3 * 2 % n3 == 0) {
            string = "@^SZHI_C_#kd}aLggbg";
            return this.exportKeyingMaterial(WebRTCMessageHandler$1.equals(n2, string), null, n);
        }
        string = WebRTCMessageHandler$1.equals(53, ",!u,(x\u007f$0x&#%ow'tvj*(}sa|vx2f`dlbba;");
        return this.exportKeyingMaterial(WebRTCMessageHandler$1.equals(n2, string), null, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] exportKeyingMaterial(String string, byte[] byArray, int n) {
        IllegalStateException illegalStateException;
        if (byArray != null && !TlsUtils.isValidUint16((int)byArray.length)) {
            String string2;
            int n2 = WebRTCMessageHandler$1.equals();
            if (n2 * 2 % n2 == 0) {
                string2 = "z=0nug{pZpfd|o,,`{|d1zrbp6{}w}ot=rzsr\"wldh':W;=,%a}0sw3z`z{1";
                throw new IllegalArgumentException(WebRTCMessageHandler$1.equals(-20 - -17, string2));
            }
            string2 = WebRTCSDPParser$1.toString("\u001b\u0003\u001d \u0017!\ti\u0013\u000b\r8\u000f\u0017\tu", 86);
            throw new IllegalArgumentException(WebRTCMessageHandler$1.equals(-20 - -17, string2));
        }
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        byte[] byArray2 = securityParameters.getClientRandom();
        byte[] byArray3 = securityParameters.getServerRandom();
        int n3 = byArray2.length + byArray3.length;
        if (byArray != null) {
            n3 += 2 + byArray.length;
        }
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        System.arraycopy(byArray2, 0, byArray4, n4, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, n4 += byArray2.length, byArray3.length);
        n4 += byArray3.length;
        if (byArray != null) {
            TlsUtils.writeUint16((int)byArray.length, (byte[])byArray4, (int)n4);
            System.arraycopy(byArray, 0, byArray4, n4 += 2, byArray.length);
            n4 += byArray.length;
        }
        if (n4 == n3) {
            byte[] byArray5 = securityParameters.getMasterSecret();
            return TlsUtils.PRF((TlsContext)this.context, (byte[])this.mSecret, (String)string, (byte[])byArray4, (int)n);
        }
        int n5 = WebRTCMessageHandler$1.equals();
        illegalStateException(WebRTCMessageHandler$1.equals(45 * 61, n5 * 5 % n5 == 0 ? "|hiso>v.a!\"(&3+)=#$\"m!)p\"760u08*y?#,2,+" : WebRTCMessageHandler$1.equals(98, "$'s$|qz\u007f.q(z}-jdk2go33>``h>doe92d1>037k")));
        throw illegalStateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getProtectionProfile() {
        Object object = this.lock;
        synchronized (object) {
            WebRTCDTLSServer webRTCDTLSServer = this;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
            return webRTCDTLSServer.protectionProfile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public byte[] getMKI() {
        Object object = this.lock;
        return this.mki;
    }

    static {
        try {
            a = WebRTCDTLSServer.class;
        }
        catch (WebRTCDTLSServer$ParseException webRTCDTLSServer$ParseException) {}
    }
}

