/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.thumbnailer;

import com.wowza.util.FLVUtils;
import com.wowza.util.PacketFragment;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoTransportStreamUtils;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoTransportStreamVideoFrameContext;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoTransportStreamVideoFrameResult;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.h265.H265Utils;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.transcoder.thumbnailer.ThumbnailerRequest$NullPointerException;
import com.wowza.wms.transcoder.thumbnailer.ThumbnailerRequestPacket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ThumbnailerRequest {
    private static final Class<ThumbnailerRequest> a;
    private static final String b = "ThumbnailerRequest";
    public static final int FORMAT_RGBA = 1;
    public static final int WIDTH_MIN = 16;
    public static final int WIDTH_MAX = 7680;
    public static final int HEIGHT_MIN = 16;
    public static final int HEIGHT_MAX = 4320;
    protected IMediaStream stream = null;
    protected int codec = 0;
    protected int codecVersion = 0;
    protected int implementation = 0;
    protected int width = 0;
    protected int height = 0;
    protected int fitMode = 1;
    protected int[] crop = new int[4];
    protected int format = 1;
    protected int gpuid = -1;
    protected int deinterlace = 1;
    protected int cpuNum = -1;
    protected int smpMode = -1;
    protected int output8Bit = 0;
    protected int mvPrecision = -1;
    protected int dpbSize = -1;
    protected int ec = -1;
    protected int loopFilter = 1;
    protected int accMode = -1;
    protected List<ThumbnailerRequestPacket> packetList = new ArrayList<ThumbnailerRequestPacket>();
    protected ThumbnailerRequestPacket[] packets = null;

    public ThumbnailerRequest(IMediaStream iMediaStream, int n, int n2, int n3) {
        this.stream = iMediaStream;
        this.setWidth(n);
        this.setHeight(n2);
        this.setFitMode(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addPacket(AMFPacket aMFPacket) {
        if (this.stream == null) return;
        int n = FLVUtils.getVideoCodec((AMFPacket)aMFPacket);
        long l = aMFPacket.getAbsTimecode();
        long l2 = FLVUtils.getPtsOffSetFromDts((AMFPacket)aMFPacket);
        ByteBuffer byteBuffer = null;
        if (n != 7 && n != 12) {
            byte[] byArray;
            int n2;
            if ((n == 11 || n == 10) && (n2 = (byArray = aMFPacket.getData()).length) > 5) {
                byteBuffer = ByteBuffer.allocateDirect(n2 - 5);
                byteBuffer.put(byArray, 5, n2 - 5);
            }
        } else {
            AMFPacket aMFPacket2 = this.stream.getVideoCodecConfigPacket(l);
            if (aMFPacket2 != null) {
                CupertinoTransportStreamVideoFrameContext cupertinoTransportStreamVideoFrameContext = new CupertinoTransportStreamVideoFrameContext();
                byte[] byArray = aMFPacket2.getData();
                int n3 = byArray.length;
                switch (n) {
                    default: {
                        break;
                    }
                    case 12: {
                        cupertinoTransportStreamVideoFrameContext.h265CodecConfigPart = H265Utils.breakApartHVCC((byte[])byArray, (int)5, (int)(n3 - 5));
                        cupertinoTransportStreamVideoFrameContext.h26xCodecConfigInfo = H265Utils.decodeHVCC((byte[])byArray, (int)5, (int)(n3 - 5));
                        break;
                    }
                    case 7: {
                        cupertinoTransportStreamVideoFrameContext.h264CodecConfigPart = H264Utils.breakApartAVCC((byte[])byArray, (int)5, (int)(n3 - 5));
                        cupertinoTransportStreamVideoFrameContext.h26xCodecConfigInfo = H264Utils.decodeAVCC((byte[])byArray, (int)5, (int)(n3 - 5));
                    }
                }
                CupertinoTransportStreamVideoFrameResult cupertinoTransportStreamVideoFrameResult = CupertinoTransportStreamUtils.prepareVideoFrame((CupertinoTransportStreamVideoFrameContext)cupertinoTransportStreamVideoFrameContext, (AMFPacket)aMFPacket);
                byteBuffer = ByteBuffer.allocateDirect(cupertinoTransportStreamVideoFrameResult.fragSize);
                boolean bl = false;
                for (PacketFragment packetFragment : cupertinoTransportStreamVideoFrameResult.pendingFragments) {
                    byteBuffer.put(packetFragment.getBuffer(), packetFragment.getOffset(), packetFragment.getLen());
                }
                byteBuffer.flip();
            }
        }
        if (byteBuffer == null) return;
        ThumbnailerRequestPacket thumbnailerRequestPacket = new ThumbnailerRequestPacket(byteBuffer, aMFPacket.getType(), l, l2);
        this.packetList.add(thumbnailerRequestPacket);
        List<ThumbnailerRequestPacket> list = this.packetList;
        this.packets = list.toArray(new ThumbnailerRequestPacket[list.size()]);
        this.codec = n;
    }

    public void addPackets(List<AMFPacket> list) {
        try {
            for (AMFPacket aMFPacket : list) {
                this.addPacket(aMFPacket);
            }
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int n) {
        try {
            this.codec = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getCodecVersion() {
        return this.codecVersion;
    }

    public void setCodecVersion(int n) {
        try {
            this.codecVersion = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getImplementation() {
        return this.implementation;
    }

    public void setImplementation(int n) {
        try {
            this.implementation = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setWidth(int n) {
        if (n < 16) {
            n = 16;
        }
        if (n > 7680) {
            n = 7680;
        }
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setHeight(int n) {
        if (n < 16) {
            n = 16;
        }
        if (n > 4320) {
            n = 4320;
        }
        this.height = n;
    }

    public int[] getCrop() {
        return this.crop;
    }

    public void setCrop(int[] nArray) {
        try {
            this.crop = nArray;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        try {
            this.format = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getGpuid() {
        return this.gpuid;
    }

    public void setGpuid(int n) {
        try {
            this.gpuid = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getCpuNum() {
        return this.cpuNum;
    }

    public void setCpuNum(int n) {
        try {
            this.cpuNum = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getSmpMode() {
        return this.smpMode;
    }

    public void setSmpMode(int n) {
        try {
            this.smpMode = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getMvPrecision() {
        return this.mvPrecision;
    }

    public void setMvPrecision(int n) {
        try {
            this.mvPrecision = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getDpbSize() {
        return this.dpbSize;
    }

    public void setDpbSize(int n) {
        try {
            this.dpbSize = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getEc() {
        return this.ec;
    }

    public void setEc(int n) {
        try {
            this.ec = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getDeinterlace() {
        return this.deinterlace;
    }

    public void setDeinterlace(int n) {
        try {
            this.deinterlace = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getOutput8Bit() {
        return this.output8Bit;
    }

    public void setOutput8Bit(int n) {
        try {
            this.output8Bit = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getLoopFilter() {
        return this.loopFilter;
    }

    public void setLoopFilter(int n) {
        try {
            this.loopFilter = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getAccMode() {
        return this.accMode;
    }

    public void setAccMode(int n) {
        try {
            this.accMode = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    public int getFitMode() {
        return this.fitMode;
    }

    public void setFitMode(int n) {
        try {
            this.fitMode = n;
            return;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {
            return;
        }
    }

    static {
        try {
            a = ThumbnailerRequest.class;
        }
        catch (ThumbnailerRequest$NullPointerException thumbnailerRequest$NullPointerException) {}
    }
}

