/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.util.FLVUtils;
import com.wowza.util.OnMetadataBasic;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.LiveStreamTranscoderActionNotifyBase$1;
import com.wowza.wms.transcoder.model.TranscoderEncodeFrameHolder$1;
import com.wowza.wms.transcoder.model.TranscoderSessionBitrateCalculator$NullPointerException;
import com.wowza.wms.transcoder.model.TranscoderStream;

public class TranscoderSessionBitrateCalculator {
    protected boolean calculating = true;
    protected long startTimecode = -1L;
    protected int bitrateCalculatorDuration = 3000;
    protected int bitrateCalculatorDefaultAudioDuration = 30;
    protected int bitrateCalculatorDefaultVideoDuration = 30;
    protected int bitrateCalculatorMaxAudioDuration = 1000;
    protected int bitrateCalculatorMaxVideoDuration = 1000;
    protected int bitrateCalculatorMinAudioDuration = 5;
    protected int bitrateCalculatorMinVideoDuration = 5;
    protected CalculatorValues audioValues = new CalculatorValues();
    protected CalculatorValues videoValues = new CalculatorValues();
    protected boolean haveAudioDataRate = false;
    protected int audioDataRate = -1;
    protected boolean haveVideoDataRate = false;
    protected int videoDataRate = -1;

    /*
     * Enabled aggressive block sorting
     */
    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        WMSProperties wMSProperties = liveStreamTranscoder.getProperties();
        int n = TranscoderEncodeFrameHolder$1.substring();
        this.bitrateCalculatorDuration = wMSProperties.getPropertyInt(TranscoderEncodeFrameHolder$1.substring(n * 2 % n == 0 ? "7?#*8.>\u001f<2<umcwkwBrzh~bcc" : TranscoderEncodeFrameHolder$1.substring("7b3=03<h'8jn6\"$up!9,!#)4~*$|-)#wpptq", 34), 35 * 7), this.bitrateCalculatorDuration);
        int n2 = TranscoderEncodeFrameHolder$1.substring();
        this.bitrateCalculatorDefaultAudioDuration = wMSProperties.getPropertyInt(TranscoderEncodeFrameHolder$1.substring(n2 * 4 % n2 == 0 ? "ea}xjxhMn|rg\u007fuaye\\||ziqj^uekl@ptf|`ee" : TranscoderEncodeFrameHolder$1.substring("]}\u007fx|fxh", 49), 45 * 3), this.bitrateCalculatorDefaultAudioDuration);
        int n3 = TranscoderEncodeFrameHolder$1.substring();
        this.bitrateCalculatorDefaultVideoDuration = wMSProperties.getPropertyInt(TranscoderEncodeFrameHolder$1.substring(n3 * 3 % n3 != 0 ? LiveStreamTranscoderActionNotifyBase$1.replace(112, "bif7l0abuiibopjib5/b=`3*>k3in9jk)tvr") : "s{gftbr[xvxiq\u007fk/3\u0006&\"$3+<\u001f#/)\"\n:\"0&:;;", 114 + 63), this.bitrateCalculatorDefaultVideoDuration);
        int n4 = TranscoderEncodeFrameHolder$1.substring();
        this.bitrateCalculatorMaxAudioDuration = wMSProperties.getPropertyInt(TranscoderEncodeFrameHolder$1.substring(n4 * 5 % n4 == 0 ? "95),>4$\u0001\"(&3+)=%9\u0001,6\u000e%5;<\u0010 $6,055" : TranscoderEncodeFrameHolder$1.substring("\ud822\ude67", 63), -42 - -5), this.bitrateCalculatorMaxAudioDuration);
        int n5 = TranscoderEncodeFrameHolder$1.substring();
        this.bitrateCalculatorMaxVideoDuration = wMSProperties.getPropertyInt(TranscoderEncodeFrameHolder$1.substring(n5 * 2 % n5 == 0 ? "bhvqeqcDiei~`lz`b\\skB|rrw]oi}iwp." : TranscoderEncodeFrameHolder$1.substring("\ud836\udf28", 11), -63 - 33), this.bitrateCalculatorMaxVideoDuration);
        int n6 = TranscoderEncodeFrameHolder$1.substring();
        this.bitrateCalculatorMinAudioDuration = wMSProperties.getPropertyInt(TranscoderEncodeFrameHolder$1.substring(n6 * 4 % n6 != 0 ? LiveStreamTranscoderActionNotifyBase$1.replace(82, "477glglkka=nfgzy!\"q\u007f %~/p)tx/ud715nfb3;") : "?7+2 6&\u0007$*$=%+?#?\u0003&>\u0010'7=:\u0012\"*8.233", 96 + -3), this.bitrateCalculatorMinAudioDuration);
        int n7 = TranscoderEncodeFrameHolder$1.substring();
        this.bitrateCalculatorMinVideoDuration = wMSProperties.getPropertyInt(TranscoderEncodeFrameHolder$1.substring(n7 * 5 % n7 == 0 ? "amqtf|lIj`n{cqe}aY|xAq}\u007ftXhl~thmm" : LiveStreamTranscoderActionNotifyBase$1.replace(124, "\ud861\udee8"), 513 / 156), this.bitrateCalculatorMinVideoDuration);
        String string = liveStreamTranscoder.getAppInstance().getContextStr() + ":" + liveStreamTranscoder.getStreamName();
        this.audioValues.defaultDuration = this.bitrateCalculatorDefaultAudioDuration;
        this.audioValues.maxDuration = this.bitrateCalculatorMaxAudioDuration;
        this.audioValues.minDuration = this.bitrateCalculatorMinAudioDuration;
        int n8 = TranscoderEncodeFrameHolder$1.substring();
        this.audioValues.contextStr = string + TranscoderEncodeFrameHolder$1.substring(n8 * 2 % n8 == 0 ? "3k~hda" : TranscoderEncodeFrameHolder$1.substring("rqwu\" x*x'|,7183<c5=1oi>6<jmv+'v\"w,'/\u007f+", 20), 13 + 124);
        this.videoValues.defaultDuration = this.bitrateCalculatorDefaultVideoDuration;
        this.videoValues.maxDuration = this.bitrateCalculatorMaxVideoDuration;
        this.videoValues.minDuration = this.bitrateCalculatorMinVideoDuration;
        int n9 = TranscoderEncodeFrameHolder$1.substring();
        this.videoValues.contextStr = string + TranscoderEncodeFrameHolder$1.substring(n9 * 3 % n9 == 0 ? "j';71:" : LiveStreamTranscoderActionNotifyBase$1.replace(100, "s'%u~*+yax~{b|f1ma{nlmivm8n>0`1f<56c"), 97 + 111);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void inspectOnMetaData(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        try {
            OnMetadataBasic onMetadataBasic = FLVUtils.getOnMetadataData((AMFPacket)aMFPacket);
            if (onMetadataBasic == null) {
                return;
            }
            if (onMetadataBasic.audiodatarate > 0.0) {
                this.haveAudioDataRate = true;
                this.audioDataRate = (int)(onMetadataBasic.audiodatarate * 1024.0);
            }
            if (!(onMetadataBasic.videodatarate > 0.0)) return;
            this.haveVideoDataRate = true;
            this.videoDataRate = (int)(onMetadataBasic.videodatarate * 1024.0);
            return;
        }
        catch (TranscoderSessionBitrateCalculator$NullPointerException transcoderSessionBitrateCalculator$NullPointerException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        long l = System.currentTimeMillis();
        if (this.startTimecode < 0L) {
            this.startTimecode = l;
        }
        int n = aMFPacket.getType();
        switch (n) {
            case 18: {
                this.inspectOnMetaData(iMediaStream, aMFPacket);
                break;
            }
            case 9: {
                if (!FLVUtils.isVideoCodecConfig((AMFPacket)aMFPacket)) {
                    this.videoValues.handlePacket(iMediaStream, aMFPacket);
                }
            }
            default: {
                break;
            }
            case 8: {
                if (FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket)) break;
                this.audioValues.handlePacket(iMediaStream, aMFPacket);
            }
        }
        if (!this.haveAudioDataRate || !this.haveVideoDataRate) {
            if (l - this.startTimecode <= (long)this.bitrateCalculatorDuration) return;
        }
        this.calculating = false;
    }

    public boolean isCalculating() {
        return this.calculating;
    }

    public void setCalculating(boolean bl) {
        try {
            this.calculating = bl;
            return;
        }
        catch (TranscoderSessionBitrateCalculator$NullPointerException transcoderSessionBitrateCalculator$NullPointerException) {
            return;
        }
    }

    public long getVideoBitrate() {
        try {
            if (!this.haveVideoDataRate) {
                return this.videoValues.getBitrate();
            }
            return this.videoDataRate;
        }
        catch (TranscoderSessionBitrateCalculator$NullPointerException transcoderSessionBitrateCalculator$NullPointerException) {
            return 0L;
        }
    }

    public long getAudioBitrate() {
        try {
            if (!this.haveAudioDataRate) {
                return this.audioValues.getBitrate();
            }
            return this.audioDataRate;
        }
        catch (TranscoderSessionBitrateCalculator$NullPointerException transcoderSessionBitrateCalculator$NullPointerException) {
            return 0L;
        }
    }

    class CalculatorValues {
        long startTimecode = -1L;
        long lastTimecode = -1L;
        int lastSize = -1;
        long totalBytes = -1L;
        long totalTime = -1L;
        int defaultDuration = 30;
        int maxDuration = 1000;
        int minDuration = 5;
        String contextStr = "";

        CalculatorValues() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
            long l = aMFPacket.getAbsTimecode();
            int n = aMFPacket.getSize();
            if (this.startTimecode < 0L) {
                this.startTimecode = l;
            } else {
                long l2 = l - this.lastTimecode;
                if (l2 < (long)this.minDuration) {
                    l2 = this.defaultDuration;
                } else if (l2 > (long)this.maxDuration) {
                    l2 = this.defaultDuration;
                }
                this.totalTime += l2;
                this.totalBytes += (long)this.lastSize;
            }
            this.lastTimecode = l;
            this.lastSize = n;
        }

        public long getBitrate() {
            try {
                if (this.totalTime <= 0L) {
                    return 0L;
                }
                return this.totalBytes * 8L * 1000L / this.totalTime;
            }
            catch (TranscoderSessionBitrateCalculator$NullPointerException transcoderSessionBitrateCalculator$NullPointerException) {
                return 0L;
            }
        }
    }
}

