/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.transcoder.model.TranscoderNativeParameterHolder;
import com.wowza.wms.transcoder.model.TranscoderNativeParameterInfo$ParameterValueInfo$Exception;
import com.wowza.wms.transcoder.model.TranscoderNativeParameterValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TranscoderNativeParameterInfo {
    private static final String CLASSNAME = "TranscoderNativeParameterInfo";
    private static final Class<TranscoderNativeParameterInfo> CLASS;
    public static final String PARAM_PREFIX_MAINCONCEPT = "mainconcept";
    public static final String PARAM_PREFIX_NVCUVID = "nvcuvid";
    public static final String PARAM_PREFIX_U30 = "u30";
    public static final String PARAM_PREFIX_U30_H26X = "u30-h26x";
    public static final String PARAM_PREFIX_DEFAULT = "default";
    public static final String PARAM_PREFIX_CUDA = "cuda";
    public static final String PARAM_PREFIX_QUICKSYNC = "quicksync";
    public static final String PARAM_PREFIX_QUICKSYNC_H265 = "quicksync-265";
    public static final String PARAM_PREFIX_VAAPI_H264 = "vaapi-h264";
    public static final String PARAM_PREFIX_VAAPI_VP9 = "vaapi-vp9";
    public static final String PARAM_PREFIX_VAAPI_H265 = "vaapi-265";
    public static final String PARAM_PREFIX_IIPH263 = "ipph263";
    public static final String PARAM_PREFIX_NVENC = "nvenc";
    public static final String PARAM_PREFIX_X264 = "x264";
    public static final String PARAM_PREFIX_X265 = "x265";
    public static final String PARAM_PREFIX_VPX = "vpx";
    public static final String PARAM_PREFIX_MAINCONCEPT_H265 = "mainconcept-h265";
    public static final String PARAM_PREFIX_BLACKMAGIC_CAPTURE = "blackmagic-capture";
    public static final String PARAM_ADVANTECH_VEGA_H264 = "advantech-vega-h264";
    public static final String PARAM_ADVANTECH_VEGA_H265 = "advantech-vega-h265";
    public static final String PARAM_PREFIX_OPUS = "opus";
    public static final String DECODE_VIDEO_PARAMETER_DEINTERLACE = "deinterlace";
    public static final String DECODE_VIDEO_PARAMETER_DEINTERLACEDOUBLERATE = "deinterlaceDoubleRate";
    public static final String[][] ALL_VIDEODECODING_PARAMETERS;
    public static final String[][] BLACKMAGIC_CAPTURE_PARAMETERS;
    public static final String[][] VPX_VIDEOENCODING_PARAMETERS;
    public static final String[][] MAINCONCEPT_VIDEODECODING_PARAMETERS;
    public static final String[][] NVCUVID_VIDEODECODING_PARAMETERS;
    public static final String DECODE_AUDIO_PARAMETER_SCALECHANNELS = "scaleChannels";
    public static final String DECODE_AUDIO_PARAMETER_SCALESAMPLERATE = "scaleSampleRate";
    public static final String[][] ALL_AUDIODECODING_PARAMETERS;
    public static final String[][] ADVANTECH_VEGA_H264_VIDEOENCODING_PARAMETERS;
    public static final String[][] ADVANTECH_VEGA_H265_VIDEOENCODING_PARAMETERS;
    public static final String[][] MAINCONCEPT_H265_VIDEOENCODING_PARAMETERS;
    public static final String[][] X265_VIDEOENCODING_PARAMETERS;
    public static final String[][] X264_VIDEOENCODING_PARAMETERS;
    public static final String MAINCONCEPT_AUDIOAACENCODING_PARAMETERS_HE = "he";
    public static final String[][] MAINCONCEPT_AUDIOAACENCODING_PARAMETERS;
    public static final String[][] OPUS_AUDIOENCODING_PARAMETERS;
    public static final String[][] VAAPI_VIDEOENCODING_VP9_PARAMETERS;
    public static final String[][] VAAPI_VIDEOENCODING_H264_PARAMETERS;
    public static final String[][] VAAPI_VIDEOENCODING_H265_PARAMETERS;
    public static final String[][] IPPH263_VIDEOENCODING_PARAMETERS;
    public static final String[][] MAINCONCEPT_VIDEOENCODING_PARAMETERS;
    public static final String[][] QUICKSYNC_VIDEOENCODING_PARAMETERS;
    public static final String[][] QUICKSYNC_VIDEOENCODING_H265_PARAMETERS;
    public static final String[][] NVENC12_VIDEOENCODING_PARAMETERS;
    public static final String[][] CUDA_VIDEOENCODING_PARAMETERS;
    public static final String[][] XILINX_U30_VIDEOENCODING_H26X_PARAMETERS;
    public static final String[][] XILINX_U30_VIDEODECODING_H26X_PARAMETERS;
    public static Map<String, Map<String, TranscoderNativeParameterHolder>> paramaterMapVideoEncode;
    public static Map<String, Map<String, TranscoderNativeParameterHolder>> paramaterMapVideoDecode;
    public static Map<String, Map<String, TranscoderNativeParameterHolder>> paramaterMapAudioEncode;
    public static Map<String, Map<String, TranscoderNativeParameterHolder>> paramaterMapAudioDecode;
    public static Map<String, Map<String, TranscoderNativeParameterHolder>> paramaterMapCapture;

    static int dataTypeStrToType(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("LONG")) {
            n = 1;
        } else if (string.equalsIgnoreCase("LONGARRAY")) {
            n = 2;
        } else if (string.equalsIgnoreCase("DOUBLE")) {
            n = 3;
        } else if (string.equalsIgnoreCase("DOUBLEARRAY")) {
            n = 4;
        }
        return n;
    }

    static TranscoderNativeParameterHolder newTranscoderNativeParameterHolder(int n, String string, String[] stringArray) {
        TranscoderNativeParameterHolder transcoderNativeParameterHolder = new TranscoderNativeParameterHolder();
        int n2 = TranscoderNativeParameterInfo.dataTypeStrToType(stringArray[1]);
        transcoderNativeParameterHolder.variableName = stringArray[0];
        transcoderNativeParameterHolder.groupName = string;
        transcoderNativeParameterHolder.description = stringArray[3];
        transcoderNativeParameterHolder.dataType = n2;
        transcoderNativeParameterHolder.dataArrLength = 0;
        transcoderNativeParameterHolder.settingIndex = n;
        return transcoderNativeParameterHolder;
    }

    public static String videoDecodeImplementationToPrefix(int n) {
        return switch (n) {
            case 3, 4 -> PARAM_PREFIX_NVCUVID;
            case 5, 6 -> PARAM_PREFIX_U30;
            default -> PARAM_PREFIX_MAINCONCEPT;
        };
    }

    public static TranscoderNativeParameterHolder lookupVideoEncodeParameter(String string, int n, int n2) {
        TranscoderNativeParameterHolder transcoderNativeParameterHolder = null;
        String string2 = TranscoderNativeParameterInfo.videoEncodeImplementationToPrefix(n, n2);
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapVideoEncode.get(string2.toLowerCase(Locale.ENGLISH));
        Map<String, TranscoderNativeParameterHolder> map2 = null;
        int n3 = string.indexOf(".");
        if (n3 >= 0) {
            map2 = paramaterMapVideoEncode.get(string.substring(0, n3).toLowerCase(Locale.ENGLISH));
            string = string.substring(n3 + 1);
        }
        if (transcoderNativeParameterHolder == null && map != null) {
            transcoderNativeParameterHolder = map.get(string.toLowerCase(Locale.ENGLISH));
        }
        if (transcoderNativeParameterHolder == null && map2 != null) {
            transcoderNativeParameterHolder = map2.get(string.toLowerCase(Locale.ENGLISH));
        }
        return transcoderNativeParameterHolder;
    }

    public static TranscoderNativeParameterHolder lookupCaptureParameter(String string, int n) {
        TranscoderNativeParameterHolder transcoderNativeParameterHolder = null;
        String string2 = TranscoderNativeParameterInfo.captureImplementationToPrefix(n);
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapCapture.get(string2.toLowerCase(Locale.ENGLISH));
        Map<String, TranscoderNativeParameterHolder> map2 = null;
        int n2 = string.indexOf(".");
        if (n2 >= 0) {
            map2 = paramaterMapCapture.get(string.substring(0, n2).toLowerCase(Locale.ENGLISH));
            string = string.substring(n2 + 1);
        }
        if (transcoderNativeParameterHolder == null && map != null) {
            transcoderNativeParameterHolder = map.get(string.toLowerCase(Locale.ENGLISH));
        }
        if (transcoderNativeParameterHolder == null && map2 != null) {
            transcoderNativeParameterHolder = map2.get(string.toLowerCase(Locale.ENGLISH));
        }
        return transcoderNativeParameterHolder;
    }

    public static TranscoderNativeParameterHolder lookupAudioEncodeParameter(String string, int n, int n2) {
        TranscoderNativeParameterHolder transcoderNativeParameterHolder = null;
        String string2 = TranscoderNativeParameterInfo.audioEncodeImplementationToPrefix(n, n2);
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapAudioEncode.get(string2.toLowerCase(Locale.ENGLISH));
        Map<String, TranscoderNativeParameterHolder> map2 = null;
        int n3 = string.indexOf(".");
        if (n3 >= 0) {
            map2 = paramaterMapAudioEncode.get(string.substring(0, n3).toLowerCase(Locale.ENGLISH));
            string = string.substring(n3 + 1);
        }
        if (transcoderNativeParameterHolder == null && map != null) {
            transcoderNativeParameterHolder = map.get(string.toLowerCase(Locale.ENGLISH));
        }
        if (transcoderNativeParameterHolder == null && map2 != null) {
            transcoderNativeParameterHolder = map2.get(string.toLowerCase(Locale.ENGLISH));
        }
        return transcoderNativeParameterHolder;
    }

    public static TranscoderNativeParameterHolder lookupVideoDecodeParameter(String string, int n) {
        TranscoderNativeParameterHolder transcoderNativeParameterHolder = null;
        String string2 = TranscoderNativeParameterInfo.videoDecodeImplementationToPrefix(n);
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapVideoDecode.get(string2);
        Map<String, TranscoderNativeParameterHolder> map2 = null;
        int n2 = string.indexOf(".");
        if (n2 >= 0) {
            map2 = paramaterMapVideoDecode.get(string.substring(0, n2).toLowerCase(Locale.ENGLISH));
            string = string.substring(n2 + 1);
        }
        if (transcoderNativeParameterHolder == null && map != null) {
            transcoderNativeParameterHolder = map.get(string.toLowerCase(Locale.ENGLISH));
        }
        if (transcoderNativeParameterHolder == null && map2 != null) {
            transcoderNativeParameterHolder = map2.get(string.toLowerCase(Locale.ENGLISH));
        }
        return transcoderNativeParameterHolder;
    }

    public static TranscoderNativeParameterHolder lookupAudioDecodeParameter(String string, int n) {
        TranscoderNativeParameterHolder transcoderNativeParameterHolder = null;
        String string2 = PARAM_PREFIX_MAINCONCEPT;
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapAudioDecode.get(string2);
        Map<String, TranscoderNativeParameterHolder> map2 = null;
        int n2 = string.indexOf(".");
        if (n2 >= 0) {
            map2 = paramaterMapAudioDecode.get(string.substring(0, n2).toLowerCase(Locale.ENGLISH));
            string = string.substring(n2 + 1);
        }
        if (transcoderNativeParameterHolder == null && map != null) {
            transcoderNativeParameterHolder = map.get(string.toLowerCase(Locale.ENGLISH));
        }
        if (transcoderNativeParameterHolder == null && map2 != null) {
            transcoderNativeParameterHolder = map2.get(string.toLowerCase(Locale.ENGLISH));
        }
        return transcoderNativeParameterHolder;
    }

    public static String videoEncodeImplementationToPrefix(int n, int n2) {
        String string;
        if (n == 9) {
            string = PARAM_PREFIX_IIPH263;
        } else if (n == 12) {
            switch (n2) {
                case 8: {
                    string = PARAM_PREFIX_QUICKSYNC_H265;
                    break;
                }
                case 11: {
                    string = PARAM_PREFIX_X265;
                    break;
                }
                case 15: {
                    string = PARAM_ADVANTECH_VEGA_H265;
                    break;
                }
                case 9: {
                    string = PARAM_PREFIX_NVENC;
                    break;
                }
                case 16: {
                    string = PARAM_PREFIX_VAAPI_H265;
                    break;
                }
                case 18: {
                    string = PARAM_PREFIX_U30_H26X;
                    break;
                }
                default: {
                    string = PARAM_PREFIX_MAINCONCEPT_H265;
                    break;
                }
            }
        } else if (n == 8) {
            switch (n2) {
                case 12: {
                    string = PARAM_PREFIX_VAAPI_VP9;
                    break;
                }
                default: {
                    string = PARAM_PREFIX_VPX;
                    break;
                }
            }
        } else {
            switch (n2) {
                case 1: 
                case 4: {
                    string = PARAM_PREFIX_QUICKSYNC;
                    break;
                }
                case 2: 
                case 5: {
                    string = PARAM_PREFIX_CUDA;
                    break;
                }
                case 6: {
                    string = PARAM_PREFIX_NVENC;
                    break;
                }
                case 7: {
                    string = PARAM_PREFIX_X264;
                    break;
                }
                case 10: {
                    string = PARAM_PREFIX_VAAPI_H264;
                    break;
                }
                case 14: {
                    string = PARAM_ADVANTECH_VEGA_H264;
                    break;
                }
                default: {
                    string = PARAM_PREFIX_MAINCONCEPT;
                    break;
                }
                case 17: {
                    string = PARAM_PREFIX_U30_H26X;
                }
            }
        }
        return string;
    }

    public static String audioEncodeImplementationToPrefix(int n, int n2) {
        String string = PARAM_PREFIX_MAINCONCEPT;
        if (n == 12) {
            string = PARAM_PREFIX_OPUS;
        }
        return string;
    }

    public static String captureImplementationToPrefix(int n) {
        return PARAM_PREFIX_BLACKMAGIC_CAPTURE;
    }

    public static List<TranscoderNativeParameterHolder> getVideoEncodeParameterListByImplementation(int n, int n2, boolean bl) {
        ArrayList<TranscoderNativeParameterHolder> arrayList = new ArrayList<TranscoderNativeParameterHolder>();
        String string = TranscoderNativeParameterInfo.videoEncodeImplementationToPrefix(n, n2);
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapVideoEncode.get(string);
        if (map != null) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public static List<TranscoderNativeParameterHolder> getAudioEncodeParameterListByImplementation(int n, int n2, boolean bl) {
        ArrayList<TranscoderNativeParameterHolder> arrayList = new ArrayList<TranscoderNativeParameterHolder>();
        String string = TranscoderNativeParameterInfo.audioEncodeImplementationToPrefix(n, n2);
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapAudioEncode.get(string);
        if (map != null) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public static List<TranscoderNativeParameterHolder> getCaptureParameterListByImplementation(int n, boolean bl) {
        ArrayList<TranscoderNativeParameterHolder> arrayList = new ArrayList<TranscoderNativeParameterHolder>();
        String string = TranscoderNativeParameterInfo.captureImplementationToPrefix(n);
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapCapture.get(string);
        if (map != null) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public static List<TranscoderNativeParameterHolder> getVideoDecodeParameterListByImplementation(int n, boolean bl) {
        ArrayList<TranscoderNativeParameterHolder> arrayList = new ArrayList<TranscoderNativeParameterHolder>();
        String string = TranscoderNativeParameterInfo.videoDecodeImplementationToPrefix(n);
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapVideoDecode.get(string);
        if (map != null) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public static List<TranscoderNativeParameterHolder> getAudioDecodeParameterListByImplementation(int n, boolean bl) {
        ArrayList<TranscoderNativeParameterHolder> arrayList = new ArrayList<TranscoderNativeParameterHolder>();
        Map<String, TranscoderNativeParameterHolder> map = paramaterMapAudioDecode.get(PARAM_PREFIX_MAINCONCEPT);
        if (map != null) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public static List<TranscoderNativeParameterValue> resolveVideoDecodeParameters(Map<String, String> map, int n) {
        ArrayList<TranscoderNativeParameterValue> arrayList = null;
        if (map.size() >= 0) {
            for (String string : map.keySet()) {
                String string2 = map.get(string);
                TranscoderNativeParameterHolder transcoderNativeParameterHolder = TranscoderNativeParameterInfo.lookupVideoDecodeParameter(string, n);
                if (transcoderNativeParameterHolder == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn("TranscoderNativeParameterInfo.resolveVideoDecodeParameters[" + string + "]: Video encoding parameter not found: " + string);
                    continue;
                }
                TranscoderNativeParameterValue transcoderNativeParameterValue = transcoderNativeParameterHolder.toParamValue(string2);
                if (transcoderNativeParameterValue == null || transcoderNativeParameterValue.dataType == 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<TranscoderNativeParameterValue>();
                }
                arrayList.add(transcoderNativeParameterValue);
            }
        }
        return arrayList;
    }

    public static List<TranscoderNativeParameterValue> resolveAudioDecodeParameters(Map<String, String> map, int n) {
        ArrayList<TranscoderNativeParameterValue> arrayList = null;
        if (map.size() >= 0) {
            for (String string : map.keySet()) {
                String string2 = map.get(string);
                TranscoderNativeParameterHolder transcoderNativeParameterHolder = TranscoderNativeParameterInfo.lookupAudioDecodeParameter(string, n);
                if (transcoderNativeParameterHolder == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn("TranscoderNativeParameterInfo.resolveAudioDecodeParameters[" + string + "]: Audio encoding parameter not found: " + string);
                    continue;
                }
                TranscoderNativeParameterValue transcoderNativeParameterValue = transcoderNativeParameterHolder.toParamValue(string2);
                if (transcoderNativeParameterValue == null || transcoderNativeParameterValue.dataType == 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<TranscoderNativeParameterValue>();
                }
                arrayList.add(transcoderNativeParameterValue);
            }
        }
        return arrayList;
    }

    public static List<TranscoderNativeParameterValue> resolveVideoEncodeParameters(Map<String, String> map, int n, int n2) {
        ArrayList<TranscoderNativeParameterValue> arrayList = null;
        ParameterValueInfo parameterValueInfo = new ParameterValueInfo();
        if (map.size() >= 0) {
            for (String parameterValueInfo.name : map.keySet()) {
                TranscoderNativeParameterHolder transcoderNativeParameterHolder;
                parameterValueInfo.value = map.get(parameterValueInfo.name);
                if ((n2 == 18 || n2 == 17) && parameterValueInfo.name.equals("xilinx-h26x.level")) {
                    parameterValueInfo.value = TranscoderNativeParameterInfo.mapU30LevelToEnum(parameterValueInfo.value);
                }
                if ((transcoderNativeParameterHolder = TranscoderNativeParameterInfo.lookupVideoEncodeParameter(parameterValueInfo.name, n, n2)) == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn("TranscoderNativeParameterInfo.resolveVideoEncodeParameters[" + parameterValueInfo.name + "]: Video encoding parameter not found: " + parameterValueInfo.name);
                    continue;
                }
                TranscoderNativeParameterValue transcoderNativeParameterValue = transcoderNativeParameterHolder.toParamValue(parameterValueInfo.value);
                if (transcoderNativeParameterValue == null || transcoderNativeParameterValue.dataType == 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<TranscoderNativeParameterValue>();
                }
                arrayList.add(transcoderNativeParameterValue);
            }
        }
        return arrayList;
    }

    public static List<TranscoderNativeParameterValue> resolveAudioEncodeParameters(Map<String, String> map, int n, int n2) {
        ArrayList<TranscoderNativeParameterValue> arrayList = null;
        if (map.size() >= 0) {
            for (String string : map.keySet()) {
                String string2 = map.get(string);
                TranscoderNativeParameterHolder transcoderNativeParameterHolder = TranscoderNativeParameterInfo.lookupAudioEncodeParameter(string, n, n2);
                if (transcoderNativeParameterHolder == null) {
                    WMSLoggerFactory.getLogger(CLASS).warn("TranscoderNativeParameterInfo.resolveAudioEncodeParameters[" + string + "]: Audio encoding parameter not found: " + string);
                    continue;
                }
                TranscoderNativeParameterValue transcoderNativeParameterValue = transcoderNativeParameterHolder.toParamValue(string2);
                if (transcoderNativeParameterValue == null || transcoderNativeParameterValue.dataType == 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<TranscoderNativeParameterValue>();
                }
                arrayList.add(transcoderNativeParameterValue);
            }
        }
        return arrayList;
    }

    private static String mapU30LevelToEnum(String string) {
        switch (string) {
            case "10": {
                return "0";
            }
            case "11": {
                return "1";
            }
            case "12": {
                return "2";
            }
            case "13": {
                return "3";
            }
            case "20": {
                return "4";
            }
            case "21": {
                return "5";
            }
            case "22": {
                return "6";
            }
            case "23": {
                return "7";
            }
            case "30": {
                return "8";
            }
            case "31": {
                return "9";
            }
            case "32": {
                return "10";
            }
            case "33": {
                return "11";
            }
            case "40": {
                return "12";
            }
            case "41": {
                return "13";
            }
            case "42": {
                return "14";
            }
            case "50": {
                return "15";
            }
            case "51": {
                return "16";
            }
            case "52": {
                return "17";
            }
        }
        return "0";
    }

    /*
     * Opcode count of 24229 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int n;
        CLASS = TranscoderNativeParameterInfo.class;
        ALL_VIDEODECODING_PARAMETERS = new String[][]{{DECODE_VIDEO_PARAMETER_DEINTERLACE, "LONG", "int32_t", "deinterlace: 0:disabled, 1:enabled"}, {DECODE_VIDEO_PARAMETER_DEINTERLACEDOUBLERATE, "LONG", "int32_t", "deinterlaceDoubleRate: 0:single rate (default), 1:double rate"}};
        BLACKMAGIC_CAPTURE_PARAMETERS = new String[][]{{"BMDDeckLinkSupportsInternalKeying", "Flag", "NA", "BMDDeckLinkSupportsInternalKeying: True if internal keying is supported on this device", "READ"}, {"BMDDeckLinkSupportsExternalKeying", "Flag", "NA", "BMDDeckLinkSupportsExternalKeying: True if external keying is supported on this device", "READ"}, {"BMDDeckLinkSupportsHDKeying", "Flag", "NA", "BMDDeckLinkSupportsHDKeying: True if HD keying is supported on this device", "READ"}, {"BMDDeckLinkSerialPortDeviceName", "String", "NA", "BMDDeckLinkSerialPortDeviceName: The operating system name of the RS422 serial port on this device", "READ"}, {"BMDDeckLinkMaximumAudioChannels", "Int", "NA", "BMDDeckLinkMaximumAudioChannels: The maximum number of embedded audio channels on digital connections supported by this device", "READ"}, {"BMDDeckLinkMaximumAnalogAudioChannels", "Int", "NA", "BMDDeckLinkMaximumAnalogAudioChannels: The maximum number of analog audio channels supported by this device", "READ"}, {"BMDDeckLinkSupportsInputFormatDetection", "Flag", "NA", "BMDDeckLinkSupportsInputFormatDetection: True if input format detection is supported on this device", "READ"}, {"BMDDeckLinkHasReferenceInput", "Flag", "NA", "BMDDeckLinkHasReferenceInput: True if the DeckLink device has a genlock reference source input connector", "READ"}, {"BMDDeckLinkHasSerialPort", "Flag", "NA", "BMDDeckLinkHasSerialPort: True if device has a serial port", "READ"}, {"BMDDeckLinkNumberOfSubDevices", "Int", "NA", "BMDDeckLinkNumberOfSubDevices: Some DeckLink hardware devices contain multiple independent sub-devices. This attribute will be equal to one for most devices, or two or more on a card with multiple sub-devices (eg DeckLink Duo)", "READ"}, {"BMDDeckLinkSubDeviceIndex", "Int", "NA", "BMDDeckLinkSubDeviceIndex: Some DeckLink hardware devices contain multiple independent sub-devices. This attribute indicates the index of the sub-device, starting from zero", "READ"}, {"BMDDeckLinkVideoOutputConnections", "Int", "NA", "BMDDeckLinkVideoOutputConnections: The video output connections supported by the hardware (see BMDVideoConnection for more details)", "READ"}, {"BMDDeckLinkAudioOutputConnections", "Int", "NA", "BMDDeckLinkAudioOutputConnections: The audio output connections supported by the hardware (see BMDAudioConnection for more details)", "READ"}, {"BMDDeckLinkVideoInputConnections", "Int", "NA", "BMDDeckLinkVideoInputConnections: The video input connections supported by the hardware (see BMDVideoConnection for more details)", "READ"}, {"BMDDeckLinkAudioInputConnections", "Int", "NA", "BMDDeckLinkAudioInputConnections: The audio input connections supported by the hardware (see BMDAudioConnection for more details)", "READ"}, {"BMDDeckLinkHasAnalogVideoOutputGain", "Flag", "NA", "BMDDeckLinkHasAnalogVideoOutputGain: True if analog video output gain adjustment is supported on this device", "READ"}, {"BMDDeckLinkCanOnlyAdjustOverallVideoOutputGain", "Flag", "NA", "BMDDeckLinkCanOnlyAdjustOverallVideoOutputGain: True if only the overall video output gain can be adjusted", "READ"}, {"BMDDeckLinkHasVideoInputAntiAliasingFilter", "Flag", "NA", "BMDDeckLinkHasVideoInputAntiAliasingFilter: True if there is an antialising filter on the analog video input of this device", "READ"}, {"BMDDeckLinkHasBypass", "Flag", "NA", "BMDDeckLinkHasBypass: True if this device has loop-through bypass function", "READ"}, {"BMDDeckLinkVideoInputGainMinimum", "Float", "NA", "BMDDeckLinkVideoInputGainMinimum: The minimum video input gain in dB for this device", "READ"}, {"BMDDeckLinkVideoInputGainMaximum", "Float", "NA", "BMDDeckLinkVideoInputGainMaximum: The maximum video input gain in dB for this device", "READ"}, {"BMDDeckLinkVideoOutputGainMinimum", "Float", "NA", "BMDDeckLinkVideoOutputGainMinimum: The minimum video output gain in dB for this device", "READ"}, {"BMDDeckLinkVideoOutputGainMaximum", "Float", "NA", "BMDDeckLinkVideoOutputGainMaximum: The maximum video output gain in dB for this device", "READ"}, {"BMDDeckLinkSupportsDesktopDisplay", "Flag", "NA", "BMDDeckLinkSupportsDesktopDisplay: True if the extended desktop feature is supported on this device and platform", "READ"}, {"BMDDeckLinkVideoIOSupport", "Int", "NA", "BMDDeckLinkVideoIOSupport: The capture and/or playback capability of the device (See BMDVideoIOSupport for more information)", "READ"}, {"BMDDeckLinkSupportsClockTimingAdjustment", "Flag", "NA", "BMDDeckLinkSupportsClockTimingAdjustment:  True if this device supports clock timing adjustment (see bmdDeckLinkConfigClockTimingAdjustment)", "READ"}, {"BMDDeckLinkSupportsFullDuplex", "Flag", "NA", "BMDDeckLinkSupportsFullDuplex: True if the DeckLink device supports capture and playback simultaneously", "READ"}, {"BMDDeckLinkPersistentID", "Int", "NA", "BMDDeckLinkPersistentID: A device specific 32 bit unique identifier", "READ"}, {"BMDDeckLinkPairedDevicePersistentID", "Int", "NA", "BMDDeckLinkPairedDevicePersistentID: The device specific 32 bit unique identifier of the paired sub-device (If the DeckLink device has paired sub-devices - e.g. the DeckLink Quad 2)", "READ"}, {"BMDDeckLinkDeviceGroupID", "Int", "NA", "BMDDeckLinkDeviceGroupID: A 32 bit identifier used to group sub-devices belonging to the same DeckLink hardware device. Supported if the sub-device supports BMDDeckLinkPersistentID", "READ"}, {"BMDDeckLinkTopologicalID", "Int", "NA", "BMDDeckLinkTopologicalID: An identifier for DeckLink devices. This feature is supported on a given device if S_OK is returned. The ID will persist across reboots assuming that devices are not disconnected or moved to a different slot", "READ"}, {"BMDDeckLinkSupportsFullFrameReferenceInputTimingOffset", "Flag", "NA", "BMDDeckLinkSupportsFullFrameReferenceInputTimingOffset: True if the DeckLink device supports genlock offset adjustment wider than +/- 511 pixels (see bmdDeckLinkConfigReferenceInputTimingOffset for more information)", "READ"}, {"BMDDeckLinkSupportsSMPTELevelAOutput", "Flag", "NA", "BMDDeckLinkSupportsSMPTELevelAOutput: True if SMPTE Level A output is supported on this device", "READ"}, {"BMDDeckLinkSupportsDualLinkSDI", "Flag", "NA", "BMDDeckLinkSupportsDualLinkSDI: True if SDI dual-link is supported on this device", "READ"}, {"BMDDeckLinkSupportsQuadLinkSDI", "Flag", "NA", "BMDDeckLinkSupportsQuadLinkSDI: True if SDI quad-link is supported on this device", "READ"}, {"BMDDeckLinkSupportsIdleOutput", "Flag", "NA", "BMDDeckLinkSupportsIdleOutput: True if this device supports idle output. (see BMDIdleVideoOutputOperation for idle output options)", "READ"}, {"BMDDeckLinkDeckControlConnections", "Int", "NA", "BMDDeckLinkDeckControlConnections: The deck control connections supported by the hardware (see BMDDeckControlConnection for more information)", "READ"}, {"BMDDeckLinkMicrophoneInputGainMinimum", "Float", "NA", "BMDDeckLinkMicrophoneInputGainMinimum: The minimum microphone input gain in dB for this device", "READ"}, {"BMDDeckLinkMicrophoneInputGainMaximum", "Float", "NA", "BMDDeckLinkMicrophoneInputGainMaximum: The maximum microphone input gain in dB for this device", "READ"}, {"BMDDeckLinkDeviceInterface", "Int", "NA", "BMDDeckLinkDeviceInterface: The active device interface (see BMDDeviceInterface for more information)", "READ"}, {"BMDDeckLinkHasLTCTimecodeInput", "Flag", "NA", "BMDDeckLinkHasLTCTimecodeInput: True if this device has a dedicated LTC input", "READ"}, {"BMDDeckLinkVendorName", "String", "NA", "BMDDeckLinkVendorName: Hardware vendor name", "READ"}, {"BMDDeckLinkDisplayName", "String", "NA", "BMDDeckLinkDisplayName: The device's display name", "READ"}, {"BMDDeckLinkModeName", "String", "NA", "BMDDeckLinkModeName: Hardware Model Name", "READ"}, {"BMDDeckLinkSupportsDuplexModeConfiguration", "Flag", "NA", "BMDDeckLinkSupportsDuplexModeConfiguration: True if the DeckLink device supports duplex mode configuration. See bmdDeckLinkConfigDuplexMode and BMDDuplexMode for more information", "READ"}, {"BMDDeckLinkSupportsHDRMetadata", "Flag", "NA", "BMDDeckLinkSupportsHDRMetadata: True if the device supports transport of HDR metadata", "READ"}, {"bmdDeckLinkConfigUse1080pNotPsF", "Flag", "NA", "bmdDeckLinkConfigUse1080pNotPsF: In 1080 or 2K modes use P not PsF if this setting is enabled", "READWRITE"}, {"bmdDeckLinkConfigHDMI3DPackingFormat", "LONG", "NA", "bmdDeckLinkConfigHDMI3DPackingFormat: The 3D packing format setting. See BMDVideo3DPackingFormat for more details", "READWRITE"}, {"bmdDeckLinkConfigAnalogAudioConsumerLevels", "Flag", "NA", "bmdDeckLinkConfigAnalogAudioConsumerLevels: If set true the analog audio levels are set to maximum gain on audio input and maximum attenuation on audio output. If set false the selected analog input and output gain levels are used", "READWRITE"}, {"bmdDeckLinkConfigFieldFlickerRemoval", "Flag", "NA", "bmdDeckLinkConfigFieldFlickerRemoval: Sets field flicker removal when paused functionality", "READWRITE"}, {"bmdDeckLinkConfigHD1080p24ToHD1080i5994Conversion", "Flag", "NA", "bmdDeckLinkConfigHD1080p24ToHD1080i5994Conversion:  True if HD 1080p24 to HD 1080i5994 conversion is enabled", "READWRITE"}, {"bmdDeckLinkConfig444SDIVideoOutput", "Flag", "NA", "bmdDeckLinkConfig444SDIVideoOutput: True if 444 video output is enabled", "READWRITE"}, {"bmdDeckLinkConfigBlackVideoOutputDuringCapture", "Flag", "NA", "bmdDeckLinkConfigBlackVideoOutputDuringCapture: True if black output during capture is enabled. This feature is only supported on legacy DeckLink devices", "READWRITE"}, {"bmdDeckLinkConfigReferenceInputTimingOffset", "LONG", "NA", "bmdDeckLinkConfigReferenceInputTimingOffset: Adjust genlock timing pixel offset", "READWRITE"}, {"bmdDeckLinkConfigCapturePassThroughMode", "LONG", "NA", "bmdDeckLinkConfigCapturePassThroughMode: The capture pass through mode specifies how the monitoring video output is generated while capture is in progress", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputConnection", "LONG", "NA", "bmdDeckLinkConfigVideoOutputConnection: The output video connection", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputConversionMode", "LONG", "NA", "bmdDeckLinkConfigVideoOutputConversionMode: Settings for video output conversion. The possible output modes are enumerated by BMDVideoOutputConversionMode", "READWRITE"}, {"bmdDeckLinkConfigAnalogVideoOutputFlags", "LONG", "NA", "bmdDeckLinkConfigAnalogVideoOutputFlags: Settings for analog video output. BMDAnalogVideoFlags enumerates the available analog video \ufb02ags", "READWRITE"}, {"bmdDeckLinkConfigVideoInputConnection", "LONG", "NA", "bmdDeckLinkConfigVideoInputConnection: The input video connection. Only one video input connection can be active at a time. See BMDVideoConnection for more details", "READWRITE"}, {"bmdDeckLinkConfigAnalogVideoInputFlags", "LONG", "NA", "bmdDeckLinkConfigAnalogVideoInputFlags: The analog video input flags. See BMDAnalogVideoFlags for more details", "READWRITE"}, {"bmdDeckLinkConfigVideoInputConversionMode", "LONG", "NA", "bmdDeckLinkConfigVideoInputConversionMode: The video input conversion mode. See BMDVideoInputConversionMode for more details", "READWRITE"}, {"bmdDeckLinkConfig32PulldownSequenceInitialTimecodeFrame", "LONG", "NA", "bmdDeckLinkConfig32PulldownSequenceInitialTimecodeFrame: The A-frame setting for NTSC 23.98, which is used to appropriately adjust the timecode. The frame setting range is between 0 and 29", "READWRITE"}, {"bmdDeckLinkConfigVANCSourceLine1Mapping", "LONG", "NA", "bmdDeckLinkConfigVANCSourceLine1Mapping: The configuration of up to three lines of VANC to be transferred to or from the active picture on capture or output. The acceptable range is between 0 and 30. A value of 0 will disable the capture of that line", "READWRITE"}, {"bmdDeckLinkConfigVANCSourceLine2Mapping", "LONG", "NA", "bmdDeckLinkConfigVANCSourceLine2Mapping: The acceptable range is between 0 and 30. A value of 0 will disable the capture of the line", "READWRITE"}, {"bmdDeckLinkConfigVANCSourceLine3Mapping", "LONG", "NA", "bmdDeckLinkConfigVANCSourceLine3Mapping: The acceptable range is between 0 and 30. A value of 0 will disable the capture of the line", "READWRITE"}, {"bmdDeckLinkConfigAudioInputConnection", "LONG", "NA", "bmdDeckLinkConfigAudioInputConnection: The configuration of the audio input connection. See BMDAudioConnection for more details", "READWRITE"}, {"bmdDeckLinkConfigAnalogAudioInputScaleChannel1", "Float", "NA", "bmdDeckLinkConfigAnalogAudioInputScaleChannel1: The analog audio input scale in dB. The supported range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigAnalogAudioInputScaleChannel2", "Float", "NA", "bmdDeckLinkConfigAnalogAudioInputScaleChannel2: The analog audio input scale in dB. The supported range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigAnalogAudioInputScaleChannel3", "Float", "NA", "bmdDeckLinkConfigAnalogAudioInputScaleChannel3: The analog audio input scale in dB. The supported range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigAnalogAudioInputScaleChannel4", "Float", "NA", "bmdDeckLinkConfigAnalogAudioInputScaleChannel4: The analog audio input scale in dB. The supported range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigDigitalAudioInputScale", "Float", "NA", "bmdDeckLinkConfigDigitalAudioInputScale: The digital audio input scale in dB. The acceptable range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigAudioOutputAESAnalogSwitch", "LONG", "NA", "bmdDeckLinkConfigAudioOutputAESAnalogSwitch: The AES / analog audio output selection switch. This is applicable only to cards that support switchable analog audio outputs", "READWRITE"}, {"bmdDeckLinkConfigAnalogAudioOutputScaleChannel1", "Float", "NA", "bmdDeckLinkConfigAnalogAudioOutputScaleChannel1: The analog audio output scale in dB. The acceptable range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigAnalogAudioOutputScaleChannel2", "Float", "NA", "bmdDeckLinkConfigAnalogAudioOutputScaleChannel2: The analog audio output scale in dB. The acceptable range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigAnalogAudioOutputScaleChannel3", "Float", "NA", "bmdDeckLinkConfigAnalogAudioOutputScaleChannel3: The analog audio output scale in dB. The acceptable range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigAnalogAudioOutputScaleChannel4", "Float", "NA", "bmdDeckLinkConfigAnalogAudioOutputScaleChannel4: The analog audio output scale in dB. The acceptable range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigDigitalAudioOutputScale", "Float", "NA", "bmdDeckLinkConfigDigitalAudioOutputScale: The digital audio output scale in dB. The acceptable range is between -12.00 and 12.00", "READWRITE"}, {"bmdDeckLinkConfigDownConversionOnAllAnalogOutput", "Flag", "NA", "bmdDeckLinkConfigDownConversionOnAllAnalogOutput: Enable down conversion on all analog outputs", "READWRITE"}, {"bmdDeckLinkConfigSMPTELevelAOutput", "Flag", "NA", "bmdDeckLinkConfigSMPTELevelAOutput: Enable SMPTE level A output", "READWRITE"}, {"bmdDeckLinkConfigDeviceInformationLabel", "String", "NA", "bmdDeckLinkConfigDeviceInformationLabel: Set the label of the device. This can only be set if the device has a persistent ID", "READWRITE"}, {"bmdDeckLinkConfigDeviceInformationSerialNumber", "String", "NA", "bmdDeckLinkConfigDeviceInformationSerialNumber: Set the serial number of the device. This can only be set if the device has a persistent ID", "READWRITE"}, {"bmdDeckLinkConfigDeviceInformationCompany", "String", "NA", "bmdDeckLinkConfigDeviceInformationCompany: Set the device's seller name. This can only be set if the device has a persistent ID", "READWRITE"}, {"bmdDeckLinkConfigDeviceInformationPhone", "String", "NA", "bmdDeckLinkConfigDeviceInformationPhone: Set the device's seller phone number. This can only be set if the device has a persistent ID", "READWRITE"}, {"bmdDeckLinkConfigDeviceInformationEmail", "String", "NA", "bmdDeckLinkConfigDeviceInformationEmail: Set the device's seller email address. This can only be set if the device has a persistent ID", "READWRITE"}, {"bmdDeckLinkConfigDeviceInformationDate", "String", "NA", "bmdDeckLinkConfigDeviceInformationDate: Set the device's purchase date. This can only be set if the device has a persistent ID", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputIdleOperation", "LONG", "NA", "bmdDeckLinkConfigVideoOutputIdleOperation: Video output idle control. See BMDIdleVideoOutputOperation for more details", "READWRITE"}, {"bmdDeckLinkConfigSwapSerialRxTx", "Flag", "NA", "bmdDeckLinkConfigSwapSerialRxTx: If set to true, the Rx and Tx lines of the RS422 port on the DeckLink device will be swapped", "READWRITE"}, {"bmdDeckLinkConfigBypass", "LONG", "NA", "bmdDeckLinkConfigBypass: The state of the bypass feature. This parameter can be set to a value of -1 for normal operation or zero to bypass the card. A timeout of up to 65 seconds may be specified in milliseconds", "READWRITE"}, {"bmdDeckLinkConfigClockTimingAdjustment", "LONG", "NA", "bmdDeckLinkConfigClockTimingAdjustment: Clock frequency adjustment for fine output control. The acceptable range is from -127 to 127 PPM (Parts Per Million)", "READWRITE"}, {"bmdDeckLinkConfigVideoInputScanning", "Flag", "NA", "bmdDeckLinkConfigVideoInputScanning: The video input connector scanning on the H.264 Pro Recorder. True if enabled", "READWRITE"}, {"bmdDeckLinkConfigUseDedicatedLTCInput", "Flag", "NA", "bmdDeckLinkConfigUseDedicatedLTCInput: Use the timecode from the LTC input rather than from the SDI stream", "READWRITE"}, {"bmdDeckLinkConfigDefaultVideoOutputMode", "LONG", "NA", "bmdDeckLinkConfigDefaultVideoOutputMode: The default video output mode. The bmdDeckLinkConfigDefaultVideoOutputModeFlags must be set for 3D video modes before using this setting. See BMDDisplayMode for more details", "READWRITE"}, {"bmdDeckLinkConfigDefaultVideoOutputModeFlags", "LONG", "NA", "bmdDeckLinkConfigDefaultVideoOutputModeFlags: The default video output mode 2D or 3D flag setting. See bmdVideoOutputFlagDefault and bmdVideoOutputDualStream3D for more details", "READWRITE"}, {"bmdDeckLinkConfigSDIOutputLinkConfiguration", "LONG", "NA", "bmdDeckLinkConfigSDIOutputLinkConfiguration: The SDI link configuration for a single output video stream. See BMDLinkConfiguration for more information", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputComponentLumaGain", "Float", "NA", "bmdDeckLinkConfigVideoOutputComponentLumaGain: The component video output luma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoOutputGainMinimum and BMDDeckLinkVideoOutputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputComponentChromaBlueGain", "Float", "NA", "bmdDeckLinkConfigVideoOutputComponentChromaBlueGain: The component video output chroma blue gain in dB.The accepted range can be determined by using the BMDDeckLinkVideoOutputGainMinimum and BMDDeckLinkVideoOutputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputComponentChromaRedGain", "Float", "NA", "bmdDeckLinkConfigVideoOutputComponentChromaRedGain: The component video output chroma red gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoOutputGainMinimum and BMDDeckLinkVideoOutputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputCompositeLumaGain", "Float", "NA", "bmdDeckLinkConfigVideoOutputCompositeLumaGain: The composite video output luma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoOutputGainMinimum and BMDDeckLinkVideoOutputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputCompositeChromaGain", "Float", "NA", "bmdDeckLinkConfigVideoOutputCompositeChromaGain: The composite video output chroma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoOutputGainMinimum and BMDDeckLinkVideoOutputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputSVideoLumaGain", "Float", "NA", "bmdDeckLinkConfigVideoOutputSVideoLumaGain: The s-video output luma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoOutputGainMinimum and BMDDeckLinkVideoOutputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoOutputSVideoChromaGain", "Float", "NA", "bmdDeckLinkConfigVideoOutputSVideoChromaGain: The s-video output chroma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoOutputGainMinimum and BMDDeckLinkVideoOutputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoInputComponentLumaGain", "Float", "NA", "bmdDeckLinkConfigVideoInputComponentLumaGain: The component video input luma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoInputGainMinimum and BMDDeckLinkVideoInputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoInputComponentChromaBlueGain", "Float", "NA", "bmdDeckLinkConfigVideoInputComponentChromaBlueGain: The component video input chroma blue gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoInputGainMinimum and BMDDeckLinkVideoInputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoInputComponentChromaRedGain", "Float", "NA", "bmdDeckLinkConfigVideoInputComponentChromaRedGain: The component video input chroma red gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoInputGainMinimum and BMDDeckLinkVideoInputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoInputCompositeLumaGain", "Float", "NA", "bmdDeckLinkConfigVideoInputCompositeLumaGain: The composite video input luma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoInputGainMinimum and BMDDeckLinkVideoInputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoInputCompositeChromaGain", "Float", "NA", "bmdDeckLinkConfigVideoInputCompositeChromaGain: The composite video input chroma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoInputGainMinimum and BMDDeckLinkVideoInputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoInputSVideoLumaGain", "Float", "NA", "bmdDeckLinkConfigVideoInputSVideoLumaGain: The s-video input luma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoInputGainMinimum and BMDDeckLinkVideoInputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigVideoInputSVideoChromaGain", "Float", "NA", "bmdDeckLinkConfigVideoInputSVideoChromaGain: The s-video input chroma gain in dB. The accepted range can be determined by using the BMDDeckLinkVideoInputGainMinimum and BMDDeckLinkVideoInputGainMaximum attributes", "READWRITE"}, {"bmdDeckLinkConfigMicrophonePhantomPower", "Flag", "NA", "bmdDeckLinkConfigMicrophonePhantomPower: If set to true, the Microphone input will provide +48V Phantom Power", "READWRITE"}, {"bmdDeckLinkConfigMicrophoneInputGain", "Float", "NA", "bmdDeckLinkConfigMicrophoneInputGain: The microphone input gain in dB. The acceptable range can be determined via BMDDeckLinkMicrophoneInputGainMinimum and BMDDeckLinkMicrophoneInputGainMaximum", "READWRITE"}, {"bmdDeckLinkConfigHeadphoneVolume", "Float", "NA", "bmdDeckLinkConfigHeadphoneVolume: Set the headphone volume, acceptable range is between 0.0 (mute), to 1.0 (full volume)", "READWRITE"}, {"bmdDeckLinkConfigDeckControlConnection", "LONG", "NA", "bmdDeckLinkConfigDeckControlConnection: The active RS422 deck control connection. See BMDDeckControlConnection for more information", "READWRITE"}, {"bmdDeckLinkConfigSDIInput3DPayloadOverride", "Flag", "NA", "bmdDeckLinkConfigSDIInput3DPayloadOverride: If set to true, the device will capture two genlocked SDI streams with matching video modes as a 3D stream", "READWRITE"}, {"bmdDeckLinkConfigDuplexMode", "LONG", "NA", "bmdDeckLinkConfigDuplexMode: The active duplex mode on sub-devices which support duplex mode configuration. See BMDDeckLinkSupportsDuplexModeConfiguration and BMDDuplexMode for more information", "READWRITE"}, {"customEmptyFrameWidth", "LONG", "NA", "customEmptyFrameWidth: The width of an empty frame"}, {"customEmptyFrameHeight", "LONG", "NA", "customEmptyFrameHeight: The height of an empty frame"}, {"customAudioCaptureChannelCount", "LONG", "NA", "customAudioCaptureChannelCount: Maximum number of audio channel to capture: 0: no limit (default)"}, {"customDeinterlaceMode", "LONG", "NA", "customDeinterlaceMode: Deinterlace implementation: 0: default, 1: YADIF"}, {"customGPUID", "LONG", "NA", "customGPUID: GPUID: default is -1"}};
        VPX_VIDEOENCODING_PARAMETERS = new String[][]{{"g_usage", "LONG", "unsigned int", "g_usage: Algorithm specific usage value"}, {"g_threads", "LONG", "unsigned int", "g_threads: Maximum number of threads to use"}, {"g_profile", "LONG", "unsigned int", "g_profile: Bitstream profile to use"}, {"g_w", "LONG", "unsigned int", "g_w: Width of the frame"}, {"g_h", "LONG", "unsigned int", "g_h: Height of the frame"}, {"g_bit_depth", "LONG", "unsigned int", "g_bit_depth: Bit-depth of the codec: 8, 10, 12"}, {"g_input_bit_depth", "LONG", "unsigned int", "g_input_bit_depth: Bit-depth of the input frames"}, {"g_timebase_num", "LONG", "unsigned int", "g_timebase_num: Stream timebase units"}, {"g_timebase_den", "LONG", "unsigned int", "g_timebase_den: Stream timebase units"}, {"g_error_resilient", "LONG", "unsigned int", "g_error_resilient: Enable error resilient modes: 1:default, 2:partitions"}, {"g_pass", "LONG", "unsigned int", "g_pass: Multi-pass Encoding Mode"}, {"g_lag_in_frames", "LONG", "unsigned int", "g_lag_in_frames: Allow lagged encoding"}, {"rc_dropframe_thresh", "LONG", "unsigned int", "rc_dropframe_thresh: Temporal resampling configuration, if supported by the codec"}, {"rc_resize_allowed", "LONG", "unsigned int", "rc_resize_allowed: Enable/disable spatial resampling, if supported by the codec."}, {"rc_scaled_width", "LONG", "unsigned int", "rc_scaled_width: Internal coded frame width."}, {"rc_scaled_height", "LONG", "unsigned int", "rc_scaled_height: Internal coded frame height."}, {"rc_resize_up_thresh", "LONG", "unsigned int", "rc_resize_up_thresh: Spatial resampling up watermark."}, {"rc_resize_down_thresh", "LONG", "unsigned int", "rc_resize_down_thresh: Spatial resampling down watermark."}, {"rc_end_usage", "LONG", "unsigned int", "rc_end_usage: Rate control algorithm to use: 0:VBR, 1:CBR, 2:CQ, 3:Q"}, {"rc_target_bitrate", "LONG", "unsigned int", "rc_target_bitrate: Target data rate in kilobits per second"}, {"rc_min_quantizer", "LONG", "unsigned int", "rc_min_quantizer: Minimum (Best Quality) Quantizer"}, {"rc_max_quantizer", "LONG", "unsigned int", "rc_max_quantizer: Maximum (Worst Quality) Quantizer"}, {"rc_undershoot_pct", "LONG", "unsigned int", "rc_undershoot_pct: Rate control adaptation undershoot control"}, {"rc_overshoot_pct", "LONG", "unsigned int", "rc_overshoot_pct: Rate control adaptation overshoot control"}, {"rc_buf_sz", "LONG", "unsigned int", "rc_buf_sz: Decoder Buffer Size (milliseconds)"}, {"rc_buf_initial_sz", "LONG", "unsigned int", "rc_buf_initial_sz: Decoder Buffer Initial Size (milliseconds)"}, {"rc_buf_optimal_sz", "LONG", "unsigned int", "rc_buf_optimal_sz: Decoder Buffer Optimal Size (milliseconds)"}, {"rc_2pass_vbr_bias_pct", "LONG", "unsigned int", "rc_2pass_vbr_bias_pct: Two-pass mode CBR/VBR bias"}, {"rc_2pass_vbr_minsection_pct", "LONG", "unsigned int", "rc_2pass_vbr_minsection_pct: Two-pass mode per-GOP minimum bitrate"}, {"rc_2pass_vbr_maxsection_pct", "LONG", "unsigned int", "rc_2pass_vbr_maxsection_pct: Two-pass mode per-GOP maximum bitrate"}, {"kf_mode", "LONG", "unsigned int", "kf_mode: Keyframe placement mode: 1:FIXED, 2:AUTO, 0:DISABLED"}, {"kf_min_dist", "LONG", "unsigned int", "kf_min_dist: Keyframe minimum interval"}, {"kf_max_dist", "LONG", "unsigned int", "kf_max_dist: Keyframe maximum interval"}, {"cpu_used", "LONG", "int", "cpu_used: Codec control function to set encoder internal speed settings: VP8: -16..16, VP9: -8..8 (default is max setting)"}, {"deadline", "LONG", "unsigned long", "deadline: Time to spend encoding, in microseconds. 0:infinite, 1:realtime"}};
        MAINCONCEPT_VIDEODECODING_PARAMETERS = new String[][]{{"optCPUNum", "LONG", "int32_t", "optCPUNum: Sets number of logical CPUs, which can be used in specified SMP mode by the optSMPMode command"}, {"optSMPMode", "LONG", "int32_t", "optSMPMode: Sets symmetric multiprocessing (SMP) mode of decoding: 0:SMP_NONE, 1:SMP_BY_PICTURES, 2:SMP_BY_SLICES"}, {"optACCMode", "LONG", "int32_t", "optACCMode: Hardware acceleration mode: 0:ACC_MODE_NONE, 1:ACC_MODE_DXVA1, 2:ACC_MODE_DXVA2, 3:ACC_MODE_NVCUVID"}, {"maxTemporalLayer", "LONG", "int32_t", "maxTemporalLayer: Set maximum layer to be decode (default is 8)"}, {"loop_filter", "LONG", "int32_t", "loop_filter: Set loop filter mode option: 0:off, 1:on"}, {"output_8bit", "LONG", "int32_t", "output_8bit: Allow only 8bit output image option: 0:off, 1:on"}, {"mv_precision", "LONG", "int32_t", "mv_precision: Limits precision of motion vectors option: 0:PRECISION_QUARTER, 1:H264VD_MV_PRECISION_HALF, 2:H264VD_MV_PRECISION_FULL"}, {"dpb_size", "LONG", "int32_t", "dpb_size: Set DPB size option"}, {"ec", "LONG", "int32_t", "ec: Set Error concealemnt modes (bitmask): 0:NONE, 1:SHOW_BASE_LAYER (SVC only), 2:CONCEAL_ERROR_FRAMES, 4:TEMPORAL_FOR_INTRA, 8:ERRORLESS_REF_ONLY"}};
        NVCUVID_VIDEODECODING_PARAMETERS = new String[][]{{"numDecodeSurfaces", "LONG", "int32_t", "numDecodeSurfaces: Number of decode surfaces (default 16)"}, {"maxNumDecodeSurfaces", "LONG", "int32_t", "maxNumDecodeSurfaces: Max number of decode surfaces (default 16)"}, {"maxDisplayDelay", "LONG", "int32_t", "maxDisplayDelay: Display display (default 1)"}, {"numOutputSurfaces", "LONG", "int32_t", "numOutputSurfaces: Number of output surfaces (default 4)"}, {"deinterlaceMode", "LONG", "int32_t", "deinterlaceMode: Deinterlace mode: 0:Weave, 1:Bob, 2:Adaptive (default 2)"}};
        ALL_AUDIODECODING_PARAMETERS = new String[][]{{DECODE_AUDIO_PARAMETER_SCALECHANNELS, "LONG", "int32_t", "scaleChannels: Fold or expand audio channels: 0:off, 1:mono (not implemented), 2:stereo"}, {DECODE_AUDIO_PARAMETER_SCALESAMPLERATE, "LONG", "int32_t", "scaleSampleRate: Scale the audio sample rate: 0:off, x:sample rate (future)"}};
        ADVANTECH_VEGA_H264_VIDEOENCODING_PARAMETERS = new String[][]{{"eInputMode", "LONG", "uint32_t", "eInputMode: Sets input mode from host or video interface: 0=data, 1=vif square, 2=vif 2 sample interleave"}, {"eInputPort", "LONG", "uint32_t", "eInputPort: Sets the SDI input port for VIF mode: 0=default, 1=A, 2=B, 4=C, 8=D"}, {"eRobustMode", "LONG", "uint32_t", "eRobustMode: Sets the robustness method for VIF mode: 0=stop encoding, 1=blue screen"}, {"eProfile", "LONG", "uint32_t", "eProfile: Sets profile of encoder: 1=main, 2=high, 3=high10, 4=high422, 5=baseline"}, {"eLevel", "LONG", "uint32_t", "eLevel: Sets level of encoder"}, {"eEntropyCoding", "LONG", "uint32_t", "eEntropyCoding: Sets entropy coding mode of encoder: 0=CABAC, 1=CAVLC"}, {"eResolution", "LONG", "uint32_t", "eResolution: Sets output resolution generated by encoder: 0=352x288, 1=416x240, 2=720x480, 3=720x576, 4=1280x720, 5=1920x1080, 6=2048x1080, 7=2560x1440, 8=2880x2160, 9=3840x2160, 10=4096x2160, 11=INVALID"}, {"bAspectRatioInfoPresent", "LONG", "uint32_t", "bAspectRatioInfoPresent"}, {"eAspectRatioIdc", "LONG", "uint32_t", "eAspectRatioIdc: Sets aspect ratio idc: 0=unspecified, 1-16=see AVC spec, 255=extended SAR"}, {"u32SarWidth", "LONG", "uint32_t", "u32SarWidth: Sets customed sample aspect width"}, {"u32SarHeight", "LONG", "uint32_t", "u32SarHeight: Sets customed sample aspect height"}, {"bDisableTimingInfoPresent", "LONG", "uint32_t", "bDisableTimingInfoPresent: Sets presentation of vps timing info"}, {"eFormat", "LONG", "uint32_t", "eFormat: Sets input image format: 0=NV12, 1=NV16, 2=YUV420, 3=YUV420P010, 4=YUV422P010, 5=YUV420P10LE, 6=YUV422P10LE"}, {"eChromaFmt", "LONG", "uint32_t", "eChromaFmt: Sets chroma format: 0=mono, 1=420, 2=422, 3=422_TO_420"}, {"eOverScan", "LONG", "uint32_t", "eOverScan: Sets VUI overscan information: 0=NOT_PRESENT, 1=INAPPROPRIATE, 2=APPROPRIATE"}, {"tVideoSignalType_bPresentFlag", "LONG", "uint32_t", "tVideoSignalType_bPresentFlag: Sets pensence of vui_parameters_present_flag"}, {"tVideoSignalType_eVideoFormat", "LONG", "uint32_t", "tVideoSignalType_eVideoFormat: Sets the representation of the pictures; described in Table E.2 Meaning of video_format"}, {"tVideoSignalType_bVideoFullRange", "LONG", "uint32_t", "tVideoSignalType_bVideoFullRange: Sets the black level and range of the luma and chroma signals as derived from EY, EPB, and EPR or ER, EG, and EB real-valued component signals"}, {"tVideoSignalType_tColorDesc_bPresentFlag", "LONG", "uint32_t", "tVideoSignalType_tColorDesc_bPresentFlag: Sets VUI video signal information: "}, {"tVideoSignalType_tColorDesc_eColorPrimaries", "LONG", "uint32_t", "tVideoSignalType_tColorDesc_eColorPrimaries: Sets VUI video signal information: "}, {"tVideoSignalType_tColorDesc_eTransferCharacteristics", "LONG", "uint32_t", "tVideoSignalType_tColorDesc_eTransferCharacteristics: Sets VUI video signal information: "}, {"tVideoSignalType_tColorDesc_eMatrixCoeff", "LONG", "uint32_t", "tVideoSignalType_tColorDesc_eMatrixCoeff: Sets VUI video signal information: "}, {"tChromaLocation_bChromaLoc", "LONG", "uint32_t", "tChromaLocation_bChromaLoc: Sets presence of chroma_loc_info_present_flag in VUI"}, {"tChromaLocation_eTopFieldLoc", "LONG", "uint32_t", "tChromaLocation_eTopFieldLoc: Sets chroma sampling location value of top field"}, {"tChromaLocation_eBotFieldLoc", "LONG", "uint32_t", "tChromaLocation_eBotFieldLoc: Sets chroma sampling location value of bottom field"}, {"eBitDepth", "LONG", "uint32_t", "eBitDepth: Sets output bit depth: 0=8, 1=10"}, {"bInterlace", "LONG", "uint32_t", "bInterlace: Sets interlace / progressive mode"}, {"bDisableSceneChangeDetect", "LONG", "uint32_t", "bDisableSceneChangeDetect: Disable scene change detection"}, {"tCrop_u32CropLeft", "LONG", "uint32_t", "tCrop_u32CropLeft: Sets crop info of output frame"}, {"tCrop_u32CropRight", "LONG", "uint32_t", "tCrop_u32CropRight: Sets crop info of output frame"}, {"tCrop_u32CropTop", "LONG", "uint32_t", "tCrop_u32CropTop: Sets crop info of output frame"}, {"tCrop_u32CropBottom", "LONG", "uint32_t", "tCrop_u32CropBottom: Sets crop info of output frame"}, {"eTargetFrameRate", "LONG", "uint32_t", "eTargetFrameRate: Sets the frame rate of encoder: 15=15, 23=23_98, 24=24, 25=25, 29=29_97, 30=30, 50=50, 59=59_94, 60=60, 255=CUSTOMED"}, {"tCustomedFrameRateInfo_u32TimeScale", "LONG", "uint32_t", "tCustomedFrameRateInfo_u32TimeScale: Set customized frame rate"}, {"tCustomedFrameRateInfo_u32NumUnitsInTicks", "LONG", "uint32_t", "tCustomedFrameRateInfo_u32NumUnitsInTicks: Set customized frame rate"}, {"ePtsMode", "LONG", "uint32_t", "ePtsMode: Sets if encoder accepts user PTS: 0=auto, 1=user, 2=vanc"}, {"eIDRFrameNum", "LONG", "uint32_t", "eIDRFrameNum: Sets number of I frame as IDR frames"}, {"eGopType", "LONG", "uint32_t", "eGopType: Sets GOP structure: 0=I, 1=IP, 2=IPB, 3=IB"}, {"eGopHierarchy", "LONG", "uint32_t", "eGopHierarchy: Sets hierarchy method: 0=HIERARCHY, 1=HIERARCHY_NONE, 2=HIERARCHY_NO_LEADING_PICTURE"}, {"eGopSize", "LONG", "uint32_t", "eGopSize: GOP size. Unit: number of frames, GOP size must be divisible by reference frame number"}, {"eBFrameNum", "LONG", "uint32_t", "eBFrameNum: Sets number of inserted B frames b/t two referenced frames: 0=none, 1-7=[value], 8=max"}, {"bDisableTemporalId", "LONG", "uint32_t", "bDisableTemporalId: Switch off temporal ID. Default: use temporal ID"}, {"eRateCtrlAlgo", "LONG", "uint32_t", "eRateCtrlAlgo: Sets encoder rate control algorithm: 0=CBR, 1=CAPPED_VBR"}, {"u32FillerTriggerLevel", "LONG", "uint32_t", "u32FillerTriggerLevel: Fill up bitrate to u32FillerTriggerLevel(in percentage) to prevent underflow"}, {"u32Bitrate", "LONG", "uint32_t", "u32Bitrate: Sets encoder bitrate. Unit: kbps, Limitation: u32Bitrate <= API_MAX_BITRATE"}, {"u32MaxVBR", "LONG", "uint32_t", "u32MaxVBR: Sets encoder bitrate upper bound. unit: kbps, Limitation: u32AveVBR <= u32MaxVBR <= u32Bitrate"}, {"u32AveVBR", "LONG", "uint32_t", "u32AveVBR: Sets encoder average bitrate. unit: kbps, Limitation: u32AveVBR <= u32MaxVBR"}, {"u32MinVBR", "LONG", "uint32_t", "u32MinVBR: Sets encoder bitrate lower bound. unit: kbps, Limitation: u32MinVBR <= u32AveVBR"}, {"u32CpbDelay", "LONG", "uint32_t", "u32CpbDelay: Specify the cpb delay time, 0 = 270,000 (default 3sec)"}, {"tCoding_bDisableDeblocking", "LONG", "uint32_t", "tCoding_bDisableDeblocking: Disable deblocking"}, {"tCoding_eWeightedPrediction", "LONG", "uint32_t", "tCoding_eWeightedPrediction: Weighted prediction mode: 0=off, 1=PB"}, {"eDebugLevel", "LONG", "uint32_t", "eDebugLevel: Debug print level 0-4"}, {"bResetDevice", "LONG", "uint32_t", "bResetDevice: Reset device on encode"}, {"eMode", "LONG", "uint32_t", "eMode: Set encode mode for device on encode"}};
        ADVANTECH_VEGA_H265_VIDEOENCODING_PARAMETERS = new String[][]{{"eInputMode", "LONG", "uint32_t", "eInputMode: Sets input mode from host or video interface: 0=data, 1=vif square, 2=vif 2 sample interleave"}, {"eInputPort", "LONG", "uint32_t", "eInputPort: Sets the SDI input port for VIF mode: 0=default, 1=A, 2=B, 4=C, 8=D"}, {"eRobustMode", "LONG", "uint32_t", "eRobustMode: Sets the robustness method for VIF mode: 0=stop encoding, 1=blue screen"}, {"eProfile", "LONG", "uint32_t", "eProfile: Sets profile of encoder: 1=main, 2=high10, 3=main-still-picture, 4=main422-10"}, {"eLevel", "LONG", "uint32_t", "eLevel: Sets level of encoder"}, {"eTier", "LONG", "uint32_t", "eTier: Sets tier of encoder: 0=main, 1=high"}, {"eResolution", "LONG", "uint32_t", "eResolution: Sets output resolution generated by encoder: 0=352x288, 1=416x240, 2=720x480, 3=720x576, 4=1280x720, 5=1920x1080, 6=2048x1080, 7=2560x1440, 8=2880x2160, 9=3840x2160, 10=4096x2160, 11=INVALID"}, {"eAspectRatioIdc", "LONG", "uint32_t", "eAspectRatioIdc: Sets aspect ratio idc: 0=unspecified, 1-16=see AVC spec, 255=extended SAR"}, {"u32SarWidth", "LONG", "uint32_t", "u32SarWidth: Sets customed sample aspect width"}, {"u32SarHeight", "LONG", "uint32_t", "u32SarHeight: Sets customed sample aspect height"}, {"bDisableVpsTimingInfoPresent", "LONG", "uint32_t", "bDisableVpsTimingInfoPresent: Sets presentation of vps timing info. Default: use VPS timing infoformation"}, {"eFormat", "LONG", "uint32_t", "eFormat: Sets input image format: 0=NV12, 1=NV16, 2=YUV420, 3=YUV420P010, 4=YUV422P010, 5=YUV420P10LE, 6=YUV422P10LE"}, {"eChromaFmt", "LONG", "uint32_t", "eChromaFmt: Sets chroma format: 0=mono, 1=420, 2=422, 3=422_TO_420"}, {"eOverScan", "LONG", "uint32_t", "eOverScan: Sets VUI overscan information: 0=NOT_PRESENT, 1=INAPPROPRIATE, 2=APPROPRIATE"}, {"tVideoSignalType_bPresentFlag", "LONG", "uint32_t", "tVideoSignalType_bPresentFlag: Sets pensence of vui_parameters_present_flag"}, {"tVideoSignalType_eVideoFormat", "LONG", "uint32_t", "tVideoSignalType_eVideoFormat: Sets the representation of the pictures; described in Table E.2 Meaning of video_format"}, {"tVideoSignalType_bVideoFullRange", "LONG", "uint32_t", "tVideoSignalType_bVideoFullRange: Sets the black level and range of the luma and chroma signals as derived from EY, EPB, and EPR or ER, EG, and EB real-valued component signals"}, {"tVideoSignalType_tColorDesc_bPresentFlag", "LONG", "uint32_t", "tVideoSignalType_tColorDesc_bPresentFlag: Sets VUI video signal information: "}, {"tVideoSignalType_tColorDesc_eColorPrimaries", "LONG", "uint32_t", "tVideoSignalType_tColorDesc_eColorPrimaries: Sets VUI video signal information: "}, {"tVideoSignalType_tColorDesc_eTransferCharacteristics", "LONG", "uint32_t", "tVideoSignalType_tColorDesc_eTransferCharacteristics: Sets VUI video signal information: "}, {"tVideoSignalType_tColorDesc_eMatrixCoeff", "LONG", "uint32_t", "tVideoSignalType_tColorDesc_eMatrixCoeff: Sets VUI video signal information: "}, {"tChromaLocation_bChromaLoc", "LONG", "uint32_t", "tChromaLocation_bChromaLoc: Sets presence of chroma_loc_info_present_flag in VUI"}, {"tChromaLocation_eTopFieldLoc", "LONG", "uint32_t", "tChromaLocation_eTopFieldLoc: Sets chroma sampling location value of top field"}, {"tChromaLocation_eBotFieldLoc", "LONG", "uint32_t", "tChromaLocation_eBotFieldLoc: Sets chroma sampling location value of bottom field"}, {"eBitDepth", "LONG", "uint32_t", "eBitDepth: Sets output bit depth: 0=8, 1=10"}, {"bInterlace", "LONG", "uint32_t", "bInterlace: Sets interlace / progressive mode"}, {"bDisableSceneChangeDetect", "LONG", "uint32_t", "bDisableSceneChangeDetect: Disable scene change detection"}, {"tCrop_u32CropLeft", "LONG", "uint32_t", "tCrop_u32CropLeft: Sets crop info of output frame"}, {"tCrop_u32CropRight", "LONG", "uint32_t", "tCrop_u32CropRight: Sets crop info of output frame"}, {"tCrop_u32CropTop", "LONG", "uint32_t", "tCrop_u32CropTop: Sets crop info of output frame"}, {"tCrop_u32CropBottom", "LONG", "uint32_t", "tCrop_u32CropBottom: Sets crop info of output frame"}, {"eTargetFrameRate", "LONG", "uint32_t", "eTargetFrameRate: Sets the frame rate of encoder: 15=15, 23=23_98, 24=24, 25=25, 29=29_97, 30=30, 50=50, 59=59_94, 60=60, 255=CUSTOMED"}, {"tCustomedFrameRateInfo_u32TimeScale", "LONG", "uint32_t", "tCustomedFrameRateInfo_u32TimeScale: Set customized frame rate"}, {"tCustomedFrameRateInfo_u32NumUnitsInTicks", "LONG", "uint32_t", "tCustomedFrameRateInfo_u32NumUnitsInTicks: Set customized frame rate"}, {"ePtsMode", "LONG", "uint32_t", "ePtsMode: Sets if encoder accepts user PTS: 0=auto, 1=user, 2=vanc"}, {"eIDRFrameNum", "LONG", "uint32_t", "eIDRFrameNum: Sets number of I frame as IDR frames"}, {"eIDRType", "LONG", "uint32_t", "eIDRType: Sets IDR NAL type: 0=W_RADL, 1=N_LP"}, {"eGopType", "LONG", "uint32_t", "eGopType: Sets GOP structure: 0=I, 1=IP, 2=IPB, 3=IB"}, {"eGopHierarchy", "LONG", "uint32_t", "eGopHierarchy: Sets hierarchy method: 0=HIERARCHY, 1=HIERARCHY_NONE, 2=HIERARCHY_NO_LEADING_PICTURE"}, {"eGopSize", "LONG", "uint32_t", "eGopSize: GOP size. Unit: number of frames, GOP size must be divisible by reference frame number"}, {"eBFrameNum", "LONG", "uint32_t", "eBFrameNum: Sets number of inserted B frames b/t two referenced frames: 0=none, 1-7=[value], 8=max"}, {"bDisableTemporalId", "LONG", "uint32_t", "bDisableTemporalId: Switch off temporal ID. Default: use temporal ID"}, {"eRateCtrlAlgo", "LONG", "uint32_t", "eRateCtrlAlgo: Sets encoder rate control algorithm: 0=CBR, 1=CAPPED_VBR"}, {"u32FillerTriggerLevel", "LONG", "uint32_t", "u32FillerTriggerLevel: Fill up bitrate to u32FillerTriggerLevel(in percentage) to prevent underflow"}, {"u32Bitrate", "LONG", "uint32_t", "u32Bitrate: Sets encoder bitrate. Unit: kbps, Limitation: u32Bitrate <= API_MAX_BITRATE"}, {"u32MaxVBR", "LONG", "uint32_t", "u32MaxVBR: Sets encoder bitrate upper bound. unit: kbps, Limitation: u32AveVBR <= u32MaxVBR <= u32Bitrate"}, {"u32AveVBR", "LONG", "uint32_t", "u32AveVBR: Sets encoder average bitrate. unit: kbps, Limitation: u32AveVBR <= u32MaxVBR"}, {"u32MinVBR", "LONG", "uint32_t", "u32MinVBR: Sets encoder bitrate lower bound. unit: kbps, Limitation: u32MinVBR <= u32AveVBR"}, {"u32CpbDelay", "LONG", "uint32_t", "u32CpbDelay: Specify the cpb delay time, 0 = 270,000 (default 3sec)"}, {"tCoding_bEnableAdaptiveQuantization", "LONG", "uint32_t", "tCoding_bEnableAdaptiveQuantization: Enable / disable adaptive quantization"}, {"tCoding_u32Qmin", "LONG", "uint32_t", "tCoding_u32Qmin: Sets minimal q value"}, {"tCoding_u32Qmax", "LONG", "uint32_t", "tCoding_u32Qmax: Sets maximal q value"}, {"tCoding_u32CtuSize", "LONG", "uint32_t", "tCoding_u32CtuSize: Sets Max CTU size"}, {"tCoding_u32MinCuSize", "LONG", "uint32_t", "tCoding_u32MinCuSize: Sets Min CU size"}, {"tCoding_u32MaxTuSize", "LONG", "uint32_t", "tCoding_u32MaxTuSize: Sets Max TU size"}, {"tCoding_u32MinTuSize", "LONG", "uint32_t", "tCoding_u32MinTuSize: Sets Min TU size"}, {"tCoding_u32MaxTuDepthIntra", "LONG", "uint32_t", "tCoding_u32MaxTuDepthIntra: Sets Max TU depth for intra frame"}, {"tCoding_u32MaxTuDepthInter", "LONG", "uint32_t", "tCoding_u32MaxTuDepthInter: Sets Max TU depth for inter frame"}, {"tCoding_bDisableDeblocking", "LONG", "uint32_t", "tCoding_bDisableDeblocking: Disable deblocking"}, {"tCoding_bDisableAMP", "LONG", "uint32_t", "tCoding_bDisableAMP: Disable AMP"}, {"tCoding_eWeightedPrediction", "LONG", "uint32_t", "tCoding_eWeightedPrediction: Sets weighted prediction"}, {"tCoding_bDisableSAO", "LONG", "uint32_t", "tCoding_bDisableSAO: Disable SAO"}, {"tCoding_bWPP", "LONG", "uint32_t", "tCoding_bWPP: Enable Wavefront Parallel Processing"}, {"tCoding_u32NumSliceSegInSlice", "LONG", "uint32_t", "tCoding_u32NumSliceSegInSlice: Sets number of slice segment in slice"}, {"tHdrConfig_bEnable", "LONG", "uint32_t", "tHdrConfig_bEnable: Enable HDR SEI"}, {"tHdrConfig_u8LightContentLocation", "LONG", "uint32_t", "tHdrConfig_u8LightContentLocation: The index location of light content info for user SEI; this will occpuy one of user SEI"}, {"tHdrConfig_u16MaxContentLightLevel", "LONG", "uint32_t", "tHdrConfig_u16MaxContentLightLevel: The maximum nit value (in units of 0.00001 nit) used anywhere in the content"}, {"tHdrConfig_u16MaxPictureAvgLightLevel", "LONG", "uint32_t", "tHdrConfig_u16MaxPictureAvgLightLevel: The per-frame average of the maximum nit values (in units of 0.00001 nit)"}, {"tHdrConfig_u8AlternativeTransferCharacteristicsLocation", "LONG", "uint32_t", "tHdrConfig_u8AlternativeTransferCharacteristicsLocation: The index location of alternative transfer characteristics for user SEI; this will occpuy another user SEI"}, {"tHdrConfig_eAlternativeTransferCharacteristics", "LONG", "uint32_t", "tHdrConfig_eAlternativeTransferCharacteristics: The alternative transfer characteristics for HDR TV, to display the content correctly"}, {"tHdrConfig_u8MasteringDisplayColourVolumeLocation", "LONG", "uint32_t", "tHdrConfig_u8MasteringDisplayColourVolumeLocation: The index location of mastering display colour volume for user SEI; this will occpuy another user SEI"}, {"tHdrConfig_u16DisplayPrimariesX0", "LONG", "uint32_t", "tHdrConfig_u16DisplayPrimariesX0: The chromaticity coordinates of the 1.0 green value in x coordinate"}, {"tHdrConfig_u16DisplayPrimariesY0", "LONG", "uint32_t", "tHdrConfig_u16DisplayPrimariesY0: The chromaticity coordinates of the 1.0 green value in x coordinate"}, {"tHdrConfig_u16DisplayPrimariesX1", "LONG", "uint32_t", "tHdrConfig_u16DisplayPrimariesX1: The chromaticity coordinates of the 1.0 green value in x coordinate"}, {"tHdrConfig_u16DisplayPrimariesY1", "LONG", "uint32_t", "tHdrConfig_u16DisplayPrimariesY1: The chromaticity coordinates of the 1.0 green value in x coordinate"}, {"tHdrConfig_u16DisplayPrimariesX2", "LONG", "uint32_t", "tHdrConfig_u16DisplayPrimariesX2: The chromaticity coordinates of the 1.0 green value in x coordinate"}, {"tHdrConfig_u16DisplayPrimariesY2", "LONG", "uint32_t", "tHdrConfig_u16DisplayPrimariesY2: The chromaticity coordinates of the 1.0 green value in x coordinate"}, {"tHdrConfig_u16WhitePointX", "LONG", "uint32_t", "tHdrConfig_u16WhitePointX: The chromaticity coordinates of the 1.0 green value in x coordinate"}, {"tHdrConfig_u16WhitePointY", "LONG", "uint32_t", "tHdrConfig_u16WhitePointY: The chromaticity coordinates of the white point in y coordinate"}, {"tHdrConfig_u32MaxDisplayMasteringLuminance", "LONG", "uint32_t", "tHdrConfig_u32MaxDisplayMasteringLuminance: The maximum number of nits of the display used to master the content. Units are 0.0001 nit, so if the value is 1 nit, the value should be 10,000"}, {"tHdrConfig_u32MinDisplayMasteringLuminance", "LONG", "uint32_t", "tHdrConfig_u32MinDisplayMasteringLuminance: The minimum number of nits (in units of 0.00001 nit) of the display used to master the content"}, {"bEnableUltraLowLatency", "LONG", "uint32_t", "bEnableUltraLowLatency:  Turn on ultra low latency mode"}, {"eDebugLevel", "LONG", "uint32_t", "eDebugLevel: Debug print level 0-4"}, {"bResetDevice", "LONG", "uint32_t", "bResetDevice: Reset device on encode"}, {"eMode", "LONG", "uint32_t", "eMode: Set encode mode for device on encode"}};
        MAINCONCEPT_H265_VIDEOENCODING_PARAMETERS = new String[][]{{"main_preset", "LONG", "int32_t", "main_preset: Predefined set of special settings for SABET default initialisation"}, {"performance_mode", "LONG", "int32_t", "performance_mode: performance mode (irrelevant for now)"}, {"performance_level", "LONG", "int32_t", "performance_level: performance level, from HEVC_PERF_FASTEST to HEVC_PERF_BEST_Q"}, {"performance_reserved", "LONG", "int32_t", "performance_reserved: (irrelevant for now)"}, {"chroma_format", "LONG", "int32_t", "chroma_format: Chroma format of encoded picture"}, {"max_layers", "LONG", "int32_t", "max_layers: Number of different coding layers"}, {"snr_infer_split", "LONG", "int32_t", "snr_infer_split: Accelerates multi-layer encoding by re-using CTU structure data from previous layer. (Only used when max_layers > 1)"}, {"max_dec_pic_buffering", "LONG", "int32_t", "max_dec_pic_buffering: Maximum number of frames in decoded picture buffer"}, {"max_src_pic_buffering", "LONG", "int32_t", "max_src_pic_buffering: Input queue size for analysis and source buffering max"}, {"min_src_pic_buffering", "LONG", "int32_t", "min_src_pic_buffering: Input queue size for analysis and source buffering min"}, {"bit_depth_luma", "LONG", "int32_t", "bit_depth_luma: Bit depth of encoded luminance samples."}, {"bit_depth_chroma", "LONG", "int32_t", "bit_depth_chroma: Bit depth of encoded chrominance samples."}, {"time_scale", "LONG", "int32_t", "time_scale: Timing info use together with @ref num_units_in_tick (frame rate in fps = time_scale/num_units_in_tick)"}, {"num_units_in_tick", "LONG", "int32_t", "num_units_in_tick: Timing info use together with @ref time_scale"}, {"log2_max_poc_lsb", "LONG", "int32_t", "log2_max_poc_lsb: Allows to specify custom log2_max_pic_order_cnt_lsb_minus4 value"}, {"intra_analysis", "LONG", "int32_t", "intra_analysis: "}, {"statistics_level", "LONG", "int32_t", "statistics_level: Calculating of detailed mode encoding statistic and bits distribution"}, {"pic_hash", "LONG", "int32_t", "pic_hash: Calculating MD5"}, {"quality_metric", "LONG", "int32_t", "quality_metric: Calculating quality metric mode"}, {"cpu_opt", "LONG", "int32_t", "cpu_opt: CPU optimization"}, {"num_threads", "LONG", "int32_t", "num_threads: Number of threads"}, {"max_intra_period", "LONG", "int32_t", "max_intra_period: Max GOP length"}, {"min_intra_period", "LONG", "int32_t", "min_intra_period: Min GOP length"}, {"irap_period", "LONG", "int32_t", "irap_period: IDR period in GOP units"}, {"fixed_intra_position", "LONG", "int32_t", "fixed_intra_position: Fixed position of IDR"}, {"vscd_mode", "LONG", "int32_t", "vscd_mode: Enable Scene Change Detection"}, {"adaptive_num_b_pics", "LONG", "int32_t", "adaptive_num_b_pics: Enable adaptive b frames"}, {"max_num_b_pics", "LONG", "int32_t", "max_num_b_pics: Maximum number of B pictures"}, {"max_num_ref_pics_p", "LONG", "int32_t", "max_num_ref_pics_p: Number of reference frames used on P frames from list0. [0, 16]"}, {"max_num_ref_pics_b_l0", "LONG", "int32_t", "max_num_ref_pics_b_l0: Number of reference frames used on B frames from list0. [0, 16]"}, {"max_num_ref_pics_b_l1", "LONG", "int32_t", "max_num_ref_pics_b_l1: Number of reference frames used on B frames from list1. [0, 16]"}, {"preset", "LONG", "int32_t", "preset: Predefined set of special settings"}, {"profile", "LONG", "int32_t", "profile: Profile used to encode layer, it should be one of the preset defines"}, {"level", "LONG", "int32_t", "level: Level (multiplied by 30) used to maintain conformance of encoded file"}, {"width", "LONG", "int32_t", "width: Width of the encoded video layer"}, {"height", "LONG", "int32_t", "height: Height of the encoded video layer"}, {"wavefront_processing", "LONG", "int32_t", "wavefront_processing: Enable Wavefront Parallel Processing (WPP)"}, {"log2_min_cu_size", "LONG", "int32_t", "log2_min_cu_size: Minimum size of a coding block"}, {"log2_max_cu_size", "LONG", "int32_t", "log2_max_cu_size: Maximum size of a coding block"}, {"log2_min_tu_size", "LONG", "int32_t", "log2_min_tu_size: Minimum size of a transfrom block"}, {"log2_max_tu_size", "LONG", "int32_t", "log2_max_tu_size: Maximum size of a transfrom block"}, {"max_tu_depth_inter", "LONG", "int32_t", "max_tu_depth_inter: Maximum hierarchy depth for transform units of coding units coded in inter prediction mode"}, {"max_tu_depth_intra", "LONG", "int32_t", "max_tu_depth_intra: Maximum hierarchy depth for transform units of coding units coded in intra prediction mode"}, {"intra_partitioning", "LONG", "int32_t", "intra_partitioning: Enable intra partitioning on the last CU depth"}, {"strong_intra_smoothing", "LONG", "int32_t", "strong_intra_smoothing: Enable strong intra smoothing for CU size >= 32"}, {"motion_search_range", "LONG", "int32_t", "motion_search_range: Search range in quarter pel units"}, {"motion_search_precision", "LONG", "int32_t", "motion_search_precision: Sub-pel motion accuracy: HEVC_FULL_PEL, HEVC_HALF_PEL, HEVC_QUARTER_PEL"}, {"out_of_pic_mvs", "LONG", "int32_t", "out_of_pic_mvs: Enable out of picture MVs"}, {"max_num_merge_cand", "LONG", "int32_t", "max_num_merge_cand: Maximum number of merge candidates"}, {"inter_partitioning", "LONG", "int32_t", "inter_partitioning: Enable inter partitioning: 0 - off, 1 - symmetric only, 2 - both symmetric and asymmetric"}, {"temporal_mv_prediction", "LONG", "int32_t", "temporal_mv_prediction: Use vector predictor from collocated picture"}, {"deblocking_filter", "LONG", "int32_t", "deblocking_filter: Enable Deblocking filter"}, {"beta_offset", "LONG", "int32_t", "beta_offset: Beta offset [-6, 6]"}, {"tc_offset", "LONG", "int32_t", "tc_offset: tc offset [-6, 6]"}, {"sao_filter_luma", "LONG", "int32_t", "sao_filter_luma: Enable SAO filter for luma"}, {"sao_filter_chroma", "LONG", "int32_t", "sao_filter_chroma: Enable SAO filter for chroma"}, {"bit_rate_mode", "LONG", "int32_t", "bit_rate_mode: Rate control mode: HEVC_CBR, HEVC_CQT or HEVC_VBR"}, {"qp_i", "LONG", "int32_t", "qp_i: Qp for I-slice (ConstQ mode)"}, {"qp_p", "LONG", "int32_t", "qp_p: Qp for P-slice (ConstQ mode)"}, {"qp_b", "LONG", "int32_t", "qp_b: Qp for B-slice (ConstQ mode)"}, {"min_qp", "LONG", "int32_t", "min_qp: Minimum QP (VBR & CBR only)"}, {"max_qp", "LONG", "int32_t", "max_qp: Maximum QP (VBR & CBR only)"}, {"bit_rate", "LONG", "int32_t", "bit_rate: Average bitrate (VBR and CBR), bits/sec"}, {"hss_rate", "LONG", "int32_t", "hss_rate: HSS rate (VBR mode, for CBR this value should match @ref bit_rate), bits/sec"}, {"cpb_size", "LONG", "int32_t", "cpb_size: Coded Picture Buffer (CPB) size (see @ref cpb_fullness_units)"}, {"hrd_conformance", "LONG", "int32_t", "hrd_conformance: Maintain Hypothetical Reference Decoder (HRD): 0 - off; 1 - NAL"}, {"cpb_fullness", "LONG", "int32_t", "cpb_fullness: Initial CPB fullness (see @ref cpb_fullness_units)"}, {"cpb_fullness_trg", "LONG", "int32_t", "cpb_fullness_trg: Target CPB fullness (see @ref cpb_fullness_units)"}, {"cpb_fullness_units", "LONG", "int32_t", "cpb_fullness_units: CPB fullness units: 0 - CPB fullness in %, 1 - all parameters are in bits, 2 - CPB fullness in 90 kHz clocks"}, {"bit_rate_scale", "LONG", "int32_t", "bit_rate_scale: Scale factor for bit_rate, hss_rate"}, {"cpb_size_scale", "LONG", "int32_t", "cpb_size_scale: Scale factor for cpb_size"}, {"sign_data_hiding", "LONG", "int32_t", "sign_data_hiding: Enable sign hide quantization"}, {"transform_skip", "LONG", "int32_t", "transform_skip: Enable transform skip"}, {"cb_qp_offset", "LONG", "int32_t", "cb_qp_offset: Chroma qp offset (-X -> increase quality, +X -> decrease quality)"}, {"cr_qp_offset", "LONG", "int32_t", "cr_qp_offset: Chroma qp offset (-X -> increase quality, +X -> decrease quality)"}, {"coeff_quantization", "LONG", "int32_t", "coeff_quantization: Finding optimal quantized coefficients"}, {"vui_presentation", "LONG", "int32_t", "vui_presentation: VUI option flags"}, {"sar_idc", "LONG", "int32_t", "sar_idc: Sample aspect ratio"}, {"par_width", "LONG", "int32_t", "par_width: Picture aspect ratio: horizontal size"}, {"par_height", "LONG", "int32_t", "par_height: Picture aspect ratio: vertical size"}, {"sar_width", "LONG", "int32_t", "sar_width: Sample aspect ratio width use only for sar_idc = 255"}, {"sar_height", "LONG", "int32_t", "sar_height: Sample aspect ratio height use only for sar_idc = 255"}, {"annexb", "LONG", "int32_t", "annexb: Use Annex B or NALUs"}, {"stream_type", "LONG", "int32_t", "stream_type: Output stream type"}, {"au_delimiter", "LONG", "int32_t", "au_delimiter: Write Access Unit Delimeters (AUD)"}, {"seq_end_code", "LONG", "int32_t", "seq_end_code: Write End Of Sequence code (EOS)"}, {"single_sei_per_nalu", "LONG", "int32_t", "single_sei_per_nalu: Write single SEI per NALU"}, {"parsets_on_every_intra_pic", "LONG", "int32_t", "parsets_on_every_intra_pic: Write VPS, SPS and PPS header before each I frame"}, {"id_stamp", "LONG", "int32_t", "id_stamp: Write ID stamp"}};
        X265_VIDEOENCODING_PARAMETERS = new String[][]{{"profile", "LONG", "uint32_t", "profile: -1=[profile-in-template], 0=main"}, {"preset", "LONG", "uint32_t", "preset: -1=[no-preset], 0=ultrafast, 1=superfast, 2=veryfast, 3=faster, 4=fast, 5=medium, 6=slow, 7=slower, 8=veryslow, 9=placebo"}, {"tune", "LONG", "int32_t", "tune: -1=[no-tuning], 0=psnr, 1=ssim, 2=grain, 3=zerolatency, 4=fastdecode"}, {"tune_zerolatency", "LONG", "int32_t", "tune-zerolatency: Tune for zero latency (required for live): 0=off, 1=on"}, {"cpuid", "LONG", "int", "cpuid: Default will auto-detect this cpu capability bitmap, best to leave along"}, {"frameNumThreads", "LONG", "int", "frameNumThreads: Number of concurrently encoded frames: 0=auto-detect, 1-16 (X265_MAX_FRAME_THREADS)"}, {"bEnableWavefront", "LONG", "int", "bEnableWavefront: Wavefront parallel processing, greatly increases parallelism for less than 1% compression efficiency loss: 0=off, 1=on"}, {"bDistributeModeAnalysis", "LONG", "int", "bDistributeModeAnalysis: Use multiple threads to measure CU mode costs: 0=off, 1=on"}, {"bDistributeMotionEstimation", "LONG", "int", "bDistributeMotionEstimation: Use multiple threads to perform motion estimation: 0=off, 1=on"}, {"bEnablePsnr", "LONG", "int", "bEnablePsnr: Enable the measurement and reporting of PSNR: 0=off, 1=on"}, {"bEnableSsim", "LONG", "int", "bEnableSsim: Enable the measurement and reporting of SSIM: 0=off, 1=on"}, {"logLevel", "LONG", "int", "logLevel: The level of logging detail emitted by the encoder: -1=none, 0=error - 4=full"}, {"internalBitDepth", "LONG", "int", "internalBitDepth: Internal encoder bit depth"}, {"internalCsp", "LONG", "int", "internalCsp: Color space of internal pictures"}, {"fpsNum", "LONG", "int", "fpsNum: Numerator of frame rate"}, {"fpsDenom", "LONG", "int", "fpsDenom: Denominator of frame rate"}, {"sourceWidth", "LONG", "int", "sourceWidth: Width (in pixels) of the source pictures"}, {"sourceHeight", "LONG", "int", "sourceHeight: Height (in pixels) of the source pictures"}, {"interlaceMode", "LONG", "int", "interlaceMode: Interlace type of source pictures: 0=progressive, 1=top-first, 2=bottom-first"}, {"totalFrames", "LONG", "int", "totalFrames: Total Number of frames to be encoded: 0=unlimited"}, {"levelIdc", "LONG", "int", "levelIdc: Minimum decoder requirement level: 0=auto-detect"}, {"bHighTier", "LONG", "int", "bHighTier: If levelIdc is specified (non-zero) this flag will differentiate between Main (0) and High (1) tier"}, {"maxNumReferences", "LONG", "int", "maxNumReferences: Maximum number of L0 references a P or B slice may use"}, {"bAllowNonConformance", "LONG", "int", "bAllowNonConformance: Allow libx265 to emit HEVC bitstreams which do not meet strict level requirements: 0=off, 1=on"}, {"bRepeatHeaders", "LONG", "int", "bRepeatHeaders: Flag indicating whether VPS, SPS and PPS headers should be output with each keyframe: 0=off, 1=on"}, {"bAnnexB", "LONG", "int", "bAnnexB: Flag indicating whether the encoder should generate start codes: 0=off, 1=on"}, {"bEnableAccessUnitDelimiters", "LONG", "int", "bEnableAccessUnitDelimiters: Flag indicating whether the encoder should emit an Access Unit Delimiter NAL at the start of every access unit: 0=off, 1=on"}, {"bEmitHRDSEI", "LONG", "int", "bEmitHRDSEI: Enables the buffering period SEI and picture timing SEI to signal the HRD parameters: 0=off, 1=on"}, {"bEmitInfoSEI", "LONG", "int", "bEmitInfoSEI: Enables the emission of a user data SEI with the stream headers which describes the encoder version, build info, and parameters: 0=off, 1=on"}, {"decodedPictureHashSEI", "LONG", "int", "decodedPictureHashSEI: Enable the generation of SEI messages for each encoded frame containing the hashes of the three reconstructed picture planes: 0=off, 1=MD5, 2=CRC, 3=Checksum"}, {"bEnableTemporalSubLayers", "LONG", "int", "bEnableTemporalSubLayers: Enable Temporal Sub Layers while encoding: 0=off, 1=on"}, {"bOpenGOP", "LONG", "int", "bOpenGOP: Enable open GOP: 0=off, 1=on"}, {"keyframeMin", "LONG", "int", "keyframeMin: Scene cuts closer together than this are coded as I, not IDR"}, {"keyframeMax", "LONG", "int", "keyframeMax: Maximum keyframe distance or intra period in number of frames"}, {"bframes", "LONG", "int", "bframes: Maximum consecutive B frames that can be emitted by the lookahead"}, {"bFrameAdaptive", "LONG", "int", "bFrameAdaptive: Sets the operating mode of the lookahead: 0=off, 1=on"}, {"bBPyramid", "LONG", "int", "bBPyramid: When enabled, the encoder will use the B frame in the middle of each mini-GOP larger than 2 B frames as a motion reference for the surrounding B frames: 0=off, 1=on"}, {"bFrameBias", "LONG", "int", "bFrameBias: A value which is added to the cost estimate of B frames in the lookahead: 0=off, 1=on"}, {"lookaheadDepth", "LONG", "int", "lookaheadDepth: The number of frames that must be queued in the lookahead before it may make slice decisions"}, {"lookaheadSlices", "LONG", "int", "lookaheadSlices: Use multiple worker threads to measure the estimated cost of each frame within the lookahead"}, {"scenecutThreshold", "LONG", "int", "scenecutThreshold: An arbitrary threshold which determines how aggressively the lookahead should detect scene cuts"}, {"maxCUSize", "LONG", "int", "maxCUSize: Maximum CU width and height in pixels"}, {"minCUSize", "LONG", "int", "minCUSize: Minimum CU width and height in pixels"}, {"bEnableRectInter", "LONG", "int", "bEnableRectInter: Enable rectangular motion prediction partitions (vertical and horizontal), available at all CU depths from 64x64 to 8x8: 0=off, 1=on"}, {"bEnableAMP", "LONG", "int", "bEnableAMP: Enable asymmetrical motion predictions: 0=off, 1=on"}, {"maxTUSize", "LONG", "int", "maxTUSize: Maximum TU width and height in pixels"}, {"tuQTMaxInterDepth", "LONG", "int", "tuQTMaxInterDepth: The additional depth the residual quad-tree is allowed to recurse beyond the coding quad-tree, for inter coded blocks"}, {"tuQTMaxIntraDepth", "LONG", "int", "tuQTMaxIntraDepth: The additional depth the residual quad-tree is allowed to recurse beyond the coding quad-tree, for intra coded blocks"}, {"rdoqLevel", "LONG", "int", "rdoqLevel: Set the amount of rate-distortion analysis to use within quant"}, {"bEnableSignHiding", "LONG", "int", "bEnableSignHiding: Enable the implicit signaling of the sign bit of the last coefficient of each transform unit: 0=off, 1=on"}, {"bEnableTransformSkip", "LONG", "int", "bEnableTransformSkip: Allow intra coded blocks to be encoded directly as residual without the DCT transform, when this improves efficiency: 0=off, 1=on"}, {"noiseReductionIntra", "LONG", "int", "noiseReductionIntra: An integer value in range of 0 to 2000, which denotes strength of noise reduction in intra CUs"}, {"noiseReductionInter", "LONG", "int", "noiseReductionInter: An integer value in range of 0 to 2000, which denotes strength of noise reduction in inter CUs"}, {"bEnableConstrainedIntra", "LONG", "int", "bEnableConstrainedIntra: Enable constrained intra prediction: 0=off, 1=on"}, {"bEnableStrongIntraSmoothing", "LONG", "int", "bEnableStrongIntraSmoothing: Enable strong intra smoothing for 32x32 blocks where the reference samples are flat: 0=off, 1=on"}, {"maxNumMergeCand", "LONG", "int", "maxNumMergeCand: The maximum number of merge candidates that are considered during inter analysis: 1-5"}, {"limitReferences", "LONG", "int", "limitReferences: Limit the motion references used for each search based on the results of previous motion searches already performed for the same CU: If 0 all references are always searched"}, {"searchMethod", "LONG", "int", "searchMethod: ME search method: 0=DIA, 1=HEX, 2=UMH, 3=STAR, 4=FULL"}, {"subpelRefine", "LONG", "int", "subpelRefine: A value between 0 and X265_MAX_SUBPEL_LEVEL which adjusts the amount of effort performed during sub-pel refine: 1-7 (X265_MAX_SUBPEL_LEVEL)"}, {"searchRange", "LONG", "int", "searchRange: The maximum distance from the motion prediction that the full pel motion search is allowed to progress before terminating"}, {"bEnableTemporalMvp", "LONG", "int", "bEnableTemporalMvp: Enable availability of temporal motion vector for AMVP: 0=off, 1=on"}, {"bEnableWeightedPred", "LONG", "int", "bEnableWeightedPred: Enable weighted prediction in P slices: 0=off, 1=on"}, {"bEnableWeightedBiPred", "LONG", "int", "bEnableWeightedBiPred: Enable weighted prediction in B slices: 0=off, 1=on"}, {"bEnableLoopFilter", "LONG", "int", "bEnableLoopFilter: Enable the deblocking loop filter, which improves visual quality by reducing blocking effects at block edges, particularly at lower bitrates or higher QP: 0=off, 1=on"}, {"deblockingFilterTCOffset", "LONG", "int", "deblockingFilterTCOffset: Deblocking filter tC offset [-6, 6] -6 light filter, 6 strong: -6-6"}, {"deblockingFilterBetaOffset", "LONG", "int", "deblockingFilterBetaOffset: deblocking filter Beta offset [-6, 6] -6 light filter, 6 strong: -6-6"}, {"bEnableSAO", "LONG", "int", "bEnableSAO: Enable the Sample Adaptive Offset loop filter, which reduces distortion effects by adjusting reconstructed sample values based on histogram analysis to better approximate the original samples: 0=off, 1=on"}, {"bSaoNonDeblocked", "LONG", "int", "param: "}, {"rdLevel", "LONG", "int", "rdLevel: A value between X265_NO_RDO_NO_RDOQ and X265_RDO_LEVEL which determines the level of rate distortion optimizations to perform during mode decisions and quantization"}, {"bEnableEarlySkip", "LONG", "int", "bEnableEarlySkip: Enable early skip decisions to avoid intra and inter analysis in likely skip blocks: 0=off, 1=on"}, {"bEnableFastIntra", "LONG", "int", "bEnableFastIntra: Use a faster search method to find the best intra mode: 0=off, 1=on"}, {"bEnableTSkipFast", "LONG", "int", "bEnableTSkipFast: Enable a faster determination of whether skipping the DCT transform will be beneficial: 0=off, 1=on"}, {"bCULossless", "LONG", "int", "bCULossless: The CU Lossless flag, when enabled, compares the rate-distortion costs for normal and lossless encoding, and chooses the best mode for each CU: 0=off, 1=on"}, {"bIntraInBFrames", "LONG", "int", "bIntraInBFrames: Specify whether to attempt to encode intra modes in B frames: 0=off, 1=on"}, {"rdPenalty", "LONG", "int", "rdPenalty: Apply an optional penalty to the estimated cost of 32x32 intra blocks in non-intra slices: 0=disabled, 1=small penalty, 2=full penalty"}, {"psyRd", "DOUBLE", "double", "psyRd: Psycho-visual rate-distortion strength: 0-2.0"}, {"psyRdoq", "DOUBLE", "double", "psyRdoq: Strength of psycho-visual optimizations in quantization: 0-50.0"}, {"analysisMode", "LONG", "int", "analysisMode: If X265_ANALYSIS_SAVE, write per-frame analysis information into analysis buffers"}, {"bLossless", "LONG", "int", "bLossless: The lossless flag enables true lossless coding, bypassing scaling, transform, quantization and in-loop filter processes: o=off, 1=on"}, {"cbQpOffset", "LONG", "int", "cbQpOffset: Generally a small signed integer which offsets the QP used to quantize the Cb chroma residual (delta from luma QP specified by rate-control)"}, {"crQpOffset", "LONG", "int", "crQpOffset: Generally a small signed integer which offsets the QP used to quantize the Cr chroma residual (delta from luma QP specified by rate-control)"}, {"rateControlMode", "LONG", "int", "rateControlMode: Explicit mode of rate-control, necessary for API users: 0=ABR, 1=CQP, 2=CRF"}, {"qp", "LONG", "int", "qp: Base QP to use for Constant QP rate control"}, {"bitrate", "LONG", "int", "bitrate: Target bitrate for Average BitRate (ABR) rate control"}, {"qCompress", "DOUBLE", "double", "qCompress: Sets the quantizer curve compression factor: 0.0-1.0"}, {"ipFactor", "DOUBLE", "double", "ipFactor: QP offset between I/P and P/B frames"}, {"pbFactor", "DOUBLE", "double", "pbFactor: QP offset between I/P and P/B frames"}, {"rfConstant", "DOUBLE", "double", "rfConstant: Ratefactor constant: targets a certain constant quality: 0.0-51.0"}, {"qpStep", "LONG", "int", "qpStep: Max QP difference between frames"}, {"aqMode", "LONG", "int", "aqMode: Enable adaptive quantization: 0=none, 1=variance, 2=auto-variance, 3=auto-variance-biased"}, {"aqStrength", "DOUBLE", "double", "aqStrength: Sets the strength of AQ bias towards low detail CTUs: 0.0-3.0"}, {"vbvMaxBitrate", "LONG", "int", "vbvMaxBitrate: Maximum rate the VBV buffer should be assumed to refill at"}, {"vbvBufferSize", "LONG", "int", "vbvBufferSize: Size of the VBV buffer in kilobits"}, {"vbvBufferInit", "DOUBLE", "double", "vbvBufferInit: How full the VBV buffer must be before playback starts: 0.0-1.0"}, {"cuTree", "LONG", "int", "cuTree: Enable CUTree rate-control"}, {"rfConstantMax", "DOUBLE", "double", "rfConstantMax: In CRF mode, maximum CRF as caused by VBV"}, {"rfConstantMin", "DOUBLE", "double", "rfConstantMin: In CRF mode, minimum CRF as caused by VBV"}, {"qblur", "DOUBLE", "double", "qblur: Temporally blur quants"}, {"complexityBlur", "DOUBLE", "double", "complexityBlur: Temporally blur complexity"}, {"bEnableSlowFirstPass", "LONG", "int", "bEnableSlowFirstPass: Enable slow and a more detailed first pass encode in multi pass rate control: 0=off, 1=on"}, {"bStrictCbr", "LONG", "int", "bStrictCbr: Enable stricter conditions to check bitrate deviations in CBR mode: 0=off, 1=on"}, {"qgSize", "LONG", "int", "qgSize: Enable adaptive quantization at CU granularity: 64, 32, 16"}, {"aspectRatioIdc", "LONG", "int", "aspectRatioIdc: Aspect ratio idc to be added to the VUI"}, {"sarWidth", "LONG", "int", "sarWidth: Sample Aspect Ratio width in arbitrary units to be added to the VUI only if aspectRatioIdc is set to 255"}, {"sarHeight", "LONG", "int", "sarHeight: Sample Aspect Ratio height in arbitrary units to be added to the VUI only if aspectRatioIdc is set to 255"}, {"bEnableOverscanInfoPresentFlag", "LONG", "int", "bEnableOverscanInfoPresentFlag: Enable overscan info present flag in the VUI: 0=off, 1=on"}, {"bEnableOverscanAppropriateFlag", "LONG", "int", "bEnableOverscanAppropriateFlag: Enable overscan appropriate flag: 0=off, 1=on"}, {"bEnableVideoSignalTypePresentFlag", "LONG", "int", "bEnableVideoSignalTypePresentFlag: Video signal type present flag of the VUI: 0=off, 1=on"}, {"videoFormat", "LONG", "int", "videoFormat: Video format of the source video: 0=component, 1=PAL, 2=TSC, 3=SECAM, 4=MAC, 5=unspecified"}, {"bEnableVideoFullRangeFlag", "LONG", "int", "bEnableVideoFullRangeFlag: Video full range flag indicates the black level and range of the luma and chroma signals as derived from E'Y, E'PB, and E'PR or E'R, E'G, and E'B real-valued component signals: 0=off, 1=on"}, {"bEnableColorDescriptionPresentFlag", "LONG", "int", "bEnableColorDescriptionPresentFlag: Color description present flag in the VUI."}, {"colorPrimaries", "LONG", "int", "colorPrimaries: Color primaries holds the chromacity coordinates of the source primaries"}, {"transferCharacteristics", "LONG", "int", "transferCharacteristics: Transfer characteristics indicates the opto-electronic transfer characteristic of the source picture"}, {"matrixCoeffs", "LONG", "int", "matrixCoeffs: Matrix coefficients used to derive the luma and chroma signals from the red, blue and green primaries"}, {"bEnableChromaLocInfoPresentFlag", "LONG", "int", "bEnableChromaLocInfoPresentFlag: Chroma location info present flag adds chroma_sample_loc_type_top_field and chroma_sample_loc_type_bottom_field to the VUI: 0=off, 1=on"}, {"chromaSampleLocTypeTopField", "LONG", "int", "chromaSampleLocTypeTopField: Chroma sample location type top field holds the chroma location in the top field"}, {"chromaSampleLocTypeBottomField", "LONG", "int", "chromaSampleLocTypeBottomField: Chroma sample location type bottom field holds the chroma location in the bottom field"}, {"bEnableDefaultDisplayWindowFlag", "LONG", "int", "bEnableDefaultDisplayWindowFlag: Default display window flag adds def_disp_win_left_offset, def_disp_win_right_offset, def_disp_win_top_offset and def_disp_win_bottom_offset to the VUI: 0=off, 1=on"}, {"defDispWinLeftOffset", "LONG", "int", "defDispWinLeftOffset: Default display window left offset holds the left offset with the conformance cropping window to further crop the displayed window"}, {"defDispWinRightOffset", "LONG", "int", "defDispWinRightOffset: Default display window right offset holds the right offset with the conformance cropping window to further crop the displayed window"}, {"defDispWinTopOffset", "LONG", "int", "defDispWinTopOffset: Default display window top offset holds the top offset with the conformance cropping window to further crop the displayed window"}, {"defDispWinBottomOffset", "LONG", "int", "defDispWinBottomOffset: Default display window bottom offset holds the bottom offset with the conformance cropping window to further crop the displayed window"}, {"maxCLL", "LONG", "int", "maxCLL: Maximum Content light level(MaxCLL), specified as integer that indicates the maximum pixel intensity level in units of 1 candela per square metre of the bitstream"}, {"maxFALL", "LONG", "int", "maxFALL:  Maximum Frame Average Light Level(MaxFALL), specified as integer that indicates the maximum frame average intensity level in units of 1 candela per square metre of the bitstream"}, {"minLuma", "LONG", "int", "minLuma: Minimum luma level of input source picture, specified as a integer which would automatically increase any luma values below the specified --min-luma value to that value"}, {"maxLuma", "LONG", "int", "maxLuma: Maximum luma level of input source picture, specified as a integer which would automatically decrease any luma values above the specified --max-luma value to that value"}};
        X264_VIDEOENCODING_PARAMETERS = new String[][]{{"profile", "LONG", "uint32_t", "profile: -1=[profile-in-template], 0=baseline, 1=main, 2=high"}, {"preset", "LONG", "uint32_t", "preset: -1=[no-preset], 0=ultrafast, 1=superfast, 2=veryfast, 3=faster, 4=fast, 5=medium, 6=slow, 7=slower, 8=veryslow, 9=placebo"}, {"tune", "LONG", "int32_t", "tune: -1=[no-tuning], 0=film, 1=animation, 2=grain, 3=stillimage, 4=psnr, 5=ssim, 6=fastdecode, 7=zerolatency"}, {"tune-zerolatency", "LONG", "int32_t", "tune-zerolatency: Tune for zero latency (required for live): 1=enable, 0=disable"}, {"keyint", "LONG", "uint32_t", "keyint: Maximum GOP size: 1073741824=X264_KEYINT_MAX_INFINITE, n=GOP size"}, {"min-keyint", "LONG", "uint32_t", "min-keyint: Minimum GOP size: 0=auto"}, {"scenecut", "LONG", "uint32_t", "scenecut: How aggressively to insert extra I-frames: 0=off"}, {"intra-refresh", "LONG", "uint32_t", "intra-refresh: Use Periodic Intra Refresh instead of IDR frames: 0=off, 1=on"}, {"bframes", "LONG", "uint32_t", "bframes: Number of B-frames between I and P: 0=off"}, {"b-adapt", "LONG", "uint32_t", "b-adapt: Adaptive B-frame decision method: 0=disable, 1=fast, 2=optimal (slow with high bframes)"}, {"b-bias", "LONG", "uint32_t", "b-bias: Influences how often B-frames are used"}, {"b-pyramid", "LONG", "uint32_t", "b-pyramid: Keep some B-frames as references: 0=off, 1=strict hierarchical, 2=normal"}, {"open-gop", "LONG", "uint32_t", "open-gop: Use recovery points to close GOPs (Only available with b-frames): 0=false, 1=true"}, {"cabac", "LONG", "uint32_t", "cabac: Enable CABAC: 1=enable CABAC, 0=disable CABAC"}, {"ref", "LONG", "uint32_t", "ref: Number of reference frames"}, {"deblock", "LONG", "uint32_t", "deblock: Enable loop filter: 1=enable loop filter, 0=disable loop filter"}, {"deblock-alpha", "LONG", "uint32_t", "deblock-alpha: Loop filter parameters: alpha"}, {"deblock-beta", "LONG", "uint32_t", "deblock-beta: Loop filter parameters: beta"}, {"slices", "LONG", "uint32_t", "slices: Number of slices per frame"}, {"constrained-intra", "LONG", "uint32_t", "constrained-intra: Enable constrained intra prediction"}, {"qp", "LONG", "uint32_t", "qp: Force constant QP: 0-69, 0=lossless"}, {"bitrate", "LONG", "uint32_t", "bitrate: Set bitrate (kbit/s)"}, {"crf", "DOUBLE", "double", "crf: Quality-based VBR (0-51)"}, {"crf-max", "DOUBLE", "double", "crf-max: With CRF+VBV, limit RF to this value (May cause VBV underflows!)"}, {"rc-lookahead", "LONG", "uint32_t", "rc-lookahead: Number of frames for frametype lookahead"}, {"vbv-maxrate", "LONG", "uint32_t", "vbv-maxrate: Max local bitrate (kbit/s)"}, {"vbv-bufsize", "LONG", "uint32_t", "vbv-bufsize: Set size of the VBV buffer (kbit)"}, {"vbv-init", "DOUBLE", "double", "vbv-init: Initial VBV buffer occupancy"}, {"qpmin", "LONG", "uint32_t", "qpmin: Set min QP"}, {"qpmax", "LONG", "uint32_t", "qpmax: Set max QP"}, {"qpstep", "LONG", "uint32_t", "qpstep: Set max QP step"}, {"ratetol", "DOUBLE", "double", "ratetol: Tolerance of ABR ratecontrol and VBV"}, {"ipratio", "DOUBLE", "double", "ipratio: QP factor between I and P"}, {"pbratio", "DOUBLE", "double", "pbratio: QP factor between P and B"}, {"chroma-qp-offset", "LONG", "uint32_t", "chroma-qp-offset: QP difference between chroma and luma"}, {"aq-mode", "LONG", "uint32_t", "aq-mode: AQ method: 0=disable, 1=variance AQ, 2=auto-variable AQ (experimental)"}, {"aq-strength", "DOUBLE", "double", "aq-strength: Reduces blocking and blurring in flat and textured areas"}, {"mbtree", "LONG", "uint32_t", "mbtree: Enable mb-tree ratecontrol: 0=enable, 1=disable"}, {"qcomp", "DOUBLE", "double", "qcomp: QP curve compression"}, {"cplxblur", "DOUBLE", "double", "cplxblur: Reduce fluctuations in QP (before curve compression)"}, {"qblur", "DOUBLE", "double", "qblur: Reduce fluctuations in QP (after curve compression)"}, {"partitions", "LONG", "uint32_t", "partitions: Partitions to consider (mask): 0x00=none, 0x133=all, 0x01=i4x4, 0x02=i8x8, 0x10=p8x8, 0x20=p4x4, 0x100=b8x8"}, {"direct", "LONG", "uint32_t", "direct: Direct MV prediction mode: 0=none, 1=spatial, 2=temporal, 3=auto"}, {"weightb", "LONG", "uint32_t", "weightb: Enable weighted prediction for B-frames: 1=enable, 0=disable"}, {"weightp", "LONG", "uint32_t", "weightp: Weighted prediction for P-frames: 0=disable, 1=weighted refs, 2=weighted refs + dubplicates"}, {"me", "LONG", "uint32_t", "me: Integer pixel motion estimation method: 0=dia, 1=hex, 2=umh, 3=esa, 4=tesa"}, {"merange", "LONG", "uint32_t", "merange: Maximum motion vector search range"}, {"mvrange", "LONG", "uint32_t", "mvrange: Maximum motion vector length"}, {"mvrange-thread", "LONG", "uint32_t", "mvrange-thread: Minimum buffer between threads"}, {"subme", "LONG", "uint32_t", "subme: Subpixel motion estimation and mode decision: 0=fullpel only (not recommended), 1=SAD mode decision, one qpel iteration, 2=SATD mode decision, 3-5=Progressively more qpel, 6=RD mode decision for I/P-frames, 7=RD mode decision for all frames, 8=RD refinement for I/P-frames, 9=RD refinement for all frames, 10=QP-RD - requires trellis=2, aq-mode>0, 11=Full RD: disable all early terminations"}, {"psy-rd-rd", "DOUBLE", "double", "psy-rd-rd: Strength of psychovisual optimization (requires subme>=6)"}, {"psy-rd-trellis", "DOUBLE", "double", "psy-rd-trellis: Strength of psychovisual optimization (requires trellis, experimental)"}, {"psy", "LONG", "uint32_t", "psy: Enable all visual optimizations that worsen both PSNR and SSIM"}, {"mixed-refs", "LONG", "uint32_t", "mixed-refs: Decide references on a per partition basis"}, {"chroma-me", "LONG", "uint32_t", "chroma-me: Enable chroma in motion estimation"}, {"8x8dct", "LONG", "uint32_t", "8x8dct: Enable adaptive spatial transform size"}, {"trellis", "LONG", "uint32_t", "trellis: Trellis RD quantization: 0=disable, 1=enable only on final encode of a MB, 2=enable on all mode decisions"}, {"fast-pskip", "LONG", "uint32_t", "fast-pskip: Enable early SKIP detection on P-frames"}, {"dct-decimate", "LONG", "uint32_t", "dct-decimate: Enable coefficient thresholding on P-frames"}, {"nr", "LONG", "uint32_t", "nr: Noise reduction"}, {"deadzone-inter", "LONG", "uint32_t", "deadzone-inter: Set the size of the inter luma quantization deadzone (deadzones should be in the range 0 - 32)"}, {"deadzone-intra", "LONG", "uint32_t", "deadzone-intra: Set the size of the intra luma quantization deadzone (deadzones should be in the range 0 - 32)"}, {"cqm", "LONG", "uint32_t", "cqm: Preset quant matrices: 0=flat, 1=jvt"}, {"overscan", "LONG", "uint32_t", "overscan: VUI: Specify crop overscan setting: 0=undef, 1=show, 2=crop"}, {"videoformat", "LONG", "uint32_t", "videoformat: VUI: Specify video format: 0=component, 1=pal, 2=ntsc, 3=secam, 4=mac, 5=undef"}, {"range", "LONG", "uint32_t", "range: VUI: Specify color range: -1=auto, 0=tv, 1=pc"}, {"colorprim", "LONG", "uint32_t", "colorprim: VUI: Specify color primaries: 1=bt709, 2=undef, 4=bt470m, 5=bt470bg, 6=smpte170m, 7=smpte240m, 8=film"}, {"transfer", "LONG", "uint32_t", "transfer: VUI: Specify transfer characteristics: 1=bt709, 2=undef, 4=bt470m, 5=bt470bg, 6=smpte170m, 7=smpte240m, 8=linear, 9=log100, 10=log316"}, {"colormatrix", "LONG", "uint32_t", "colormatrix: VUI: Specify color matrix setting: 09=GBR, 1=bt709, 2=undef, 4=fcc, 5=bt470bg, 6=smpte170m, 7=smpte240m, 8=YCgCo"}, {"chromaloc", "LONG", "uint32_t", "chromaloc: VUI: Specify chroma sample location (0 to 5)"}, {"nal-hrd", "LONG", "uint32_t", "nal-hrd: Signal HRD information (requires vbv-bufsize): 0=none, 1=vbr, 2=cbr"}, {"pic-struct", "LONG", "uint32_t", "pic-struct: VUI: Force pic_struct in Picture Timing SEI"}, {"crop-rect", "LONGARRAY:4", "uint32_t", "pic-struct: VUI: Add 'left,top,right,bottom' to the bitstream-level cropping rectangle"}, {"threads", "LONG", "uint32_t", "threads: Force a specific number of threads"}, {"lookahead-threads", "LONG", "uint32_t", "lookahead-threads: Force a specific number of lookahead threads"}, {"sliced-threads", "LONG", "uint32_t", "sliced-threads: Low-latency but lower-efficiency threading"}, {"sync-lookahead", "LONG", "uint32_t", "sync-lookahead: Number of buffer frames for threaded lookahead"}, {"non-deterministic", "LONG", "uint32_t", "non-deterministic: Slightly improve quality of SMP, at the cost of repeatability"}, {"cpu-independent", "LONG", "uint32_t", "cpu-independent: Ensure exact reproducibility across different cpus, as opposed to letting them select different algorithms"}, {"asm", "LONG", "uint32_t", "asm: Override CPU detection"}, {"no-asm", "LONG", "uint32_t", "no-asm: Disable all CPU optimizations"}, {"visualize", "LONG", "uint32_t", "visualize: Show MB types overlayed on the encoded video (currently not enabled)"}, {"sps-id", "LONG", "uint32_t", "sps-id: Set SPS and PPS id numbers"}, {"aud", "LONG", "uint32_t", "aud: Use access unit delimiters"}, {"force-cfr", "LONG", "uint32_t", "force-cfr: Force constant framerate timestamp generation"}, {"log-level", "LONG", "uint32_t", "log-level: 0=none, 1=error, 2=warning, 3=info, 4=debug"}, {"repeat-headers", "LONG", "uint32_t", "repeat-headers: Repeat SPS/PPS for I frames"}, {"annexb", "LONG", "uint32_t", "annexb: if set, place start codes (4 bytes) before NAL units, otherwise place size (4 bytes) before NAL units"}, {"opencl", "LONG", "uint32_t", "open: Enabled OpenCL accelerated encoding"}, {"level-idc", "LONG", "uint32_t", "level-idc: Set encoding level"}};
        MAINCONCEPT_AUDIOAACENCODING_PARAMETERS = new String[][]{{"mpeg_version", "LONG", "uint32_t", "mpeg version: 6=MPEG2_AAC_AUDIO, 7=MPEG4_AAC_AUDIO, 16=MPEG4_AAC_AUDIO_PSP"}, {"aac_object_type", "LONG", "uint32_t", "aac object type"}, {"hf_cutoff", "LONG", "uint32_t", "high frequency cut-off"}, {"vbr", "LONG", "uint32_t", "variable bitrate mode: 0 = off"}, {MAINCONCEPT_AUDIOAACENCODING_PARAMETERS_HE, "LONG", "uint32_t", "high efficiency: 0=off, 1=HE-v1, 2=HE-v"}, {"protect_adts_stream", "LONG", "uint32_t", "crc protection: 0=off, 1=on"}, {"tns", "LONG", "uint32_t", "temporal noise shaping (tns) algorithm: 0=off, 1=on"}, {"channel_copy", "LONG", "uint32_t", "channel copy: 0=donothing, 1=copy-left-over-right, 2=copy-right-over-left"}, {"input_channels", "LONG", "uint32_t", "input channels : Number of audio channels at the input"}, {"audio_bitrate_index", "LONG", "uint32_t", "audio bitrate index : Range between 0 to 31"}, {"header_type", "LONG", "uint32_t", "header type: 0=AAC_HEADER_RAW, 1=AAC_HEADER_ADTS, 2=AAC_HEADER_LATMLOAS"}, {"bits_per_sample", "LONG", "uint32_t", "bits per sample: 8=AAC_BITS_PER_SAMPLE_08, 16=AAC_BITS_PER_SAMPLE_16, 24=AAC_BITS_PER_SAMPLE_24, 32=AAC_BITS_PER_SAMPLE_FLOAT"}, {"pts_offset", "LONG", "int64_t", "pts offset: This field specifies the time stamp offset (starting value). Default value is 0"}, {"pts_units", "LONG", "int32_t", "pts units: Units for the time stamp offset. Default value is 27.000.000 MHz"}, {"ch_mode", "LONG", "uint32_t", "ch mode: 0=AAC_CH_MODE_AUTO, 7=AAC_CH_MODE_7_1_FRONT_CHANNEL, 12=AAC_CH_MODE_7_1_BACK_CHANNEL"}, {"LFE_filtering", "LONG", "uint32_t", "LFE filtering: Enable/Disable LFE filtering flag"}, {"restart_interval", "LONG", "int64_t", "restart interval: Time stamp restart interval (measured in pts)"}, {"audio_bitrate_custom", "LONG", "uint16_t", "Custom audio bit rate, in kbits/s. Has effect only when audio_bitrate_index is set to AAC_AUDIOBITRATE_CUSTOM(0)"}};
        OPUS_AUDIOENCODING_PARAMETERS = new String[][]{{"gain", "double", "double", "gain: audio gain in decibels (default 0.0)"}};
        VAAPI_VIDEOENCODING_VP9_PARAMETERS = new String[][]{{"profile", "LONG", "unsigned int", "profile: (only profile0 supported at this time) 19:profile0, 20:profile1, 21:profile2, 22:profile3"}, {"level", "LONG", "unsigned int", "level: NA"}, {"width", "LONG", "unsigned int", "width: Frame width rounded up to 8-bits"}, {"height", "LONG", "unsigned int", "height: Frame height rounded up to 8-bits"}, {"frameRateNum", "LONG", "unsigned int", "frameRateNum: Frame rate enumerator"}, {"frameRateDenom", "LONG", "unsigned int", "frameRateDenom: Frame rate denominator"}, {"intraPeriod", "LONG", "unsigned int", "intraPeriod: Key frame interval"}, {"ipPeriod", "LONG", "unsigned int", "ipPeriod: IDR period"}, {"numRefFrames", "LONG", "unsigned int", "numRefFrames: Number of reference frames"}, {"rcMode", "LONG", "unsigned int", "rcMode: Rate control mode (only CBR and CQP support at this time): 1:RC_NONE, 2:RC_CBR, 4:RC_VBR, 8:RC_VC (video conference), 16:RC_CQP, 32:RC_VBR_CONSTRAINED"}, {"rc_bitRate", "LONG", "unsigned int", "rc_bitRate: Bitrate bits per second"}, {"rc_initQP", "LONG", "unsigned int", "rc_initQP: Initial QP"}, {"rc_minQP", "LONG", "unsigned int", "rc_minQP: Minimum QP"}, {"rc_maxQP", "LONG", "unsigned int", "rc_maxQP: Maximum QP"}, {"rc_windowSize", "LONG", "unsigned int", "rc_windowSize: Rate control window size (milliseconds)"}, {"rc_targetPercentage", "LONG", "unsigned int", "rc_targetPercentage: VBR target percentage"}, {"rc_disableFrameSkip", "LONG", "unsigned int", "rc_disableFrameSkip: Disable frame skip"}, {"rc_disableBitsStuffing", "LONG", "unsigned int", "rc_disableBitsStuffing: Disable bits stuffing"}, {"rc_diffQPIP", "LONG", "unsigned int", "rc_diffQPIP: P frame qp minus initQP"}, {"rc_diffQPIB", "LONG", "unsigned int", "rc_diffQPIB: B frame qp minus initQP"}, {"leastInputCount", "LONG", "unsigned int", "leastInputCount: Number of frames in encoder"}, {"enableLowPower", "LONG", "unsigned int", "enableLowPower: Enable low power"}, {"bitDepth", "LONG", "unsigned int", "bitDepth: Bit depth"}, {"referenceMode", "LONG", "unsigned int", "referenceMode: Reference mode"}, {"rc_bufferSize", "LONG", "unsigned int", "rc_bufferSize: Rate control buffer size (bits)"}, {"rc_initBufferFullness", "LONG", "unsigned int", "rc_initBufferFullness: Rate control initial buffer size (bits)"}, {"qualityLevel", "LONG", "unsigned int", "qualityLevel: 0:default, 1:min - 7:max"}, {"keyFrameFollow", "LONG", "unsigned int", "keyFrameFollow: 0:off, 1:on"}};
        VAAPI_VIDEOENCODING_H264_PARAMETERS = new String[][]{{"profile", "LONG", "unsigned int", "profile: 5:baseline, 13:baseline-constrained, 6:main, 7:high"}, {"level", "LONG", "unsigned int", "level: AVC level"}, {"width", "LONG", "unsigned int", "width: Frame width rounded up to 8-bits"}, {"height", "LONG", "unsigned int", "height: Frame height rounded up to 8-bits"}, {"frameRateNum", "LONG", "unsigned int", "frameRateNum: Frame rate enumerator"}, {"frameRateDenom", "LONG", "unsigned int", "frameRateDenom: Frame rate denominator"}, {"intraPeriod", "LONG", "unsigned int", "intraPeriod: Key frame interval"}, {"ipPeriod", "LONG", "unsigned int", "ipPeriod: IDR period"}, {"numRefFrames", "LONG", "unsigned int", "numRefFrames: Number of reference frames"}, {"rcMode", "LONG", "unsigned int", "rcMode: Rate control mode (only CBR, CQP and VBR support at this time): 1:RC_NONE, 2:RC_CBR, 4:RC_VBR, 8:RC_VC (video conference), 16:RC_CQP, 32:RC_VBR_CONSTRAINED"}, {"rc_bitRate", "LONG", "unsigned int", "rc_bitRate: Bitrate bits per second"}, {"rc_initQP", "LONG", "unsigned int", "rc_initQP: Initial QP"}, {"rc_minQP", "LONG", "unsigned int", "rc_minQP: Minimum QP"}, {"rc_maxQP", "LONG", "unsigned int", "rc_maxQP: Maximum QP"}, {"rc_disableFrameSkip", "LONG", "unsigned int", "rc_disableFrameSkip: Disable frame skip"}, {"rc_disableBitsStuffing", "LONG", "unsigned int", "rc_disableBitsStuffing: Disable bits stuffing"}, {"rc_diffQPIP", "LONG", "unsigned int", "rc_diffQPIP: P frame qp minus initQP"}, {"rc_diffQPIB", "LONG", "unsigned int", "rc_diffQPIB: B frame qp minus initQP"}, {"rc_windowSize", "LONG", "unsigned int", "rc_windowSize: Rate control window size (milliseconds)"}, {"rc_targetPercentage", "LONG", "unsigned int", "rc_targetPercentage: VBR target percentage"}, {"rc_bufferSize", "LONG", "unsigned int", "rc_bufferSize: Rate control buffer size (bits)"}, {"rc_initBufferFullness", "LONG", "unsigned int", "rc_initBufferFullness: Rate control initial buffer size (bits)"}, {"leastInputCount", "LONG", "unsigned int", "leastInputCount: Number of frames in encoder"}, {"enableLowPower", "LONG", "unsigned int", "enableLowPower: Enable low power"}, {"bitDepth", "LONG", "unsigned int", "bitDepth: Bit depth"}, {"basicUnitSize", "LONG", "unsigned int", "basicUnitSize: FUTURE"}, {"maxSliceSize", "LONG", "unsigned int", "maxSliceSize: FUTURE"}, {"idrInterval", "LONG", "unsigned int", "idrInterval: How many Intra frames will have an IDR frame"}, {"sar_width", "LONG", "unsigned int", "sar_width: FUTURE"}, {"sar_height", "LONG", "unsigned int", "sar_height: FUTURE"}, {"deblockAlphaOffsetDiv2", "LONG", "unsigned int", "deblockAlphaOffsetDiv2: same as slice_alpha_c0_offset_div2 defined in h264 spec 7.4.3"}, {"deblockBetaOffsetDiv2", "LONG", "unsigned int", "deblockBetaOffsetDiv2: same as slice_beta_offset_div2 defined in h264 spec 7.4.3"}, {"temporalLayerNum", "LONG", "unsigned int", "temporalLayerNum: FUTURE"}, {"priorityId", "LONG", "unsigned int", "priorityId: FUTURE"}, {"enableCabac", "LONG", "unsigned int", "enableCabac: Enable CABAC entropy encoding"}, {"enableDct8x8", "LONG", "unsigned int", "enableDct8x8: Enable 8x8 for high profile"}, {"enableDeblockFilter", "LONG", "unsigned int", "enableDeblockFilter: Enable deblocking filter"}, {"enablePrefixNalUnit", "LONG", "unsigned int", "enablePrefixNalUnit: NA"}, {"enableVUI", "LONG", "unsigned int", "enableVUI: FUTURE"}, {"qualityLevel", "LONG", "unsigned int", "qualityLevel: 0:default, 1:min - 7:max"}, {"keyFrameFollow", "LONG", "unsigned int", "keyFrameFollow: 0:off, 1:on"}};
        VAAPI_VIDEOENCODING_H265_PARAMETERS = new String[][]{{"profile", "LONG", "unsigned int", "profile: 5:baseline, 13:baseline-constrained, 6:main, 7:high"}, {"level", "LONG", "unsigned int", "level: AVC level"}, {"width", "LONG", "unsigned int", "width: Frame width rounded up to 8-bits"}, {"height", "LONG", "unsigned int", "height: Frame height rounded up to 8-bits"}, {"frameRateNum", "LONG", "unsigned int", "frameRateNum: Frame rate enumerator"}, {"frameRateDenom", "LONG", "unsigned int", "frameRateDenom: Frame rate denominator"}, {"intraPeriod", "LONG", "unsigned int", "intraPeriod: Key frame interval"}, {"ipPeriod", "LONG", "unsigned int", "ipPeriod: IDR period"}, {"numRefFrames", "LONG", "unsigned int", "numRefFrames: Number of reference frames"}, {"rcMode", "LONG", "unsigned int", "rcMode: Rate control mode (only CBR, CQP and VBR support at this time): 1:RC_NONE, 2:RC_CBR, 4:RC_VBR, 8:RC_VC (video conference), 16:RC_CQP, 32:RC_VBR_CONSTRAINED"}, {"rc_bitRate", "LONG", "unsigned int", "rc_bitRate: Bitrate bits per second"}, {"rc_initQP", "LONG", "unsigned int", "rc_initQP: Initial QP"}, {"rc_minQP", "LONG", "unsigned int", "rc_minQP: Minimum QP"}, {"rc_maxQP", "LONG", "unsigned int", "rc_maxQP: Maximum QP"}, {"rc_disableFrameSkip", "LONG", "unsigned int", "rc_disableFrameSkip: Disable frame skip"}, {"rc_disableBitsStuffing", "LONG", "unsigned int", "rc_disableBitsStuffing: Disable bits stuffing"}, {"rc_diffQPIP", "LONG", "unsigned int", "rc_diffQPIP: P frame qp minus initQP"}, {"rc_diffQPIB", "LONG", "unsigned int", "rc_diffQPIB: B frame qp minus initQP"}, {"rc_windowSize", "LONG", "unsigned int", "rc_windowSize: Rate control window size (milliseconds)"}, {"rc_targetPercentage", "LONG", "unsigned int", "rc_targetPercentage: VBR target percentage"}, {"rc_bufferSize", "LONG", "unsigned int", "rc_bufferSize: Rate control buffer size (bits)"}, {"rc_initBufferFullness", "LONG", "unsigned int", "rc_initBufferFullness: Rate control initial buffer size (bits)"}, {"leastInputCount", "LONG", "unsigned int", "leastInputCount: Number of frames in encoder"}, {"enableLowPower", "LONG", "unsigned int", "enableLowPower: Enable low power"}, {"bitDepth", "LONG", "unsigned int", "bitDepth: Bit depth"}, {"basicUnitSize", "LONG", "unsigned int", "basicUnitSize: FUTURE"}, {"maxSliceSize", "LONG", "unsigned int", "maxSliceSize: FUTURE"}, {"idrInterval", "LONG", "unsigned int", "idrInterval: How many Intra frames will have an IDR frame"}, {"sar_width", "LONG", "unsigned int", "sar_width: FUTURE"}, {"sar_height", "LONG", "unsigned int", "sar_height: FUTURE"}, {"deblockAlphaOffsetDiv2", "LONG", "unsigned int", "deblockAlphaOffsetDiv2: same as slice_alpha_c0_offset_div2 defined in h264 spec 7.4.3"}, {"deblockBetaOffsetDiv2", "LONG", "unsigned int", "deblockBetaOffsetDiv2: same as slice_beta_offset_div2 defined in h264 spec 7.4.3"}, {"temporalLayerNum", "LONG", "unsigned int", "temporalLayerNum: FUTURE"}, {"priorityId", "LONG", "unsigned int", "priorityId: FUTURE"}, {"enableCabac", "LONG", "unsigned int", "enableCabac: Enable CABAC entropy encoding"}, {"enableDct8x8", "LONG", "unsigned int", "enableDct8x8: Enable 8x8 for high profile"}, {"enableDeblockFilter", "LONG", "unsigned int", "enableDeblockFilter: Enable deblocking filter"}, {"enablePrefixNalUnit", "LONG", "unsigned int", "enablePrefixNalUnit: NA"}, {"enableVUI", "LONG", "unsigned int", "enableVUI: FUTURE"}, {"qualityLevel", "LONG", "unsigned int", "qualityLevel: 0:default, 1:min - 7:max"}, {"keyFrameFollow", "LONG", "unsigned int", "keyFrameFollow: 0:off, 1:on"}};
        IPPH263_VIDEOENCODING_PARAMETERS = new String[][]{{"quantIPic", "LONG", "int32_t", "quantIPic"}, {"quantPPic", "LONG", "int32_t", "quantPPic"}, {"quantBPic", "LONG", "int32_t", "quantBPic"}, {"IPicdist", "LONG", "int32_t", "IPicdist"}, {"PPicdist", "LONG", "int32_t", "PPicdist"}, {"PPicsearchWidth", "LONG", "int32_t", "PPicsearchWidth"}, {"PPicsearchHeight", "LONG", "int32_t", "PPicsearchHeight"}, {"MEalgorithm", "LONG", "int32_t", "MEalgorithm"}, {"MEaccuracy", "LONG", "int32_t", "MEaccuracy"}, {"advPred", "LONG", "int32_t", "advPred"}, {"deblockFilt", "LONG", "int32_t", "deblockFilt"}, {"calcPSNR", "LONG", "int32_t", "calcPSNR"}, {"advIntra", "LONG", "int32_t", "advIntra"}, {"UMV", "LONG", "int32_t", "UMV"}, {"modQuant", "LONG", "int32_t", "modQuant"}, {"RateControl", "LONG", "int32_t", "RateControl"}, {"BitRate", "LONG", "int32_t", "BitRate"}, {"SceneChangeThreshold", "LONG", "int32_t", "SceneChangeThreshold"}, {"FrameSkip", "LONG", "int32_t", "FrameSkip"}, {"GOBheaders", "LONG", "int32_t", "GOBheaders"}, {"PAR_width", "LONG", "int32_t", "PAR_width"}, {"PAR_height", "LONG", "int32_t", "PAR_height"}};
        MAINCONCEPT_VIDEOENCODING_PARAMETERS = new String[][]{{"profile_id", "LONG", "int32_t", "profile_id: 0=H264PROFILE_BASELINE, 1=H264PROFILE_MAIN, 3=H264PROFILE_HIGH"}, {"level_id", "LONG", "int32_t", "level_id: = 10 -> 1.0, .. 51 -> 5.1"}, {"idr_interval", "LONG", "int32_t", "idr_interval: gop length"}, {"reordering_delay", "LONG", "int32_t", "reordering_delay: max distance between two P frames"}, {"interlace_mode", "LONG", "int32_t", "interlace_mode: 0=H264_PROGRESSIVE, 1=H264_INTERLACED, 2=H264_MBAFF"}, {"def_horizontal_size", "LONG", "int32_t", "def_horizontal_size"}, {"def_vertical_size", "LONG", "int32_t", "def_vertical_size"}, {"frame_rate", "DOUBLE", "double", "frame_rate"}, {"num_reference_frames", "LONG", "int32_t", "num_reference_frames"}, {"search_range", "LONG", "int32_t", "search_range: motion search: spatial search range"}, {"max_l0_active", "LONG", "int32_t", "max_l0_active: motion search: max index of reference frames in list0"}, {"max_l1_active", "LONG", "int32_t", "max_l1_active: motion search: max index of reference frames in list1"}, {"quant_pI", "LONG", "int32_t", "quant_pI: macro blocks: quantization parameter"}, {"quant_pP", "LONG", "int32_t", "quant_pP: macro blocks: quantization parameter"}, {"quant_pB", "LONG", "int32_t", "quant_pB: macro blocks: quantization parameter"}, {"bit_rate_mode", "LONG", "int32_t", "bit_rate_mode: bit rate stuff: 0=H264_CBR, 1=H264_CQT, 2=H264_VBR"}, {"bit_rate_buffer_size", "LONG", "int32_t", "bit_rate_buffer_size: bit rate stuff: vbv buffer size"}, {"bit_rate", "LONG", "int32_t", "bit_rate: bit rate stuff: avg bitrate; if 0, use above quantization parameters"}, {"max_bit_rate", "LONG", "int32_t", "max_bit_rate: bit rate stuff: max bitrate, used in VBR mode"}, {"inter_search_shape", "LONG", "int32_t", "inter_search_shape: prediction: 0=H264_INTERSEARCH_16x16 (use only 16x16 block size) or 1=H264_INTERSEARCH_8x8 (use block size down to 8x8)"}, {"entropy_coding_mode", "LONG", "int32_t", "entropy_coding_mode: coding mode: 0=H264_CAVLC or 1=H264_CABAC"}, {"use_hadamard_transform", "LONG", "int32_t", "use_hadamard_transform: coding mode: 0=SAD is used, 1=SATD is used"}, {"sar_width", "LONG", "int32_t", "sar_width: vui parameters: sample aspect ratio: horizontal size in arbitrary units"}, {"sar_height", "LONG", "int32_t", "sar_height: vui parameters: sample aspect ratio: vertical size in arbitrary units"}, {"video_format", "LONG", "int32_t", "video_format: vui parameters: 1=PAL, 2=NTSC"}, {"num_units_in_tick", "LONG", "int32_t", "num_units_in_tick: vui parameters: timing info use together with time_scale"}, {"time_scale", "LONG", "int32_t", "time_scale: vui parameters: timing info use together with num_units_in_tick (fps = time_scale/num_units_in_tick)"}, {"vbv_buffer_fullness", "LONG", "int32_t", "vbv_buffer_fullness: advanced settings: initial vbv-fullness"}, {"vbv_buffer_fullness_trg", "LONG", "int32_t", "vbv_buffer_fullness_trg: advanced settings: final vbv-fullness"}, {"vbv_buffer_units", "LONG", "int32_t", "vbv_buffer_units: advanced settings: units of vbv-fullness and buffer size"}, {"cpb_removal_delay", "LONG", "int32_t", "cpb_removal_delay: advanced settings: CPB removal delay for the first picture (needed for segment merging)"}, {"bit_rate_scale", "LONG", "int32_t", "bit_rate_scale: external setting of bit_rate_scale (avoids recalculation of bitrate)"}, {"cpb_size_scale", "LONG", "int32_t", "cpb_size_scale: external setting of cpb_size_scale (avoids recalculation of bitrate)"}, {"max_frame_size", "LONGARRAY:4", "int32_t", "max_frame_size: max frames size for I, P, Bref, B frames"}, {"hrd_maintain", "LONG", "int32_t", "hrd_maintain: 0=hrd model disabled, 1=hrd model enabled"}, {"min_frame_size", "LONGARRAY:4", "int32_t", "min_frame_size: min frames size for I, P, Bref, B frames"}, {"hrd_low_delay", "LONG", "int32_t", "hrd_low_delay: 0=low delay hrd disabled, 1=low delay hrd enabled"}, {"smooth_factor", "LONG", "int32_t", "smooth_factor: Quantizer curve compression smooth factor, 0 = disabled"}, {"use_deblocking_filter", "LONG", "int32_t", "use_deblocking_filter: in-loop filter:"}, {"deblocking_alphaC0_offset", "LONG", "int32_t", "deblocking_alphaC0_offset: in-loop filter:"}, {"deblocking_beta_offset", "LONG", "int32_t", "deblocking_beta_offset: in-loop filter:"}, {"adaptive_deblocking", "LONG", "int32_t", "adaptive_deblocking: in-loop filter: adaptive deblocking filter"}, {"video_type", "LONG", "int32_t", "video_type: type issues: one of above defines"}, {"video_pulldown_flag", "LONG", "int32_t", "video_pulldown_flag: type issues: one of above flags"}, {"overscan_appropriate_flag", "LONG", "int32_t", "overscan_appropriate_flag: additional vui parameters: controls overscan_appropriate_flag of VUI"}, {"stream_type", "LONG", "int32_t", "stream_type: file/stream issues: 0=H264_STREAM_TYPE_I, 1=H264_STREAM_TYPE_I_SEI, 2=H264_STREAM_TYPE_II, 3=H264_STREAM_TYPE_II_NO_SEI"}, {"bit_depth_luma", "LONG", "int32_t", "bit_depth_luma: bit_depth_luma"}, {"bit_depth_chroma", "LONG", "int32_t", "bit_depth_chroma: bit_depth_chroma"}, {"chroma_format", "LONG", "int32_t", "chroma_format: 1=H264_CHROMA_400, 2=H264_CHROMA_420 or 3=H264_CHROMA_422, 4=H264_CHROMA_444"}, {"write_au_delimiters", "LONG", "int32_t", "write_au_delimiters: write access unit delimiters"}, {"write_seq_end_code", "LONG", "int32_t", "write_seq_end_code: write seq end code"}, {"write_timestamps", "LONG", "int32_t", "write_timestamps: write picture timecode in PT SEI"}, {"timestamp_offset", "LONG", "int32_t", "timestamp_offset: frame offset (in #frames) for timestamps (default = 0)"}, {"drop_frame_timecode", "LONG", "int32_t", "drop_frame_timecode: use NTSC drop frame timecode notation for 29.97 and 59.94 target frame rates"}, {"write_single_sei_per_nalu", "LONG", "int32_t", "write_single_sei_per_nalu: writes single sei message per nal unit"}, {"write_seq_par_set", "LONG", "int32_t", "write_seq_par_set: behaviour of writing sequence parameter set (default = 0): 0 - old school (SPS once per IDR), 1 - SPS once per I-frame"}, {"write_pic_par_set", "LONG", "int32_t", "write_pic_par_set: behaviour of writing picture parameter set (default = 0): 0 - old school (PPS once per IDR), 1 - PPS once per I picture, 2 - PPS once per picture"}, {"log2_max_poc", "LONG", "int32_t", "log2_max_poc: allows to specify custom log2_max_pic_order_cnt_lsb_minus4 value: valid range is 4..16, default - 8"}, {"log2_max_frame_num", "LONG", "int32_t", "log2_max_frame_num: allows to specify custom log2_max_frame_num_minus4 value: valid range is 4..16, default - 8"}, {"pic_order_cnt_type", "LONG", "int32_t", "pic_order_cnt_type: allows to specify custom pic_order_cnt_type value: valid values are 0 (default) and 2"}, {"pic_order_present_flag", "LONG", "int32_t", "pic_order_present_flag: controls pic_order_present_flag value in PPS (e.g. for SBTVD-T)"}, {"fixed_frame_rate", "LONG", "int32_t", "fixed_frame_rate: controls fixed_frame_rate_flag in VUI"}, {"frame_based_timing", "LONG", "int32_t", "frame_based_timing: controls time_scale / num_units_in_tick ration in VUI (field or frame rate)"}, {"vcsd_mode", "LONG", "int32_t", "vcsd_mode: scene detection: visual content scene detection, 0: OFF, 1: IDR (see vcsd_mode_flags)"}, {"slice_arg", "LONG", "int32_t", "slice_arg: advanced settings: number of slices per picture"}, {"b_slice_reference", "LONG", "int32_t", "b_slice_reference: advanced settings: use b slices as reference too (b -> B)"}, {"b_slice_pyramid", "LONG", "int32_t", "b_slice_pyramid: advanced settings: pyramidal gop structure  (...bBb...)"}, {"cb_offset", "LONG", "int32_t", "cb_offset: advanced settings: chroma quality offset (-X -> increase quality, +X -> decrease quality)"}, {"cr_offset", "LONG", "int32_t", "cr_offset: advanced settings: chroma quality offset (-X -> increase quality, +X -> decrease quality)"}, {"me_subpel_mode", "LONG", "int32_t", "me_subpel_mode: advanced settings: 0=H264_FULL_PEL, 1=H264_HALF_PEL, 2=H264_QUARTER_PEL"}, {"me_weighted_p_mode", "LONG", "int32_t", "me_weighted_p_mode: advanced settings: whether to use explicit WP for P-frames or not"}, {"me_weighted_b_mode", "LONG", "int32_t", "me_weighted_b_mode: advanced settings: (currently) not used"}, {"enable_fast_intra_decisions", "LONG", "int32_t", "enable_fast_intra_decisions: advanced settings: enables fast intra decisions"}, {"enable_fast_inter_decisions", "LONG", "int32_t", "enable_fast_inter_decisions: advanced settings: enables fast inter decisions"}, {"pic_ar_x", "LONG", "int32_t", "pic_ar_x: advanced settings: picture aspect ratio: horizontal size"}, {"pic_ar_y", "LONG", "int32_t", "pic_ar_y: advanced settings: picture aspect ratio: vertical size"}, {"calc_quality", "LONG", "int32_t", "calc_quality: advanced settings: calculate PSNR or not"}, {"cpu_opt", "LONG", "int32_t", "cpu_opt: advanced settings: cpu optimization"}, {"num_threads", "LONG", "int32_t", "num_threads: advanced settings: number of threads"}, {"live_mode", "LONG", "int32_t", "live_mode: advanced settings: online or offline mode"}, {"buffering", "LONG", "int32_t", "buffering: advanced settings: defines the encoder input queue length in frames."}, {"min_quant", "LONG", "int32_t", "min_quant: advanced settings: minimum quantization parameter"}, {"max_quant", "LONG", "int32_t", "max_quant: advanced settings: maximum quantization parameter"}, {"max_slice_size", "LONG", "int32_t", "max_slice_size: advanced settings: maximum slice size in bits, set to 0 if you do not need it"}, {"constrained_slices", "LONG", "int32_t", "constrained_slices: advanced settings: controls using pixels beyond the slice boundaries for motion compensation"}, {"encoding_buffering", "LONG", "int32_t", "encoding_buffering: advanced settings: maximum number of frames to buffer encoding queue."}, {"low_delay", "LONG", "int32_t", "low_delay: advanced settings: low delay mode"}, {"air_mode", "LONG", "int32_t", "air_mode: advanced settings: adaptive intra refresh mode"}, {"detach_thread", "LONG", "int32_t", "detach_thread: advanced settings: run core in a new thread or not"}, {"constrained_intra_pred", "LONG", "int32_t", "constrained_intra_pred: advanced settings: constrained intra prediction for improving error resilience"}, {"air_split_frequency", "LONG", "int32_t", "air_split_frequency: advanced settings: frequency of intra lines for adaptive air mode split"}, {"air_qp_offset", "LONG", "int32_t", "air_qp_offset: advanced settings: qp offset for adaptive intra mode lines"}, {"min_idr_interval", "LONG", "int32_t", "min_idr_interval: advanced gop settings: min gop length"}, {"adaptive_b_frames", "LONG", "int32_t", "adaptive_b_frames: advanced gop settings: use adaptive B-frames placement or not"}, {"idr_frequency", "LONG", "int32_t", "idr_frequency: advanced gop settings: 0 means only first frame is IDR, 1 means every I-frame is IDR, etc"}, {"field_order", "LONG", "int32_t", "field_order: advanced gop settings: 0=TFF, 1=BFF"}, {"fixed_i_position", "LONG", "int32_t", "fixed_i_position: advanced gop settings: constant I frame position"}, {"isolated_gops", "LONG", "int32_t", "isolated_gops: advanced gop settings: allows to limit referencing to frames from the previous GOP, may be useful when idr_frequency != 1"}, {"hierar_p_frames", "LONG", "int32_t", "hierar_p_frames: advanced gop settings: GOP structure with hierarchically coded P frames (for temporal scalability with out using B frames) (not yet supported in enc_avc/trunk)"}, {"fast_multi_ref_me", "LONG", "int32_t", "fast_multi_ref_me: advanced me settings: enables fast decisions for multi-ref ME"}, {"fast_sub_block_me", "LONG", "int32_t", "fast_sub_block_me: advanced me settings: enables fast decisions for sub-block ME"}, {"allow_out_of_pic_mvs", "LONG", "int32_t", "allow_out_of_pic_mvs: advanced me settings: enables mvs out of picture boundaries"}, {"constrained_ref_list", "LONG", "int32_t", "constrained_ref_list: advanced me settings: use constrained reference picture list"}, {"chroma_me", "LONG", "int32_t", "chroma_me: advanced me settings: chroma evaluation for inter-macroblocks."}, {"enable_intra_big", "LONG", "int32_t", "enable_intra_big: advanced intra settings: allows to use 16x16 intra mode in intra slices"}, {"enable_intra_8x8", "LONG", "int32_t", "enable_intra_8x8: advanced intra settings: same for 8x8"}, {"enable_intra_4x4", "LONG", "int32_t", "enable_intra_4x4: advanced intra settings: same for 4x4"}, {"enable_intra_pcm", "LONG", "int32_t", "enable_intra_pcm: advanced intra settings: same for PCM"}, {"enable_inter_big", "LONG", "int32_t", "enable_inter_big: advanced intra settings: allows to use 16x16 intra mode in inter slices"}, {"enable_inter_8x8", "LONG", "int32_t", "enable_inter_8x8: advanced intra settings: same for 8x8"}, {"enable_inter_4x4", "LONG", "int32_t", "enable_inter_4x4: advanced intra settings: same for 4x4"}, {"enable_inter_pcm", "LONG", "int32_t", "enable_inter_pcm: advanced intra settings: same for PCM"}, {"fast_rd_optimization", "LONG", "int32_t", "fast_rd_optimization: advanced rdo settings: allows fast RDO"}, {"quant_mode", "LONG", "int32_t", "quant_mode: advanced rdo settings: quantization optimization mode"}, {"grain_mode", "LONG", "int32_t", "grain_mode: advanced rdo settings: granular noise optimization mode, not used any more"}, {"grain_opt_strength", "LONG", "int32_t", "grain_opt_strength: advanced rdo settings: scalable film grain optimization [0..100], use 0 to turn it off"}, {"adaptive_quant_strength", "LONGARRAY:8", "int32_t", "adaptive_quant_strength: advanced rdo settings: adaptive quantization strength [-100..100] or every mode (from H264_AQUANT_MODE_BRIGHTNESS to COMPLEXITY), last 5 strengths are not used at the moment"}, {"denoise_strength_y", "LONG", "int32_t", "denoise_strength_y: Psycho-visual enhancement: denoise strength for luma [0..100]"}, {"denoise_strength_c", "LONG", "int32_t", "denoise_strength_c: Psycho-visual enhancement: denoise strength for chroma [0..100]"}, {"black_norm_level", "LONG", "int32_t", "black_norm_level: Psycho-visual enhancement: black normalization level, any luma less than or equal to black_norm_level will be set to 16"}, {"pulse_reduction", "LONG", "int32_t", "pulse_reduction: Psycho-visual enhancement: key frame pulsing reduction"}, {"intra_y_4x4_scaling_list", "LONGARRAY:16", "uint8_t", "intra_y_4x4_scaling_list: scaling lists: intra_y_4x4_scaling_list"}, {"intra_cb_4x4_scaling_list", "LONGARRAY:16", "uint8_t", "intra_cb_4x4_scaling_list: scaling lists: intra_cb_4x4_scaling_list"}, {"intra_cr_4x4_scaling_list", "LONGARRAY:16", "uint8_t", "intra_cr_4x4_scaling_list: scaling lists: intra_cr_4x4_scaling_list"}, {"inter_y_4x4_scaling_list", "LONGARRAY:16", "uint8_t", "inter_y_4x4_scaling_list: scaling lists: inter_y_4x4_scaling_list"}, {"inter_cb_4x4_scaling_list", "LONGARRAY:16", "uint8_t", "inter_cb_4x4_scaling_list: scaling lists: inter_cb_4x4_scaling_list"}, {"inter_cr_4x4_scaling_list", "LONGARRAY:16", "uint8_t", "inter_cr_4x4_scaling_list: scaling lists: inter_cr_4x4_scaling_list"}, {"intra_y_8x8_scaling_list", "LONGARRAY:64", "uint8_t", "intra_y_8x8_scaling_list: scaling lists: intra_y_8x8_scaling_list"}, {"inter_y_8x8_scaling_list", "LONGARRAY:64", "uint8_t", "inter_y_8x8_scaling_list: scaling lists: inter_y_8x8_scaling_list"}, {"performance_level", "LONG", "uint32_t", "performance_level: (0-15) 0:H264_PERF_FASTEST, 9:H264_PERF_BALANCED, 15:H264_PERF_BEST_Q"}, {"keyframe_follow", "LONG", "uint32_t", "keyframe_follow: 0:off, 1:on (default)"}, {"maintain_original_pts", "LONG", "uint32_t", "maintain_original_pts: 0:off, 1:on (default)"}, {"extended_sar", "LONG", "uint32_t", "extended_sar: Enable extended sample aspect ratio"}, {"vui_presentation", "LONG", "uint32_t", "vui_presentation: configuration of VUI header: 0 - old school / auto mode, 1 - customized configuration, depending on following flags/bits, 0x002 - aspect_ratio_info_present_flag, 0x004 - overscan_info_present_flag (not supported), 0x008 - video_signal_type_present_flag, 0x010 - colour_description_present_flag, 0x020 - chroma_loc_info_present_flag (not supported), 0x040 - timing_info_present_flag, 0x080 - nal_hrd_parameters_present_flag, 0x100 - vcl_hrd_parameters_present_flag, 0x200 - pic_struct_present_flag, 0x400 - bitstream_restriction_flag"}, {"input_colorimetry", "LONG", "uint32_t", "input_colorimetry: configures input color_primaries, transfer_characteristics and matrix_coefficients according to color description: -1=COLOR_DESCRIPTION_AUTO, 0=COLOR_DESCRIPTION_DEFAULT, 1=COLOR_DESCRIPTION_UNSPECIFIED, 2=COLOR_DESCRIPTION_BT601_625, 3=COLOR_DESCRIPTION_BT601_525, 4=COLOR_DESCRIPTION_BT709, 5=COLOR_DESCRIPTION_SMPTE240, 6=COLOR_DESCRIPTION_BT2020_10BIT, 7=COLOR_DESCRIPTION_BT2020_12BIT, 8=COLOR_DESCRIPTION_BT2100_PQ, 9=COLOR_DESCRIPTION_BT2100_HLG"}, {"output_colorimetry", "LONG", "uint32_t", "output_colorimetry: configures output color_primaries, transfer_characteristics and matrix_coefficients according to color description: -1=COLOR_DESCRIPTION_AUTO, 0=COLOR_DESCRIPTION_DEFAULT, 1=COLOR_DESCRIPTION_UNSPECIFIED, 2=COLOR_DESCRIPTION_BT601_625, 3=COLOR_DESCRIPTION_BT601_525, 4=COLOR_DESCRIPTION_BT709, 5=COLOR_DESCRIPTION_SMPTE240, 6=COLOR_DESCRIPTION_BT2020_10BIT, 7=COLOR_DESCRIPTION_BT2020_12BIT, 8=COLOR_DESCRIPTION_BT2100_PQ, 9=COLOR_DESCRIPTION_BT2100_HLG"}, {"constraint_set3_flag", "LONG", "uint32_t", "@brief Enables additional profile constraints. Please refer to 7.4.2.1.1 and A.2 sections of Rec. ITU-T H.264 for detailed information."}, {"constraint_set4_flag", "LONG", "uint32_t", "@brief Enables additional profile constraints. Please refer to 7.4.2.1.1 and A.2 sections of Rec. ITU-T H.264 for detailed information."}, {"constraint_set5_flag", "LONG", "uint32_t", "@brief Enables additional profile constraints. Please refer to 7.4.2.1.1 and A.2 sections of Rec. ITU-T H.264 for detailed information."}};
        QUICKSYNC_VIDEOENCODING_PARAMETERS = new String[][]{{"CodecId", "LONG", "mfxU32", "CodecId: MFX_CODEC_AVC=MFX_MAKEFOURCC('A','V','C',' '), MFX_CODEC_MPEG2=MFX_MAKEFOURCC('M','P','G','2'), MFX_CODEC_VC1 =MFX_MAKEFOURCC('V','C','1',' ')"}, {"CodecProfile", "LONG", "mfxU16", "CodecProfile: 66=MFX_PROFILE_AVC_BASELINE, 77=MFX_PROFILE_AVC_MAIN, 100=MFX_PROFILE_AVC_HIGH"}, {"CodecLevel", "LONG", "mfxU16", "CodecLevel: MFX_LEVEL_AVC_1=10, MFX_LEVEL_AVC_1b=9, MFX_LEVEL_AVC_11=11, MFX_LEVEL_AVC_12=12, MFX_LEVEL_AVC_13=13, MFX_LEVEL_AVC_2=20, MFX_LEVEL_AVC_21=21, MFX_LEVEL_AVC_22=22, MFX_LEVEL_AVC_3=30, MFX_LEVEL_AVC_31=31, MFX_LEVEL_AVC_32=32, MFX_LEVEL_AVC_4=40, MFX_LEVEL_AVC_41=41, MFX_LEVEL_AVC_42=42, MFX_LEVEL_AVC_5=50, MFX_LEVEL_AVC_51=51"}, {"NumThread", "LONG", "mfxU16", "NumThread: 0 = encoder decides"}, {"TargetUsage", "LONG", "mfxU16", "TargetUsage: 0=MFX_TARGETUSAGE_UNKNOWN, 1=MFX_TARGETUSAGE_BEST_QUALITY, 4=MFX_TARGETUSAGE_BALANCED, 7=MFX_TARGETUSAGE_BEST_SPEED"}, {"GopPicSize", "LONG", "mfxU16", "GopPicSize"}, {"GopRefDist", "LONG", "mfxU16", "GopRefDist"}, {"GopOptFlag", "LONG", "mfxU16", "GopOptFlag: 1=MFX_GOP_CLOSED, 2=MFX_GOP_STRICT"}, {"IdrInterval", "LONG", "mfxU16", "IdrInterval"}, {"RateControlMethod", "LONG", "mfxU16", "RateControlMethod: 1=MFX_RATECONTROL_CBR, 2=MFX_RATECONTROL_VBR, 3=MFX_RATECONTROL_CQP"}, {"InitialDelayInKB", "LONG", "mfxU16", "InitialDelayInKB"}, {"QPI", "LONG", "mfxU16", "QPI"}, {"BufferSizeInKB", "LONG", "mfxU16", "BufferSizeInKB"}, {"TargetKbps", "LONG", "mfxU16", "TargetKbps"}, {"QPP", "LONG", "mfxU16", "QPP"}, {"MaxKbps", "LONG", "mfxU16", "MaxKbps"}, {"QPB", "LONG", "mfxU16", "QPB"}, {"NumSlice", "LONG", "mfxU16", "NumSlice"}, {"NumRefFrame", "LONG", "mfxU16", "NumRefFrame"}, {"EncodedOrder", "LONG", "mfxU16", "EncodedOrder: binary flag, 0 signals encoder to take frames in display order"}, {"AspectRatioW", "LONG", "mfxU16", "AspectRatioW: frame aspect ratio width"}, {"AspectRatioH", "LONG", "mfxU16", "AspectRatioH: frame aspect ratio height"}, {"EnforceKeyFrameAlignment", "LONG", "uint8_t", "EnforceKeyFrameAlignment: If stream starts at timecode zero and stream has B-frame controls how pts/dts offset is calculated"}, {"MaxFramesPerSession", "LONG", "uint64_t", "MaxFramesPerSession: Maximum number of frames per-session (session is re-created on-the-fly). Zero never expires session"}};
        QUICKSYNC_VIDEOENCODING_H265_PARAMETERS = new String[][]{{"CodecId", "LONG", "mfxU32", "CodecId: MFX_CODEC_AVC=MFX_MAKEFOURCC('A','V','C',' '), MFX_CODEC_MPEG2=MFX_MAKEFOURCC('M','P','G','2'), MFX_CODEC_VC1 =MFX_MAKEFOURCC('V','C','1',' ')"}, {"CodecProfile", "LONG", "mfxU16", "CodecProfile: 66=MFX_PROFILE_AVC_BASELINE, 77=MFX_PROFILE_AVC_MAIN, 100=MFX_PROFILE_AVC_HIGH"}, {"CodecLevel", "LONG", "mfxU16", "CodecLevel: MFX_LEVEL_AVC_1=10, MFX_LEVEL_AVC_1b=9, MFX_LEVEL_AVC_11=11, MFX_LEVEL_AVC_12=12, MFX_LEVEL_AVC_13=13, MFX_LEVEL_AVC_2=20, MFX_LEVEL_AVC_21=21, MFX_LEVEL_AVC_22=22, MFX_LEVEL_AVC_3=30, MFX_LEVEL_AVC_31=31, MFX_LEVEL_AVC_32=32, MFX_LEVEL_AVC_4=40, MFX_LEVEL_AVC_41=41, MFX_LEVEL_AVC_42=42, MFX_LEVEL_AVC_5=50, MFX_LEVEL_AVC_51=51"}, {"NumThread", "LONG", "mfxU16", "NumThread: 0 = encoder decides"}, {"TargetUsage", "LONG", "mfxU16", "TargetUsage: 0=MFX_TARGETUSAGE_UNKNOWN, 1=MFX_TARGETUSAGE_BEST_QUALITY, 4=MFX_TARGETUSAGE_BALANCED, 7=MFX_TARGETUSAGE_BEST_SPEED"}, {"GopPicSize", "LONG", "mfxU16", "GopPicSize"}, {"GopRefDist", "LONG", "mfxU16", "GopRefDist"}, {"GopOptFlag", "LONG", "mfxU16", "GopOptFlag: 1=MFX_GOP_CLOSED, 2=MFX_GOP_STRICT"}, {"IdrInterval", "LONG", "mfxU16", "IdrInterval"}, {"RateControlMethod", "LONG", "mfxU16", "RateControlMethod: 1=MFX_RATECONTROL_CBR, 2=MFX_RATECONTROL_VBR, 3=MFX_RATECONTROL_CQP"}, {"InitialDelayInKB", "LONG", "mfxU16", "InitialDelayInKB"}, {"QPI", "LONG", "mfxU16", "QPI"}, {"BufferSizeInKB", "LONG", "mfxU16", "BufferSizeInKB"}, {"TargetKbps", "LONG", "mfxU16", "TargetKbps"}, {"QPP", "LONG", "mfxU16", "QPP"}, {"MaxKbps", "LONG", "mfxU16", "MaxKbps"}, {"QPB", "LONG", "mfxU16", "QPB"}, {"NumSlice", "LONG", "mfxU16", "NumSlice"}, {"NumRefFrame", "LONG", "mfxU16", "NumRefFrame"}, {"EncodedOrder", "LONG", "mfxU16", "EncodedOrder: binary flag, 0 signals encoder to take frames in display order"}, {"AspectRatioW", "LONG", "mfxU16", "AspectRatioW: frame aspect ratio width"}, {"AspectRatioH", "LONG", "mfxU16", "AspectRatioH: frame aspect ratio height"}, {"EnforceKeyFrameAlignment", "LONG", "uint8_t", "EnforceKeyFrameAlignment: If stream starts at timecode zero and stream has B-frame controls how pts/dts offset is calculated"}, {"MaxFramesPerSession", "LONG", "uint64_t", "MaxFramesPerSession: Maximum number of frames per-session (session is re-created on-the-fly). Zero never expires session"}};
        NVENC12_VIDEOENCODING_PARAMETERS = new String[][]{{"preset", "LONG", "unsigned int", "preset: 1,...7. Performance degrades and quality improves as we move from P1 to P7. Presets P3 to P7 for H264 and Presets P2 to P7 for HEVC have B frames enabled by default for HIGH_QUALITY and LOSSLESS tuning info, and will not work with Weighted Prediction enabled. In case Weighted Prediction is required, disable B frames by setting frameIntervalP = 1."}, {"profile", "LONG", "unsigned int", "profile: 66=baseline, 77=main, 100=high"}, {"level", "LONG", "unsigned int", "level: Specifies the level of the encoded bitstream"}, {"rateControl", "LONG", "unsigned int", "rateControl: 0=Constant QP mode, 1=Variable bitrate mode, 2=Constant bitrate mode"}, {"avgBitRate", "LONG", "unsigned int", "avgBitRate: Specifies the average bitrate(in bits/sec) used for encoding."}, {"peakBitRate", "LONG", "unsigned int", "peakBitRate: Specifies the maximum bitrate for the encoded output. This is used for VBR and ignored for CBR mode."}, {"vbvBufferSize", "LONG", "unsigned int", "vbvBufferSize: Specifies the VBV(HRD) buffer size. in bits. Set 0 to use the default VBV  buffer size."}, {"vbvInitialDelay", "LONG", "unsigned int", "vbvInitialDelay: Specifies the VBV(HRD) initial delay in bits. Set 0 to use the default VBV  initial delay."}, {"enableInitialRCQP", "LONG", "unsigned int", "enableInitialRCQP: Set this to 1 if user suppplied initial QP is used for rate control."}, {"qpIntra", "LONG", "unsigned int", "qpIntra: Specifies QP value for Intra Frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"qpInterP", "LONG", "unsigned int", "qpInterP: Specifies QP value for P-frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"qpInterB", "LONG", "unsigned int", "qpInterB: Specifies QP value for B-frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"gopLength", "LONG", "unsigned int", "gopLength: Group-of-pictures length in frames: # or infinite: 4294967295 (0xffffffff)"}, {"mvPrecision", "LONG", "unsigned int", "mvPrecision: 0=default, 1=full, 2=half, 3=quarter"}, {"numSlices", "LONG", "unsigned int", "numSlices: Number of slices per-frame. See sliceMode and sliceModeData for nvenc12."}, {"fieldEncoding", "LONG", "unsigned int", "FieldEncoding: 1=frame, 2=field, 3=mbaff"}, {"bottomFieldFirst", "LONG", "unsigned int", "bottomFieldFirst: Not used."}, {"numBFrames", "LONG", "unsigned int", "numBFrames: Number of b-frames."}, {"enablePTD", "LONG", "unsigned int", "enablePTD: Set this to 1 to enable the Picture Type Decision is be taken by the NvEncodeAPI interface."}, {"syncMode", "LONG", "unsigned int", "syncMode: Set this to 1 to enable asynchronous mode and is expected to use events to get picture completion notification."}, {"useMappedResources", "LONG", "unsigned int", "useMappedResources: Not used (switching between host and device frames is automatic)."}, {"enforceKeyFrameAlignment", "LONG", "unsigned int", "enforceKeyFrameAlignment: Only used for B-frame processing when the timecode of the first frame is zero, If 1 frame alignment will be maintained but ctts values could be negative. If 0, frame alignment will be sacrificed so that ctts values are >= 0: 0=do not enforce, 1=enforce (default is 1)"}, {"enableMinQP", "LONG", "unsigned int", "enableMinQP: Set this to 1 if minimum QP used for rate control."}, {"minQPIntra", "LONG", "unsigned int", "minQPIntra: Specifies QP value for Intra Frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"minQPInterP", "LONG", "unsigned int", "minQPInterP: Specifies QP value for P-frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"minQPInterB", "LONG", "unsigned int", "minQPInterB: Specifies QP value for B-frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"enableMaxQP", "LONG", "unsigned int", "enableMaxQP: Set this to 1 if maximum QP used for rate control."}, {"maxQPIntra", "LONG", "unsigned int", "maxQPIntra: Specifies QP value for Intra Frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"maxQPInterP", "LONG", "unsigned int", "maxQPInterP: Specifies QP value for P-frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"maxQPInterB", "LONG", "unsigned int", "maxQPInterB: Specifies QP value for B-frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"enableConstQP", "LONG", "unsigned int", "enableConstQP: Specifies the initial QP to be used for encoding. Set to 1 to enable. (this is ignored by nvenc12, use rateControl 0=constqp to enable)."}, {"constQPIntra", "LONG", "unsigned int", "constQPIntra: Specifies QP value for Intra Frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"constQPInterP", "LONG", "unsigned int", "constQPIntra: Specifies QP value for P-frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"constQPInterB", "LONG", "unsigned int", "constQPIntra: Specifies QP value for B-frame. Even though this field is uint32_t for legacy reasons, the client should treat this as a signed parameter(int32_t) for cases in which negative QP values are to be specified."}, {"enableAQ", "LONG", "unsigned int", "enableAQ: Set this to 1 to enable adaptive quantization (Spatial)."}, {"enableLookahead", "LONG", "unsigned int", "enableLookahead: Set this to 1 to enable lookahead with depth <lookaheadDepth> (if lookahead is enabled, input frames must remain available to the encoder until encode completion)."}, {"disableIadapt", "LONG", "unsigned int", "disableIadapt: Set this to 1 to disable adaptive I-frame insertion at scene cuts (only has an effect when lookahead is enabled)."}, {"disableBadapt", "LONG", "unsigned int", "disableBadapt: Set this to 1 to disable adaptive B-frame decision (only has an effect when lookahead is enabled)."}, {"enableTemporalAQ", "LONG", "unsigned int", "enableTemporalAQ: Set this to 1 to enable temporal AQ."}, {"zeroReorderDelay", "LONG", "unsigned int", "zeroReorderDelay: Set this to 1 to indicate zero latency operation (no reordering delay, num_reorder_frames=0)."}, {"enableNonRefP", "LONG", "unsigned int", "enableNonRefP: Set this to 1 to enable automatic insertion of non-reference P-frames (no effect if enablePTD=0)."}, {"strictGOPTarget", "LONG", "unsigned int", "strictGOPTarget: Set this to 1 to minimize GOP-to-GOP rate fluctuations."}, {"aqStrength", "LONG", "unsigned int", "aqStrength: When AQ (Spatial) is enabled (i.e. NV_ENC_RC_PARAMS::enableAQ is set), this field is used to specify AQ strength. AQ strength scale is from 1 (low) - 15 (aggressive). If not set, strength is autoselected by driver."}, {"targetQuality", "LONG", "unsigned int", "targetQuality: Target CQ (Constant Quality) level for VBR mode (range 0-51 with 0-automatic)."}, {"targetQualityLSB", "LONG", "unsigned int", "targetQualityLSB: TFractional part of target quality (as 8.8 fixed point format)."}, {"lookaheadDepth", "LONG", "unsigned int", "lookaheadDepth: Maximum depth of lookahead with range 0-32 (only used if enableLookahead=1)."}, {"maxNumRefFrames", "LONG", "unsigned int", "maxNumRefFrames: Specifies the DPB size used for encoding. Setting it to 0 will let driver use the default dpb size."}, {"sliceMode", "LONG", "unsigned int", "sliceMode: This parameter in conjunction with sliceModeData specifies the way in which the picture is divided into slices sliceMode = 0 MB based slices, sliceMode = 1 Byte based slices, sliceMode = 2 MB row based slices, sliceMode = 3 numSlices in Picture."}, {"sliceModeData", "LONG", "unsigned int", "sliceModeData: Specifies the parameter needed for sliceMode. sliceMode = 0 # of MBs in each slice (except last slice), sliceMode = 1, maximum # of bytes in each slice (except last slice), sliceMode = 2, sliceModeData # of MB rows in each slice (except last slice), sliceMode = 3, sliceModeData specifies number of slices in the picture. Driver will divide picture into slices optimally. [overrides numSlices]"}, {"tuningInfo", "LONG", "unsigned int", "tuningInfo: Tuning information of NVENC encoding (TuningInfo is not applicable to H264 and HEVC MEOnly mode). 1=latency tolerant encoding, 2=low latency streaming, 3=ultra low latency streaming, 4=lossless encoding."}, {"multiPass", "LONG", "unsigned int", "multipass: Multi Pass encoding. 0=Single Pass, 1=Two Pass encoding is enabled where first Pass is quarter resolution, 2=Two Pass encoding is enabled where first Pass is full resolution."}, {"frameIntervalP", "LONG", "unsigned int", "frameIntervalP: Specifies the GOP pattern as follows: 0=I, 1=IPP, 2=IBP, 3=IBBP. If goplength is set to NVENC_INFINITE_GOPLENGTH frameIntervalP should be set to 1."}, {"idrPeriod", "LONG", "unsigned int", "idrPeriod: Specifies the IDR interval. If not set, this is made equal to gopLength in NV_ENC_CONFIG. Low latency application client can set IDR interval to NVENC_INFINITE_GOPLENGTH so that IDR frames are not inserted automatically."}, {"outputBufferingPeriodSEI", "LONG", "unsigned int", "outputBufferingPeriodSEI: Set to 1 to write SEI buffering period syntax in the bitstream"}, {"outputPictureTimingSEI", "LONG", "unsigned int", "outputPictureTimingSEI: Set to 1 to write SEI picture timing syntax in the bitstream."}, {"outputAUD", "LONG", "unsigned int", "outputAUD: Set to 1 to write access unit delimiter syntax in bitstream."}, {"useBFramesAsRef", "LONG", "unsigned int", "useBFramesAsRef: Specifies the B-Frame as reference mode. 0=B as reference is not supported ,1=each B-Frame as reference is supported."}};
        CUDA_VIDEOENCODING_PARAMETERS = new String[][]{{"measure_psnr", "LONG", "int", "measure_psnr"}, {"measure_fps", "LONG", "int", "measure_fps"}, {"force_device", "LONG", "int", "force_device"}, {"iSurfaceFormat", "LONG", "int", "iSurfaceFormat: 0=UYVY, 1=YUY2, 2=YV12, 3=NV12, 4=IYUV"}, {"iPictureType", "LONG", "int", "iPictureType: 1=NV_TOP_FIELD, 2=NV_BOTTOM_FIELD, 3=NV_FRAME_PICTURE"}, {"nDeviceMemPitch", "LONG", "int", "nDeviceMemPitch"}, {"iCodecType", "LONG", "int", "iCodecType: 1=NV_CODEC_TYPE_MPEG1, 2=NV_CODEC_TYPE_MPEG2, 3=NV_CODEC_TYPE_MPEG4, 4=NV_CODEC_TYPE_H264, 5=NV_CODEC_TYPE_VC1"}, {"GPU_count", "LONG", "int", "GPU_count: Choose the specific GPU count"}, {"GPU_devID", "LONG", "int", "GPU_devID:Choose the specific GPU device ID"}, {"iUseDeviceMem", "LONG", "int", "iUseDeviceMem: CUDA with DEVICE_MEMORY_INPUT (for encoding)"}, {"iForcedGPU", "LONG", "int", "iForcedGPU"}, {"iOutputSize", "LONGARRAY:2", "int", "iOutputSize"}, {"iInputSize", "LONGARRAY:2", "int", "iInputSize"}, {"fAspectRatio", "DOUBLE", "float", "fAspectRatio: set as -1.0f for custom aspect ratio"}, {"iAspectRatio", "LONGARRAY:3", "int", "iAspectRatio"}, {"Fieldmode", "LONG", "int", "Fieldmode: 0=MODE_FRAME, 1=MODE_FIELD_TOP_FIRST, 2=MODE_FIELD_BOTTOM_FIRST, 3=MODE_FIELD_PICAFF"}, {"iP_Interval", "LONG", "int", "iP_Interval"}, {"iIDR_Period", "LONG", "int", "iIDR_Period"}, {"iDynamicGOP", "LONG", "int", "iDynamicGOP"}, {"RCType", "LONG", "int", "RCType: 0=RC_CQP, 1=RC_VBR, 2=RC_CBR, 3=RC_VBR_MINQP"}, {"iAvgBitrate", "LONG", "int", "iAvgBitrate"}, {"iPeakBitrate", "LONG", "int", "iPeakBitrate"}, {"iQP_Level_Intra", "LONG", "int", "iQP_Level_Intra"}, {"iQP_Level_InterP", "LONG", "int", "iQP_Level_InterP"}, {"iQP_Level_InterB", "LONG", "int", "iQP_Level_InterB"}, {"iFrameRate", "LONGARRAY:2", "int", "iFrameRate"}, {"iDeblockMode", "LONG", "int", "iDeblockMode"}, {"iProfileLevel", "LONG", "int", "iProfileLevel: 65346=baseline, 65357=main, 65380=high"}, {"iForceIntra", "LONG", "int", "iForceIntra"}, {"iForceIDR", "LONG", "int", "iForceIDR"}, {"iClearStat", "LONG", "int", "iClearStat"}, {"DIMode", "LONG", "int", "DIMode: 0=DI_OFF, 1=DI_MEDIAN"}, {"Presets", "LONG", "int", "Presets: -1=ignore, 0=ENC_PRESET_PSP (width 320  height 240), 1=ENC_PRESET_IPOD (width 320  height 240), 2=ENC_PRESET_AVCHD (width 1920 height 1080), 3=ENC_PRESET_BD (width 1920 height 1080), 4=ENC_PRESET_HDV_1440 (width 1440 height 1080), 5=ENC_PRESET_ZUNEHD (width 720  height 480), 6=ENC_PRESET_FLIP_CAM"}, {"iDisableCabac", "LONG", "int", "iDisableCabac: 0=enabled 1=disabled"}, {"iNaluFramingType", "LONG", "int", "iNaluFramingType: 0:start codes 1,2,4:length prefixed NAL units"}, {"iDisableSPSPPS", "LONG", "int", "iDisableSPSPPS: (0:enabled 1:disable)"}, {"GPUOffloadLevel", "LONG", "int", "GPUOffloadLevel: NVVE_GPU_OFFLOAD_DEFAULT=-1 (default setting for pel processing ), NVVE_GPU_OFFLOAD_ESTIMATORS=8 (pel processing on CPU, Motion Estimation on GPU), NVVE_GPU_OFFLOAD_ALL=16 (pel processing on GPU)"}, {"MaxOffloadLevel", "LONG", "int", "MaxOffloadLevel: NVVE_GPU_OFFLOAD_DEFAULT=-1 (default setting for pel processing ), NVVE_GPU_OFFLOAD_ESTIMATORS=8 (pel processing on CPU, Motion Estimation on GPU), NVVE_GPU_OFFLOAD_ALL=16 (pel processing on GPU)"}, {"iSliceCnt", "LONG", "int", "iSliceCnt"}, {"iMultiGPU", "LONG", "int", "iMultiGPU"}, {"iDeviceMemInput", "LONG", "int", "iDeviceMemInput"}};
        XILINX_U30_VIDEOENCODING_H26X_PARAMETERS = new String[][]{{"control_rate", "LONG", "unsigned int", "control_rate: Rate control mode: 0: constant QP, 1: constant bitrate, 2: variable bitrate, 3: low latency, 4: capped variable bitrate, 5: bypass"}, {"max_bitrate", "LONG", "unsigned int", "max_bitrate: Maximum bitrate in bits/sec for the rate control: 5000: lowest bitrate, 35000000: highest bitrate"}, {"slice_qp", "LONG", "int", "slice_qp: It is not supported."}, {"min_qp", "LONG", "unsigned int", "min_qp: Minimum QP value allowed for the rate control: 0: lowest qp, 51: highest qp"}, {"max_qp", "LONG", "unsigned int", "max_qp: Maximum QP value allowed for the rate control: 0: lowest_qp, 51: highest_qp"}, {"cpb_size", "DOUBLE", "double", "cpb_size: Coded Picture Buffer as specified in the HRD model in sec: lowest cpb size, 0.0: highest cpb size, 100.0. It is not supported."}, {"initial_delay", "DOUBLE", "double", "Initial Removal Delay as specified in the HRD model in sec: lowest delay, 0.0: highest delay, infinite.  It is not supported."}, {"gop_mode", "LONG", "unsigned int", "gop_mode: GOP Configuration: 0: default, 1: Pyramidal GOP (Advanced GOP pattern with hierachical B-frames), 2: Adaptive GOP (Advanced GOP pattern with adaptive B-frames), 3: bypass, 4: Single I-frame followed by P-frames only, 5: Single I-frame followed by B-frames only"}, {"gdr_mode", "LONG", "unsigned int", "gdr_mode: Gradual Decoder Refresh scheme mode: 0: disabled (no GDR), 1: Vertical (Gradual refresh using a vertical bar moving from left to right), 2: Horizontal (Gradual refresh using a horizontal bar moving from top to bottom)"}, {"b_frames", "LONG", "unsigned int", "b_frames: Number of B frames, more B frames helps compression but hurts high motion scenes: 0: lowest, 4: highest"}, {"periodicity_idr", "LONG", "unsigned int", "periodicity_idr: IDR Picture Frequency: 0: lowest, infinite (highest)"}, {"profile", "LONG", "unsigned int", "profile: H264 Profile: 66: Baseline profile, 77: Main profile, 100: High profile"}, {"level", "LONG", "unsigned int", "level: Level of encoder multiplied per ten: 10: Level 1, 11: Level 1.1, ..., 52: Level 5.2"}, {"tier", "LONG", "unsigned int", "tier: Set the encoding tier: 0: main tier, 1: high tier.  It is not supported."}, {"num_slices", "LONG", "unsigned int", "num_slices: Number of Slices: 1: lowest, 68: highest"}, {"qp_mode", "LONG", "unsigned int", "qp_mode: QP control mode: 0: Use the same QP for all coding units of the frame, 1: Let the VCU encoder change the QP for each coding unit according to its content, 2: Use the values in the lambda file, 3: Use the information gathered in the lookahead to calculate the best QP"}, {"filler_data", "LONG", "unsigned int", "filler_data: Specifies if filler data can be added to the stream or not: 1: enable, 0: disable.  It is not supported."}, {"aspect_ratio", "LONG", "unsigned int", "aspect_ratio: Aspect ratio of video: 0: Automatic selection, 1: 4:3 Aspect ratio, 2: 16:9 Aspect ratio, 3: Aspect ratio information is not present in the stream.  It is not supported."}, {"dependent_slice", "LONG", "unsigned int", "dependent_slice: Additional slices are dependent slice segments: 1: enable dependent, 0: disable dependent.  It is not supported."}, {"slice_size", "LONG", "unsigned int", "slice_size: 0: Defined by the NumSlices parameter, value: Specifies the target slice size, in bytes, that the encoder uses to automatically split the bitstream into approximately equally sized slices with a granularity of one LCU, 65535: highest.  It is not supported."}, {"scaling_list", "LONG", "unsigned int", "scaling_list: Scaling list mode: 0: Flat scaling list mode, 1: Default scaling list mode"}, {"entropy_mode", "LONG", "unsigned int", "entropy_mode: Entropy encoding mode: 0: CAVLC entropy mode, 1: CABAC entropy mode.  It is not supported."}, {"loop_filter", "LONG", "unsigned int", "loop_filter: Specifies if deblocking filter must be used: 1: enable, 0: disable.  It is not supported."}, {"constrained_intra_pred", "LONG", "unsigned int", "onstrained_intra_pred: Specifies if constrained intra prediction must be used: 1: enable, 0: disable"}, {"prefetch_buffer", "LONG", "unsigned int", "prefetch_buffer: Specifies if L2 cache must be used in encoding process: 1: enable, 0: disable.  It is not supported."}, {"cores", "LONG", "unsigned int", "cores: Number of cores to use: 0: lowest, 4: highest"}, {"lookahead_depth", "LONG", "unsigned int", "lookahead_depth: Number of frames to lookahead for qp maps generation or custom rate control: 0: lowest, 20: highest"}, {"spatial_aq", "LONG", "unsigned int", "spatial_aq: 1: enable, 0: disable"}, {"temporal_aq", "LONG", "unsigned int", "temporal_aq: 1: enable, 0: disable"}, {"rate_control_mode", "LONG", "unsigned int", "rate_control_mode: Custom rate control mode. Not Yet Implemented: 1: enable, 0: disable"}, {"spatial_aq_gain", "LONG", "unsigned int", "spatial_aq_gain: Percentage of spatial AQ gain: 0: lowest precentage gain: 0: highest precentage gain: 100"}, {"latency_logging", "LONG", "unsigned int", "latency_logging: Log latency information to syslog: 1: enable, 0: disable.  It is not supported."}, {"tune_metrics", "LONG", "unsigned int", "tune_metrics: Tunes MPSoC H.264 Encoder's video quality for objective metrics: 1: enable, 0: disable"}, {"gop_size", "LONG", "unsigned int", "gop_sizes: Group of pictures length in frames: 1: lowest, 30: default, ..., infinite"}, {"dynamic_gop", "LONG", "unsigned int", "dynamic_gop: Ability to change the composition of a GOP in response to the lookahead, not compatible with b-frames flag and needs a lookahead depth of minimum 5: 1: enable, 0: disable"}};
        XILINX_U30_VIDEODECODING_H26X_PARAMETERS = new String[][]{{"low_latency", "LONG", "unsigned int", "low_latency: Should low latency decoding be used: 1: enable, 0: disable"}, {"entropy_buffers_count", "LONG", "unsigned int", "entropy_buffers_count: Specify number of internal entropy buffers: 2: lowest entropy buffers, 10: highest entropy buffers"}, {"latency_logging", "LONG", "unsigned int", "latency_logging: Log latency information to syslog: 1: enable, 0: disable"}, {"splitbuff_mode", "LONG", "unsigned int", "splitbuff_mode: Configure decoder in split/unsplit input buffer mode: 1: enable, 0: disable"}, {"max_height_webrtc_input", "LONG", "unsigned int", "max_height_webrtc_input: WebRTC maximum height input received, must be less than 1080. Default 1080"}, {"max_width_webrtc_input", "LONG", "unsigned int", "max_width_webrtc_input: WebRTC maximum width input received, must be less than 1920. Default 1920"}, {"max_webrtc_framerate", "LONG", "unsigned int", "max_webrtc_framerate: WebRTC maximum framerate received. Default 30"}, {"enable_cpu_fallback", "Boolean", "unsigned int", "Enable CPU fallback when U30 decoder is not able to process frame."}};
        paramaterMapVideoEncode = new HashMap<String, Map<String, TranscoderNativeParameterHolder>>();
        paramaterMapVideoDecode = new HashMap<String, Map<String, TranscoderNativeParameterHolder>>();
        paramaterMapAudioEncode = new HashMap<String, Map<String, TranscoderNativeParameterHolder>>();
        paramaterMapAudioDecode = new HashMap<String, Map<String, TranscoderNativeParameterHolder>>();
        paramaterMapCapture = new HashMap<String, Map<String, TranscoderNativeParameterHolder>>();
        HashMap<String, TranscoderNativeParameterHolder> hashMap = new HashMap<String, TranscoderNativeParameterHolder>();
        HashMap<String, TranscoderNativeParameterHolder> hashMap2 = new HashMap<String, TranscoderNativeParameterHolder>();
        HashMap<String, TranscoderNativeParameterHolder> hashMap3 = new HashMap<String, TranscoderNativeParameterHolder>();
        Object object = null;
        int n2 = 0;
        for (n = 0; n < ALL_VIDEODECODING_PARAMETERS.length; ++n) {
            object = TranscoderNativeParameterInfo.newTranscoderNativeParameterHolder(n2 + n, PARAM_PREFIX_DEFAULT, ALL_VIDEODECODING_PARAMETERS[n]);
            hashMap.put(((TranscoderNativeParameterHolder)object).variableName.toLowerCase(Locale.ENGLISH), (TranscoderNativeParameterHolder)object);
            hashMap2.put(((TranscoderNativeParameterHolder)object).variableName.toLowerCase(Locale.ENGLISH), (TranscoderNativeParameterHolder)object);
            hashMap3.put(((TranscoderNativeParameterHolder)object).variableName.toLowerCase(Locale.ENGLISH), (TranscoderNativeParameterHolder)object);
        }
        n2 += 10000;
        for (n = 0; n < MAINCONCEPT_VIDEODECODING_PARAMETERS.length; ++n) {
            object = TranscoderNativeParameterInfo.newTranscoderNativeParameterHolder(n2 + n, PARAM_PREFIX_MAINCONCEPT, MAINCONCEPT_VIDEODECODING_PARAMETERS[n]);
            hashMap.put(((TranscoderNativeParameterHolder)object).variableName.toLowerCase(Locale.ENGLISH), (TranscoderNativeParameterHolder)object);
        }
        n2 += 10000;
        for (n = 0; n < NVCUVID_VIDEODECODING_PARAMETERS.length; ++n) {
            object = TranscoderNativeParameterInfo.newTranscoderNativeParameterHolder(n2 + n, PARAM_PREFIX_NVCUVID, NVCUVID_VIDEODECODING_PARAMETERS[n]);
            hashMap2.put(((TranscoderNativeParameterHolder)object).variableName.toLowerCase(Locale.ENGLISH), (TranscoderNativeParameterHolder)object);
        }
        n2 += 10000;
        for (n = 0; n < XILINX_U30_VIDEODECODING_H26X_PARAMETERS.length; ++n) {
            object = TranscoderNativeParameterInfo.newTranscoderNativeParameterHolder(n2 + n, PARAM_PREFIX_U30, XILINX_U30_VIDEODECODING_H26X_PARAMETERS[n]);
            hashMap3.put(((TranscoderNativeParameterHolder)object).variableName.toLowerCase(Locale.ENGLISH), (TranscoderNativeParameterHolder)object);
        }
        paramaterMapVideoDecode.put(PARAM_PREFIX_U30, hashMap3);
        paramaterMapVideoDecode.put(PARAM_PREFIX_NVCUVID, hashMap2);
        paramaterMapVideoDecode.put(PARAM_PREFIX_MAINCONCEPT, hashMap);
        object = new HashMap();
        HashMap<String, TranscoderNativeParameterHolder> hashMap4 = null;
        n = 0;
        for (int i = 0; i < ALL_AUDIODECODING_PARAMETERS.length; ++i) {
            hashMap4 = TranscoderNativeParameterInfo.newTranscoderNativeParameterHolder(n + i, PARAM_PREFIX_DEFAULT, ALL_AUDIODECODING_PARAMETERS[i]);
            object.put(((TranscoderNativeParameterHolder)((Object)hashMap4)).variableName.toLowerCase(Locale.ENGLISH), hashMap4);
        }
        paramaterMapAudioDecode.put(PARAM_PREFIX_MAINCONCEPT, (Map<String, TranscoderNativeParameterHolder>)object);
        hashMap4 = new HashMap();
        HashMap hashMap5 = new HashMap();
        HashMap hashMap6 = new HashMap();
        HashMap hashMap7 = new HashMap();
        HashMap<String, TranscoderNativeParameterHolder> hashMap8 = new HashMap<String, TranscoderNativeParameterHolder>();
        HashMap hashMap9 = new HashMap();
        HashMap hashMap10 = new HashMap();
        HashMap hashMap11 = new HashMap();
        HashMap hashMap12 = new HashMap();
        HashMap hashMap13 = new HashMap();
        HashMap hashMap14 = new HashMap();
        HashMap hashMap15 = new HashMap();
        HashMap hashMap16 = new HashMap();
        HashMap hashMap17 = new HashMap();
        HashMap hashMap18 = new HashMap();
        HashMap hashMap19 = new HashMap();
        HashMap hashMap20 = new HashMap();
        paramaterMapVideoEncode.put(PARAM_PREFIX_MAINCONCEPT, (Map<String, TranscoderNativeParameterHolder>)hashMap4);
        paramaterMapVideoEncode.put(PARAM_PREFIX_CUDA, hashMap5);
        paramaterMapVideoEncode.put(PARAM_PREFIX_NVENC, hashMap6);
        paramaterMapVideoEncode.put(PARAM_PREFIX_X264, hashMap7);
        paramaterMapVideoEncode.put(PARAM_PREFIX_QUICKSYNC, hashMap8);
        paramaterMapVideoEncode.put(PARAM_PREFIX_QUICKSYNC_H265, hashMap9);
        paramaterMapVideoEncode.put(PARAM_PREFIX_VAAPI_H264, hashMap10);
        paramaterMapVideoEncode.put(PARAM_PREFIX_VAAPI_H265, hashMap11);
        paramaterMapVideoEncode.put(PARAM_PREFIX_VAAPI_VP9, hashMap12);
        paramaterMapVideoEncode.put(PARAM_PREFIX_IIPH263, hashMap13);
        paramaterMapVideoEncode.put(PARAM_PREFIX_MAINCONCEPT_H265, hashMap14);
        paramaterMapVideoEncode.put(PARAM_PREFIX_VPX, hashMap15);
        paramaterMapVideoEncode.put(PARAM_PREFIX_X265, hashMap16);
        paramaterMapVideoEncode.put(PARAM_ADVANTECH_VEGA_H264, hashMap17);
        paramaterMapVideoEncode.put(PARAM_ADVANTECH_VEGA_H265, hashMap18);
        paramaterMapVideoEncode.put(PARAM_PREFIX_U30_H26X, hashMap20);
        HashMap hashMap21 = new HashMap();
        paramaterMapAudioEncode.put(PARAM_PREFIX_MAINCONCEPT, hashMap21);
        paramaterMapAudioEncode.put(PARAM_PREFIX_OPUS, hashMap19);
        HashMap hashMap22 = new HashMap();
        paramaterMapCapture.put(PARAM_PREFIX_BLACKMAGIC_CAPTURE, hashMap22);
        for (int i = 0; i < 19; ++i) {
            String[][] stringArray = null;
            HashMap<String, TranscoderNativeParameterHolder> hashMap23 = null;
            String string = null;
            int n3 = 0;
            switch (i) {
                case 0: {
                    stringArray = MAINCONCEPT_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap4;
                    string = PARAM_PREFIX_MAINCONCEPT;
                    n3 = 10000;
                    break;
                }
                case 1: {
                    stringArray = QUICKSYNC_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap8;
                    string = PARAM_PREFIX_QUICKSYNC;
                    n3 = 20000;
                    break;
                }
                case 2: {
                    stringArray = CUDA_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap5;
                    string = PARAM_PREFIX_CUDA;
                    n3 = 30000;
                    break;
                }
                case 3: {
                    stringArray = MAINCONCEPT_AUDIOAACENCODING_PARAMETERS;
                    hashMap23 = hashMap21;
                    string = PARAM_PREFIX_MAINCONCEPT;
                    n3 = 40000;
                    break;
                }
                case 4: {
                    stringArray = VAAPI_VIDEOENCODING_H264_PARAMETERS;
                    hashMap23 = hashMap10;
                    string = PARAM_PREFIX_VAAPI_H264;
                    n3 = 50000;
                    break;
                }
                case 5: {
                    stringArray = IPPH263_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap13;
                    string = PARAM_PREFIX_IIPH263;
                    n3 = 60000;
                    break;
                }
                case 6: {
                    stringArray = NVENC12_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap6;
                    string = PARAM_PREFIX_NVENC;
                    n3 = 70000;
                    break;
                }
                case 7: {
                    stringArray = X264_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap7;
                    string = PARAM_PREFIX_X264;
                    n3 = 80000;
                    break;
                }
                case 8: {
                    stringArray = MAINCONCEPT_H265_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap14;
                    string = PARAM_PREFIX_MAINCONCEPT_H265;
                    n3 = 90000;
                    break;
                }
                case 9: {
                    stringArray = VPX_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap15;
                    string = PARAM_PREFIX_VPX;
                    n3 = 100000;
                    break;
                }
                case 10: {
                    stringArray = X265_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap16;
                    string = PARAM_PREFIX_X265;
                    n3 = 110000;
                    break;
                }
                case 11: {
                    stringArray = VAAPI_VIDEOENCODING_VP9_PARAMETERS;
                    hashMap23 = hashMap12;
                    string = PARAM_PREFIX_VAAPI_VP9;
                    n3 = 120000;
                    break;
                }
                case 12: {
                    stringArray = BLACKMAGIC_CAPTURE_PARAMETERS;
                    hashMap23 = hashMap22;
                    string = PARAM_PREFIX_BLACKMAGIC_CAPTURE;
                    n3 = 130000;
                    break;
                }
                case 13: {
                    stringArray = ADVANTECH_VEGA_H264_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap17;
                    string = PARAM_ADVANTECH_VEGA_H264;
                    n3 = 140000;
                    break;
                }
                case 14: {
                    stringArray = ADVANTECH_VEGA_H265_VIDEOENCODING_PARAMETERS;
                    hashMap23 = hashMap18;
                    string = PARAM_ADVANTECH_VEGA_H265;
                    n3 = 150000;
                    break;
                }
                case 15: {
                    stringArray = VAAPI_VIDEOENCODING_H265_PARAMETERS;
                    hashMap23 = hashMap11;
                    string = "vaapi-h265";
                    n3 = 160000;
                    break;
                }
                case 16: {
                    stringArray = QUICKSYNC_VIDEOENCODING_H265_PARAMETERS;
                    hashMap23 = hashMap9;
                    string = "quicksync-h265";
                    n3 = 170000;
                    break;
                }
                case 17: {
                    stringArray = OPUS_AUDIOENCODING_PARAMETERS;
                    hashMap23 = hashMap19;
                    string = PARAM_PREFIX_OPUS;
                    n3 = 190000;
                    break;
                }
                case 18: {
                    stringArray = XILINX_U30_VIDEOENCODING_H26X_PARAMETERS;
                    hashMap23 = hashMap20;
                    string = "xilinx-h26x";
                    n3 = 210000;
                }
            }
            for (int j = 0; j < stringArray.length; ++j) {
                String string2;
                TranscoderNativeParameterHolder transcoderNativeParameterHolder = new TranscoderNativeParameterHolder();
                transcoderNativeParameterHolder.variableName = stringArray[j][0];
                transcoderNativeParameterHolder.groupName = string;
                transcoderNativeParameterHolder.description = stringArray[j][3];
                transcoderNativeParameterHolder.settingIndex = n3 + j;
                if (stringArray[j].length >= 5 && (string2 = stringArray[j][4].toLowerCase(Locale.ENGLISH)).equals("read")) {
                    transcoderNativeParameterHolder.writable = false;
                }
                int n4 = 0;
                String string3 = stringArray[j][1];
                int n5 = string3.indexOf(":");
                if (n5 >= 0) {
                    n4 = Integer.parseInt(string3.substring(n5 + 1));
                    string3 = string3.substring(0, n5);
                }
                int n6 = 0;
                if (string3.equalsIgnoreCase("LONG") || string3.equalsIgnoreCase("FLAG") || string3.equalsIgnoreCase("INT")) {
                    n6 = 1;
                } else if (string3.equalsIgnoreCase("LONGARRAY")) {
                    n6 = 2;
                } else if (string3.equalsIgnoreCase("DOUBLE") || string3.equalsIgnoreCase("FLOAT")) {
                    n6 = 3;
                } else if (string3.equalsIgnoreCase("DOUBLEARRAY")) {
                    n6 = 4;
                }
                transcoderNativeParameterHolder.dataType = n6;
                transcoderNativeParameterHolder.dataArrLength = n4;
                hashMap23.put(transcoderNativeParameterHolder.variableName.toLowerCase(Locale.ENGLISH), transcoderNativeParameterHolder);
            }
        }
    }

    public static class ParameterValueInfo {
        String name = null;
        String value = null;

        public ParameterValueInfo clone() {
            try {
                ParameterValueInfo parameterValueInfo = new ParameterValueInfo();
                parameterValueInfo.name = this.name;
                parameterValueInfo.value = this.value;
                return parameterValueInfo;
            }
            catch (TranscoderNativeParameterInfo$ParameterValueInfo$Exception transcoderNativeParameterInfo$ParameterValueInfo$Exception) {
                return null;
            }
        }
    }
}

