/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.publish;

import com.wowza.wms.stream.publish.IPublishingProvider;
import com.wowza.wms.stream.publish.PlaylistItem;
import com.wowza.wms.stream.publish.Publisher;
import com.wowza.wms.stream.publish.PublishingProviderBase;
import com.wowza.wms.stream.publish.PublishingProviderLive;
import com.wowza.wms.stream.publish.PublishingProviderMediaReader;
import com.wowza.wms.stream.publish.Stream;

class PublishingProviderFactory {
    PublishingProviderFactory() {
    }

    IPublishingProvider getPublishingProvider(Stream stream, PlaylistItem playlistItem, Publisher publisher, long l, long l2, long l3) {
        PublishingProviderBase publishingProviderBase;
        int n = playlistItem.getStart();
        if (n <= -2) {
            publishingProviderBase = new PublishingProviderLive(publisher, l2, l3, playlistItem.getName());
            this.setLiveDefaults((PublishingProviderLive)publishingProviderBase, stream);
        } else {
            publishingProviderBase = new PublishingProviderMediaReader(publisher, l2, l3, playlistItem.getName());
            ((PublishingProviderMediaReader)publishingProviderBase).setSpeed(stream.getVODSpeed());
            if (n > 0) {
                publishingProviderBase.seek((long)n * (long)(stream.isTimesInMilliseconds() ? 1 : 1000));
            }
        }
        this.setCommonDefaults((IPublishingProvider)((Object)publishingProviderBase), stream, l, playlistItem.getLength());
        return publishingProviderBase;
    }

    private void setLiveDefaults(PublishingProviderLive publishingProviderLive, Stream stream) {
        publishingProviderLive.setStartOnPreviousBufferTime(stream.getStartLiveOnPreviousBufferTime());
        publishingProviderLive.setStartOnPreviousKeyFrame(stream.isStartLiveOnPreviousKeyFrame());
        publishingProviderLive.setStopIfStreamMissing(stream.isMoveToNextIfLiveStreamMissing());
    }

    private void setCommonDefaults(IPublishingProvider iPublishingProvider, Stream stream, long l, int n) {
        iPublishingProvider.setSendOnMetadata(stream.isSendOnMetadata());
        iPublishingProvider.setRealTimeStartTime(l);
        if (n > 0) {
            iPublishingProvider.setDuration((long)n * (long)(stream.isTimesInMilliseconds() ? 1 : 1000));
        }
    }
}

