/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamPlay;
import com.wowza.wms.stream.live.ILivePlayer;
import com.wowza.wms.stream.live.MediaStreamLivePlayAbstract$IOException;
import java.io.OutputStream;

public abstract class MediaStreamLivePlayAbstract
extends MediaStreamPlay {
    protected ILivePlayer player = null;
    protected String contextStr = "";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        try {
            super.init(iMediaStream, mediaStreamMap);
            if (iMediaStream != null) {
                this.contextStr = iMediaStream.getContextStr();
                if (this.contextStr == null) {
                    this.contextStr = "";
                }
            }
            this.player.init(iMediaStream, mediaStreamMap);
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    protected int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        try {
            return this.player.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return 0;
        }
    }

    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        try {
            return this.player.play(outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return 0;
        }
    }

    protected boolean play(IMediaStream iMediaStream) {
        try {
            return this.player.play(iMediaStream);
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return false;
        }
    }

    public boolean play() {
        try {
            return this.player.play();
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return false;
        }
    }

    public void resetNoLookup() {
        try {
            this.player.resetNoLookup();
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void close() {
        try {
            this.player.close();
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void reset(boolean bl) {
        try {
            this.player.reset(bl);
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void pause(int n, long l) {
        try {
            this.player.pause(n, l);
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void pauseRaw(int n, long l) {
        try {
            this.player.pauseRaw(n, l);
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void seek(int n) {
        try {
            this.player.seek(n);
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void setBufferTime(int n) {
        try {
            super.setBufferTime(n);
            this.player.setBufferTime(n);
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void shutdown() {
        try {
            this.player.shutdown();
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void stopName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        try {
            this.player.stopName(string, string2, string3, string4, d, d2, n);
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        try {
            this.player.switchName(string, string2, string3, string4, d, d2, n);
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void setName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        try {
            this.player.setName(string, string2, string3, string4, d, d2, n);
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void interruptPlay() {
        try {
            this.player.interruptPlay();
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void startPlay() {
        try {
            this.player.startPlay();
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void switchPlay() {
        try {
            this.player.switchPlay();
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public void updateLoggingValues() {
        try {
            this.player.updateLoggingValues();
            return;
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return;
        }
    }

    public double length() {
        try {
            return this.player.length();
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return 0.0;
        }
    }

    public long size() {
        try {
            return this.player.size();
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return 0L;
        }
    }

    public long getLastTimecodeOffset() {
        try {
            return this.player.getLastTimecodeOffset();
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return 0L;
        }
    }

    public long getLastSentVideoTC() {
        try {
            return this.player.getLastSentVideoTC();
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return 0L;
        }
    }

    public long getLastSentAudioTC() {
        try {
            return this.player.getLastSentAudioTC();
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return 0L;
        }
    }

    public long getLastSentDataTC() {
        try {
            return this.player.getLastSentDataTC();
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return 0L;
        }
    }

    public int getLastVideoFilter() {
        try {
            return this.player.getLastVideoFilter();
        }
        catch (MediaStreamLivePlayAbstract$IOException mediaStreamLivePlayAbstract$IOException) {
            return 0;
        }
    }
}

