/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stats.utils;

import com.wowza.wms.stats.utils.StatsUtilsDateTime$Exception;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class StatsUtilsDateTime {
    static int offsetMilliseconds = 0;

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public static void setCurrentTime(DateTime dateTime) {
        long l;
        DateTime dateTime2;
        int n = -1;
        ++n;
        String string = "0";
        switch (Integer.parseInt(string)) {
            case 0: {
                dateTime2 = DateTime.now((DateTimeZone)DateTimeZone.UTC);
                l = dateTime.getMillis();
                n += 13;
                string = "26";
                break;
            }
            default: {
                n += 9;
                l = 0L;
                dateTime2 = null;
            }
        }
        offsetMilliseconds = (int)(l - dateTime2.getMillis());
    }

    public static DateTime getNow() {
        try {
            DateTime dateTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).plusMillis(offsetMilliseconds);
            return dateTime;
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    public static DateTime getNow(DateTimeZone dateTimeZone) {
        try {
            DateTime dateTime = DateTime.now((DateTimeZone)dateTimeZone).plusMillis(offsetMilliseconds);
            return dateTime;
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    public static DateTime getNormalizedToSeconds() {
        try {
            return StatsUtilsDateTime.getNormalizedToSeconds(StatsUtilsDateTime.getNow());
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    public static DateTime getNormalizedToSeconds(DateTime dateTime) {
        try {
            DateTime dateTime2 = new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), StatsUtilsDateTime.normalizeSeconds(dateTime), dateTime.getZone());
            return dateTime2;
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    public static DateTime getNormalizedToMinutes() {
        try {
            return StatsUtilsDateTime.getNormalizedToMinutes(StatsUtilsDateTime.getNow());
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    public static DateTime getNormalizedToMinutes(DateTime dateTime) {
        try {
            return new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), 0, dateTime.getZone());
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    public static DateTime getNormalizedToHours() {
        try {
            return StatsUtilsDateTime.getNormalizedToHours(StatsUtilsDateTime.getNow());
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    public static DateTime getNormalizedToHours(DateTime dateTime) {
        try {
            return new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), 0, 0, dateTime.getZone());
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    public static DateTime getNormalizedToDays() {
        try {
            return StatsUtilsDateTime.getNormalizedToDays(StatsUtilsDateTime.getNow());
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    public static DateTime getNormalizedToDays(DateTime dateTime) {
        try {
            return new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), 0, 0, 0, dateTime.getZone());
        }
        catch (StatsUtilsDateTime$Exception statsUtilsDateTime$Exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int normalizeSeconds(DateTime dateTime) {
        int n = dateTime.getSecondOfMinute();
        if (n == 0) return n;
        return n / 5 * 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int compare(DateTime dateTime, DateTime dateTime2) {
        int n = dateTime.getYear() - dateTime2.getYear();
        if (n == 0) {
            n += dateTime.getMonthOfYear() - dateTime2.getMonthOfYear();
        }
        if (n == 0) {
            n += dateTime.getDayOfMonth() - dateTime2.getDayOfMonth();
        }
        if (n == 0) {
            n += dateTime.getHourOfDay() - dateTime2.getHourOfDay();
        }
        if (n == 0) {
            n += dateTime.getMinuteOfHour() - dateTime2.getMinuteOfHour();
        }
        if (n != 0) return n;
        return n += dateTime.getSecondOfMinute() - dateTime2.getSecondOfMinute();
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public static int getHoursOffsetFromUTC() {
        int n;
        int n2;
        int n3 = -1;
        ++n3;
        String string = "0";
        switch (Integer.parseInt(string)) {
            default: {
                int n4;
                n3 += 6;
                n2 = n4 = 1;
                break;
            }
            case 0: {
                int n5;
                n2 = n5 = DateTimeZone.getDefault().getOffset((ReadableInstant)DateTime.now());
                n3 += 7;
                string = "10";
            }
        }
        switch (n3) {
            case 0: {
                n3 += 15;
                n = 0;
                return n2 / n / 60;
            }
        }
        n2 = n2 / 1000;
        n = 60;
        return n2 / n / 60;
    }
}

