/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.protocol.srt.socket;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.protocol.srt.SRTStatisticsMonitor$1;
import com.wowza.wms.protocol.srt.socket.SRTNativeAPI;
import com.wowza.wms.protocol.srt.socket.SRTNativeBooleanByReference;
import com.wowza.wms.protocol.srt.socket.SRTNativeBooleanByReference$1;
import com.wowza.wms.protocol.srt.socket.SRTNativeIntByReference;
import com.wowza.wms.protocol.srt.socket.SRTNativeLongByReference;
import com.wowza.wms.protocol.srt.socket.SRTNativeStringByReference;
import com.wowza.wms.protocol.srt.socket.SRTNativeTraceStats;
import com.wowza.wms.protocol.srt.socket.SRTSocketBase$ParseException;
import com.wowza.wms.protocol.srt.socket.SRTSocketSetting;
import java.nio.ByteBuffer;
import java.util.List;

public class SRTSocketBase {
    protected final int packetSize;
    protected final List<SRTSocketSetting> settings;
    protected SRTNativeAPI srtNativeAPI;
    protected long srtNativeSession;
    protected long srtSocketReference;
    protected final int localPort;
    protected final String localIpAddress;
    protected int remoteAddressPort;
    protected String remoteIpAddress;
    protected final String loggerContext;
    protected boolean debug;
    protected boolean bound;

    public SRTSocketBase(int n, String string, int n2, String string2, String string3, List<SRTSocketSetting> list, boolean bl) {
        this.debug = bl;
        this.loggerContext = string3;
        this.localPort = n2;
        this.localIpAddress = string2;
        this.remoteIpAddress = string;
        this.remoteAddressPort = n;
        this.settings = list;
        this.createNativeAPI(list);
        this.packetSize = this.getSocketSettingInt(49);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void createNativeAPI(List<SRTSocketSetting> list) {
        this.srtNativeAPI = new SRTNativeAPI();
        this.srtNativeSession = this.srtNativeAPI.createInstance();
        SRTNativeLongByReference sRTNativeLongByReference = new SRTNativeLongByReference();
        this.srtNativeAPI.srt_socket(this.srtNativeSession, 2, 2, 0, sRTNativeLongByReference);
        this.srtSocketReference = sRTNativeLongByReference.value;
        if (this.srtSocketReference > 0L && !list.isEmpty()) {
            this.srtNativeAPI.setSocketSettings(this.srtNativeSession, this.srtSocketReference, list);
        }
        if (!this.debug) return;
        this.srtNativeAPI.srt_setloglevel(7);
    }

    public SRTSocketBase(int n, String string, long l, SRTSocketBase sRTSocketBase) {
        this.debug = sRTSocketBase.debug;
        this.loggerContext = sRTSocketBase.loggerContext;
        this.localPort = sRTSocketBase.localPort;
        this.localIpAddress = sRTSocketBase.localIpAddress;
        this.srtNativeAPI = sRTSocketBase.srtNativeAPI;
        this.settings = sRTSocketBase.settings;
        this.packetSize = sRTSocketBase.packetSize;
        this.srtNativeSession = this.srtNativeAPI.createInstance();
        this.remoteIpAddress = string;
        this.remoteAddressPort = n;
        this.srtSocketReference = l;
    }

    public boolean isBound() {
        return this.bound;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean bind() {
        try {
            if (this.bound) {
                return true;
            }
            long l = this.srtNativeAPI.srt_bind(this.srtNativeSession, this.srtSocketReference, this.localIpAddress, this.localPort);
            if (l == 0L) {
                this.bound = true;
                return true;
            }
            int n = SRTStatisticsMonitor$1.substring();
            WMSLoggerFactory.getLogger(this.getClass()).info(this.getClass().getSimpleName() + SRTStatisticsMonitor$1.substring(n * 4 % n != 0 ? SRTStatisticsMonitor$1.substring("rqtt\"-\"#+'x*p'x{t!\"}\u007f|}~v|{|ckcfl1lg>:i", 52) : "x;358}8>)-71!e))hsj", -9 - 31) + this.localIpAddress + ":" + this.localPort);
            this.bound = false;
            return false;
        }
        catch (SRTSocketBase$ParseException sRTSocketBase$ParseException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void close(boolean bl) {
        long l = this.srtNativeAPI.srt_close(this.srtNativeSession, this.srtSocketReference);
        if (!this.debug) return;
        int n = SRTStatisticsMonitor$1.substring();
        int n2 = SRTStatisticsMonitor$1.substring();
        WMSLoggerFactory.getLogger(this.getClass()).info(this.getClass().getSimpleName() + SRTStatisticsMonitor$1.substring(n * 2 % n != 0 ? SRTStatisticsMonitor$1.substring("zu\u007f`~fi|g`{geh", 107) : "<'keexi-|jcd~g.5", 694 / 112) + l + SRTStatisticsMonitor$1.substring(n2 * 5 % n2 != 0 ? SRTStatisticsMonitor$1.substring("\ud878\ude4f", 101) : "nc", 10 - 40) + this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSocketState() {
        int n = 0;
        if (this.srtSocketReference <= 0L) return n;
        return (int)this.srtNativeAPI.srt_getsockstate(this.srtNativeSession, this.srtSocketReference);
    }

    public boolean getSocketSettingBoolean(int n) {
        try {
            SRTNativeBooleanByReference sRTNativeBooleanByReference = new SRTNativeBooleanByReference();
            this.srtNativeAPI.srt_getsockflag_boolean(this.srtNativeSession, this.srtSocketReference, n, sRTNativeBooleanByReference);
            return sRTNativeBooleanByReference.value;
        }
        catch (SRTSocketBase$ParseException sRTSocketBase$ParseException) {
            return false;
        }
    }

    public int getSocketSettingInt(int n) {
        try {
            SRTNativeIntByReference sRTNativeIntByReference = new SRTNativeIntByReference();
            this.srtNativeAPI.srt_getsockflag_int(this.srtNativeSession, this.srtSocketReference, n, sRTNativeIntByReference);
            return sRTNativeIntByReference.value;
        }
        catch (SRTSocketBase$ParseException sRTSocketBase$ParseException) {
            return 0;
        }
    }

    public long getSocketSettingLong(int n) {
        try {
            SRTNativeLongByReference sRTNativeLongByReference = new SRTNativeLongByReference();
            this.srtNativeAPI.srt_getsockflag_long(this.srtNativeSession, this.srtSocketReference, n, sRTNativeLongByReference);
            return sRTNativeLongByReference.value;
        }
        catch (SRTSocketBase$ParseException sRTSocketBase$ParseException) {
            return 0L;
        }
    }

    public String getSocketSettingString(int n) {
        try {
            SRTNativeStringByReference sRTNativeStringByReference = new SRTNativeStringByReference();
            this.srtNativeAPI.srt_getsockflag_string(this.srtNativeSession, this.srtSocketReference, n, sRTNativeStringByReference);
            return sRTNativeStringByReference.value;
        }
        catch (SRTSocketBase$ParseException sRTSocketBase$ParseException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean sendData(byte[] byArray, int n) {
        long l = this.srtNativeAPI.srt_send(this.srtNativeSession, this.srtSocketReference, byArray, 0, n);
        if (l >= 0L) return true;
        if (!this.debug) return false;
        int n2 = SRTNativeBooleanByReference$1.replace();
        int n3 = SRTNativeBooleanByReference$1.replace();
        WMSLoggerFactory.getLogger(this.getClass()).warn(this.getClass().getName() + SRTNativeBooleanByReference$1.replace(-45 - 4, n2 * 3 % n2 != 0 ? SRTStatisticsMonitor$1.substring("q'$&'~!y6~.z.mur!\"h\u007fp)-gz(+~)fdcaadd", 51) : "up\"7=0<80x=;/=}*0`2- / 2g.(#'))to") + l + SRTNativeBooleanByReference$1.replace(97 + -34, n3 * 2 % n3 == 0 ? "1`\u0012- / 2}h" : SRTNativeBooleanByReference$1.replace(24, ").(5.-0.46,;2")) + this);
        return false;
    }

    public SRTNativeTraceStats getStats() {
        try {
            return this.getStats(false);
        }
        catch (SRTSocketBase$ParseException sRTSocketBase$ParseException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public SRTNativeTraceStats getStats(boolean bl) {
        SRTNativeTraceStats sRTNativeTraceStats = new SRTNativeTraceStats();
        this.srtNativeAPI.srt_bistats(this.srtNativeSession, this.srtSocketReference, sRTNativeTraceStats, 0, bl ? 1 : 0);
        return sRTNativeTraceStats;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasData() {
        try {
            if (this.getSocketSettingInt(20) <= 0) return false;
            return true;
        }
        catch (SRTSocketBase$ParseException sRTSocketBase$ParseException) {
            return false;
        }
    }

    public ByteBuffer getData() {
        try {
            byte[] byArray = new byte[this.packetSize];
            int n = this.srtNativeAPI.srt_recv(this.srtNativeSession, this.srtSocketReference, byArray, this.packetSize);
            if (n <= 0) {
                return null;
            }
            return ByteBuffer.wrap(byArray, 0, n);
        }
        catch (SRTSocketBase$ParseException sRTSocketBase$ParseException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        if (this.getSocketState() != 5) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string;
        String string2 = this.getClass().getName();
        int n = SRTStatisticsMonitor$1.substring();
        String string3 = SRTStatisticsMonitor$1.substring(n * 2 % n == 0 ? "$^tbef~nE}Oktcw`g(" : SRTNativeBooleanByReference$1.replace(105, "{y~{|\u007f~c`ebm"), 561 / 120);
        int n2 = SRTStatisticsMonitor$1.substring();
        String string4 = SRTStatisticsMonitor$1.substring(n2 * 2 % n2 == 0 ? ";8k\u007fvsi{^depfwvVhz}7" : SRTNativeBooleanByReference$1.replace(65, "\ud87c\udf49"), 31 * 9);
        int n3 = SRTStatisticsMonitor$1.substring();
        String string5 = SRTStatisticsMonitor$1.substring(n3 * 5 % n3 != 0 ? SRTStatisticsMonitor$1.substring("\ud83a\udebb", 7) : "la.,'$*\u0017';>v", 50 - -14);
        int n4 = SRTStatisticsMonitor$1.substring();
        String string6 = SRTStatisticsMonitor$1.substring(n4 * 4 % n4 != 0 ? SRTNativeBooleanByReference$1.replace(74, "\t$! +o%?r?=\u0096\u00fe!*<z(=3-\u007f/2b21,f#';>k(, <p$<s$4%#\u009b\u00f0") : ")&wijanx^guu,", 1 - -4);
        int n5 = SRTStatisticsMonitor$1.substring();
        String string7 = SRTStatisticsMonitor$1.substring(n5 * 2 % n5 == 0 ? "if4:=\u0004*8$8*\u00034! =:8j" : SRTStatisticsMonitor$1.substring("\ud83c\udf24", 1), 62 - -7);
        int n6 = SRTStatisticsMonitor$1.substring();
        String string8 = SRTStatisticsMonitor$1.substring(n6 * 5 % n6 == 0 ? " -}}dB}p\u007fpbE}\u007f\u007fiys}z=" : SRTNativeBooleanByReference$1.replace(55, ".z,y/z{|2\"#&wiqpp}d+|xtc*i2fg0le5>=h"), 85 + 55);
        int n7 = SRTStatisticsMonitor$1.substring();
        String string9 = SRTStatisticsMonitor$1.substring(n7 * 5 % n7 == 0 ? "mb0!65.''\t$\"9+7$l" : SRTStatisticsMonitor$1.substring("\u0016.-", 70), 126 + 67);
        int n8 = SRTStatisticsMonitor$1.substring();
        if (n8 * 2 % n8 == 0) {
            string = "if%'<$/q";
            return string2 + string3 + this.remoteIpAddress + string4 + this.remoteAddressPort + string5 + this.localPort + string6 + this.packetSize + string7 + this.srtNativeSession + string8 + this.srtSocketReference + string9 + this.loggerContext + SRTStatisticsMonitor$1.substring(string, 25 * 45) + this.bound + "]";
        }
        string = SRTNativeBooleanByReference$1.replace(108, "}}`}ci|`l{gbo");
        return string2 + string3 + this.remoteIpAddress + string4 + this.remoteAddressPort + string5 + this.localPort + string6 + this.packetSize + string7 + this.srtNativeSession + string8 + this.srtSocketReference + string9 + this.loggerContext + SRTStatisticsMonitor$1.substring(string, 25 * 45) + this.bound + "]";
    }
}

