/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.protocol.srt;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.protocol.srt.SRTInternalNotifier;
import com.wowza.wms.protocol.srt.SRTSessionBase$ArrayOutOfBoundsException;
import com.wowza.wms.protocol.srt.SRTSessionIO;
import com.wowza.wms.protocol.srt.SRTStatisticsMonitor;
import com.wowza.wms.protocol.srt.model.SRTContext;
import com.wowza.wms.protocol.srt.socket.SRTNativeBooleanByReference$1;
import com.wowza.wms.protocol.srt.socket.SRTNativeTraceStats;
import com.wowza.wms.protocol.srt.socket.SRTSocketBase;
import com.wowza.wms.protocol.srt.socket.SRTSocketFactory;
import jakarta.validation.constraints.NotNull;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SRTSessionBase
implements SRTSessionIO {
    public static SRTSocketFactory socketFactory;
    protected final SRTContext srtContext;
    protected final SRTInternalNotifier socketNotifier;
    protected final AtomicBoolean hasStarted = new AtomicBoolean(false);
    protected final ReentrantLock closeLock = new ReentrantLock();
    protected long reconnectWaitTime;
    protected SRTSocketBase srtSocket;
    protected volatile boolean isClosed = false;
    protected SRTStatisticsMonitor statsMonitor;
    protected long lastRead = System.currentTimeMillis();
    protected volatile boolean doReconnect = true;
    protected int timesToPrintStats;
    protected String loggerContext;
    protected boolean debug;

    public SRTSessionBase(@NotNull SRTContext sRTContext, long l, @NotNull SRTInternalNotifier sRTInternalNotifier, String string, boolean bl) {
        this.debug = bl;
        this.srtContext = sRTContext;
        this.socketNotifier = sRTInternalNotifier;
        this.reconnectWaitTime = l;
        this.timesToPrintStats = sRTContext.getTimesToPrintStats();
        this.loggerContext = string;
        SRTSessionBase sRTSessionBase = this;
        this.statsMonitor = new SRTStatisticsMonitor(sRTSessionBase, sRTSessionBase.timesToPrintStats);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isConnected() {
        try {
            if (this.getDataSocket() == null) return false;
            if (this.getDataSocket().isConnected()) return true;
            return false;
        }
        catch (SRTSessionBase$ArrayOutOfBoundsException sRTSessionBase$ArrayOutOfBoundsException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void disconnect() {
        block2: {
            block3: {
                block1: {
                    if (this.isClosed) break block1;
                    this.isClosed = true;
                    if (this.srtSocket == null) break block2;
                    break block3;
                }
                return;
            }
            this.srtSocket.close(true);
            this.srtSocket = null;
        }
        this.statsMonitor.quit();
        this.socketNotifier.onDisconnect(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasData() {
        try {
            SRTSocketBase sRTSocketBase = this.getDataSocket();
            if (sRTSocketBase == null) return false;
            if (sRTSocketBase.hasData()) return true;
            return false;
        }
        catch (SRTSessionBase$ArrayOutOfBoundsException sRTSessionBase$ArrayOutOfBoundsException) {
            return false;
        }
    }

    @Override
    public ByteBuffer getData() {
        try {
            SRTSocketBase sRTSocketBase = this.getDataSocket();
            return sRTSocketBase != null ? sRTSocketBase.getData() : null;
        }
        catch (SRTSessionBase$ArrayOutOfBoundsException sRTSessionBase$ArrayOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public SRTNativeTraceStats getSRTStatistics() {
        try {
            return this.getSRTStatistics(false);
        }
        catch (SRTSessionBase$ArrayOutOfBoundsException sRTSessionBase$ArrayOutOfBoundsException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SRTNativeTraceStats getSRTStatistics(boolean bl) {
        SRTSocketBase sRTSocketBase = this.getDataSocket();
        if (sRTSocketBase == null) {
            return null;
        }
        SRTNativeTraceStats sRTNativeTraceStats = sRTSocketBase.getStats(bl);
        return sRTNativeTraceStats;
    }

    @Override
    public void printSRTStatistics() {
        try {
            int n = SRTNativeBooleanByReference$1.replace();
            WMSLoggerFactory.getLogger(this.getClass()).info(this.srtContext.getLoggingContext() + " " + this.getDataSocket().getStats() + SRTNativeBooleanByReference$1.replace(94 + 39, n * 3 % n != 0 ? SRTNativeBooleanByReference$1.replace(9, "Lxyc\u007f") : "%Usi}o6") + this.getDataSocket().getSocketState());
            return;
        }
        catch (SRTSessionBase$ArrayOutOfBoundsException sRTSessionBase$ArrayOutOfBoundsException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getSocketState() {
        SRTSocketBase sRTSocketBase = this.getDataSocket();
        if (sRTSocketBase == null) {
            return 0;
        }
        int n = sRTSocketBase.getSocketState();
        return n;
    }

    @Override
    public String getRemoteIpAddress() {
        try {
            return this.srtContext.getRemoteIPAddress();
        }
        catch (SRTSessionBase$ArrayOutOfBoundsException sRTSessionBase$ArrayOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public int getRemoteAddressPort() {
        try {
            return this.srtContext.getRemotePort();
        }
        catch (SRTSessionBase$ArrayOutOfBoundsException sRTSessionBase$ArrayOutOfBoundsException) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void sendData(byte[] byArray, int n) {
        SRTSocketBase sRTSocketBase = this.getDataSocket();
        boolean bl = sRTSocketBase != null && sRTSocketBase.sendData(byArray, n);
        if (bl) return;
        int n2 = this.getSocketState();
        if (n2 <= 5) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = bl2;
        if (bl3) return;
        this.socketNotifier.onDataWriteFailure(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readAvailableBlocks() {
        if (this.attemptConnect() == false) return;
        var1_1 = this.hasData();
        while (true) {
            block9: {
                block8: {
                    block7: {
                        if (!this.doReconnect && var1_1 && (var2_2 = this.getData()) != null) break block9;
                        this.closeLock.lock();
                        try {
                            if (this.getSocketState() <= 5) ** GOTO lbl-1000
                            this.socketNotifier.onDataReadTimeout(this, 0L);
                            break block7;
lbl-1000:
                            // 1 sources

                            {
                                var2_3 = System.currentTimeMillis() - this.lastRead;
                                if (var2_3 <= this.getDataTimeout()) break block7;
                                v0 = this;
                            }
                        }
lbl14:
                        // 3 sources

                        catch (Throwable var4_4) {
                            break block8;
                        }
                        {
                            ** try [egrp 3[TRYBLOCK] [3 : 87->106)] { 
lbl17:
                            // 1 sources

                            v0.socketNotifier.onDataReadTimeout(this, var2_3);
                        }
                    }
                    this.closeLock.unlock();
                    return;
                }
                this.closeLock.unlock();
                throw var4_4;
            }
            this.lastRead = System.currentTimeMillis();
            this.socketNotifier.onDataRead(this, var2_2);
            var1_1 = this.hasData();
        }
    }

    protected abstract long getDataTimeout();

    protected SRTSocketBase getConnectionSocket() {
        return this.srtSocket;
    }

    protected SRTSocketBase getDataSocket() {
        return this.srtSocket;
    }

    static {
        try {
            socketFactory = new SRTSocketFactory();
        }
        catch (SRTSessionBase$ArrayOutOfBoundsException sRTSessionBase$ArrayOutOfBoundsException) {}
    }
}

