/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.protocol.srt;

import com.wowza.wms.protocol.srt.SRTCallerSession$IOException;
import com.wowza.wms.protocol.srt.SRTInternalNotifier;
import com.wowza.wms.protocol.srt.SRTReconnector;
import com.wowza.wms.protocol.srt.SRTSessionBase;
import com.wowza.wms.protocol.srt.SRTStatisticsMonitor;
import com.wowza.wms.protocol.srt.model.SRTContext;
import com.wowza.wms.protocol.srt.socket.SRTCallerSocket;
import com.wowza.wms.pushpublish.protocol.srt.SRTDataSource;
import jakarta.validation.constraints.NotNull;

public class SRTCallerSession
extends SRTSessionBase {
    private SRTReconnector a;
    private SRTDataSource b;

    public SRTCallerSession(@NotNull SRTContext sRTContext, long l, @NotNull SRTInternalNotifier sRTInternalNotifier, String string, boolean bl) {
        super(sRTContext, l, sRTInternalNotifier, string, bl);
        this.a = new SRTReconnector(this, l);
        this.srtSocket = new SRTCallerSocket(this.srtContext.getRemotePort(), this.srtContext.getRemoteIPAddress(), this.srtContext.getLocalPort(), this.srtContext.getLoggingContext(), this.srtContext.getSRTSocketSettings(), this.debug);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connect(@NotNull SRTDataSource sRTDataSource) {
        try {
            if (!this.hasStarted.compareAndSet(false, true)) {
                this.a.resetWaitTime();
                return;
            }
            this.b = sRTDataSource;
            this.a.start();
            return;
        }
        catch (SRTCallerSession$IOException sRTCallerSession$IOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() {
        this.closeLock.lock();
        try {
            if (!this.isClosed) {
                if (this.b != null) {
                    this.b.destroyInputStream();
                }
                this.a.quit();
            }
        }
        catch (Throwable throwable) {
            this.closeLock.unlock();
            throw throwable;
        }
        super.disconnect();
        this.closeLock.unlock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean attemptConnect() {
        boolean bl = false;
        this.closeLock.lock();
        try {
            if (this.isClosed) {
                boolean bl2 = false;
                return bl2;
            }
            this.socketNotifier.onConnectStart(this);
            this.srtSocket.bind();
            if (!((SRTCallerSocket)this.srtSocket).connect()) {
                this.socketNotifier.onConnectFailure(this);
                boolean bl3 = false;
                this.closeLock.unlock();
                return bl3;
            }
            bl = this.b.createInputStream();
        }
        finally {
            this.closeLock.unlock();
        }
        if (!bl) {
            this.socketNotifier.onConnectFailure(this);
            return false;
        }
        this.socketNotifier.onConnectSuccess(this);
        this.statsMonitor.start();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendData(byte[] byArray, int n) {
        try {
            boolean bl = this.srtSocket.sendData(byArray, n);
            if (bl) return;
            int n2 = this.srtSocket.getSocketState();
            if (n2 <= 5) return;
            boolean bl2 = false;
            boolean bl3 = bl2;
            if (bl3) return;
            this.a();
            return;
        }
        catch (SRTCallerSession$IOException sRTCallerSession$IOException) {
            return;
        }
    }

    @Override
    protected long getDataTimeout() {
        return Long.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void a() {
        boolean bl = this.closeLock.tryLock();
        if (!bl) return;
        try {
            if (this.isClosed) {
                return;
            }
            this.b.destroyInputStream();
            this.srtSocket.close(true);
            this.srtSocket = new SRTCallerSocket(this.srtContext.getRemotePort(), this.srtContext.getRemoteIPAddress(), this.srtContext.getLocalPort(), this.srtContext.getLoggingContext(), this.srtContext.getSRTSocketSettings(), this.debug);
            SRTCallerSession sRTCallerSession = this;
            this.a = new SRTReconnector(sRTCallerSession, sRTCallerSession.reconnectWaitTime);
            this.a.start();
            this.statsMonitor.quit();
            SRTCallerSession sRTCallerSession2 = this;
            this.statsMonitor = new SRTStatisticsMonitor(sRTCallerSession2, sRTCallerSession2.timesToPrintStats);
            return;
        }
        finally {
            this.closeLock.unlock();
            return;
        }
    }
}

