/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacasters;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.server.mediacasters.MediaCasterConfig;
import com.wowza.wms.rest.server.mediacasters.MediaCastersConfig$ParseException;
import java.util.Collections;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
@JacksonXmlRootElement(localName="MediaCasters")
@WMSDescription(text="Server MediaCasters", get="Retrieves the list of MediaCasters")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacasters", restVerbs="GET", xmlFilename="MediaCasters.xml", releaseBuild=15089L)
public class MediaCastersConfig
extends ConfigBase {
    @JsonProperty(value="mediaCasters")
    @JacksonXmlProperty(localName="MediaCaster")
    @JacksonXmlElementWrapper(useWrapping=false)
    @WMSXMLList(xpath="/Root/MediaCasters", keyxpath="/MediaCaster/Name", keyName="mediacastername")
    protected List<MediaCasterConfig> mediaCastersList;

    public MediaCastersConfig() {
        this.useLocalResourceIfAvailable = true;
    }

    public List<MediaCasterConfig> getMediaCastersList() {
        return this.mediaCastersList;
    }

    @Override
    protected boolean exists() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        boolean bl = super.loadObject();
        if (this.mediaCastersList == null) {
            return bl;
        }
        Collections.sort(this.mediaCastersList);
        return bl;
    }

    public static MediaCastersConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        try {
            return (MediaCastersConfig)MediaCastersConfig.getObjectFromREST(MediaCastersConfig.getUrl(MediaCastersConfig.class), MediaCastersConfig.class, wMSClientSecurity);
        }
        catch (MediaCastersConfig$ParseException mediaCastersConfig$ParseException) {
            return null;
        }
    }
}

