/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.mediacache;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.server.mediacache.MediaCacheConfig;
import com.wowza.wms.rest.server.mediacache.MediaCacheSourceConfig;
import com.wowza.wms.rest.server.mediacache.MediaCacheSourcesConfig$NullPointerException;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
@JacksonXmlRootElement(localName="MediaCacheSources")
@WMSDescription(text="MediaCache Sources", get="Retrieves the list of MediaCache Sources", post="Adds the specified MediaCache Source to the list", postModel="MediaCacheSourceConfig")
@WMSConfig(restLocation="/v2/servers/{serverName}/mediacache/sources", restVerbs="GET,POST", xmlFilename="MediaCache.xml", releaseBuild=15089L)
public class MediaCacheSourcesConfig
extends ConfigBase {
    @JsonProperty(value="sources")
    @JacksonXmlProperty(localName="Sources")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<ShortObject> h = new ArrayList<ShortObject>();

    public List<ShortObject> getSources() {
        return this.h;
    }

    public void setSources(List<ShortObject> list) {
        try {
            this.h = list;
            return;
        }
        catch (MediaCacheSourcesConfig$NullPointerException mediaCacheSourcesConfig$NullPointerException) {
            return;
        }
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        try {
            boolean bl = super.isValid(constraintValidatorContext);
            return bl;
        }
        catch (MediaCacheSourcesConfig$NullPointerException mediaCacheSourcesConfig$NullPointerException) {
            return false;
        }
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        List<ShortObject> list;
        MediaCacheConfig mediaCacheConfig;
        int n = -1;
        ++n;
        String string = "0";
        switch (Integer.parseInt(string)) {
            case 0: {
                mediaCacheConfig = new MediaCacheConfig();
                boolean bl = mediaCacheConfig.loadObject();
                n += 5;
                string = "42";
                break;
            }
            default: {
                n += 7;
                boolean bl = false;
                mediaCacheConfig = null;
            }
        }
        switch (n) {
            default: {
                list = this.h;
                n = 0;
                string = "0";
                break;
            }
            case 0: {
                n += 6;
                list = null;
            }
        }
        list.clear();
        Iterator<MediaCacheSourceConfig> iterator = mediaCacheConfig.mediaCacheSources.iterator();
        while (iterator.hasNext()) {
            ConfigBase configBase;
            MediaCacheSourceConfig mediaCacheSourceConfig;
            n = -1;
            ++n;
            string = "0";
            switch (Integer.parseInt(string)) {
                case 0: {
                    mediaCacheSourceConfig = iterator.next();
                    configBase = this;
                    n += 3;
                    string = "42";
                    break;
                }
                default: {
                    n += 8;
                    mediaCacheSourceConfig = null;
                    configBase = mediaCacheSourceConfig;
                }
            }
            configBase.h.add(new ShortObject(mediaCacheSourceConfig.name, this.getUrl() + "/" + mediaCacheSourceConfig.name));
        }
        return true;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @Override
    public Representation post(Representation representation) {
        Status status;
        MediaCacheSourcesConfig mediaCacheSourcesConfig;
        Representation representation2;
        Object object;
        MediaCacheSourceConfig mediaCacheSourceConfig;
        int n = -1;
        ++n;
        String string = "0";
        switch (Integer.parseInt(string)) {
            case 0: {
                mediaCacheSourceConfig = new MediaCacheSourceConfig();
                object = mediaCacheSourceConfig.post(representation, this.getRequest());
                n += 15;
                string = "38";
                break;
            }
            default: {
                n += 13;
                mediaCacheSourceConfig = null;
                object = mediaCacheSourceConfig;
            }
        }
        switch (n) {
            default: {
                representation2 = object;
                mediaCacheSourcesConfig = this;
                status = mediaCacheSourceConfig.getStatus();
                n = 0;
                string = "0";
                break;
            }
            case 0: {
                n += 15;
                mediaCacheSourcesConfig = null;
                representation2 = null;
                status = representation2;
            }
        }
        mediaCacheSourcesConfig.setStatus(status);
        if (mediaCacheSourceConfig.currentException == null) return representation2;
        this.getResponse().setEntity(mediaCacheSourceConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static MediaCacheSourcesConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        try {
            return (MediaCacheSourcesConfig)MediaCacheSourcesConfig.getObjectFromREST(MediaCacheSourcesConfig.getUrl(MediaCacheSourcesConfig.class), MediaCacheSourcesConfig.class, wMSClientSecurity);
        }
        catch (MediaCacheSourcesConfig$NullPointerException mediaCacheSourcesConfig$NullPointerException) {
            return null;
        }
    }
}

