/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.server.listeners;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.server.listeners.ServerListenerConfig;
import com.wowza.wms.rest.server.listeners.ServerListenersConfig$ParseException;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
@JacksonXmlRootElement(localName="ServerListeners")
@JsonSerialize
@WMSDescription(text="Server Listeners", get="Retrieves the list of server Listeners", put="Updates the server Listeners list")
@WMSConfig(restLocation="/v2/servers/{serverName}/listeners", restVerbs="GET,PUT", xmlFilename="Server.xml", releaseBuild=15089L)
public class ServerListenersConfig
extends ConfigBase {
    @JsonProperty(value="serverListeners")
    @JacksonXmlProperty(localName="ServerListener")
    @JacksonXmlElementWrapper(useWrapping=false)
    @WMSXMLList(xpath="/Root/Server/ServerListeners", keyxpath="/ServerListener/BaseClass", keyName="baseclass")
    protected List<ServerListenerConfig> listenersList = new ArrayList<ServerListenerConfig>();

    public List<ServerListenerConfig> getListenersList() {
        return this.listenersList;
    }

    public void setListenersList(List<ServerListenerConfig> list) {
        try {
            this.listenersList = list;
            return;
        }
        catch (ServerListenersConfig$ParseException serverListenersConfig$ParseException) {
            return;
        }
    }

    public boolean contains(ServerListenerConfig serverListenerConfig) {
        try {
            return this.listenersList.contains(serverListenerConfig);
        }
        catch (ServerListenersConfig$ParseException serverListenersConfig$ParseException) {
            return false;
        }
    }

    public boolean remove(ServerListenerConfig serverListenerConfig) {
        try {
            return this.listenersList.remove(serverListenerConfig);
        }
        catch (ServerListenersConfig$ParseException serverListenersConfig$ParseException) {
            return false;
        }
    }

    public boolean add(ServerListenerConfig serverListenerConfig) {
        try {
            if (!this.listenersList.contains(serverListenerConfig)) {
                return this.listenersList.add(serverListenerConfig);
            }
            return true;
        }
        catch (ServerListenersConfig$ParseException serverListenersConfig$ParseException) {
            return false;
        }
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        try {
            boolean bl = super.isValid(constraintValidatorContext);
            return bl;
        }
        catch (ServerListenersConfig$ParseException serverListenersConfig$ParseException) {
            return false;
        }
    }

    @Override
    public boolean hasWarnings() {
        try {
            boolean bl = super.hasWarnings();
            return bl;
        }
        catch (ServerListenersConfig$ParseException serverListenersConfig$ParseException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        int n;
        boolean bl;
        int n2 = -1;
        ++n2;
        String string = "0";
        switch (Integer.parseInt(string)) {
            default: {
                n2 += 8;
                bl = true;
                n = 1;
                break;
            }
            case 0: {
                bl = super.loadObject();
                n = 0;
                n2 += 15;
                string = "20";
            }
        }
        Iterator<ServerListenerConfig> iterator = this.listenersList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                Collections.sort(this.listenersList);
                return bl;
            }
            ServerListenerConfig serverListenerConfig = iterator.next();
            serverListenerConfig.setOrder(n++);
        }
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        try {
            Collections.sort(this.listenersList);
            return super.saveObject();
        }
        catch (ServerListenersConfig$ParseException serverListenersConfig$ParseException) {
            return null;
        }
    }

    public static ServerListenersConfig getObjectFromREST(WMSClientSecurity wMSClientSecurity) {
        try {
            return (ServerListenersConfig)ServerListenersConfig.getObjectFromREST(ServerListenersConfig.getUrl(ServerListenersConfig.class), ServerListenersConfig.class, wMSClientSecurity);
        }
        catch (ServerListenersConfig$ParseException serverListenersConfig$ParseException) {
            return null;
        }
    }
}

