/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.wms.mediareader.h264.H264Cursor$ArrayOutOfBoundsException;
import com.wowza.wms.mediareader.h264.H264CursorPosition;
import com.wowza.wms.mediareader.h264.atom.IQTMediaCursor;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTMediaCursor;

public class H264Cursor {
    protected QTAtomtrak videoTrackAtom = null;
    protected QTAtomtrak audioTrackAtom = null;
    protected QTAtomtrak dataTrackAtom = null;
    protected IQTMediaCursor dCursor = null;
    protected boolean dAtEnd = false;
    protected IQTMediaCursor vCursor = null;
    protected boolean vAtEnd = false;
    protected IQTMediaCursor aCursor = null;
    protected boolean aAtEnd = false;
    protected int cursorType = 0;

    public H264Cursor(QTAtomtrak qTAtomtrak, QTAtomtrak qTAtomtrak2, QTAtomtrak qTAtomtrak3) {
        this.videoTrackAtom = qTAtomtrak;
        this.audioTrackAtom = qTAtomtrak2;
        this.dataTrackAtom = qTAtomtrak3;
        this.a();
    }

    public H264Cursor(QTAtomtrak qTAtomtrak, QTAtomtrak qTAtomtrak2, QTAtomtrak qTAtomtrak3, int n) {
        this.videoTrackAtom = qTAtomtrak;
        this.audioTrackAtom = qTAtomtrak2;
        this.dataTrackAtom = qTAtomtrak3;
        this.a();
    }

    private void a() {
        try {
            this.initDataCursor();
            this.initVideoCursor();
            this.initAudioCursor();
            return;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initAudioCursor() {
        IQTMediaCursor iQTMediaCursor = this.aCursor = this.audioTrackAtom == null ? null : new QTMediaCursor(this.audioTrackAtom);
        if (this.aCursor != null) {
            this.aCursor.setCursorType(this.cursorType);
        }
        if (this.aCursor != null) return;
        this.aAtEnd = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initVideoCursor() {
        IQTMediaCursor iQTMediaCursor = this.vCursor = this.videoTrackAtom == null ? null : new QTMediaCursor(this.videoTrackAtom);
        if (this.vCursor != null) {
            this.vCursor.setCursorType(this.cursorType);
        }
        if (this.vCursor == null) {
            this.vAtEnd = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initDataCursor() {
        IQTMediaCursor iQTMediaCursor = this.dCursor = this.dataTrackAtom == null ? null : new QTMediaCursor(this.dataTrackAtom);
        if (this.dCursor != null) {
            this.dCursor.setCursorType(this.cursorType);
        }
        if (this.dCursor != null) return;
        this.dAtEnd = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsAudio() {
        try {
            if (this.audioTrackAtom == null) return false;
            return true;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsVideo() {
        if (this.videoTrackAtom == null) return false;
        return true;
    }

    public boolean containsData() {
        try {
            return this.dataTrackAtom != null;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void close() {
        if (this.dCursor != null) {
            this.dCursor.close();
        }
        this.dCursor = null;
        if (this.vCursor != null) {
            this.vCursor.close();
        }
        this.vCursor = null;
        if (this.aCursor != null) {
            this.aCursor.close();
        }
        this.aCursor = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final IQTMediaCursor b() {
        try {
            IQTMediaCursor iQTMediaCursor = null;
            if (this.vAtEnd && this.aAtEnd && this.dAtEnd) {
                return null;
            }
            switch (this.getCurrentType()) {
                case 9: {
                    return this.vCursor;
                }
                case 8: {
                    return this.aCursor;
                }
                case 18: {
                    return this.dCursor;
                }
            }
            return iQTMediaCursor;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getCurrentType() {
        int n;
        block9: {
            block7: {
                block8: {
                    block6: {
                        long l;
                        n = 0;
                        if (this.vAtEnd && this.aAtEnd) {
                            if (this.dAtEnd) return n;
                        }
                        long l2 = this.vAtEnd || this.vCursor == null ? Long.MAX_VALUE : this.vCursor.getTimeMillis();
                        long l3 = l = !this.aAtEnd && this.aCursor != null ? this.aCursor.getTimeMillis() : Long.MAX_VALUE;
                        long l4 = !this.dAtEnd && this.dCursor != null ? this.dCursor.getTimeMillis() : Long.MAX_VALUE;
                        if (l2 <= l4 && l2 <= l) break block6;
                        if (l > l4 || l > l2) break block7;
                        break block8;
                    }
                    n = 9;
                    break block9;
                }
                n = 8;
                break block9;
            }
            n = 18;
        }
        IQTMediaCursor iQTMediaCursor = null;
        switch (n) {
            case 18: {
                iQTMediaCursor = this.dCursor;
                break;
            }
            case 8: {
                iQTMediaCursor = this.aCursor;
                break;
            }
            case 9: {
                iQTMediaCursor = this.vCursor;
                break;
            }
        }
        if (iQTMediaCursor != null) return n;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAtEnd() {
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (!this.dAtEnd) return false;
        return true;
    }

    public boolean isAtAudioEnd() {
        return this.aAtEnd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAtVideoEnd() {
        try {
            if (!this.vAtEnd) return false;
            if (!this.aAtEnd) return false;
            return true;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return false;
        }
    }

    public boolean isAtDataEnd() {
        return this.dAtEnd;
    }

    public long getTimeMillis() {
        try {
            return this.b().getTimeMillis();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getTimeSL() {
        try {
            return this.b().getTimeSL();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getTimeScaled(int n) {
        try {
            return this.b().getTimeScaled(n);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getAudioTimescale() {
        try {
            if (this.aCursor == null) {
                return 0L;
            }
            return this.aCursor.getTimescale();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getDataTimescale() {
        try {
            if (this.dCursor == null) {
                return 0L;
            }
            return this.dCursor.getTimescale();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getVideoTimescale() {
        try {
            if (this.vCursor == null) {
                return 0L;
            }
            return this.vCursor.getTimescale();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public double getSeekPoint() {
        try {
            return this.b().getSeekPoint();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0.0;
        }
    }

    public int getCTTS() {
        try {
            return this.b().getCTTS();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0;
        }
    }

    public int getCTTSMillis() {
        try {
            return this.b().getCTTSMillis();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0;
        }
    }

    public long getFileLoc() {
        try {
            return this.b().getFileLoc();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getSample() {
        try {
            return this.b().getSample();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getSampleDesc() {
        try {
            return this.b().getSampleDesc();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public boolean getAudioSampleValid(long l) {
        try {
            if (this.aCursor == null) {
                return false;
            }
            return this.aCursor.isSampleValid(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return false;
        }
    }

    public boolean getDataSampleValid(long l) {
        try {
            if (this.dCursor == null) {
                return false;
            }
            return this.dCursor.isSampleValid(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return false;
        }
    }

    public boolean getVideoSampleValid(long l) {
        try {
            if (this.vCursor == null) {
                return false;
            }
            return this.vCursor.isSampleValid(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return false;
        }
    }

    public long getAudioSample() {
        try {
            return this.aCursor != null ? this.aCursor.getSample() : -1L;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAudioSample(long l) {
        if (this.aCursor == null) return;
        if (l < 0L) return;
        boolean bl = this.aCursor.moveToSample(l);
        if (!bl) return;
        this.aAtEnd = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDataSample(long l) {
        if (this.dCursor == null) return;
        if (l < 0L) return;
        boolean bl = this.dCursor.moveToSample(l);
        if (!bl) return;
        this.dAtEnd = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDataAtEnd() {
        try {
            if (this.dCursor == null) return;
            if (this.dCursor.getSampleCount() > 0L) {
                IQTMediaCursor iQTMediaCursor = this.dCursor;
                iQTMediaCursor.moveToSample(iQTMediaCursor.getSampleCount() - 1L);
            }
            this.dAtEnd = true;
            return;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return;
        }
    }

    public void setVideoSample(long l) {
        try {
            if (this.vCursor != null) {
                if (l >= 0L) {
                    boolean bl = this.vCursor.moveToSample(l);
                    if (bl) {
                        this.vAtEnd = false;
                    }
                }
            }
            return;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getDataSample() {
        if (this.dCursor == null) {
            return -1L;
        }
        long l = this.dCursor.getSample();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getVideoSample() {
        try {
            if (this.vCursor == null) return -1L;
            long l = this.vCursor.getSample();
            return l;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public boolean isKeyFrame() {
        try {
            return this.b().isKeyFrame();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return false;
        }
    }

    public long getSize() {
        try {
            return this.b().getSize();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long dataGetTotalTrackSize() {
        try {
            if (this.dCursor == null) {
                return 0L;
            }
            return this.dCursor.getTotalTrackSize();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public int videoGetTrackBitrate(long l) {
        try {
            if (this.vCursor == null) {
                return 0;
            }
            return this.vCursor.getTrackBiterate(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0;
        }
    }

    public int audioGetTrackBitrate(long l) {
        try {
            if (this.aCursor == null) {
                return 0;
            }
            return this.aCursor.getTrackBiterate(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0;
        }
    }

    public long videoGetTotalTrackSize() {
        try {
            if (this.vCursor == null) {
                return 0L;
            }
            return this.vCursor.getTotalTrackSize();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long[] getTotalTrackSizeAndPeakSize(int n) {
        try {
            if (this.vCursor == null) {
                return null;
            }
            return this.vCursor.getTotalTrackSizeAndPeakSize(n);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return null;
        }
    }

    public long audioGetTotalTrackSize() {
        try {
            if (this.aCursor == null) {
                return 0L;
            }
            return this.aCursor.getTotalTrackSize();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long dataFindKeySample(long l, int n) {
        try {
            if (this.dCursor == null) {
                return -1L;
            }
            return this.dCursor.findKeySample(l, n);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long videoFindKeySample(long l, int n) {
        try {
            if (this.vCursor == null) {
                return -1L;
            }
            return this.vCursor.findKeySample(l, n);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long dataTimecodeToSample(long l) {
        try {
            if (this.dCursor == null) {
                return -1L;
            }
            return this.dCursor.timecodeToSample(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long videoTimecodeToSample(long l) {
        try {
            if (this.vCursor == null) {
                return -1L;
            }
            return this.vCursor.timecodeToSample(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long dataSampleToTimecode(long l) {
        try {
            if (this.dCursor == null) {
                return -1L;
            }
            return this.dCursor.sampleToTimecode(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long videoSampleToTimecode(long l) {
        try {
            if (this.vCursor == null) {
                return -1L;
            }
            return this.vCursor.sampleToTimecode(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long videoSampleToCTTS(long l) {
        try {
            if (this.vCursor == null) {
                return -1L;
            }
            return this.vCursor.sampleToCTTS(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long dataTimeMillisToTimecode(long l) {
        try {
            if (this.dCursor == null) {
                return 0L;
            }
            return this.dCursor.timeMillisToTimecode(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long videoTimeMillisToTimecode(long l) {
        try {
            if (this.vCursor == null) {
                return 0L;
            }
            return this.vCursor.timeMillisToTimecode(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long dataTimecodeToTimeMillis(long l) {
        try {
            if (this.dCursor == null) {
                return 0L;
            }
            return this.dCursor.timecodeToTimeMillis(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long videoTimecodeToTimeMillis(long l) {
        try {
            if (this.vCursor == null) {
                return 0L;
            }
            return this.vCursor.timecodeToTimeMillis(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long dataTimecodeToTimeSL(long l) {
        try {
            if (this.dCursor == null) {
                return 0L;
            }
            return this.dCursor.timecodeToTimeSL(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long dataTimecodeToTimeSL() {
        try {
            if (this.dCursor == null) {
                return 0L;
            }
            return this.dCursor.timecodeToTimeSL();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long videoTimecodeToTimeSL(long l) {
        try {
            if (this.vCursor == null) {
                return 0L;
            }
            return this.vCursor.timecodeToTimeSL(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long videoTimecodeToTimeSL() {
        try {
            if (this.vCursor == null) {
                return 0L;
            }
            return this.vCursor.timecodeToTimeSL();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long audioTimecodeToSample(long l) {
        try {
            if (this.aCursor == null) {
                return -1L;
            }
            return this.aCursor.timecodeToSample(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long audioSampleToTimecode(long l) {
        try {
            if (this.aCursor == null) {
                return -1L;
            }
            return this.aCursor.sampleToTimecode(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long audioTimeMillisToTimecode(long l) {
        try {
            if (this.aCursor == null) {
                return 0L;
            }
            return this.aCursor.timeMillisToTimecode(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long audioTimecodeToTimeMillis(long l) {
        try {
            if (this.aCursor == null) {
                return 0L;
            }
            return this.aCursor.timecodeToTimeMillis(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long audioTimecodeToTimeSL(long l) {
        try {
            if (this.aCursor == null) {
                return 0L;
            }
            return this.aCursor.timecodeToTimeSL(l);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long audioTimecodeToTimeSL() {
        try {
            if (this.aCursor == null) {
                return 0L;
            }
            return this.aCursor.timecodeToTimeSL();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getAudioSampleCount() {
        try {
            if (this.aCursor == null) {
                return -1L;
            }
            return this.aCursor.getSampleCount();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getDataSampleCount() {
        try {
            if (this.dCursor == null) {
                return -1L;
            }
            return this.dCursor.getSampleCount();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getVideoSampleCount() {
        try {
            if (this.vCursor == null) {
                return -1L;
            }
            return this.vCursor.getSampleCount();
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean movePrevSample() {
        int n = this.getCurrentType();
        switch (n) {
            case 8: {
                if (this.aCursor.movePrevSample()) break;
                this.aAtEnd = true;
                break;
            }
            case 18: {
                if (this.dCursor.movePrevSample()) break;
                this.dAtEnd = true;
                break;
            }
            case 9: {
                if (this.vCursor.movePrevSample()) break;
                this.vAtEnd = true;
            }
        }
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (!this.dAtEnd) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveNextSample() {
        try {
            block9: {
                block10: {
                    int n = this.getCurrentType();
                    switch (n) {
                        case 8: {
                            if (!this.aCursor.moveNextSample()) {
                                this.aAtEnd = true;
                            }
                            break block9;
                        }
                        case 18: {
                            if (!this.dCursor.moveNextSample()) {
                                break;
                            }
                            break block9;
                        }
                        case 9: {
                            if (this.vCursor.moveNextSample()) break block9;
                            break block10;
                        }
                    }
                    this.dAtEnd = true;
                    break block9;
                }
                this.vAtEnd = true;
            }
            if (!this.vAtEnd) return false;
            if (!this.aAtEnd) return false;
            if (!this.dAtEnd) return false;
            return true;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean moveNextAudioSample() {
        if (this.aCursor != null && !this.aCursor.moveNextSample()) {
            this.aAtEnd = true;
        }
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (this.dAtEnd) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean moveNextVideoSample() {
        if (this.vCursor != null && !this.vCursor.moveNextSample()) {
            this.vAtEnd = true;
        }
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (this.dAtEnd) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean moveNextDataSample() {
        if (this.dCursor != null && !this.dCursor.moveNextSample()) {
            this.dAtEnd = true;
        }
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (this.dAtEnd) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetAudioAtEnd() {
        this.aAtEnd = false;
        if (this.aCursor != null) {
            return;
        }
        this.aAtEnd = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetVideoAtEnd() {
        this.vAtEnd = false;
        if (this.vCursor != null) {
            return;
        }
        this.vAtEnd = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetDataAtEnd() {
        this.dAtEnd = false;
        if (this.dCursor != null) {
            return;
        }
        this.dAtEnd = true;
    }

    public void setCurrentPosition(H264CursorPosition h264CursorPosition) {
        try {
            this.setAudioSample(h264CursorPosition.getAudioSample());
            this.setVideoSample(h264CursorPosition.getVideoSample());
            this.setDataSample(h264CursorPosition.getDataSample());
            this.vAtEnd = h264CursorPosition.isVAtEnd();
            this.aAtEnd = h264CursorPosition.isAAtEnd();
            this.dAtEnd = h264CursorPosition.isDAtEnd();
            return;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return;
        }
    }

    public H264CursorPosition getCurrentPosition() {
        try {
            return new H264CursorPosition(this.getVideoSample(), this.vAtEnd, this.getAudioSample(), this.aAtEnd, this.getDataSample(), this.dAtEnd);
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return null;
        }
    }

    public int getDataKeyFrameCount() {
        try {
            if (this.dCursor != null) {
                return this.dCursor.getKeyFrameCount();
            }
            return 0;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0;
        }
    }

    public int getVideoKeyFrameCount() {
        try {
            if (this.vCursor != null) {
                return this.vCursor.getKeyFrameCount();
            }
            return 0;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0;
        }
    }

    public long getDataKeyFrameSample(int n) {
        try {
            if (this.dCursor != null) {
                return this.dCursor.getKeyFrameSample(n);
            }
            return -1L;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    public long getVideoKeyFrameSample(int n) {
        try {
            if (this.vCursor != null) {
                return this.vCursor.getKeyFrameSample(n);
            }
            return -1L;
        }
        catch (H264Cursor$ArrayOutOfBoundsException h264Cursor$ArrayOutOfBoundsException) {
            return 0L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getDataKeyFrameTimesMillis() {
        long[] lArray = null;
        if (this.dCursor == null) return lArray;
        return this.dCursor.getKeyFrameTimesMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getKeyFrameTimesMillis() {
        long[] lArray = null;
        if (this.vCursor == null) return lArray;
        return this.vCursor.getKeyFrameTimesMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getDataKeyFrameTimecodes() {
        long[] lArray = null;
        if (this.dCursor == null) return lArray;
        return this.dCursor.getKeyFrameTimecodes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getKeyFrameTimecodes() {
        long[] lArray = null;
        if (this.vCursor == null) return lArray;
        return this.vCursor.getKeyFrameTimecodes();
    }
}

