/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder.buffered;

import com.wowza.wms.logging.WMSLoggerFactory;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class MP3BufferedDecoder {
    public static int frequency(MP3HeaderData mP3HeaderData) {
        return MP3HeaderData.frequencies[mP3HeaderData.h_version][mP3HeaderData.h_sample_frequency];
    }

    public static int samples_per_frame(MP3HeaderData mP3HeaderData) {
        int n;
        block4: {
            n = 0;
            try {
                if (mP3HeaderData.h_vbr) {
                    n = mP3HeaderData.h_vbr_samples_per_frame[mP3HeaderData.h_layer];
                    if (mP3HeaderData.h_version == 0 || mP3HeaderData.h_version == 2) {
                        n /= 2;
                    }
                    break block4;
                }
                int[][][] nArrayArray = new int[][][]{new int[][]{{192, 192, 192}, {576, 576, 576}, {576, 576, 576}}, new int[][]{{384, 384, 384}, {1152, 1152, 1152}, {1152, 1152, 1152}}, new int[][]{{96, 96, 96}, {288, 288, 288}, {288, 288, 288}}};
                return nArrayArray[mP3HeaderData.h_version][mP3HeaderData.h_layer - 1][mP3HeaderData.h_sample_frequency];
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MP3BufferedDecoder.class).error("MP3BufferedDecoder.samples_per_frame: h_version: " + mP3HeaderData.h_version + " h_layer:" + mP3HeaderData.h_layer + " h_sample_frequency:" + mP3HeaderData.h_sample_frequency + " error ", (Throwable)exception);
            }
        }
        return n;
    }

    public static int syncHeader(byte by, byte[] byArray, MP3HeaderData mP3HeaderData) {
        int n = byArray[0] << 16 & 0xFF0000 | byArray[1] << 8 & 0xFF00 | byArray[2] << 0 & 0xFF;
        n <<= 8;
        boolean bl = MP3BufferedDecoder.isSyncMark(n |= byArray[3] & 0xFF, by, mP3HeaderData);
        return bl ? n : 0;
    }

    public static boolean isSyncMark(int n, int n2, MP3HeaderData mP3HeaderData) {
        int n3 = mP3HeaderData.syncword;
        boolean bl = false;
        if (n2 == 0) {
            bl = (n & 0xFFE00000) == -2097152;
        } else {
            boolean bl2 = (n & 0xFFF80C00) == n3 && (n & 0xC0) == 192 == mP3HeaderData.single_ch_mode ? true : (bl = false);
        }
        if (bl) {
            boolean bl3 = bl = (n >>> 10 & 3) != 3;
        }
        if (bl) {
            boolean bl4 = bl = (n >>> 17 & 3) != 0;
        }
        if (bl) {
            bl = (n >>> 19 & 3) != 1;
        }
        return bl;
    }

    public static void decodeHeader(int n, int n2, MP3HeaderData mP3HeaderData) {
        try {
            if (n2 == 0) {
                mP3HeaderData.h_version = n >>> 19 & 1;
                if ((n >>> 20 & 1) == 0 && mP3HeaderData.h_version == 0) {
                    mP3HeaderData.h_version = 2;
                }
                if ((mP3HeaderData.h_sample_frequency = n >>> 10 & 3) == 3) {
                    // empty if block
                }
            }
            mP3HeaderData.h_layer = 4 - (n >>> 17) & 3;
            mP3HeaderData.h_protection_bit = n >>> 16 & 1;
            mP3HeaderData.h_bitrate_index = n >>> 12 & 0xF;
            mP3HeaderData.h_padding_bit = n >>> 9 & 1;
            mP3HeaderData.h_mode = n >>> 6 & 3;
            mP3HeaderData.h_mode_extension = n >>> 4 & 3;
            mP3HeaderData.h_intensity_stereo_bound = mP3HeaderData.h_mode == 1 ? (mP3HeaderData.h_mode_extension << 2) + 4 : 0;
            if ((n >>> 3 & 1) == 1) {
                mP3HeaderData.h_copyright = true;
            }
            if ((n >>> 2 & 1) == 1) {
                mP3HeaderData.h_original = true;
            }
            if (mP3HeaderData.h_layer == 1) {
                mP3HeaderData.h_number_of_subbands = 32;
            } else {
                int n3 = mP3HeaderData.h_bitrate_index;
                if (mP3HeaderData.h_mode != 3) {
                    n3 = n3 == 4 ? 1 : (n3 -= 4);
                }
                mP3HeaderData.h_number_of_subbands = n3 == 1 || n3 == 2 ? (mP3HeaderData.h_sample_frequency == 2 ? 12 : 8) : (mP3HeaderData.h_sample_frequency == 1 || n3 >= 3 && n3 <= 5 ? 27 : 30);
            }
            if (mP3HeaderData.h_intensity_stereo_bound > mP3HeaderData.h_number_of_subbands) {
                mP3HeaderData.h_intensity_stereo_bound = mP3HeaderData.h_number_of_subbands;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MP3BufferedDecoder.class).error("MP3BufferedDecoder.decodeHeader ", (Throwable)exception);
        }
    }

    public static int calculateFrameSize(MP3HeaderData mP3HeaderData) {
        int n = 0;
        if (mP3HeaderData.h_layer == 1) {
            n = 12 * MP3HeaderData.bitrates[mP3HeaderData.h_version][0][mP3HeaderData.h_bitrate_index] / MP3HeaderData.frequencies[mP3HeaderData.h_version][mP3HeaderData.h_sample_frequency];
            if (mP3HeaderData.h_padding_bit != 0) {
                ++n;
            }
            n <<= 2;
            var2_2 = 0;
        } else {
            n = 144 * MP3HeaderData.bitrates[mP3HeaderData.h_version][mP3HeaderData.h_layer - 1][mP3HeaderData.h_bitrate_index] / MP3HeaderData.frequencies[mP3HeaderData.h_version][mP3HeaderData.h_sample_frequency];
            if (mP3HeaderData.h_version == 0 || mP3HeaderData.h_version == 2) {
                n >>= 1;
            }
            if (mP3HeaderData.h_padding_bit != 0) {
                ++n;
            }
            var2_2 = mP3HeaderData.h_layer == 3 ? (mP3HeaderData.h_version == 1 ? n - (mP3HeaderData.h_mode == 3 ? 17 : 32) - (mP3HeaderData.h_protection_bit != 0 ? 0 : 2) - 4 : n - (mP3HeaderData.h_mode == 3 ? 9 : 17) - (mP3HeaderData.h_protection_bit != 0 ? 0 : 2) - 4) : 0;
        }
        return n -= 4;
    }
}

