/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;

public class SessionLog {
    public static final String PREFIX = SessionLog.class.getName() + ".prefix";
    public static final String LOGGER = SessionLog.class.getName() + ".logger";

    private static Class getClass(IoSession ioSession) {
        return ioSession.getHandler().getClass();
    }

    public static void debug(IoSession ioSession, String string) {
        WMSLogger wMSLogger = SessionLog.getLogger(ioSession);
        if (wMSLogger.isDebugEnabled()) {
            wMSLogger.debug(String.valueOf(ioSession.getAttribute(PREFIX)) + string);
        }
    }

    public static void debug(IoSession ioSession, String string, Throwable throwable) {
        WMSLogger wMSLogger = SessionLog.getLogger(ioSession);
        if (wMSLogger.isDebugEnabled()) {
            wMSLogger.debug(String.valueOf(ioSession.getAttribute(PREFIX)) + string, throwable);
        }
    }

    public static void info(IoSession ioSession, String string) {
        WMSLogger wMSLogger = SessionLog.getLogger(ioSession);
        if (wMSLogger.isInfoEnabled()) {
            wMSLogger.info(String.valueOf(ioSession.getAttribute(PREFIX)) + string);
        }
    }

    public static void info(IoSession ioSession, String string, Throwable throwable) {
        WMSLogger wMSLogger = SessionLog.getLogger(ioSession);
        if (wMSLogger.isInfoEnabled()) {
            wMSLogger.info(String.valueOf(ioSession.getAttribute(PREFIX)) + string, throwable);
        }
    }

    public static void warn(IoSession ioSession, String string) {
        WMSLogger wMSLogger = SessionLog.getLogger(ioSession);
        if (wMSLogger.isWarnEnabled()) {
            wMSLogger.warn(String.valueOf(ioSession.getAttribute(PREFIX)) + string);
        }
    }

    public static void warn(IoSession ioSession, String string, Throwable throwable) {
        WMSLogger wMSLogger = SessionLog.getLogger(ioSession);
        if (wMSLogger.isWarnEnabled()) {
            wMSLogger.warn(String.valueOf(ioSession.getAttribute(PREFIX)) + string, throwable);
        }
    }

    public static void error(IoSession ioSession, String string) {
        WMSLogger wMSLogger = SessionLog.getLogger(ioSession);
        if (wMSLogger.isErrorEnabled()) {
            wMSLogger.error(String.valueOf(ioSession.getAttribute(PREFIX)) + string);
        }
    }

    public static void error(IoSession ioSession, String string, Throwable throwable) {
        WMSLogger wMSLogger = SessionLog.getLogger(ioSession);
        if (wMSLogger.isErrorEnabled()) {
            wMSLogger.error(String.valueOf(ioSession.getAttribute(PREFIX)) + string, throwable);
        }
    }

    public static boolean isDebugEnabled(IoSession ioSession) {
        return SessionLog.getLogger(ioSession).isDebugEnabled();
    }

    public static boolean isInfoEnabled(IoSession ioSession) {
        return SessionLog.getLogger(ioSession).isInfoEnabled();
    }

    public static boolean isWarnEnabled(IoSession ioSession) {
        return SessionLog.getLogger(ioSession).isWarnEnabled();
    }

    public static boolean isErrorEnabled(IoSession ioSession) {
        return SessionLog.getLogger(ioSession).isErrorEnabled();
    }

    private static WMSLogger getLogger(IoSession ioSession) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(SessionLog.class);
        return wMSLogger;
    }

    public static String logBuffer(ByteBuffer byteBuffer) {
        return byteBuffer == null ? "minaBuffer:null" : "minaBuffer:" + byteBuffer.limit() + (byteBuffer.getExtra() != null ? "/extra" : "");
    }

    public static String logBuffer(java.nio.ByteBuffer byteBuffer) {
        return byteBuffer == null ? "nioBuffer:null" : "nioBuffer:" + byteBuffer.limit();
    }

    public static String logObj(Object object) {
        return object == null ? "obj:null" : "obj:" + object.hashCode();
    }
}

