/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.transport.socket.nio.FastMinaMessage;

public class Queue
extends AbstractList
implements List,
Serializable {
    private static final long serialVersionUID = 3835151744526464313L;
    private static final int DEFAULT_CAPACITY = 4;
    private static final int DEFAULT_MASK = 3;
    private Object[] items = new Object[4];
    private int mask = 3;
    private int first = 0;
    private int last = 0;
    private int size = 0;

    public int capacity() {
        return this.items.length;
    }

    @Override
    public void clear() {
        Arrays.fill(this.items, null);
        this.first = 0;
        this.last = 0;
        this.size = 0;
    }

    public Object pop() {
        if (this.size == 0) {
            return null;
        }
        Object object = this.items[this.first];
        this.items[this.first] = null;
        this.decreaseSize();
        return object;
    }

    public void push(Object object) {
        if (object == null) {
            throw new NullPointerException("item");
        }
        this.ensureCapacity();
        this.items[this.last] = object;
        this.increaseSize();
    }

    public Object first() {
        if (this.size == 0) {
            return null;
        }
        return this.items[this.first];
    }

    public Object last() {
        if (this.size == 0) {
            return null;
        }
        return this.items[this.last + this.items.length - 1 & this.mask];
    }

    public Object get(int n) {
        this.checkIndex(n);
        return this.items[this.getRealIndex(n)];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int byteSize() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = 0;
        try {
            for (int i = 0; i < this.size; ++i) {
                Object object = this.get(i);
                if (object == null || !(object instanceof IoFilter.WriteRequest)) continue;
                ByteBuffer byteBuffer = (ByteBuffer)((IoFilter.WriteRequest)object).getMessage();
                if (byteBuffer.getExtra() != null) {
                    n += ((FastMinaMessage)byteBuffer.getExtra()).remaining();
                    continue;
                }
                n += byteBuffer.remaining();
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Error byteSize: " + exception.toString());
        }
        return n;
    }

    @Override
    public String toString() {
        return "first=" + this.first + ", last=" + this.last + ", size=" + this.size + ", mask = " + this.mask;
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
    }

    private int getRealIndex(int n) {
        return this.first + n & this.mask;
    }

    private void increaseSize() {
        this.last = this.last + 1 & this.mask;
        ++this.size;
    }

    private void decreaseSize() {
        this.first = this.first + 1 & this.mask;
        --this.size;
    }

    private void ensureCapacity() {
        if (this.size < this.items.length) {
            return;
        }
        int n = this.items.length;
        Object[] objectArray = new Object[n * 2];
        if (this.first < this.last) {
            System.arraycopy(this.items, this.first, objectArray, 0, this.last - this.first);
        } else {
            System.arraycopy(this.items, this.first, objectArray, 0, n - this.first);
            System.arraycopy(this.items, 0, objectArray, n - this.first, this.last);
        }
        this.first = 0;
        this.last = n;
        this.items = objectArray;
        this.mask = objectArray.length - 1;
    }

    @Override
    public boolean add(Object object) {
        this.push(object);
        return true;
    }

    public Object set(int n, Object object) {
        this.checkIndex(n);
        int n2 = this.getRealIndex(n);
        Object object2 = this.items[n2];
        this.items[n2] = object;
        return object2;
    }

    public void add(int n, Object object) {
        if (n == this.size) {
            this.push(object);
            return;
        }
        this.checkIndex(n);
        this.ensureCapacity();
        int n2 = this.getRealIndex(n);
        if (this.first < this.last) {
            System.arraycopy(this.items, n2, this.items, n2 + 1, this.last - n2);
        } else if (n2 >= this.first) {
            System.arraycopy(this.items, 0, this.items, 1, this.last);
            this.items[0] = this.items[this.items.length - 1];
            System.arraycopy(this.items, n2, this.items, n2 + 1, this.items.length - n2 - 1);
        } else {
            System.arraycopy(this.items, n2, this.items, n2 + 1, this.last - n2);
        }
        this.items[n2] = object;
        this.increaseSize();
    }

    public Object remove(int n) {
        if (n == 0) {
            return this.pop();
        }
        this.checkIndex(n);
        int n2 = this.getRealIndex(n);
        Object object = this.items[n2];
        if (this.first < this.last) {
            System.arraycopy(this.items, this.first, this.items, this.first + 1, n2 - this.first);
        } else if (n2 >= this.first) {
            System.arraycopy(this.items, this.first, this.items, this.first + 1, n2 - this.first);
        } else {
            System.arraycopy(this.items, 0, this.items, 1, n2);
            this.items[0] = this.items[this.items.length - 1];
            System.arraycopy(this.items, this.first, this.items, this.first + 1, this.items.length - this.first - 1);
        }
        this.items[this.first] = null;
        this.decreaseSize();
        return object;
    }

    public boolean offer(Object object) {
        this.push(object);
        return true;
    }

    public Object poll() {
        return this.pop();
    }

    public Object remove() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.pop();
    }

    public Object peek() {
        return this.first();
    }

    public Object element() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.first();
    }
}

