/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.mina.util.ExpirationListener;

public class ExpiringMap
implements Map {
    public static final int DEFAULT_TIME_TO_LIVE = 60;
    public static final int DEFAULT_EXPIRATION_INTERVAL = 1;
    private static volatile int expirerCount = 1;
    private final ConcurrentHashMap delegate;
    private final CopyOnWriteArrayList expirationListeners;
    private final Expirer expirer;

    public ExpiringMap() {
        this(60, 1);
    }

    public ExpiringMap(int n) {
        this(n, 1);
    }

    public ExpiringMap(int n, int n2) {
        this(new ConcurrentHashMap(), new CopyOnWriteArrayList(), n, n2);
    }

    private ExpiringMap(ConcurrentHashMap concurrentHashMap, CopyOnWriteArrayList copyOnWriteArrayList, int n, int n2) {
        this.delegate = concurrentHashMap;
        this.expirationListeners = copyOnWriteArrayList;
        this.expirer = new Expirer();
        this.expirer.setTimeToLive(n);
        this.expirer.setExpirationInterval(n2);
    }

    public Object put(Object object, Object object2) {
        return this.delegate.put(object, new ExpiringObject(object, object2, System.currentTimeMillis()));
    }

    public Object get(Object object) {
        Object v = this.delegate.get(object);
        if (v != null) {
            ExpiringObject expiringObject = (ExpiringObject)v;
            expiringObject.setLastAccessTime(System.currentTimeMillis());
            return expiringObject.getValue();
        }
        return v;
    }

    public Object remove(Object object) {
        return this.delegate.remove(object);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.delegate.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.delegate.containsValue(object);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    @Override
    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        Map map2 = map;
        synchronized (map2) {
            for (Object k : map.keySet()) {
                Object v = map.get(k);
                if (!(v instanceof ExpiringObject)) continue;
                this.delegate.put(k, v);
            }
        }
    }

    public Collection values() {
        return this.delegate.values();
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    public void addExpirationListener(ExpirationListener expirationListener) {
        this.expirationListeners.add(expirationListener);
    }

    public void removeExpirationListener(ExpirationListener expirationListener) {
        this.expirationListeners.remove(expirationListener);
    }

    public Expirer getExpirer() {
        return this.expirer;
    }

    public int getExpirationInterval() {
        return this.expirer.getExpirationInterval();
    }

    public int getTimeToLive() {
        return this.expirer.getTimeToLive();
    }

    public void setExpirationInterval(int n) {
        this.expirer.setExpirationInterval(n);
    }

    public void setTimeToLive(int n) {
        this.expirer.setTimeToLive(n);
    }

    public class Expirer
    implements Runnable {
        private WMSReadWriteLock stateLock = new WMSReentrantReadWriteLock();
        private long timeToLiveMillis;
        private long expirationIntervalMillis;
        private boolean running = false;
        private final Thread expirerThread = new Thread((Runnable)this, "ExpiringMapExpirer-" + expirerCount++);

        public Expirer() {
            this.expirerThread.setDaemon(true);
        }

        @Override
        public void run() {
            while (this.running) {
                this.processExpires();
                try {
                    Thread.sleep(this.expirationIntervalMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void processExpires() {
            long l = System.currentTimeMillis();
            for (ExpiringObject expiringObject : ExpiringMap.this.delegate.values()) {
                long l2;
                if (this.timeToLiveMillis <= 0L || (l2 = l - expiringObject.getLastAccessTime()) < this.timeToLiveMillis) continue;
                ExpiringMap.this.delegate.remove(expiringObject.getKey());
                for (ExpirationListener expirationListener : ExpiringMap.this.expirationListeners) {
                    expirationListener.expired(expiringObject.getValue());
                }
            }
        }

        public void startExpiring() {
            this.stateLock.writeLock().lock();
            try {
                if (!this.running) {
                    this.running = true;
                    this.expirerThread.start();
                }
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        public void startExpiringIfNotStarted() {
            this.stateLock.readLock().lock();
            try {
                if (this.running) {
                    return;
                }
            }
            finally {
                this.stateLock.readLock().unlock();
            }
            this.stateLock.writeLock().lock();
            try {
                if (!this.running) {
                    this.running = true;
                    this.expirerThread.start();
                }
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        public void stopExpiring() {
            this.stateLock.writeLock().lock();
            try {
                if (this.running) {
                    this.running = false;
                    this.expirerThread.interrupt();
                }
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        public boolean isRunning() {
            this.stateLock.readLock().lock();
            try {
                boolean bl = this.running;
                return bl;
            }
            finally {
                this.stateLock.readLock().unlock();
            }
        }

        public int getTimeToLive() {
            this.stateLock.readLock().lock();
            try {
                int n = (int)this.timeToLiveMillis / 1000;
                return n;
            }
            finally {
                this.stateLock.readLock().unlock();
            }
        }

        public void setTimeToLive(long l) {
            this.stateLock.writeLock().lock();
            try {
                this.timeToLiveMillis = l * 1000L;
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }

        public int getExpirationInterval() {
            this.stateLock.readLock().lock();
            try {
                int n = (int)this.expirationIntervalMillis / 1000;
                return n;
            }
            finally {
                this.stateLock.readLock().unlock();
            }
        }

        public void setExpirationInterval(long l) {
            this.stateLock.writeLock().lock();
            try {
                this.expirationIntervalMillis = l * 1000L;
            }
            finally {
                this.stateLock.writeLock().unlock();
            }
        }
    }

    private class ExpiringObject {
        private Object key;
        private Object value;
        private long lastAccessTime;
        private WMSReadWriteLock lastAccessTimeLock = new WMSReentrantReadWriteLock();

        public ExpiringObject(Object object, Object object2, long l) {
            if (object2 == null) {
                throw new IllegalArgumentException("An expiring object cannot be null.");
            }
            this.key = object;
            this.value = object2;
            this.lastAccessTime = l;
        }

        public long getLastAccessTime() {
            this.lastAccessTimeLock.readLock().lock();
            try {
                long l = this.lastAccessTime;
                return l;
            }
            finally {
                this.lastAccessTimeLock.readLock().unlock();
            }
        }

        public void setLastAccessTime(long l) {
            this.lastAccessTimeLock.writeLock().lock();
            try {
                this.lastAccessTime = l;
            }
            finally {
                this.lastAccessTimeLock.writeLock().unlock();
            }
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            return this.value.equals(object);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

