/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.mina.util.Queue;

public class BlockingQueue
extends Queue {
    private static final long serialVersionUID = 5516588196355725567L;
    private int waiters = 0;

    public synchronized void waitForNewItem() throws InterruptedException {
        ++this.waiters;
        try {
            while (super.isEmpty()) {
                this.wait();
            }
        }
        finally {
            --this.waiters;
        }
    }

    @Override
    public synchronized void push(Object object) {
        super.push(object);
        this.notifyAdded();
    }

    @Override
    public synchronized void add(int n, Object object) {
        super.add(n, object);
        this.notifyAdded();
    }

    @Override
    public synchronized boolean add(Object object) {
        if (super.add(object)) {
            this.notifyAdded();
            return true;
        }
        return false;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        if (super.addAll(n, collection)) {
            this.notifyAdded();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addAll(Collection collection) {
        if (super.addAll(collection)) {
            this.notifyAdded();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean offer(Object object) {
        if (super.offer(object)) {
            this.notifyAdded();
            return true;
        }
        return false;
    }

    private void notifyAdded() {
        if (this.waiters > 0) {
            this.notify();
        }
    }

    @Override
    public synchronized int capacity() {
        return super.capacity();
    }

    @Override
    public synchronized void clear() {
        super.clear();
    }

    @Override
    public synchronized Object first() {
        return super.first();
    }

    @Override
    public synchronized Object get(int n) {
        return super.get(n);
    }

    @Override
    public synchronized boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public synchronized Object last() {
        return super.last();
    }

    @Override
    public synchronized Object pop() {
        return super.pop();
    }

    @Override
    public synchronized int size() {
        return super.size();
    }

    @Override
    public synchronized String toString() {
        return super.toString();
    }

    @Override
    public synchronized Object remove(int n) {
        return super.remove(n);
    }

    @Override
    public synchronized Object set(int n, Object object) {
        return super.set(n, object);
    }

    @Override
    public synchronized boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized int indexOf(Object object) {
        return super.indexOf(object);
    }

    @Override
    public synchronized Iterator iterator() {
        return super.iterator();
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return super.lastIndexOf(object);
    }

    public synchronized ListIterator listIterator() {
        return super.listIterator();
    }

    public synchronized ListIterator listIterator(int n) {
        return super.listIterator(n);
    }

    public synchronized List subList(int n, int n2) {
        return super.subList(n, n2);
    }

    @Override
    public synchronized boolean contains(Object object) {
        return super.contains(object);
    }

    @Override
    public synchronized boolean containsAll(Collection collection) {
        return super.containsAll(collection);
    }

    @Override
    public synchronized boolean remove(Object object) {
        return super.remove(object);
    }

    @Override
    public synchronized boolean removeAll(Collection collection) {
        return super.removeAll(collection);
    }

    @Override
    public synchronized boolean retainAll(Collection collection) {
        return super.retainAll(collection);
    }

    @Override
    public synchronized Object[] toArray() {
        return super.toArray();
    }

    @Override
    public synchronized Object[] toArray(Object[] objectArray) {
        return super.toArray(objectArray);
    }

    @Override
    public synchronized Object element() {
        return super.element();
    }

    @Override
    public synchronized Object peek() {
        return super.peek();
    }

    @Override
    public synchronized Object poll() {
        return super.poll();
    }

    @Override
    public synchronized Object remove() {
        return super.remove();
    }
}

