/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe.support;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.common.support.IoServiceListenerSupport;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.transport.vmpipe.support.VmPipeFilterChain;
import org.apache.mina.transport.vmpipe.support.VmPipeIdleStatusChecker;
import org.apache.mina.util.Queue;

public class VmPipeSessionImpl
extends BaseIoSession {
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoService service;
    private final IoServiceConfig serviceConfig;
    private final IoServiceListenerSupport serviceListeners;
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final SocketAddress serviceAddress;
    private final IoHandler handler;
    private final VmPipeFilterChain filterChain;
    final VmPipeSessionImpl remoteSession;
    final Object lock;
    final Queue pendingDataQueue;

    public VmPipeSessionImpl(IoService ioService, IoServiceConfig ioServiceConfig, IoServiceListenerSupport ioServiceListenerSupport, Object object, SocketAddress socketAddress, IoHandler ioHandler, VmPipe vmPipe) throws IOException {
        this.service = ioService;
        this.serviceConfig = ioServiceConfig;
        this.serviceListeners = ioServiceListenerSupport;
        this.lock = object;
        this.localAddress = socketAddress;
        this.remoteAddress = this.serviceAddress = vmPipe.getAddress();
        this.handler = ioHandler;
        this.filterChain = new VmPipeFilterChain(this);
        this.pendingDataQueue = new Queue();
        this.remoteSession = new VmPipeSessionImpl(this, vmPipe);
        try {
            ioService.getFilterChainBuilder().buildFilterChain(this.filterChain);
            ioServiceConfig.getFilterChainBuilder().buildFilterChain(this.filterChain);
            ioServiceConfig.getThreadModel().buildFilterChain(this.filterChain);
            ioServiceListenerSupport.fireSessionCreated(this);
        }
        catch (Throwable throwable) {
            throw (IOException)new IOException("Failed to create a connector session.").initCause(throwable);
        }
        VmPipeIdleStatusChecker.getInstance().addSession(this);
    }

    private VmPipeSessionImpl(VmPipeSessionImpl vmPipeSessionImpl, VmPipe vmPipe) throws IOException {
        this.service = vmPipe.getAcceptor();
        this.serviceConfig = vmPipe.getConfig();
        this.serviceListeners = vmPipe.getListeners();
        this.lock = vmPipeSessionImpl.lock;
        this.localAddress = this.serviceAddress = vmPipeSessionImpl.remoteAddress;
        this.remoteAddress = vmPipeSessionImpl.localAddress;
        this.handler = vmPipe.getHandler();
        this.filterChain = new VmPipeFilterChain(this);
        this.remoteSession = vmPipeSessionImpl;
        this.pendingDataQueue = new Queue();
        try {
            vmPipe.getAcceptor().getFilterChainBuilder().buildFilterChain(this.getFilterChain());
            vmPipe.getConfig().getFilterChainBuilder().buildFilterChain(this.getFilterChain());
            vmPipe.getConfig().getThreadModel().buildFilterChain(this.getFilterChain());
            this.serviceListeners.fireSessionCreated(this);
        }
        catch (Throwable throwable) {
            ExceptionMonitor.getInstance().exceptionCaught(throwable);
            IOException iOException = new IOException("Failed to initialize acceptor session.");
            iOException.initCause(throwable);
            throw iOException;
        }
        VmPipeIdleStatusChecker.getInstance().addSession(this);
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    IoServiceListenerSupport getServiceListeners() {
        return this.serviceListeners;
    }

    @Override
    public IoServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    @Override
    public IoSessionConfig getConfig() {
        return CONFIG;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    protected void close0() {
        this.filterChain.fireFilterClose(this);
    }

    @Override
    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.fireFilterWrite(this, writeRequest);
    }

    @Override
    public int getScheduledWriteRequests() {
        return 0;
    }

    @Override
    public int getScheduledWriteBytes() {
        return 0;
    }

    @Override
    public long getFirstWriteRequestId() {
        return -1L;
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.VM_PIPE;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateTrafficMask() {
        if (this.getTrafficMask().isReadable() || this.getTrafficMask().isWritable()) {
            Object[] objectArray;
            Queue queue = this.pendingDataQueue;
            synchronized (queue) {
                objectArray = this.pendingDataQueue.toArray();
                this.pendingDataQueue.clear();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof IoFilter.WriteRequest) {
                    IoFilter.WriteRequest writeRequest = (IoFilter.WriteRequest)objectArray[i];
                    this.filterChain.doWrite(this, writeRequest);
                    continue;
                }
                this.filterChain.fireMessageReceived(this, objectArray[i]);
            }
        }
    }
}

