/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.common.support.BaseIoConnectorConfig;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;
import org.apache.mina.util.AnonymousSocketAddress;

public class VmPipeConnector
extends BaseIoConnector {
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoServiceConfig defaultConfig = new BaseIoConnectorConfig(){

        @Override
        public IoSessionConfig getSessionConfig() {
            return CONFIG;
        }
    };

    @Override
    public ConnectFuture connect(SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        return this.connect(socketAddress, null, ioHandler, ioServiceConfig);
    }

    @Override
    public ConnectFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        VmPipe vmPipe;
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        if (ioHandler == null) {
            throw new NullPointerException("handler");
        }
        if (!(socketAddress instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (ioServiceConfig == null) {
            ioServiceConfig = this.getDefaultConfig();
        }
        if ((vmPipe = (VmPipe)VmPipeAcceptor.boundHandlers.get(socketAddress)) == null) {
            return DefaultConnectFuture.newFailedFuture(new IOException("Endpoint unavailable: " + socketAddress));
        }
        DefaultConnectFuture defaultConnectFuture = new DefaultConnectFuture();
        try {
            VmPipeSessionImpl vmPipeSessionImpl = new VmPipeSessionImpl(this, ioServiceConfig, this.getListeners(), new Object(), new AnonymousSocketAddress(), ioHandler, vmPipe);
            defaultConnectFuture.setSession(vmPipeSessionImpl);
        }
        catch (IOException iOException) {
            defaultConnectFuture.setException(iOException);
        }
        return defaultConnectFuture;
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

