/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import com.wowza.wms.logging.WMSLoggerFactory;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.common.support.IoServiceListenerSupport;
import org.apache.mina.transport.socket.nio.SocketFilterChain;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfigImpl;
import org.apache.mina.util.Queue;

public class SocketSessionImpl
extends BaseIoSession {
    private static final Class<SocketSessionImpl> CLASS = SocketSessionImpl.class;
    private final IoService manager;
    private final IoServiceConfig serviceConfig;
    private final SocketSessionConfig config = new SessionConfigImpl();
    private final SocketIoProcessor ioProcessor;
    private final SocketFilterChain filterChain;
    private final SocketChannel ch;
    private final Queue writeRequestQueue;
    private final IoHandler handler;
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;
    private final SocketAddress serviceAddress;
    private final IoServiceListenerSupport serviceListeners;
    private SelectionKey key;
    private int readBufferSize;
    private AtomicLong scheduledBytesToZero = new AtomicLong(0L);

    SocketSessionImpl(IoService ioService, SocketIoProcessor socketIoProcessor, IoServiceListenerSupport ioServiceListenerSupport, IoServiceConfig ioServiceConfig, SocketChannel socketChannel, IoHandler ioHandler, SocketAddress socketAddress) {
        this.manager = ioService;
        this.serviceListeners = ioServiceListenerSupport;
        this.ioProcessor = socketIoProcessor;
        this.filterChain = new SocketFilterChain(this);
        this.ch = socketChannel;
        this.writeRequestQueue = new Queue();
        this.handler = ioHandler;
        this.remoteAddress = socketChannel.socket().getRemoteSocketAddress();
        this.localAddress = socketChannel.socket().getLocalSocketAddress();
        this.serviceAddress = socketAddress;
        this.serviceConfig = ioServiceConfig;
        IoSessionConfig ioSessionConfig = ioServiceConfig.getSessionConfig();
        if (ioSessionConfig instanceof SocketSessionConfig) {
            SocketSessionConfig socketSessionConfig = (SocketSessionConfig)ioSessionConfig;
            try {
                this.config.setReuseAddress(socketSessionConfig.isReuseAddress());
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).warn("SocketSessionImpl.setReuseAddress[" + socketSessionConfig.isReuseAddress() + "][" + this.serviceAddress + "]: Failed ", (Throwable)exception);
            }
            try {
                this.config.setKeepAlive(socketSessionConfig.isKeepAlive());
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).warn("SocketSessionImpl.setKeepAlive[" + socketSessionConfig.isKeepAlive() + "][" + this.serviceAddress + "]: Failed ", (Throwable)exception);
            }
            try {
                this.config.setOobInline(socketSessionConfig.isOobInline());
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).warn("SocketSessionImpl.setOobInline[" + socketSessionConfig.isOobInline() + "][" + this.serviceAddress + "]: Failed ", (Throwable)exception);
            }
            int n = socketSessionConfig.getReceiveBufferSize();
            if (n > 0) {
                try {
                    this.config.setReceiveBufferSize(n);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(CLASS).warn("SocketSessionImpl.setReceiveBufferSize[" + n + "][" + this.serviceAddress + "]: Failed ", (Throwable)exception);
                }
            }
            this.readBufferSize = socketSessionConfig.getReadBufferSize();
            try {
                this.config.setSendBufferSize(socketSessionConfig.getSendBufferSize());
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).warn("SocketSessionImpl.setSendBufferSize[" + socketSessionConfig.getSendBufferSize() + "][" + this.serviceAddress + "]: Failed ", (Throwable)exception);
            }
            try {
                this.config.setSoLinger(socketSessionConfig.getSoLinger());
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).warn("SocketSessionImpl.setSoLinger[" + socketSessionConfig.getSoLinger() + "][" + this.serviceAddress + "]: Failed ", (Throwable)exception);
            }
            try {
                this.config.setTcpNoDelay(socketSessionConfig.isTcpNoDelay());
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(CLASS).warn("SocketSessionImpl.setTcpNoDelay[" + socketSessionConfig.isTcpNoDelay() + "][" + this.serviceAddress + "]: Failed ", (Throwable)exception);
            }
            if (this.config.getTrafficClass() != socketSessionConfig.getTrafficClass()) {
                try {
                    this.config.setTrafficClass(socketSessionConfig.getTrafficClass());
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(CLASS).warn("SocketSessionImpl.setTrafficClass[" + socketSessionConfig.getTrafficClass() + "][" + this.serviceAddress + "]: Failed ", (Throwable)exception);
                }
            }
        }
    }

    @Override
    public IoService getService() {
        return this.manager;
    }

    @Override
    public IoServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    @Override
    public IoSessionConfig getConfig() {
        return this.config;
    }

    SocketIoProcessor getIoProcessor() {
        return this.ioProcessor;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public SocketChannel getChannel() {
        return this.ch;
    }

    IoServiceListenerSupport getServiceListeners() {
        return this.serviceListeners;
    }

    SelectionKey getSelectionKey() {
        return this.key;
    }

    void setSelectionKey(SelectionKey selectionKey) {
        this.key = selectionKey;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    protected void close0() {
        this.filterChain.fireFilterClose(this);
    }

    Queue getWriteRequestQueue() {
        return this.writeRequestQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScheduledWriteRequests() {
        Queue queue = this.writeRequestQueue;
        synchronized (queue) {
            return this.writeRequestQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScheduledWriteBytes() {
        Queue queue = this.writeRequestQueue;
        synchronized (queue) {
            return this.writeRequestQueue.byteSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFirstWriteRequestId() {
        long l = -1L;
        Queue queue = this.writeRequestQueue;
        synchronized (queue) {
            Object object = this.writeRequestQueue.peek();
            if (object != null && object instanceof IoFilter.WriteRequest) {
                l = ((IoFilter.WriteRequest)object).getWriteId();
            }
        }
        return l;
    }

    @Override
    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.fireFilterWrite(this, writeRequest);
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.SOCKET;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    protected void updateTrafficMask() {
        this.ioProcessor.updateTrafficMask(this);
    }

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void incScheduleBytesToZero() {
        this.scheduledBytesToZero.incrementAndGet();
    }

    public long getScheduleBytesToZero() {
        return this.scheduledBytesToZero.get();
    }

    private class SessionConfigImpl
    extends BaseIoSessionConfig
    implements SocketSessionConfig {
        private SessionConfigImpl() {
        }

        @Override
        public boolean isKeepAlive() {
            try {
                return SocketSessionImpl.this.ch.socket().getKeepAlive();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public void setKeepAlive(boolean bl) {
            try {
                SocketSessionImpl.this.ch.socket().setKeepAlive(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public boolean isOobInline() {
            try {
                return SocketSessionImpl.this.ch.socket().getOOBInline();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public void setOobInline(boolean bl) {
            try {
                SocketSessionImpl.this.ch.socket().setOOBInline(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public boolean isReuseAddress() {
            try {
                return SocketSessionImpl.this.ch.socket().getReuseAddress();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public void setReuseAddress(boolean bl) {
            try {
                SocketSessionImpl.this.ch.socket().setReuseAddress(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public int getSoLinger() {
            try {
                return SocketSessionImpl.this.ch.socket().getSoLinger();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public void setSoLinger(int n) {
            try {
                if (n < 0) {
                    SocketSessionImpl.this.ch.socket().setSoLinger(false, 0);
                } else {
                    SocketSessionImpl.this.ch.socket().setSoLinger(true, n);
                }
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public boolean isTcpNoDelay() {
            try {
                return SocketSessionImpl.this.ch.socket().getTcpNoDelay();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public void setTcpNoDelay(boolean bl) {
            try {
                SocketSessionImpl.this.ch.socket().setTcpNoDelay(bl);
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public int getTrafficClass() {
            block3: {
                if (SocketSessionConfigImpl.isGetTrafficClassAvailable()) {
                    try {
                        return SocketSessionImpl.this.ch.socket().getTrafficClass();
                    }
                    catch (SocketException socketException) {
                        if (!SocketSessionConfigImpl.isSetTrafficClassAvailable()) break block3;
                        throw new RuntimeIOException(socketException);
                    }
                }
            }
            return 0;
        }

        @Override
        public void setTrafficClass(int n) {
            if (SocketSessionConfigImpl.isSetTrafficClassAvailable()) {
                try {
                    SocketSessionImpl.this.ch.socket().setTrafficClass(n);
                }
                catch (SocketException socketException) {
                    throw new RuntimeIOException(socketException);
                }
            }
        }

        @Override
        public int getSendBufferSize() {
            try {
                return SocketSessionImpl.this.ch.socket().getSendBufferSize();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public void setSendBufferSize(int n) {
            if (SocketSessionConfigImpl.isSetSendBufferSizeAvailable()) {
                try {
                    if (n > 0) {
                        SocketSessionImpl.this.ch.socket().setSendBufferSize(n);
                    }
                }
                catch (SocketException socketException) {
                    throw new RuntimeIOException(socketException);
                }
            }
        }

        @Override
        public int getReceiveBufferSize() {
            try {
                return SocketSessionImpl.this.ch.socket().getReceiveBufferSize();
            }
            catch (SocketException socketException) {
                throw new RuntimeIOException(socketException);
            }
        }

        @Override
        public void setReceiveBufferSize(int n) {
            if (SocketSessionConfigImpl.isSetReceiveBufferSizeAvailable()) {
                try {
                    if (n > 0) {
                        SocketSessionImpl.this.ch.socket().setReceiveBufferSize(n);
                    }
                }
                catch (SocketException socketException) {
                    throw new RuntimeIOException(socketException);
                }
            }
        }

        @Override
        public int getReadBufferSize() {
            return SocketSessionImpl.this.readBufferSize;
        }

        @Override
        public void setReadBufferSize(int n) {
            SocketSessionImpl.this.readBufferSize = n;
        }
    }
}

