/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.Queue;

class SocketFilterChain
extends AbstractIoFilterChain {
    SocketFilterChain(IoSession ioSession) {
        super(ioSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(IoSession ioSession, IoFilter.WriteRequest writeRequest) {
        SocketSessionImpl socketSessionImpl = (SocketSessionImpl)ioSession;
        Queue queue = socketSessionImpl.getWriteRequestQueue();
        ((ByteBuffer)writeRequest.getMessage()).mark();
        Queue queue2 = queue;
        synchronized (queue2) {
            if (queue.size() <= 0) {
                socketSessionImpl.incScheduleBytesToZero();
            }
            queue.push(writeRequest);
            if (queue.size() == 1 && ioSession.getTrafficMask().isWritable()) {
                socketSessionImpl.getIoProcessor().flush(socketSessionImpl);
            }
        }
    }

    @Override
    protected void doClose(IoSession ioSession) throws IOException {
        SocketSessionImpl socketSessionImpl = (SocketSessionImpl)ioSession;
        socketSessionImpl.getIoProcessor().remove(socketSessionImpl);
    }
}

