/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.management;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.management.IoSessionStat;

public class StatCollector {
    public static final String KEY = StatCollector.class.getName() + ".stat";
    private static volatile int nextId = 0;
    private final int id = nextId++;
    private final IoService service;
    private Worker worker;
    private int pollingInterval = 5000;
    private List polledSessions;
    private final IoServiceListener serviceListener = new IoServiceListener(){

        @Override
        public void serviceActivated(IoService ioService, SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        }

        @Override
        public void serviceDeactivated(IoService ioService, SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
        }

        @Override
        public void sessionCreated(IoSession ioSession) {
            StatCollector.this.addSession(ioSession);
        }

        @Override
        public void sessionDestroyed(IoSession ioSession) {
            StatCollector.this.removeSession(ioSession);
        }
    };

    public StatCollector(IoService ioService) {
        this(ioService, 5000);
    }

    public StatCollector(IoService ioService, int n) {
        this.service = ioService;
        this.pollingInterval = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            if (this.worker != null && this.worker.isAlive()) {
                throw new RuntimeException("Stat collecting already started");
            }
            this.polledSessions = new ArrayList();
            for (SocketAddress socketAddress : this.service.getManagedServiceAddresses()) {
                Iterator iterator = this.service.getManagedSessions(socketAddress).iterator();
                while (iterator.hasNext()) {
                    this.addSession((IoSession)iterator.next());
                }
            }
            this.service.addListener(this.serviceListener);
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            this.service.removeListener(this.serviceListener);
            this.worker.stop = true;
            this.worker.interrupt();
            while (this.worker.isAlive()) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            for (IoSession ioSession : this.polledSessions) {
                ioSession.removeAttribute(KEY);
            }
            this.polledSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            return this.worker != null && !this.worker.stop;
        }
    }

    private void addSession(IoSession ioSession) {
        this.polledSessions.add(ioSession);
        ioSession.setAttribute(KEY, new IoSessionStat());
    }

    private void removeSession(IoSession ioSession) {
        this.polledSessions.remove(ioSession);
        ioSession.removeAttribute(KEY);
    }

    private class Worker
    extends Thread {
        boolean stop;

        private Worker() {
            super("StatCollectorWorker-" + StatCollector.this.id);
            this.stop = false;
        }

        @Override
        public void run() {
            while (!this.stop) {
                IoSessionStat ioSessionStat;
                for (IoSession ioSession : StatCollector.this.polledSessions) {
                    ioSessionStat = (IoSessionStat)ioSession.getAttribute(KEY);
                    ioSessionStat.lastByteRead = ioSession.getReadBytes();
                    ioSessionStat.lastByteWrite = ioSession.getWrittenBytes();
                    ioSessionStat.lastMessageRead = ioSession.getReadMessages();
                    ioSessionStat.lastMessageWrite = ioSession.getWrittenMessages();
                }
                try {
                    Thread.sleep(StatCollector.this.pollingInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (IoSession ioSession : StatCollector.this.polledSessions) {
                    ioSessionStat = (IoSessionStat)ioSession.getAttribute(KEY);
                    ioSessionStat.byteReadThroughput = (float)(ioSession.getReadBytes() - ioSessionStat.lastByteRead) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    ioSessionStat.byteWrittenThroughput = (float)(ioSession.getWrittenBytes() - ioSessionStat.lastByteWrite) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    ioSessionStat.messageReadThroughput = (float)(ioSession.getReadMessages() - ioSessionStat.lastMessageRead) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                    ioSessionStat.messageWrittenThroughput = (float)(ioSession.getWrittenMessages() - ioSessionStat.lastMessageWrite) / ((float)StatCollector.this.pollingInterval / 1000.0f);
                }
            }
        }
    }
}

