/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.impl.PartialDecoder;

public class IntPartialDecoder
implements PartialDecoder<Integer> {
    private int size;
    private int remaining;
    private int value;

    public IntPartialDecoder(int n) {
        this.remaining = n;
        this.size = n;
    }

    public IntPartialDecoder() {
        this(4);
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        if (this.remaining == 0) {
            throw new IllegalStateException();
        }
        while (this.remaining > 0 && byteBuffer.hasRemaining()) {
            this.value = (this.value << 8) + (byteBuffer.get() & 0xFF);
            --this.remaining;
        }
        return this.remaining == 0;
    }

    @Override
    public Integer getValue() {
        if (this.remaining > 0) {
            throw new IllegalStateException();
        }
        return this.value;
    }

    @Override
    public void reset() {
        this.remaining = this.size;
        this.value = 0;
    }
}

