/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2WindowUpdateFrame;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;
import org.apache.mina.http2.impl.IntPartialDecoder;
import org.apache.mina.http2.impl.PartialDecoder;

public class Http2WindowUpdateFrameDecoder
extends Http2FrameDecoder {
    private State state;
    private PartialDecoder<?> decoder;
    private Http2WindowUpdateFrame.Http2WindowUpdateFrameBuilder builder = new Http2WindowUpdateFrame.Http2WindowUpdateFrameBuilder();

    public Http2WindowUpdateFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        this.state = State.INCREMENT;
        this.decoder = new IntPartialDecoder(4);
        this.initBuilder(this.builder);
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        while (this.getValue() == null && byteBuffer.remaining() > 0) {
            switch (this.state) {
                case INCREMENT: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.windowUpdateIncrement(((IntPartialDecoder)this.decoder).getValue());
                    if (this.getHeader().getLength() > 4) {
                        this.state = State.EXTRA;
                        this.decoder = new BytePartialDecoder(this.getHeader().getLength() - 4);
                        break;
                    }
                    this.setValue(this.builder.build());
                    break;
                }
                case EXTRA: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.setValue(this.builder.build());
                }
            }
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }

    private static enum State {
        INCREMENT,
        EXTRA;

    }
}

