/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2UnknownFrame;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;

public class Http2UnknownFrameDecoder
extends Http2FrameDecoder {
    private BytePartialDecoder decoder;
    private Http2UnknownFrame.Http2UnknownFrameBuilder builder = new Http2UnknownFrame.Http2UnknownFrameBuilder();

    public Http2UnknownFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        this.initBuilder(this.builder);
        if (http2FrameHeader.getLength() > 0) {
            this.decoder = new BytePartialDecoder(http2FrameHeader.getLength());
        } else {
            this.setValue(this.builder.build());
        }
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        while (this.getValue() == null && byteBuffer.remaining() > 0) {
            if (!this.decoder.consume(byteBuffer)) continue;
            this.builder.payload(this.decoder.getValue());
            this.setValue(this.builder.build());
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }
}

