/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Setting;
import org.apache.mina.http2.api.Http2SettingsFrame;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;
import org.apache.mina.http2.impl.LongPartialDecoder;

public class Http2SettingsFrameDecoder
extends Http2FrameDecoder {
    private int remaining;
    private LongPartialDecoder decoder = new LongPartialDecoder(6);
    private Http2SettingsFrame.Http2SettingsFrameBuilder builder = new Http2SettingsFrame.Http2SettingsFrameBuilder();
    private List<Http2Setting> settings = new ArrayList<Http2Setting>();

    public Http2SettingsFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        this.remaining = http2FrameHeader.getLength() / 6;
        this.initBuilder(this.builder);
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            this.setValue(this.builder.build());
        }
        while (this.getValue() == null && byteBuffer.remaining() > 0) {
            if (!this.decoder.consume(byteBuffer)) continue;
            --this.remaining;
            Http2Setting http2Setting = new Http2Setting();
            http2Setting.setID((int)((this.decoder.getValue() & 0xFFFF00000000L) >> 32));
            http2Setting.setValue((long)(this.decoder.getValue() & 0xFFFFFFFFL));
            this.settings.add(http2Setting);
            this.decoder.reset();
            if (this.remaining != 0) continue;
            this.builder.settings(this.settings);
            this.setValue(this.builder.build());
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }
}

