/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2RstStreamFrame;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;
import org.apache.mina.http2.impl.LongPartialDecoder;
import org.apache.mina.http2.impl.PartialDecoder;

public class Http2RstStreamFrameDecoder
extends Http2FrameDecoder {
    private State state;
    private PartialDecoder<?> decoder;
    private Http2RstStreamFrame.Http2RstStreamFrameBuilder builder = new Http2RstStreamFrame.Http2RstStreamFrameBuilder();

    public Http2RstStreamFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        this.state = State.ERROR_CODE;
        this.decoder = new LongPartialDecoder(4);
        this.initBuilder(this.builder);
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        while (this.getValue() == null && byteBuffer.remaining() > 0) {
            switch (this.state) {
                case ERROR_CODE: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.errorCode(((LongPartialDecoder)this.decoder).getValue());
                    if (this.getHeader().getLength() > 4) {
                        this.state = State.EXTRA;
                        this.decoder = new BytePartialDecoder(this.getHeader().getLength() - 4);
                        break;
                    }
                    this.setValue(this.builder.build());
                    break;
                }
                case EXTRA: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.setValue(this.builder.build());
                }
            }
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }

    private static enum State {
        ERROR_CODE,
        EXTRA;

    }
}

