/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.impl.Http2ContinuationFrameDecoder;
import org.apache.mina.http2.impl.Http2DataFrameDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;
import org.apache.mina.http2.impl.Http2GoAwayFrameDecoder;
import org.apache.mina.http2.impl.Http2HeadersFrameDecoder;
import org.apache.mina.http2.impl.Http2PingFrameDecoder;
import org.apache.mina.http2.impl.Http2PriorityFrameDecoder;
import org.apache.mina.http2.impl.Http2PushPromiseFrameDecoder;
import org.apache.mina.http2.impl.Http2RstStreamFrameDecoder;
import org.apache.mina.http2.impl.Http2SettingsFrameDecoder;
import org.apache.mina.http2.impl.Http2UnknownFrameDecoder;
import org.apache.mina.http2.impl.Http2WindowUpdateFrameDecoder;

public class Http2RequestDecoder {
    private final Http2FrameHeadePartialDecoder headerDecoder = new Http2FrameHeadePartialDecoder();
    private Http2FrameDecoder frameDecoder;
    private DecoderState decoderState = DecoderState.HEADER;

    public Http2Frame decode(ByteBuffer byteBuffer) {
        Http2Frame http2Frame = null;
        switch (this.decoderState) {
            case HEADER: {
                if (!this.headerDecoder.consume(byteBuffer)) break;
                Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader = this.headerDecoder.getValue();
                this.headerDecoder.reset();
                this.decoderState = DecoderState.FRAME;
                switch (http2FrameHeader.getType()) {
                    case 0: {
                        this.frameDecoder = new Http2DataFrameDecoder(http2FrameHeader);
                        break;
                    }
                    case 1: {
                        this.frameDecoder = new Http2HeadersFrameDecoder(http2FrameHeader);
                        break;
                    }
                    case 2: {
                        this.frameDecoder = new Http2PriorityFrameDecoder(http2FrameHeader);
                        break;
                    }
                    case 3: {
                        this.frameDecoder = new Http2RstStreamFrameDecoder(http2FrameHeader);
                        break;
                    }
                    case 4: {
                        this.frameDecoder = new Http2SettingsFrameDecoder(http2FrameHeader);
                        break;
                    }
                    case 5: {
                        this.frameDecoder = new Http2PushPromiseFrameDecoder(http2FrameHeader);
                        break;
                    }
                    case 6: {
                        this.frameDecoder = new Http2PingFrameDecoder(http2FrameHeader);
                        break;
                    }
                    case 7: {
                        this.frameDecoder = new Http2GoAwayFrameDecoder(http2FrameHeader);
                        break;
                    }
                    case 8: {
                        this.frameDecoder = new Http2WindowUpdateFrameDecoder(http2FrameHeader);
                        break;
                    }
                    case 9: {
                        this.frameDecoder = new Http2ContinuationFrameDecoder(http2FrameHeader);
                        break;
                    }
                    default: {
                        this.frameDecoder = new Http2UnknownFrameDecoder(http2FrameHeader);
                    }
                }
                if (!this.frameDecoder.consume(byteBuffer)) break;
                http2Frame = this.frameDecoder.getValue();
                this.decoderState = DecoderState.HEADER;
                break;
            }
            case FRAME: {
                if (!this.frameDecoder.consume(byteBuffer)) break;
                http2Frame = this.frameDecoder.getValue();
                this.decoderState = DecoderState.HEADER;
            }
        }
        return http2Frame;
    }

    private static enum DecoderState {
        HEADER,
        FRAME;

    }
}

