/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2PushPromiseFrame;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;
import org.apache.mina.http2.impl.IntPartialDecoder;
import org.apache.mina.http2.impl.PartialDecoder;

public class Http2PushPromiseFrameDecoder
extends Http2FrameDecoder {
    private State state;
    private PartialDecoder<?> decoder;
    private int padLength;
    private Http2PushPromiseFrame.Http2PushPromiseFrameBuilder builder = new Http2PushPromiseFrame.Http2PushPromiseFrameBuilder();

    public Http2PushPromiseFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        if (this.isFlagSet((short)8)) {
            this.state = State.PAD_LENGTH;
        } else {
            this.state = State.PROMISED_STREAM;
            this.decoder = new IntPartialDecoder(4);
        }
        this.initBuilder(this.builder);
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        while (this.getValue() == null && byteBuffer.remaining() > 0) {
            switch (this.state) {
                case PAD_LENGTH: {
                    this.padLength = byteBuffer.get();
                    this.state = State.PROMISED_STREAM;
                    this.decoder = new IntPartialDecoder(4);
                    break;
                }
                case PROMISED_STREAM: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.promisedStreamID((int)(((IntPartialDecoder)this.decoder).getValue() & Integer.MAX_VALUE));
                    this.state = State.HEADER;
                    int n = this.getHeader().getLength() - 4;
                    if (this.isFlagSet((short)8)) {
                        n -= this.padLength + 1;
                    }
                    this.decoder = new BytePartialDecoder(n);
                    break;
                }
                case HEADER: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.headerBlockFragment(((BytePartialDecoder)this.decoder).getValue());
                    if (this.isFlagSet((short)8)) {
                        this.state = State.PADDING;
                        this.decoder = new BytePartialDecoder(this.padLength);
                        break;
                    }
                    this.setValue(this.builder.build());
                    break;
                }
                case PADDING: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.padding(((BytePartialDecoder)this.decoder).getValue());
                    this.setValue(this.builder.build());
                }
            }
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }

    private static enum State {
        PAD_LENGTH,
        PROMISED_STREAM,
        HEADER,
        PADDING;

    }
}

