/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2PriorityFrame;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;
import org.apache.mina.http2.impl.IntPartialDecoder;
import org.apache.mina.http2.impl.PartialDecoder;

public class Http2PriorityFrameDecoder
extends Http2FrameDecoder {
    private State state;
    private PartialDecoder<?> decoder;
    private Http2PriorityFrame.Http2PriorityFrameBuilder builder = new Http2PriorityFrame.Http2PriorityFrameBuilder();

    public Http2PriorityFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        this.state = State.STREAM_DEPENDENCY;
        this.decoder = new IntPartialDecoder(4);
        this.initBuilder(this.builder);
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        while (this.getValue() == null && byteBuffer.remaining() > 0) {
            switch (this.state) {
                case STREAM_DEPENDENCY: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.streamDependencyID((int)(((IntPartialDecoder)this.decoder).getValue() & Integer.MAX_VALUE));
                    this.builder.exclusiveMode((((IntPartialDecoder)this.decoder).getValue() & Integer.MIN_VALUE) == Integer.MIN_VALUE);
                    this.state = State.WEIGHT;
                    break;
                }
                case WEIGHT: {
                    this.builder.weight((short)((byteBuffer.get() & 0xFF) + 1));
                    int n = this.getHeader().getLength() - 5;
                    if (n > 0) {
                        this.decoder = new BytePartialDecoder(n);
                        this.state = State.EXTRA;
                        break;
                    }
                    this.setValue(this.builder.build());
                    break;
                }
                case EXTRA: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.setValue(this.builder.build());
                }
            }
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }

    private static enum State {
        STREAM_DEPENDENCY,
        WEIGHT,
        EXTRA;

    }
}

