/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2HeadersFrame;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;
import org.apache.mina.http2.impl.IntPartialDecoder;
import org.apache.mina.http2.impl.PartialDecoder;

public class Http2HeadersFrameDecoder
extends Http2FrameDecoder {
    private State state;
    private PartialDecoder<?> decoder;
    private int padLength;
    private Http2HeadersFrame.Http2HeadersFrameBuilder builder = new Http2HeadersFrame.Http2HeadersFrameBuilder();

    public Http2HeadersFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        if (this.isFlagSet((short)8)) {
            this.state = State.PAD_LENGTH;
        } else if (this.isFlagSet((short)32)) {
            this.state = State.STREAM_DEPENDENCY;
            this.decoder = new IntPartialDecoder(4);
        } else {
            this.state = State.HEADER;
            this.decoder = new BytePartialDecoder(http2FrameHeader.getLength());
        }
        this.initBuilder(this.builder);
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        while (this.getValue() == null && byteBuffer.remaining() > 0) {
            switch (this.state) {
                case PAD_LENGTH: {
                    this.padLength = byteBuffer.get();
                    if (this.isFlagSet((short)32)) {
                        this.decoder = new IntPartialDecoder(4);
                        this.state = State.STREAM_DEPENDENCY;
                        break;
                    }
                    this.state = State.HEADER;
                    this.decoder = new BytePartialDecoder(this.getHeader().getLength() - 1 - this.padLength);
                    break;
                }
                case STREAM_DEPENDENCY: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.streamDependencyID((int)(((IntPartialDecoder)this.decoder).getValue() & Integer.MAX_VALUE));
                    this.builder.exclusiveMode((((IntPartialDecoder)this.decoder).getValue() & Integer.MIN_VALUE) == Integer.MIN_VALUE);
                    this.state = State.WEIGHT;
                    break;
                }
                case WEIGHT: {
                    this.builder.weight((byte)(byteBuffer.get() + 1));
                    this.state = State.HEADER;
                    int n = this.getHeader().getLength() - 5;
                    if (this.isFlagSet((short)8)) {
                        n -= this.padLength + 1;
                    }
                    this.decoder = new BytePartialDecoder(n);
                    break;
                }
                case HEADER: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.headerBlockFragment(((BytePartialDecoder)this.decoder).getValue());
                    if (this.isFlagSet((short)8)) {
                        this.state = State.PADDING;
                        this.decoder = new BytePartialDecoder(this.padLength);
                        break;
                    }
                    this.setValue(this.builder.build());
                    break;
                }
                case PADDING: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.padding(((BytePartialDecoder)this.decoder).getValue());
                    this.setValue(this.builder.build());
                }
            }
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }

    private static enum State {
        PAD_LENGTH,
        STREAM_DEPENDENCY,
        WEIGHT,
        HEADER,
        PADDING;

    }
}

