/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2GoAwayFrame;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;
import org.apache.mina.http2.impl.IntPartialDecoder;
import org.apache.mina.http2.impl.LongPartialDecoder;
import org.apache.mina.http2.impl.PartialDecoder;

public class Http2GoAwayFrameDecoder
extends Http2FrameDecoder {
    private State state;
    private PartialDecoder<?> decoder;
    private Http2GoAwayFrame.Http2GoAwayFrameBuilder builder = new Http2GoAwayFrame.Http2GoAwayFrameBuilder();

    public Http2GoAwayFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        this.state = State.LAST_STREAM_ID;
        this.decoder = new IntPartialDecoder(4);
        this.initBuilder(this.builder);
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        while (this.getValue() == null && byteBuffer.remaining() > 0) {
            switch (this.state) {
                case LAST_STREAM_ID: {
                    if (this.decoder.consume(byteBuffer)) {
                        this.builder.lastStreamID((int)(((IntPartialDecoder)this.decoder).getValue() & Integer.MAX_VALUE));
                        this.state = State.CODE;
                        this.decoder = new LongPartialDecoder(4);
                    }
                }
                case CODE: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.errorCode(((LongPartialDecoder)this.decoder).getValue());
                    if (this.getHeader().getLength() > 8) {
                        this.state = State.EXTRA;
                        this.decoder = new BytePartialDecoder(this.getHeader().getLength() - 8);
                        break;
                    }
                    this.setValue(this.builder.build());
                    break;
                }
                case EXTRA: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.data(((BytePartialDecoder)this.decoder).getValue());
                    this.setValue(this.builder.build());
                }
            }
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }

    private static enum State {
        LAST_STREAM_ID,
        CODE,
        EXTRA;

    }
}

