/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.IntPartialDecoder;
import org.apache.mina.http2.impl.PartialDecoder;

public class Http2FrameHeadePartialDecoder
implements PartialDecoder<Http2FrameHeader> {
    private State state;
    private PartialDecoder<?> decoder;
    private Http2FrameHeader value;

    public Http2FrameHeadePartialDecoder() {
        this.reset();
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining() && this.state != State.END) {
            if (!this.decoder.consume(byteBuffer)) continue;
            switch (this.state) {
                case LENGTH: {
                    this.value.setLength(((IntPartialDecoder)this.decoder).getValue());
                    this.decoder = new BytePartialDecoder(2);
                    this.state = State.TYPE_FLAGS;
                    break;
                }
                case TYPE_FLAGS: {
                    this.value.setType(((BytePartialDecoder)this.decoder).getValue()[0]);
                    this.value.setFlags(((BytePartialDecoder)this.decoder).getValue()[1]);
                    this.decoder = new IntPartialDecoder(4);
                    this.state = State.STREAMID;
                    break;
                }
                case STREAMID: {
                    this.value.setStreamID((int)(((IntPartialDecoder)this.decoder).getValue() & Integer.MAX_VALUE));
                    this.state = State.END;
                }
            }
        }
        return this.state == State.END;
    }

    @Override
    public Http2FrameHeader getValue() {
        return this.value;
    }

    @Override
    public void reset() {
        this.state = State.LENGTH;
        this.decoder = new IntPartialDecoder(3);
        this.value = new Http2FrameHeader();
    }

    private static enum State {
        LENGTH,
        TYPE_FLAGS,
        STREAMID,
        END;

    }

    public static class Http2FrameHeader {
        private int length;
        private short type;
        private byte flags;
        private int streamID;

        public int getLength() {
            return this.length;
        }

        public void setLength(int n) {
            this.length = n;
        }

        public short getType() {
            return this.type;
        }

        public void setType(short s) {
            this.type = s;
        }

        public byte getFlags() {
            return this.flags;
        }

        public void setFlags(byte by) {
            this.flags = by;
        }

        public int getStreamID() {
            return this.streamID;
        }

        public void setStreamID(int n) {
            this.streamID = n;
        }
    }
}

