/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2DataFrame;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;
import org.apache.mina.http2.impl.PartialDecoder;

public class Http2DataFrameDecoder
extends Http2FrameDecoder {
    private State state;
    private PartialDecoder<?> decoder;
    private int padLength;
    private Http2DataFrame.Http2DataFrameBuilder builder = new Http2DataFrame.Http2DataFrameBuilder();

    public Http2DataFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        this.initBuilder(this.builder);
        if (this.isFlagSet((short)8)) {
            this.state = State.PAD_LENGTH;
        } else if (http2FrameHeader.getLength() > 0) {
            this.state = State.DATA;
            this.decoder = new BytePartialDecoder(http2FrameHeader.getLength());
        } else {
            this.setValue(this.builder.build());
        }
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        while (this.getValue() == null && byteBuffer.remaining() > 0) {
            switch (this.state) {
                case PAD_LENGTH: {
                    this.padLength = byteBuffer.get();
                    if (this.getHeader().getLength() - 1 - this.padLength > 0) {
                        this.state = State.DATA;
                        this.decoder = new BytePartialDecoder(this.getHeader().getLength() - 1 - this.padLength);
                        break;
                    }
                    if (this.padLength > 0) {
                        this.state = State.PADDING;
                        this.decoder = new BytePartialDecoder(this.padLength);
                        break;
                    }
                    this.setValue(this.builder.build());
                    break;
                }
                case DATA: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.data(((BytePartialDecoder)this.decoder).getValue());
                    if (this.isFlagSet((short)8) && this.padLength > 0) {
                        this.state = State.PADDING;
                        this.decoder = new BytePartialDecoder(this.padLength);
                        break;
                    }
                    this.setValue(this.builder.build());
                    break;
                }
                case PADDING: {
                    if (!this.decoder.consume(byteBuffer)) break;
                    this.builder.padding(((BytePartialDecoder)this.decoder).getValue());
                    this.setValue(this.builder.build());
                }
            }
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }

    private static enum State {
        PAD_LENGTH,
        DATA,
        PADDING;

    }
}

