/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2ContinuationFrame;
import org.apache.mina.http2.impl.BytePartialDecoder;
import org.apache.mina.http2.impl.Http2FrameDecoder;
import org.apache.mina.http2.impl.Http2FrameHeadePartialDecoder;

public class Http2ContinuationFrameDecoder
extends Http2FrameDecoder {
    private BytePartialDecoder decoder;
    private Http2ContinuationFrame.Http2ContinuationFrameBuilder builder = new Http2ContinuationFrame.Http2ContinuationFrameBuilder();

    public Http2ContinuationFrameDecoder(Http2FrameHeadePartialDecoder.Http2FrameHeader http2FrameHeader) {
        super(http2FrameHeader);
        this.initBuilder(this.builder);
        if (http2FrameHeader.getLength() > 0) {
            this.decoder = new BytePartialDecoder(http2FrameHeader.getLength());
        } else {
            this.setValue(this.builder.build());
        }
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        if (this.decoder != null && this.decoder.consume(byteBuffer)) {
            this.builder.headerBlockFragment(this.decoder.getValue());
            this.setValue(this.builder.build());
        }
        return this.getValue() != null;
    }

    @Override
    public void reset() {
    }
}

