/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.impl;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.impl.PartialDecoder;

public class BytePartialDecoder
implements PartialDecoder<byte[]> {
    private int offset = 0;
    private byte[] value;

    public BytePartialDecoder(int n) {
        this.value = new byte[n];
    }

    @Override
    public boolean consume(ByteBuffer byteBuffer) {
        if (this.value.length - this.offset == 0) {
            throw new IllegalStateException();
        }
        int n = Math.min(byteBuffer.remaining(), this.value.length - this.offset);
        byteBuffer.get(this.value, this.offset, n);
        this.offset += n;
        return this.value.length - this.offset == 0;
    }

    @Override
    public byte[] getValue() {
        if (this.value.length - this.offset > 0) {
            throw new IllegalStateException();
        }
        return this.value;
    }

    @Override
    public void reset() {
        this.offset = 0;
    }
}

