/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Frame;

public class Http2WindowUpdateFrame
extends Http2Frame {
    private final int windowUpdateIncrement;

    public int getWindowUpdateIncrement() {
        return this.windowUpdateIncrement;
    }

    @Override
    public void writePayload(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.getWindowUpdateIncrement());
    }

    protected Http2WindowUpdateFrame(Http2WindowUpdateFrameBuilder http2WindowUpdateFrameBuilder) {
        super(http2WindowUpdateFrameBuilder);
        this.windowUpdateIncrement = http2WindowUpdateFrameBuilder.getWindowUpdateIncrement();
    }

    public static class Http2WindowUpdateFrameBuilder
    extends Http2Frame.AbstractHttp2FrameBuilder<Http2WindowUpdateFrameBuilder, Http2WindowUpdateFrame> {
        private int windowUpdateIncrement;

        public Http2WindowUpdateFrameBuilder windowUpdateIncrement(int n) {
            this.windowUpdateIncrement = n;
            return this;
        }

        public int getWindowUpdateIncrement() {
            return this.windowUpdateIncrement;
        }

        @Override
        public Http2WindowUpdateFrame build() {
            if (this.getLength() == -1) {
                this.setLength(4);
            }
            return new Http2WindowUpdateFrame((Http2WindowUpdateFrameBuilder)this.type((short)8));
        }

        public static Http2WindowUpdateFrameBuilder builder() {
            return new Http2WindowUpdateFrameBuilder();
        }
    }
}

