/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Http2ResponseMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.http2.api.Http2ContinuationFrame;
import org.apache.mina.http2.api.Http2DataFrame;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.api.Http2GoAwayFrame;
import org.apache.mina.http2.api.Http2HeadersFrame;
import org.apache.mina.http2.api.Http2PushPromiseFrame;
import org.apache.mina.http2.api.Http2ServerConnectionSettings;
import org.apache.mina.http2.api.Http2SettingsModel;
import org.apache.mina.http2.api.Http2Stream;
import org.apache.mina.http2.api.Http2WindowUpdateFrame;
import org.apache.mina.http2.impl.ConnectionErrorException;
import org.apache.mina.http2.impl.StreamErrorException;

public class Http2StreamManager {
    private NavigableMap<Integer, Http2Stream> streams = new ConcurrentSkipListMap<Integer, Http2Stream>();
    private Integer lastStreamToProcess = null;
    private Http2ServerConnectionSettings settings = new Http2ServerConnectionSettings();
    private ConcurrentSkipListSet<Integer> pendingOutputStreams = new ConcurrentSkipListSet();
    private AtomicLong connectionInputWindow = new AtomicLong(65535L);
    private AtomicLong connectionOutputWindow = new AtomicLong(65535L);
    private AtomicInteger lastClientInitiatedStream = new AtomicInteger(0);
    private AtomicInteger lastServerInitiatedStream = new AtomicInteger(0);
    private final boolean traceLogging;
    private static final Class<Http2StreamManager> CLASS = Http2StreamManager.class;

    public Http2StreamManager(boolean bl) {
        this.traceLogging = bl;
    }

    public void closeStream(int n) {
        Http2Stream http2Stream = (Http2Stream)this.streams.get(n);
        if (http2Stream == null) {
            Http2Stream http2Stream2 = Http2Stream.createAndClose(n);
            this.streams.put(n, http2Stream2);
        } else {
            http2Stream.close();
        }
    }

    public boolean createStream(Http2HeadersFrame http2HeadersFrame) {
        int n = http2HeadersFrame.getStreamID();
        this.lastClientInitiatedStream.set(n);
        if (this.lastStreamToProcess != null && n > this.lastStreamToProcess) {
            return false;
        }
        Http2Stream http2Stream = Http2Stream.createFromHeadersFrame(http2HeadersFrame, this.settings);
        this.streams.put(n, http2Stream);
        return true;
    }

    public int createStream(Http2PushPromiseFrame http2PushPromiseFrame) {
        int n = this.lastServerInitiatedStream.addAndGet(2);
        Http2Stream http2Stream = Http2Stream.createFromPushPromise(http2PushPromiseFrame, n, this.settings);
        this.streams.put(n, http2Stream);
        return n;
    }

    public Http2HeadersFrame onContinuationFrame(Http2ContinuationFrame http2ContinuationFrame) {
        int n = http2ContinuationFrame.getStreamID();
        Http2Stream http2Stream = (Http2Stream)this.streams.get(n);
        if (http2Stream != null) {
            return http2Stream.onContinuationFrame(http2ContinuationFrame);
        }
        return null;
    }

    public Http2GoAwayFrame createConnectionError(int n, String string) {
        this.lastStreamToProcess = this.lastClientInitiatedStream.get();
        Http2GoAwayFrame.Http2GoAwayFrameBuilder http2GoAwayFrameBuilder = (Http2GoAwayFrame.Http2GoAwayFrameBuilder)((Http2GoAwayFrame.Http2GoAwayFrameBuilder)Http2GoAwayFrame.Http2GoAwayFrameBuilder.builder().errorCode(n).streamID(0)).lastStreamID(this.lastClientInitiatedStream.get()).endStream();
        if (string != null) {
            http2GoAwayFrameBuilder.data(string.getBytes());
        }
        return http2GoAwayFrameBuilder.build();
    }

    public void updateClientSettings(Http2SettingsModel http2SettingsModel) throws Exception {
        Http2SettingsModel http2SettingsModel2 = this.settings.getClientSettings();
        this.settings.updateClientSettings(http2SettingsModel);
        Http2SettingsModel http2SettingsModel3 = this.settings.getClientSettings();
        long l = http2SettingsModel3.getInitialWindowSize() - http2SettingsModel2.getInitialWindowSize();
        for (Http2Stream http2Stream : this.streams.values()) {
            http2Stream.updateOutputWindowSize(l);
        }
    }

    public long updateWindow(int n, int n2) throws Exception {
        return ((Http2Stream)this.streams.get(n)).updateOutputWindowSize(n2);
    }

    public Http2Stream.StreamState getStreamState(int n) {
        Http2Stream http2Stream = (Http2Stream)this.streams.get(n);
        if (http2Stream != null) {
            return http2Stream.getStreamState();
        }
        if (this.isStreamClosed(n)) {
            return Http2Stream.StreamState.CLOSED;
        }
        return Http2Stream.StreamState.IDLE;
    }

    private boolean isStreamClosed(int n) {
        boolean bl;
        boolean bl2 = bl = n % 2 != 0;
        if (bl) {
            return this.lastClientInitiatedStream.get() > n;
        }
        return this.lastServerInitiatedStream.get() > n;
    }

    public List<Http2Frame> onSendResponse(Http2ResponseMessage http2ResponseMessage) {
        long l;
        Http2Stream http2Stream = (Http2Stream)this.streams.get(http2ResponseMessage.getHttp2StreamID());
        List<Http2Frame> list = http2Stream.sendResponse(http2ResponseMessage, l = this.getAndUpdateWindowSize(http2Stream, http2ResponseMessage.getBodyLength()));
        if (!Http2StreamManager.isStreamEnded(list)) {
            this.pendingOutputStreams.add(http2ResponseMessage.getHttp2StreamID());
        }
        return list;
    }

    public List<Http2DataFrame> onWindowUpdate(Http2WindowUpdateFrame http2WindowUpdateFrame) throws ConnectionErrorException, StreamErrorException {
        List<Http2DataFrame> list = new ArrayList<Http2DataFrame>();
        Integer n = http2WindowUpdateFrame.getStreamID();
        if (Http2StreamManager.isConnectionWindowUpdate(n)) {
            long l = this.updateConnectionWindow(http2WindowUpdateFrame.getWindowUpdateIncrement());
            for (Integer n2 : this.pendingOutputStreams) {
                Http2Stream http2Stream = (Http2Stream)this.streams.get(n2);
                long l2 = this.getAndUpdateWindowSize(http2Stream, http2Stream.getDataPayloadLength());
                if (l2 == 0L) continue;
                List<Http2DataFrame> list2 = http2Stream.sendData(l2);
                if (Http2StreamManager.isStreamEnded(list)) {
                    this.pendingOutputStreams.remove(http2Stream.getStreamID());
                }
                list.addAll(list2);
            }
        } else {
            Http2Stream http2Stream = (Http2Stream)this.streams.get(n);
            http2Stream.updateOutputWindowSize(http2WindowUpdateFrame.getWindowUpdateIncrement());
            if (this.pendingOutputStreams.contains(n)) {
                long l = this.getAndUpdateWindowSize(http2Stream, http2Stream.getDataPayloadLength());
                if (l == 0L) {
                    return Collections.emptyList();
                }
                list = http2Stream.sendData(l);
                if (Http2StreamManager.isStreamEnded(list)) {
                    this.pendingOutputStreams.remove(n);
                }
            }
        }
        return list;
    }

    private static boolean isStreamEnded(List<? extends Http2Frame> list) {
        return !list.isEmpty() && list.get(list.size() - 1).isEndStream();
    }

    private static boolean isConnectionWindowUpdate(int n) {
        return n == 0;
    }

    public long updateConnectionWindow(int n) throws ConnectionErrorException {
        long l = this.connectionOutputWindow.addAndGet(n);
        if (l > Integer.MAX_VALUE) {
            throw new ConnectionErrorException(3, "connection flow control window overflow");
        }
        return l;
    }

    private synchronized long getAndUpdateWindowSize(Http2Stream http2Stream, long l) {
        long l2 = this.connectionOutputWindow.get();
        long l3 = http2Stream.getOutputWindowSize();
        long l4 = Math.min(l2, l3);
        long l5 = Math.min(l4, l);
        try {
            if (l5 > 0L) {
                this.connectionOutputWindow.addAndGet(l5 * -1L);
                http2Stream.updateOutputWindowSize(l5 * -1L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l5;
    }

    public void close() {
        if (this.traceLogging) {
            if (this.pendingOutputStreams.size() > 0) {
                for (Integer n : this.pendingOutputStreams) {
                    WMSLoggerFactory.getLogger(CLASS).info("Outstanding stalled stream found when closing HTTP2Connection: " + this.streams.get(n));
                }
            } else {
                WMSLoggerFactory.getLogger(CLASS).info("NO outstanding stalled streams found when closing HTTP2Connection");
            }
        }
    }
}

