/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Http2ResponseMessage;
import com.wowza.wms.server.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.http2.api.Http2ContinuationFrame;
import org.apache.mina.http2.api.Http2DataFrame;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.api.Http2HeadersFrame;
import org.apache.mina.http2.api.Http2PushPromiseFrame;
import org.apache.mina.http2.api.Http2ServerConnectionSettings;
import org.apache.mina.http2.impl.StreamErrorException;

public class Http2Stream {
    private static final Class<Http2Stream> CLASS = Http2Stream.class;
    private boolean inputClosed = false;
    private boolean outputClosed = false;
    private boolean isIdle = false;
    private final int streamId;
    private Http2HeadersFrame bufferedHeader = null;
    private Http2ResponseMessage stalledResponse;
    private boolean isServerInitiated = false;
    public AtomicLong inputCredit;
    public AtomicLong outputCredit;
    private int maxFrameSize;
    private int maxHeaderTableSize;
    private final long streamCreationTime;
    private boolean traceHttp2;

    private Http2Stream(Http2HeadersFrame http2HeadersFrame, Http2ServerConnectionSettings http2ServerConnectionSettings) {
        if (http2HeadersFrame.isEndHeaders()) {
            this.inputClosed = true;
        } else {
            this.bufferedHeader = http2HeadersFrame;
        }
        this.isIdle = false;
        this.streamId = http2HeadersFrame.getStreamID();
        this.outputCredit = new AtomicLong(http2ServerConnectionSettings.getClientSettings().getInitialWindowSize());
        this.inputCredit = new AtomicLong(http2ServerConnectionSettings.getServerSettings().getInitialWindowSize());
        this.maxFrameSize = http2ServerConnectionSettings.getClientSettings().getMaxFrameSize();
        this.maxHeaderTableSize = http2ServerConnectionSettings.getClientSettings().getHeaderTableSize();
        this.streamCreationTime = System.currentTimeMillis();
        this.initializeLoggingValues();
    }

    private Http2Stream(Http2PushPromiseFrame http2PushPromiseFrame, int n, Http2ServerConnectionSettings http2ServerConnectionSettings) {
        this.isIdle = false;
        this.isServerInitiated = true;
        this.streamId = n;
        this.outputCredit = new AtomicLong(http2ServerConnectionSettings.getClientSettings().getInitialWindowSize());
        this.inputCredit = new AtomicLong(http2ServerConnectionSettings.getServerSettings().getInitialWindowSize());
        this.maxFrameSize = http2ServerConnectionSettings.getClientSettings().getMaxFrameSize();
        this.maxHeaderTableSize = http2ServerConnectionSettings.getClientSettings().getHeaderTableSize();
        this.streamCreationTime = System.currentTimeMillis();
        this.initializeLoggingValues();
    }

    private Http2Stream(int n) {
        this.isIdle = false;
        this.streamId = n;
        this.streamCreationTime = System.currentTimeMillis();
        this.initializeLoggingValues();
    }

    private void initializeLoggingValues() {
        Server server = Server.getInstance();
        this.traceHttp2 = server.traceHttp2Connections();
    }

    public static Http2Stream createFromHeadersFrame(Http2HeadersFrame http2HeadersFrame, Http2ServerConnectionSettings http2ServerConnectionSettings) {
        Http2Stream http2Stream = new Http2Stream(http2HeadersFrame, http2ServerConnectionSettings);
        return http2Stream;
    }

    public static Http2Stream createFromPushPromise(Http2PushPromiseFrame http2PushPromiseFrame, int n, Http2ServerConnectionSettings http2ServerConnectionSettings) {
        Http2Stream http2Stream = new Http2Stream(http2PushPromiseFrame, n, http2ServerConnectionSettings);
        return http2Stream;
    }

    public void close() {
        this.outputClosed = true;
        this.inputClosed = true;
    }

    public Http2HeadersFrame onContinuationFrame(Http2ContinuationFrame http2ContinuationFrame) {
        if (this.bufferedHeader != null) {
            this.bufferedHeader.append(http2ContinuationFrame);
            if (http2ContinuationFrame.isEndHeaders()) {
                this.inputClosed = true;
                return this.bufferedHeader;
            }
        }
        return null;
    }

    public boolean isInputClosed() {
        return this.inputClosed;
    }

    public void closeInput() {
        this.inputClosed = true;
    }

    public boolean isOutboundClosed() {
        return this.outputClosed;
    }

    public void closeOutput() {
        this.outputClosed = true;
    }

    public StreamState getStreamState() {
        if (this.isIdle) {
            return StreamState.IDLE;
        }
        if (this.inputClosed && this.outputClosed) {
            return StreamState.CLOSED;
        }
        if (this.inputClosed) {
            return StreamState.HALF_CLOSED_REMOTE;
        }
        if (this.outputClosed) {
            return StreamState.HALF_CLOSED_LOCAL;
        }
        if (this.isServerInitiated) {
            return StreamState.RESERVED_LOCAL;
        }
        return StreamState.OPEN;
    }

    public static Http2Stream createAndClose(int n) {
        Http2Stream http2Stream = new Http2Stream(n);
        http2Stream.close();
        return http2Stream;
    }

    public long updateOutputWindowSize(long l) throws StreamErrorException {
        long l2 = this.outputCredit.addAndGet(l);
        if (l2 > Integer.MAX_VALUE) {
            throw new StreamErrorException(3, "stream overflow");
        }
        return l2;
    }

    public long getOutputWindowSize() {
        return this.outputCredit.get();
    }

    public int getStreamID() {
        return this.streamId;
    }

    public List<Http2Frame> sendResponse(Http2ResponseMessage http2ResponseMessage, long l) {
        boolean bl;
        ArrayList<Http2Frame> arrayList = new ArrayList<Http2Frame>();
        boolean bl2 = bl = http2ResponseMessage.isSendBody() && http2ResponseMessage.getBodyLength() != 0;
        if (bl) {
            arrayList.addAll(http2ResponseMessage.outputData(l, this.maxFrameSize));
            if (!arrayList.isEmpty()) {
                if (((Http2Frame)arrayList.get(arrayList.size() - 1)).isEndStream()) {
                    this.stalledResponse = null;
                    if (this.traceHttp2) {
                        WMSLoggerFactory.getLogger(CLASS).info("Stream: " + this.getStreamID() + ", sending ENTIRE response " + this.getTimeDiffFromCreation() + " milliseconds after creation");
                    }
                } else {
                    if (this.traceHttp2) {
                        WMSLoggerFactory.getLogger(CLASS).info("Stream: " + this.getStreamID() + ", sending INITIAL PARTIAL response" + this.getTimeDiffFromCreation() + " milliseconds after creation");
                    }
                    this.stalledResponse = http2ResponseMessage;
                }
            }
        }
        if (http2ResponseMessage.isSendHeader() && !http2ResponseMessage.isHeadersSent()) {
            Http2HeadersFrame http2HeadersFrame = http2ResponseMessage.toHeader(!bl);
            arrayList.add(0, http2HeadersFrame);
            http2ResponseMessage.setHeadersSent(true);
            if (this.isServerInitiated) {
                this.closeInput();
            }
        }
        return arrayList;
    }

    private long getTimeDiffFromCreation() {
        return System.currentTimeMillis() - this.streamCreationTime;
    }

    public synchronized List<Http2DataFrame> sendData(long l) {
        List<Http2DataFrame> list = new ArrayList<Http2DataFrame>();
        if (this.stalledResponse == null) {
            return list;
        }
        list = this.stalledResponse.outputData(l, this.maxFrameSize);
        if (!list.isEmpty()) {
            if (list.get(list.size() - 1).isEndStream()) {
                this.stalledResponse = null;
                if (this.traceHttp2) {
                    WMSLoggerFactory.getLogger(CLASS).info("Stream: " + this.getStreamID() + ", sending FINAL part of response " + this.getTimeDiffFromCreation() + " milliseconds after creation");
                }
            } else if (this.traceHttp2) {
                WMSLoggerFactory.getLogger(CLASS).info("Stream: " + this.getStreamID() + ", sending PARTIAL part of response " + this.getTimeDiffFromCreation() + " milliseconds after creation");
            }
        }
        return list;
    }

    public synchronized long getDataPayloadLength() {
        if (this.stalledResponse != null) {
            return this.stalledResponse.getBytesRemainingInBody();
        }
        return 0L;
    }

    public synchronized String toString() {
        return "Http2Stream [inputClosed=" + this.inputClosed + ", outputClosed=" + this.outputClosed + ", isIdle=" + this.isIdle + ", streamId=" + this.streamId + ", isServerInitiated=" + this.isServerInitiated + ", inputCredit=" + this.inputCredit + ", outputCredit=" + this.outputCredit + ", maxFrameSize=" + this.maxFrameSize + ", maxHeaderTableSize=" + this.maxHeaderTableSize + ", stalledResponse=" + this.stalledResponse + (String)(this.stalledResponse != null ? "bytes remaining in response: " + this.stalledResponse.getBytesRemainingInBody() : "") + "]";
    }

    public static enum StreamState {
        IDLE,
        RESERVED_LOCAL,
        RESERVED_REMOTE,
        OPEN,
        HALF_CLOSED_REMOTE,
        HALF_CLOSED_LOCAL,
        CLOSED;

    }
}

