/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import java.util.List;
import org.apache.mina.http2.api.Http2Setting;
import org.apache.mina.http2.api.Http2SettingsFrame;

public class Http2SettingsModel {
    private boolean isPushEnabled = true;
    private int headerTableSize = 4096;
    private long initialWindowSize = 65535L;
    private long maxConcurrentStreams = Integer.MAX_VALUE;
    private int maxFrameSize = 16384;
    private int maxHeaderListSize = Integer.MAX_VALUE;

    private Http2SettingsModel(boolean bl) {
        this.isPushEnabled = !bl;
    }

    public Http2SettingsModel(Http2SettingsFrame http2SettingsFrame) throws Exception {
        List<Http2Setting> list = http2SettingsFrame.getSettings();
        for (Http2Setting http2Setting : list) {
            switch (http2Setting.getID()) {
                case 1: {
                    this.headerTableSize = Long.valueOf(http2Setting.getValue()).intValue();
                    break;
                }
                case 2: {
                    long l = http2Setting.getValue();
                    if (l != 0L && l != 1L) {
                        throw new Exception("invalid settings frame setting");
                    }
                    this.isPushEnabled = l == 1L;
                    break;
                }
                case 3: {
                    this.maxConcurrentStreams = http2Setting.getValue();
                    break;
                }
                case 4: {
                    long l = http2Setting.getValue();
                    if (this.initialWindowSize > Integer.MAX_VALUE) {
                        throw new Exception("invalid initial window size setting");
                    }
                    this.initialWindowSize = l;
                    break;
                }
                case 5: {
                    Long l = http2Setting.getValue();
                    if (l < 16384L || l > 0xFFFFFFL) {
                        throw new Exception("invalid max frame size setting");
                    }
                    this.maxFrameSize = l.intValue();
                    break;
                }
                case 6: {
                    Long l = http2Setting.getValue();
                    this.maxHeaderListSize = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : l.intValue();
                }
            }
        }
    }

    public static Http2SettingsModel getServerSettingsDefaults() {
        return new Http2SettingsModel(true);
    }

    public static Http2SettingsModel getClientSettingsDefaults() {
        return new Http2SettingsModel(false);
    }

    public int getHeaderTableSize() {
        return this.headerTableSize;
    }

    public boolean isPushEnabled() {
        return this.isPushEnabled;
    }

    public long getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public long getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public String toString() {
        return "Http2SettingsModel [isPushEnabled=" + this.isPushEnabled + ", headerTableSize=" + this.headerTableSize + ", initialWindowSize=" + this.initialWindowSize + ", maxConcurrentStreams=" + this.maxConcurrentStreams + ", maxFrameSize=" + this.maxFrameSize + ", maxHeaderListSize=" + this.maxHeaderListSize + "]";
    }

    public Http2SettingsFrame toFrame() {
        Http2Setting http2Setting = new Http2Setting(2, this.isPushEnabled ? 1L : 0L);
        Http2Setting http2Setting2 = new Http2Setting(1, this.headerTableSize);
        Http2Setting http2Setting3 = new Http2Setting(4, this.initialWindowSize);
        Http2Setting http2Setting4 = new Http2Setting(3, this.maxConcurrentStreams);
        Http2Setting http2Setting5 = new Http2Setting(5, this.maxFrameSize);
        Http2Setting http2Setting6 = new Http2Setting(6, this.maxHeaderListSize);
        return ((Http2SettingsFrame.Http2SettingsFrameBuilder)Http2SettingsFrame.Http2SettingsFrameBuilder.builder().settings(List.of(http2Setting, http2Setting2, http2Setting3, http2Setting4, http2Setting5, http2Setting6)).streamID(0)).build();
    }
}

