/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import java.util.Collections;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.api.Http2Setting;

public class Http2SettingsFrame
extends Http2Frame {
    private final List<Http2Setting> settings;

    public List<Http2Setting> getSettings() {
        return this.settings;
    }

    @Override
    public void writePayload(ByteBuffer byteBuffer) {
        for (Http2Setting http2Setting : this.getSettings()) {
            byteBuffer.putShort((short)http2Setting.getID());
            byteBuffer.putInt((int)http2Setting.getValue());
        }
    }

    protected Http2SettingsFrame(Http2SettingsFrameBuilder http2SettingsFrameBuilder) {
        super(http2SettingsFrameBuilder);
        this.settings = http2SettingsFrameBuilder.getSettings();
    }

    public boolean isAckSettingsFrame() {
        return this.isFlagSet((byte)1);
    }

    public static Http2SettingsFrame getConnectionSettingsDefaults() {
        Http2Setting http2Setting = new Http2Setting(1, 4096L);
        Http2Setting http2Setting2 = new Http2Setting(3, Integer.MAX_VALUE);
        Http2Setting http2Setting3 = new Http2Setting(4, 65535L);
        return ((Http2SettingsFrameBuilder)Http2SettingsFrameBuilder.builder().settings(List.of(http2Setting, http2Setting2, http2Setting3)).streamID(0)).build();
    }

    public static Http2SettingsFrame createAcknowledgementSettignsFrame() {
        return Http2SettingsFrameBuilder.builder().setAckFlag().build();
    }

    public static class Http2SettingsFrameBuilder
    extends Http2Frame.AbstractHttp2FrameBuilder<Http2SettingsFrameBuilder, Http2SettingsFrame> {
        private List<Http2Setting> settings = Collections.emptyList();

        public Http2SettingsFrameBuilder settings(List<Http2Setting> list) {
            this.settings = list;
            return this;
        }

        public List<Http2Setting> getSettings() {
            return this.settings;
        }

        @Override
        public Http2SettingsFrame build() {
            if (this.getLength() == -1) {
                this.setLength(this.getSettings().size() * 6);
            }
            return new Http2SettingsFrame((Http2SettingsFrameBuilder)this.type((short)4));
        }

        public Http2SettingsFrameBuilder setAckFlag() {
            this.addFlag((byte)1);
            return this;
        }

        public static Http2SettingsFrameBuilder builder() {
            return new Http2SettingsFrameBuilder();
        }
    }
}

