/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.http2.api.Http2DataFrame;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.api.Http2HeadersFrame;

public class Http2ResponseModel {
    private boolean hasEndStreamFlagSet = false;
    private final ArrayList<Http2Frame> frames;

    public Http2ResponseModel(ArrayList<Http2Frame> arrayList) {
        if (!arrayList.isEmpty() && arrayList.get(arrayList.size() - 1).isEndStream()) {
            this.hasEndStreamFlagSet = true;
        }
        this.frames = arrayList;
    }

    public Http2ResponseModel() {
        this.frames = new ArrayList();
    }

    public void addData(Http2DataFrame http2DataFrame) {
        this.frames.add(http2DataFrame);
        if (http2DataFrame.isEndStream()) {
            this.hasEndStreamFlagSet = true;
        }
    }

    public void addHeaders(Http2HeadersFrame http2HeadersFrame) {
        this.frames.add(0, http2HeadersFrame);
        if (http2HeadersFrame.isEndStream()) {
            this.hasEndStreamFlagSet = true;
        }
    }

    public boolean isEndStreamFlagSet() {
        return this.hasEndStreamFlagSet;
    }

    public int size() {
        return this.frames.size();
    }

    public void addAll(List<Http2DataFrame> list) {
        this.frames.addAll(list);
    }
}

