/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import java.io.IOException;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.api.Http2FrameWithHeaders;

public class Http2PushPromiseFrame
extends Http2FrameWithHeaders {
    private final byte[] padding;
    private int promisedStreamID;

    public byte[] getPadding() {
        return this.padding;
    }

    public int getPromisedStreamID() {
        return this.promisedStreamID;
    }

    @Override
    public void writePayload(ByteBuffer byteBuffer) {
        if (this.isFlagSet((byte)8)) {
            byteBuffer.put((byte)this.getPadding().length);
        }
        byteBuffer.putInt(this.getPromisedStreamID());
        if (this.getHeaderBlockFragment() != null) {
            byteBuffer.put(this.getHeaderBlockFragment());
        }
        if (this.isFlagSet((byte)8)) {
            byteBuffer.put(this.getPadding());
        }
    }

    @Override
    public int getLength() {
        int n = this.getHeaderBlockFragment().length + 4;
        if (this.isFlagSet((byte)8)) {
            n += this.getPadding() == null ? 0 : this.getPadding().length + 1;
        }
        return n;
    }

    protected Http2PushPromiseFrame(Http2PushPromiseFrameBuilder http2PushPromiseFrameBuilder) {
        super(http2PushPromiseFrameBuilder);
        this.padding = http2PushPromiseFrameBuilder.getPadding();
        this.promisedStreamID = http2PushPromiseFrameBuilder.getPromisedStreamID();
        this.headerBlockFragment = http2PushPromiseFrameBuilder.getHeaderBlockFragment();
        this.headers = http2PushPromiseFrameBuilder.headers;
    }

    public void setPromisedStreamId(int n) {
        this.promisedStreamID = n;
    }

    public static class Http2PushPromiseFrameBuilder
    extends Http2Frame.AbstractHttp2FrameBuilder<Http2PushPromiseFrameBuilder, Http2PushPromiseFrame> {
        private byte[] padding = null;
        private int promisedStreamID;
        private byte[] headerBlockFragment = null;
        private Map<String, String> headers = new Http2FrameWithHeaders.HeaderMap<String, String>();

        public Http2PushPromiseFrameBuilder padding(byte[] byArray) {
            this.padding = byArray;
            this.addFlag((byte)8);
            return this;
        }

        public byte[] getPadding() {
            return this.padding;
        }

        public Http2PushPromiseFrameBuilder promisedStreamID(int n) {
            this.promisedStreamID = n;
            return this;
        }

        public int getPromisedStreamID() {
            return this.promisedStreamID;
        }

        public Http2PushPromiseFrameBuilder headerBlockFragment(byte[] byArray) {
            this.headerBlockFragment = byArray;
            return this;
        }

        public byte[] getHeaderBlockFragment() {
            return this.headerBlockFragment;
        }

        public Http2PushPromiseFrameBuilder header(String string, String string2) throws IOException {
            this.headers.put(string, string2);
            return this;
        }

        public Http2PushPromiseFrameBuilder headers(Map<String, String> map) throws IOException {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
            return this;
        }

        @Override
        public Http2PushPromiseFrame build() {
            return new Http2PushPromiseFrame((Http2PushPromiseFrameBuilder)this.type((short)5));
        }

        public static Http2PushPromiseFrameBuilder builder() {
            return new Http2PushPromiseFrameBuilder();
        }
    }
}

