/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Frame;

public class Http2PriorityFrame
extends Http2Frame {
    private final int streamDependencyID;
    private boolean exclusiveMode;
    private final short weight;

    public int getStreamDependencyID() {
        return this.streamDependencyID;
    }

    public boolean getExclusiveMode() {
        return this.exclusiveMode;
    }

    public short getWeight() {
        return this.weight;
    }

    @Override
    public void writePayload(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.getExclusiveMode() ? Integer.MIN_VALUE | this.getStreamDependencyID() : this.getStreamDependencyID());
        byteBuffer.put((byte)(this.getWeight() - 1));
    }

    protected Http2PriorityFrame(Http2PriorityFrameBuilder http2PriorityFrameBuilder) {
        super(http2PriorityFrameBuilder);
        this.streamDependencyID = http2PriorityFrameBuilder.getStreamDependencyID();
        this.exclusiveMode = http2PriorityFrameBuilder.exclusiveMode;
        this.weight = http2PriorityFrameBuilder.getWeight();
    }

    public static class Http2PriorityFrameBuilder
    extends Http2Frame.AbstractHttp2FrameBuilder<Http2PriorityFrameBuilder, Http2PriorityFrame> {
        private int streamDependencyID;
        private boolean exclusiveMode;
        private short weight;

        public Http2PriorityFrameBuilder streamDependencyID(int n) {
            this.streamDependencyID = n;
            return this;
        }

        public int getStreamDependencyID() {
            return this.streamDependencyID;
        }

        public Http2PriorityFrameBuilder exclusiveMode(boolean bl) {
            this.exclusiveMode = bl;
            return this;
        }

        public boolean getExclusiveMode() {
            return this.exclusiveMode;
        }

        public Http2PriorityFrameBuilder weight(short s) {
            this.weight = s;
            return this;
        }

        public short getWeight() {
            return this.weight;
        }

        @Override
        public Http2PriorityFrame build() {
            if (this.getLength() == -1) {
                this.setLength(5);
            }
            return new Http2PriorityFrame((Http2PriorityFrameBuilder)this.type((short)2));
        }

        public static Http2PriorityFrameBuilder builder() {
            return new Http2PriorityFrameBuilder();
        }
    }
}

