/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import java.util.Arrays;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2ContinuationFrame;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.api.Http2FrameWithHeaders;

public class Http2HeadersFrame
extends Http2FrameWithHeaders {
    private final byte[] padding;
    private final int streamDependencyID;
    private final boolean exclusiveMode;
    private final short weight;

    public byte[] getPadding() {
        return this.padding;
    }

    public int getStreamDependencyID() {
        return this.streamDependencyID;
    }

    public boolean getExclusiveMode() {
        return this.exclusiveMode;
    }

    public short getWeight() {
        return this.weight;
    }

    @Override
    public void writePayload(ByteBuffer byteBuffer) {
        if (this.isFlagSet((byte)8)) {
            byteBuffer.put((byte)this.getPadding().length);
        }
        if (this.isFlagSet((byte)32)) {
            byteBuffer.putInt(this.getExclusiveMode() ? Integer.MIN_VALUE | this.getStreamDependencyID() : this.getStreamDependencyID());
            byteBuffer.put((byte)(this.getWeight() - 1));
        }
        if (this.getHeaderBlockFragment() != null) {
            byteBuffer.put(this.getHeaderBlockFragment());
        }
        if (this.isFlagSet((byte)8)) {
            byteBuffer.put(this.getPadding());
        }
    }

    public Http2HeadersFrame append(Http2ContinuationFrame http2ContinuationFrame) {
        int n = http2ContinuationFrame.getHeaderBlockFragment().length;
        int n2 = this.headerBlockFragment.length;
        this.headerBlockFragment = Arrays.copyOf(this.headerBlockFragment, n2 + n);
        System.arraycopy(http2ContinuationFrame.getHeaderBlockFragment(), 0, this.headerBlockFragment, n2, n);
        if (http2ContinuationFrame.isEndHeaders()) {
            this.endHeaders();
        }
        return this;
    }

    @Override
    public int getLength() {
        int n = this.getHeaderBlockFragment().length;
        if (this.isFlagSet((byte)8)) {
            n += this.getPadding() == null ? 0 : this.getPadding().length + 1;
        }
        if (this.isFlagSet((byte)32)) {
            n += 5;
        }
        return n;
    }

    protected Http2HeadersFrame(Http2HeadersFrameBuilder http2HeadersFrameBuilder) {
        super(http2HeadersFrameBuilder);
        this.padding = http2HeadersFrameBuilder.getPadding();
        this.streamDependencyID = http2HeadersFrameBuilder.getStreamDependencyID();
        this.exclusiveMode = http2HeadersFrameBuilder.getExclusiveMode();
        this.weight = http2HeadersFrameBuilder.getWeight();
        this.headerBlockFragment = http2HeadersFrameBuilder.getHeaderBlockFragment();
        this.headers = http2HeadersFrameBuilder.headers;
    }

    public static class Http2HeadersFrameBuilder
    extends Http2Frame.AbstractHttp2FrameBuilder<Http2HeadersFrameBuilder, Http2HeadersFrame> {
        private byte[] padding = null;
        private int streamDependencyID;
        private short weight;
        private byte[] headerBlockFragment = null;
        private boolean exclusiveMode;
        private Map<String, String> headers = new Http2FrameWithHeaders.HeaderMap<String, String>();

        public Http2HeadersFrameBuilder padding(byte[] byArray) {
            this.padding = byArray;
            this.addFlag((byte)8);
            return this;
        }

        public byte[] getPadding() {
            return this.padding;
        }

        public Http2HeadersFrameBuilder streamDependencyID(int n) {
            this.streamDependencyID = n;
            this.addFlag((byte)32);
            return this;
        }

        public int getStreamDependencyID() {
            return this.streamDependencyID;
        }

        public Http2HeadersFrameBuilder exclusiveMode(boolean bl) {
            this.exclusiveMode = bl;
            this.addFlag((byte)32);
            return this;
        }

        public boolean getExclusiveMode() {
            return this.exclusiveMode;
        }

        public Http2HeadersFrameBuilder weight(short s) {
            this.weight = s;
            this.addFlag((byte)32);
            return this;
        }

        public short getWeight() {
            return this.weight;
        }

        public Http2HeadersFrameBuilder headerBlockFragment(byte[] byArray) {
            this.headerBlockFragment = byArray;
            return this;
        }

        public byte[] getHeaderBlockFragment() {
            return this.headerBlockFragment;
        }

        public Http2HeadersFrameBuilder header(String string, String string2) {
            this.headers.put(string, string2);
            return this;
        }

        public Http2HeadersFrameBuilder headers(Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
            return this;
        }

        @Override
        public Http2HeadersFrame build() {
            return new Http2HeadersFrame((Http2HeadersFrameBuilder)this.type((short)1));
        }

        public static Http2HeadersFrameBuilder builder() {
            return new Http2HeadersFrameBuilder();
        }
    }
}

