/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Constants;
import org.apache.mina.http2.api.Http2Frame;

public class Http2GoAwayFrame
extends Http2Frame {
    private final int lastStreamID;
    private final long errorCode;
    private byte[] data;

    public int getLastStreamID() {
        return this.lastStreamID;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void writePayload(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.getLastStreamID());
        byteBuffer.putInt((int)this.getErrorCode());
        byteBuffer.put(this.getData());
    }

    protected Http2GoAwayFrame(Http2GoAwayFrameBuilder http2GoAwayFrameBuilder) {
        super(http2GoAwayFrameBuilder);
        this.lastStreamID = http2GoAwayFrameBuilder.getLastStreamID();
        this.errorCode = http2GoAwayFrameBuilder.getErrorCode();
        this.data = http2GoAwayFrameBuilder.getData();
    }

    public static class Http2GoAwayFrameBuilder
    extends Http2Frame.AbstractHttp2FrameBuilder<Http2GoAwayFrameBuilder, Http2GoAwayFrame> {
        private int lastStreamID;
        private long errorCode;
        private byte[] data = Http2Constants.EMPTY_BYTE_ARRAY;

        public Http2GoAwayFrameBuilder lastStreamID(int n) {
            this.lastStreamID = n;
            return this;
        }

        public int getLastStreamID() {
            return this.lastStreamID;
        }

        public Http2GoAwayFrameBuilder errorCode(long l) {
            this.errorCode = l;
            return this;
        }

        public long getErrorCode() {
            return this.errorCode;
        }

        public Http2GoAwayFrameBuilder data(byte[] byArray) {
            this.data = byArray;
            return this;
        }

        public byte[] getData() {
            return this.data;
        }

        @Override
        public Http2GoAwayFrame build() {
            if (this.getLength() == -1) {
                this.setLength(this.getData().length + 8);
            }
            return new Http2GoAwayFrame((Http2GoAwayFrameBuilder)this.type((short)7));
        }

        public static Http2GoAwayFrameBuilder builder() {
            return new Http2GoAwayFrameBuilder();
        }
    }
}

