/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http2.api;

import com.twitter.hpack.Decoder;
import com.twitter.hpack.Encoder;
import com.twitter.hpack.HeaderListener;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Http2ResponseEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.http2.api.Http2Constants;
import org.apache.mina.http2.api.Http2Frame;
import org.apache.mina.http2.impl.ConnectionErrorException;

public abstract class Http2FrameWithHeaders
extends Http2Frame {
    public static final String CLASS_NAME = Http2FrameWithHeaders.class.getSimpleName();
    private static final Class<Http2FrameWithHeaders> CLASS = Http2FrameWithHeaders.class;
    protected byte[] headerBlockFragment;
    protected Map<String, String> headers;

    public byte[] getHeaderBlockFragment() {
        return this.headerBlockFragment;
    }

    protected <T extends Http2Frame.AbstractHttp2FrameBuilder<T, V>, V extends Http2Frame> Http2FrameWithHeaders(Http2Frame.AbstractHttp2FrameBuilder<T, V> abstractHttp2FrameBuilder) {
        super(abstractHttp2FrameBuilder);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public ByteBuffer toBuffer() {
        throw new IllegalArgumentException("toBuffer must be called with encoder parameter.");
    }

    public ByteBuffer toBuffer(Encoder encoder, int n) throws ConnectionErrorException {
        this.encodeHeaders(encoder, n);
        return super.toBuffer();
    }

    protected void encodeHeaders(Encoder encoder, int n) throws ConnectionErrorException {
        if (!this.headers.isEmpty()) {
            int n2 = 0;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    String string = entry.getKey();
                    String string2 = entry.getValue();
                    if ((n2 += string.length() + string2.length() + 32) <= n) {
                        encoder.encodeHeader((OutputStream)byteArrayOutputStream, string.toLowerCase().getBytes(Http2Constants.US_ASCII_CHARSET), string2.getBytes(Http2Constants.US_ASCII_CHARSET), true);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw new ConnectionErrorException(9, "Error encoding headers frame: " + iOException.getMessage());
            }
            this.headerBlockFragment = byteArrayOutputStream.toByteArray();
        }
        if (this.headerBlockFragment == null) {
            this.headerBlockFragment = new byte[0];
        }
    }

    public Map<String, String> decodeHeaders(Decoder decoder) throws ConnectionErrorException {
        HeaderMap<String, String> headerMap = new HeaderMap<String, String>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getHeaderBlockFragment());
        HeaderListener headerListener = (byArray, byArray2, bl) -> headerMap.put(new String(byArray, Http2Constants.US_ASCII_CHARSET), new String(byArray2, Http2Constants.US_ASCII_CHARSET));
        try {
            decoder.decode((InputStream)byteArrayInputStream, headerListener);
            decoder.endHeaderBlock();
            this.headers = headerMap;
            return headerMap;
        }
        catch (IOException iOException) {
            throw new ConnectionErrorException(9, "Error generated while encoding headers. " + iOException.getMessage());
        }
    }

    private static String logPrefix() {
        return Http2ResponseEncoder.CLASS_NAME + ": ";
    }

    private void logTrace(String string) {
        WMSLoggerFactory.getLogger(CLASS).info(Http2FrameWithHeaders.logPrefix() + string);
    }

    protected static class HeaderMap<K, V>
    extends TreeMap {
        public HeaderMap() {
            super(new HeaderComparitor());
        }
    }

    private static class HeaderComparitor<T>
    implements Comparator<T> {
        private HeaderComparitor() {
        }

        @Override
        public int compare(T t, T t2) {
            String string = t.toString();
            String string2 = t2.toString();
            if (string.charAt(0) == ':' && string2.charAt(0) == ':') {
                return string.substring(1).compareTo(string2.substring(1));
            }
            if (string.charAt(0) == ':') {
                return -1;
            }
            if (string2.charAt(0) == ':') {
                return 1;
            }
            return string.compareTo(string2);
        }
    }
}

